/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConfigurationPropertyNotFoundException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TokenAccessProviderException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.RefreshTokenBasedTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.UserPasswordTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.WorkloadIdentityTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestAccountConfiguration {
    private static final String TEST_OAUTH_PROVIDER_CLASS_CONFIG = "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider";
    private static final String TEST_OAUTH_MSI_TOKEN_PROVIDER_CLASS_CONFIG = "org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider";
    private static final String TEST_CUSTOM_PROVIDER_CLASS_CONFIG = "org.apache.hadoop.fs.azurebfs.oauth2.RetryTestTokenProvider";
    private static final String TEST_SAS_PROVIDER_CLASS_CONFIG_1 = "org.apache.hadoop.fs.azurebfs.extensions.MockErrorSASTokenProvider";
    private static final String TEST_SAS_PROVIDER_CLASS_CONFIG_2 = "org.apache.hadoop.fs.azurebfs.extensions.MockSASTokenProvider";
    private static final String TEST_OAUTH_ENDPOINT = "oauthEndpoint";
    private static final String TEST_CLIENT_ID = "clientId";
    private static final String TEST_CLIENT_SECRET = "clientSecret";
    private static final String TEST_USER_NAME = "userName";
    private static final String TEST_USER_PASSWORD = "userPassword";
    private static final String TEST_MSI_TENANT = "msiTenant";
    private static final String TEST_REFRESH_TOKEN = "refreshToken";
    private static final List<String> CLIENT_CREDENTIAL_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.client.endpoint", "fs.azure.account.oauth2.client.id", "fs.azure.account.oauth2.client.secret"));
    private static final List<String> USER_PASSWORD_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.client.endpoint", "fs.azure.account.oauth2.user.name", "fs.azure.account.oauth2.user.password"));
    private static final List<String> REFRESH_TOKEN_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.refresh.token", "fs.azure.account.oauth2.client.id"));
    private static final List<String> WORKLOAD_IDENTITY_OAUTH_CONFIG_KEYS = Collections.unmodifiableList(Arrays.asList("fs.azure.account.oauth2.msi.tenant", "fs.azure.account.oauth2.client.id"));

    @Test
    public void testStringPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        Configuration conf = new Configuration();
        String accountName1 = "account1";
        String accountName2 = "account2";
        String accountName3 = "account3";
        String globalKey = "fs.azure.configuration";
        String accountKey1 = "fs.azure.configuration.account1";
        String accountKey2 = "fs.azure.configuration.account2";
        String accountKey3 = "fs.azure.configuration.account3";
        String globalValue = "global";
        String accountValue1 = "one";
        String accountValue2 = "two";
        conf.set("fs.azure.configuration.account1", "one");
        conf.set("fs.azure.configuration.account2", "two");
        conf.set("fs.azure.configuration", "global");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.get("fs.azure.configuration.account1"), (Object)"one");
        Assert.assertEquals((String)"Account-specific value was not returned when one existed", (Object)abfsConf.get("fs.azure.configuration"), (Object)"one");
        abfsConf = new AbfsConfiguration(conf, "account2");
        Assert.assertEquals((String)"Wrong value returned when a different account-specific value was requested", (Object)abfsConf.get("fs.azure.configuration.account1"), (Object)"one");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.get("fs.azure.configuration.account2"), (Object)"two");
        Assert.assertEquals((String)"Account-agnostic value return even though account-specific value was set", (Object)abfsConf.get("fs.azure.configuration"), (Object)"two");
        abfsConf = new AbfsConfiguration(conf, "account3");
        Assert.assertNull((String)"Account-specific value returned when none was set", (Object)abfsConf.get("fs.azure.configuration.account3"));
        Assert.assertEquals((String)"Account-agnostic value not returned when no account-specific value was set", (Object)abfsConf.get("fs.azure.configuration"), (Object)"global");
    }

    @Test
    public void testPasswordPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        Configuration conf = new Configuration();
        String accountName1 = "account1";
        String accountName2 = "account2";
        String accountName3 = "account3";
        String globalKey = "fs.azure.password";
        String accountKey1 = "fs.azure.password.account1";
        String accountKey2 = "fs.azure.password.account2";
        String accountKey3 = "fs.azure.password.account3";
        String globalValue = "global";
        String accountValue1 = "one";
        String accountValue2 = "two";
        conf.set("fs.azure.password.account1", "one");
        conf.set("fs.azure.password.account2", "two");
        conf.set("fs.azure.password", "global");
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account1");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.getPasswordString("fs.azure.password.account1"), (Object)"one");
        Assert.assertEquals((String)"Account-specific value was not returned when one existed", (Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"one");
        abfsConf = new AbfsConfiguration(conf, "account2");
        Assert.assertEquals((String)"Wrong value returned when a different account-specific value was requested", (Object)abfsConf.getPasswordString("fs.azure.password.account1"), (Object)"one");
        Assert.assertEquals((String)"Wrong value returned when account-specific value was requested", (Object)abfsConf.getPasswordString("fs.azure.password.account2"), (Object)"two");
        Assert.assertEquals((String)"Account-agnostic value return even though account-specific value was set", (Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"two");
        abfsConf = new AbfsConfiguration(conf, "account3");
        Assert.assertNull((String)"Account-specific value returned when none was set", (Object)abfsConf.getPasswordString("fs.azure.password.account3"));
        Assert.assertEquals((String)"Account-agnostic value not returned when no account-specific value was set", (Object)abfsConf.getPasswordString("fs.azure.password"), (Object)"global");
    }

    @Test
    public void testBooleanPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.bool";
        String accountKey = "fs.azure.bool.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setBoolean("fs.azure.bool", false);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)false);
        conf.unset("fs.azure.bool");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)true);
        conf.setBoolean("fs.azure.bool.account", false);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)false);
        conf.unset("fs.azure.bool.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getBoolean("fs.azure.bool", true), (Object)true);
        conf.setBoolean("fs.azure.bool.account", true);
        conf.setBoolean("fs.azure.bool", false);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (Object)abfsConf.getBoolean("fs.azure.bool", false), (Object)true);
    }

    @Test
    public void testLongPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.long";
        String accountKey = "fs.azure.long.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setLong("fs.azure.long", 0L);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (long)abfsConf.getLong("fs.azure.long", 1L), (long)0L);
        conf.unset("fs.azure.long");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (long)abfsConf.getLong("fs.azure.long", 1L), (long)1L);
        conf.setLong("fs.azure.long.account", 0L);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (long)abfsConf.getLong("fs.azure.long", 1L), (long)0L);
        conf.unset("fs.azure.long.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (long)abfsConf.getLong("fs.azure.long", 1L), (long)1L);
        conf.setLong("fs.azure.long.account", 1L);
        conf.setLong("fs.azure.long", 0L);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (long)abfsConf.getLong("fs.azure.long", 0L), (long)1L);
    }

    @Test
    public void testEnumPrecedence() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.enum";
        String accountKey = "fs.azure.enum.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        conf.setEnum("fs.azure.enum", (Enum)GetEnumType.FALSE);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.FALSE));
        conf.unset("fs.azure.enum");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.TRUE));
        conf.setEnum("fs.azure.enum.account", (Enum)GetEnumType.FALSE);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.FALSE));
        conf.unset("fs.azure.enum.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.TRUE), (Object)((Object)GetEnumType.TRUE));
        conf.setEnum("fs.azure.enum.account", (Enum)GetEnumType.TRUE);
        conf.setEnum("fs.azure.enum", (Enum)GetEnumType.FALSE);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (Object)abfsConf.getEnum("fs.azure.enum", (Enum)GetEnumType.FALSE), (Object)((Object)GetEnumType.TRUE));
    }

    @Test
    public void testClass() throws IllegalAccessException, IOException, InvalidConfigurationValueException {
        String accountName = "account";
        String globalKey = "fs.azure.class";
        String accountKey = "fs.azure.class.account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        Class<GetClassImpl0> class0 = GetClassImpl0.class;
        Class<GetClassImpl1> class1 = GetClassImpl1.class;
        Class<GetClassInterface> xface = GetClassInterface.class;
        conf.setClass("fs.azure.class", class0, xface);
        Assert.assertEquals((String)"Default value returned even though account-agnostic config was set", (Object)abfsConf.getAccountAgnosticClass("fs.azure.class", class1, xface), class0);
        conf.unset("fs.azure.class");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getAccountAgnosticClass("fs.azure.class", class1, xface), class1);
        conf.setClass("fs.azure.class.account", class0, xface);
        Assert.assertEquals((String)"Default value returned even though account-specific config was set", (Object)abfsConf.getAccountSpecificClass("fs.azure.class", class1, xface), class0);
        conf.unset("fs.azure.class.account");
        Assert.assertEquals((String)"Default value not returned even though config was unset", (Object)abfsConf.getAccountSpecificClass("fs.azure.class", class1, xface), class1);
        conf.setClass("fs.azure.class.account", class1, xface);
        conf.setClass("fs.azure.class", class0, xface);
        Assert.assertEquals((String)"Account-agnostic or default value returned even though account-specific config was set", (Object)abfsConf.getAccountSpecificClass("fs.azure.class", class0, xface), class1);
    }

    @Test
    public void testSASProviderPrecedence() throws IOException, IllegalAccessException {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        abfsConf.set("fs.azure.account.auth.type.account", "SAS");
        abfsConf.set("fs.azure.sas.token.provider.type.account", TEST_SAS_PROVIDER_CLASS_CONFIG_1);
        abfsConf.set("fs.azure.account.auth.type", AuthType.SAS.toString());
        abfsConf.set("fs.azure.sas.token.provider.type", TEST_SAS_PROVIDER_CLASS_CONFIG_2);
        ((AbstractStringAssert)Assertions.assertThat((String)abfsConf.getSASTokenProvider().getClass().getName()).describedAs("Account-specific SAS token provider should be in effect.", new Object[0])).isEqualTo((Object)TEST_SAS_PROVIDER_CLASS_CONFIG_1);
    }

    @Test
    public void testAccessTokenProviderPrecedence() throws IllegalAccessException, IOException {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.Custom, AuthType.OAuth);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.OAuth, AuthType.Custom);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.SAS, AuthType.Custom);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.Custom, null);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, AuthType.OAuth, null);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, null, AuthType.Custom);
        this.testGlobalAndAccountOAuthPrecedence(abfsConf, null, AuthType.OAuth);
    }

    @Test
    public void testOAuthConfigPropNotFound() throws Throwable {
        this.testConfigPropNotFound(CLIENT_CREDENTIAL_OAUTH_CONFIG_KEYS, ClientCredsTokenProvider.class.getName());
        this.testConfigPropNotFound(USER_PASSWORD_OAUTH_CONFIG_KEYS, UserPasswordTokenProvider.class.getName());
        this.testConfigPropNotFound(REFRESH_TOKEN_OAUTH_CONFIG_KEYS, RefreshTokenBasedTokenProvider.class.getName());
        this.testConfigPropNotFound(WORKLOAD_IDENTITY_OAUTH_CONFIG_KEYS, WorkloadIdentityTokenProvider.class.getName());
    }

    private void testConfigPropNotFound(List<String> configKeys, String tokenProviderClassName) throws Throwable {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        for (String key : configKeys) {
            this.setAuthConfig(abfsConf, true, AuthType.OAuth, tokenProviderClassName);
            abfsConf.unset(key);
            abfsConf.unset(key + ".account");
            TestAccountConfiguration.testMissingConfigKey(abfsConf, key);
        }
        this.unsetAuthConfig(abfsConf, false);
        this.unsetAuthConfig(abfsConf, true);
    }

    private static void testMissingConfigKey(AbfsConfiguration abfsConf, String confKey) throws Throwable {
        GenericTestUtils.assertExceptionContains((String)("Configuration property " + confKey + " not found."), (Throwable)LambdaTestUtils.verifyCause(ConfigurationPropertyNotFoundException.class, (Throwable)LambdaTestUtils.intercept(TokenAccessProviderException.class, () -> abfsConf.getTokenProvider().getClass().getTypeName())));
    }

    @Test
    public void testClientAndTenantIdOptionalWhenUsingMsiTokenProvider() throws Throwable {
        String accountName = "account";
        Configuration conf = new Configuration();
        AbfsConfiguration abfsConf = new AbfsConfiguration(conf, "account");
        String accountNameSuffix = "." + abfsConf.getAccountName();
        String authKey = "fs.azure.account.auth.type" + accountNameSuffix;
        Object providerClassKey = "";
        String providerClassValue = "";
        providerClassKey = "fs.azure.account.oauth.provider.type" + accountNameSuffix;
        providerClassValue = TEST_OAUTH_MSI_TOKEN_PROVIDER_CLASS_CONFIG;
        abfsConf.set(authKey, AuthType.OAuth.toString());
        abfsConf.set((String)providerClassKey, providerClassValue);
        AccessTokenProvider tokenProviderTypeName = abfsConf.getTokenProvider();
        ((ObjectAssert)Assertions.assertThat((Object)tokenProviderTypeName).describedAs("Token Provider Should be MsiTokenProvider", new Object[0])).isInstanceOf(MsiTokenProvider.class);
    }

    public void testGlobalAndAccountOAuthPrecedence(AbfsConfiguration abfsConf, AuthType globalAuthType, AuthType accountSpecificAuthType) throws IOException {
        if (globalAuthType == null) {
            this.unsetAuthConfig(abfsConf, false);
        } else {
            this.setAuthConfig(abfsConf, false, globalAuthType, TEST_OAUTH_PROVIDER_CLASS_CONFIG);
        }
        if (accountSpecificAuthType == null) {
            this.unsetAuthConfig(abfsConf, true);
        } else {
            this.setAuthConfig(abfsConf, true, accountSpecificAuthType, TEST_OAUTH_PROVIDER_CLASS_CONFIG);
        }
        AuthType expectedEffectiveAuthType = accountSpecificAuthType != null ? accountSpecificAuthType : globalAuthType;
        Class expectedEffectiveTokenProviderClassType = expectedEffectiveAuthType == AuthType.OAuth ? ClientCredsTokenProvider.class : CustomTokenProviderAdapter.class;
        ((AbstractStringAssert)Assertions.assertThat((String)abfsConf.getTokenProvider().getClass().getTypeName()).describedAs("Account-specific settings takes precendence to global settings. In absence of Account settings, global settings should take effect.", new Object[0])).isEqualTo((Object)expectedEffectiveTokenProviderClassType.getTypeName());
        this.unsetAuthConfig(abfsConf, false);
        this.unsetAuthConfig(abfsConf, true);
    }

    public void setAuthConfig(AbfsConfiguration abfsConf, boolean isAccountSetting, AuthType authType, String tokenProviderClassName) {
        String accountNameSuffix = "." + abfsConf.getAccountName();
        String authKey = "fs.azure.account.auth.type" + (String)(isAccountSetting ? accountNameSuffix : "");
        Object providerClassKey = "";
        String providerClassValue = "";
        switch (authType) {
            case OAuth: {
                providerClassKey = "fs.azure.account.oauth.provider.type" + (String)(isAccountSetting ? accountNameSuffix : "");
                providerClassValue = tokenProviderClassName;
                this.setOAuthConfigs(abfsConf, isAccountSetting, tokenProviderClassName);
                abfsConf.set("fs.azure.account.oauth2.client.endpoint" + (String)(isAccountSetting ? accountNameSuffix : ""), TEST_OAUTH_ENDPOINT);
                abfsConf.set("fs.azure.account.oauth2.client.id" + (String)(isAccountSetting ? accountNameSuffix : ""), TEST_CLIENT_ID);
                abfsConf.set("fs.azure.account.oauth2.client.secret" + (String)(isAccountSetting ? accountNameSuffix : ""), TEST_CLIENT_SECRET);
                break;
            }
            case Custom: {
                providerClassKey = "fs.azure.account.oauth.provider.type" + (String)(isAccountSetting ? accountNameSuffix : "");
                providerClassValue = TEST_CUSTOM_PROVIDER_CLASS_CONFIG;
                break;
            }
            case SAS: {
                providerClassKey = "fs.azure.sas.token.provider.type" + (String)(isAccountSetting ? accountNameSuffix : "");
                providerClassValue = TEST_SAS_PROVIDER_CLASS_CONFIG_1;
                break;
            }
        }
        abfsConf.set(authKey, authType.toString());
        abfsConf.set((String)providerClassKey, providerClassValue);
    }

    private void setOAuthConfigs(AbfsConfiguration abfsConfig, boolean isAccountSettings, String tokenProviderClassName) {
        String accountNameSuffix;
        String string = accountNameSuffix = isAccountSettings ? "." + abfsConfig.getAccountName() : "";
        if (tokenProviderClassName.equals(ClientCredsTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.client.endpoint" + accountNameSuffix, TEST_OAUTH_ENDPOINT);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
            abfsConfig.set("fs.azure.account.oauth2.client.secret" + accountNameSuffix, TEST_CLIENT_SECRET);
        }
        if (tokenProviderClassName.equals(UserPasswordTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.client.endpoint" + accountNameSuffix, TEST_OAUTH_ENDPOINT);
            abfsConfig.set("fs.azure.account.oauth2.user.name" + accountNameSuffix, TEST_USER_NAME);
            abfsConfig.set("fs.azure.account.oauth2.user.password" + accountNameSuffix, TEST_USER_PASSWORD);
        }
        if (tokenProviderClassName.equals(MsiTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        }
        if (tokenProviderClassName.equals(RefreshTokenBasedTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.refresh.token" + accountNameSuffix, TEST_REFRESH_TOKEN);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        }
        if (tokenProviderClassName.equals(WorkloadIdentityTokenProvider.class.getName())) {
            abfsConfig.set("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix, TEST_MSI_TENANT);
            abfsConfig.set("fs.azure.account.oauth2.client.id" + accountNameSuffix, TEST_CLIENT_ID);
        }
    }

    private void unsetAuthConfig(AbfsConfiguration abfsConf, boolean isAccountSettings) {
        String accountNameSuffix = isAccountSettings ? "." + abfsConf.getAccountName() : "";
        abfsConf.unset("fs.azure.account.auth.type" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth.provider.type" + accountNameSuffix);
        abfsConf.unset("fs.azure.sas.token.provider.type" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.endpoint" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.id" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.client.secret" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.user.name" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.user.password" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.msi.tenant" + accountNameSuffix);
        abfsConf.unset("fs.azure.account.oauth2.refresh.token" + accountNameSuffix);
    }

    public static enum GetEnumType {
        TRUE,
        FALSE;

    }

    private class GetClassImpl0
    implements GetClassInterface {
        private GetClassImpl0() {
        }
    }

    private class GetClassImpl1
    implements GetClassInterface {
        private GetClassImpl1() {
        }
    }

    static interface GetClassInterface {
    }
}

