/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.Hashtable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ITestFileSystemProperties
extends AbstractAbfsIntegrationTest {
    private static final int TEST_DATA = 100;
    private static final String TEST_PATH = "/testfile";

    @Test
    public void testReadWriteBytesToFileAndEnsureThreadPoolCleanup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_PATH);
        try (FSDataOutputStream stream = fs.create(testPath);){
            stream.write(100);
        }
        FileStatus fileStatus = fs.getFileStatus(testPath);
        ITestFileSystemProperties.assertEquals((long)1L, (long)fileStatus.getLen());
        try (FSDataInputStream inputStream = fs.open(testPath, 0x400000);){
            int i = inputStream.read();
            ITestFileSystemProperties.assertEquals((long)100L, (long)i);
        }
    }

    @Test
    public void testWriteOneByteToFileAndEnsureThreadPoolCleanup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_PATH);
        try (FSDataOutputStream stream = fs.create(testPath);){
            stream.write(100);
        }
        FileStatus fileStatus = fs.getFileStatus(testPath);
        ITestFileSystemProperties.assertEquals((long)1L, (long)fileStatus.getLen());
    }

    @Test
    public void testBase64FileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: value }");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setFilesystemProperties(properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getFilesystemProperties(tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test
    public void testBase64PathProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: valueTest }");
        Path testPath = this.path(TEST_PATH);
        this.touch(testPath);
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setPathProperties(testPath, properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getPathStatus(testPath, tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test(expected=Exception.class)
    public void testBase64InvalidFileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: value\u6b72 }");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setFilesystemProperties(properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getFilesystemProperties(tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test(expected=Exception.class)
    public void testBase64InvalidPathProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("key", "{ value: valueTest\u5169 }");
        Path testPath = this.path(TEST_PATH);
        this.touch(testPath);
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setPathProperties(testPath, properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getPathStatus(testPath, tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test
    public void testSetFileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("containerForDevTest", "true");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        fs.getAbfsStore().setFilesystemProperties(properties, tracingContext);
        Hashtable fetchedProperties = fs.getAbfsStore().getFilesystemProperties(tracingContext);
        ITestFileSystemProperties.assertEquals(properties, (Object)fetchedProperties);
    }

    @Test
    public void testBufferSizeSet() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsConfiguration abfsConfig = fs.getAbfsStore().getAbfsConfiguration();
        int bufferSizeConfig = 0x600000;
        int bufferSizeArg = 0xA00000;
        Path testPath = this.path(TEST_PATH);
        fs.create(testPath);
        abfsConfig.setReadBufferSize(bufferSizeConfig);
        FSDataInputStream inputStream = fs.open(testPath, bufferSizeArg);
        AbfsInputStream abfsInputStream = (AbfsInputStream)inputStream.getWrappedStream();
        int actualBufferSize = abfsInputStream.getBufferSize();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualBufferSize).describedAs("Buffer size should be set to the value in the configuration", new Object[0])).isEqualTo(bufferSizeConfig);
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualBufferSize).describedAs("Buffer size should not be set to the value passed as argument", new Object[0])).isNotEqualTo(bufferSizeArg);
    }
}

