/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.ITestAzureBlobFileSystemListStatus;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemFileStatus
extends AbstractAbfsIntegrationTest {
    private static final String DEFAULT_FILE_PERMISSION_VALUE = "640";
    private static final String DEFAULT_DIR_PERMISSION_VALUE = "750";
    private static final String DEFAULT_UMASK_VALUE = "027";
    private static final String FULL_PERMISSION = "777";
    private static final String TEST_FILE = "testFile";
    private static final String TEST_FOLDER = "testDir";

    @Test
    public void testEnsureStatusWorksForRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path root = new Path("/");
        FileStatus[] rootls = fs.listStatus(root);
        ITestAzureBlobFileSystemFileStatus.assertEquals((String)"root listing", (long)0L, (long)rootls.length);
    }

    @Test
    public void testFileStatusPermissionsAndOwnerAndGroup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        Path testFile = this.path(TEST_FILE);
        this.touch(testFile);
        this.validateStatus(fs, testFile, false);
    }

    private FileStatus validateStatus(AzureBlobFileSystem fs, Path name, boolean isDir) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(name);
        String errorInStatus = "error in " + fileStatus + " from " + fs;
        if (!this.getIsNamespaceEnabled(fs)) {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": owner"), (Object)fs.getOwnerUser(), (Object)fileStatus.getOwner());
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": group"), (Object)fs.getOwnerUserPrimaryGroup(), (Object)fileStatus.getGroup());
            ITestAzureBlobFileSystemFileStatus.assertEquals((Object)new FsPermission(FULL_PERMISSION), (Object)fileStatus.getPermission());
        } else if (isDir) {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": permission"), (Object)new FsPermission(DEFAULT_DIR_PERMISSION_VALUE), (Object)fileStatus.getPermission());
            ITestAzureBlobFileSystemFileStatus.assertTrue((String)(errorInStatus + "not a directory"), (boolean)fileStatus.isDirectory());
        } else {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": permission"), (Object)new FsPermission(DEFAULT_FILE_PERMISSION_VALUE), (Object)fileStatus.getPermission());
            ITestAzureBlobFileSystemFileStatus.assertTrue((String)(errorInStatus + "not a file"), (boolean)fileStatus.isFile());
        }
        this.assertPathDns(fileStatus.getPath());
        return fileStatus;
    }

    @Test
    public void testFolderStatusPermissionsAndOwnerAndGroup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        Path testFolder = this.path(TEST_FOLDER);
        fs.mkdirs(testFolder);
        this.validateStatus(fs, testFolder, true);
    }

    @Test
    public void testAbfsPathWithHost() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path pathWithHost1 = new Path("abfs://mycluster/abfs/file1.txt");
        Path pathwithouthost1 = new Path("/abfs/file1.txt");
        Path pathWithHost2 = new Path("abfs://mycluster/abfs/file2.txt");
        Path pathwithouthost2 = new Path("/abfs/file2.txt");
        fs.create(pathWithHost1).close();
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)pathwithouthost1);
        fs.create(pathwithouthost2).close();
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)pathWithHost2);
        FileStatus fileStatus1 = fs.getFileStatus(pathWithHost1);
        ITestAzureBlobFileSystemFileStatus.assertEquals((Object)pathwithouthost1.getName(), (Object)fileStatus1.getPath().getName());
        FileStatus fileStatus2 = fs.getFileStatus(pathwithouthost2);
        ITestAzureBlobFileSystemFileStatus.assertEquals((Object)pathWithHost2.getName(), (Object)fileStatus2.getPath().getName());
    }

    @Test
    public void testLastModifiedTime() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = this.path("childfile1.txt");
        long createStartTime = System.currentTimeMillis();
        long minCreateStartTime = createStartTime / 1000L * 1000L - 1L;
        fs.create(testFilePath).close();
        long createEndTime = System.currentTimeMillis();
        FileStatus fStat = fs.getFileStatus(testFilePath);
        long lastModifiedTime = fStat.getModificationTime();
        ITestAzureBlobFileSystemFileStatus.assertTrue((String)"lastModifiedTime should be after minCreateStartTime", (minCreateStartTime < lastModifiedTime ? 1 : 0) != 0);
        ITestAzureBlobFileSystemFileStatus.assertTrue((String)"lastModifiedTime should be before createEndTime", (createEndTime > lastModifiedTime ? 1 : 0) != 0);
    }

    @Test
    public void testFileStatusOnRoot() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = new Path("/");
        this.validateStatus(fs, testPath, true);
        String testPathStr = this.makeQualified(testPath).toString();
        this.validateStatus(fs, new Path(testPathStr), true);
        testPathStr = testPathStr.substring(0, testPathStr.length() - 1);
        this.validateStatus(fs, new Path(testPathStr), true);
    }

    @Test
    public void testFileStatusOnExplicitPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path explicitDirPath = this.path("explicitDir");
        Path filePath = new Path(explicitDirPath, "explicitFile");
        Path nonExistingPath = new Path(explicitDirPath, "nonExistingFile");
        fs.mkdirs(explicitDirPath);
        fs.create(filePath).close();
        FileStatus fileStatus = fs.getFileStatus(explicitDirPath);
        this.verifyFileStatus(fileStatus, true);
        fileStatus = fs.getFileStatus(filePath);
        this.verifyFileStatus(fileStatus, false);
        FileNotFoundException ex = (FileNotFoundException)LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getFileStatus(nonExistingPath));
        this.verifyFileNotFound(ex, nonExistingPath.getName());
    }

    @Test
    public void testFileStatusOnImplicitPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path("implicitDir/fileWithImplicitParent");
        Path implicitDir = filePath.getParent();
        Path nonExistingPath = new Path(implicitDir, "nonExistingFile");
        this.createAzCopyFile(filePath);
        FileStatus fileStatus = fs.getFileStatus(implicitDir);
        this.verifyFileStatus(fileStatus, true);
        fileStatus = fs.getFileStatus(filePath);
        this.verifyFileStatus(fileStatus, false);
        FileNotFoundException ex = (FileNotFoundException)LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getFileStatus(nonExistingPath));
        this.verifyFileNotFound(ex, nonExistingPath.getName());
    }

    @Test
    public void testListStatusIsCalledForImplicitPathOnBlobEndpoint() throws Exception {
        this.assumeBlobServiceType();
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        AbfsBlobClient abfsClient = (AbfsBlobClient)Mockito.spy((Object)store.getClientHandler().getBlobClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)abfsClient).when((Object)store)).getClient();
        Path implicitPath = this.path("implicitDir");
        this.createAzCopyFolder(implicitPath);
        fs.getFileStatus(implicitPath);
        ((AbfsBlobClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)1))).getPathStatus((String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (TracingContext)ArgumentMatchers.any(), (ContextEncryptionAdapter)ArgumentMatchers.any());
        ((AbfsBlobClient)Mockito.verify((Object)abfsClient, (VerificationMode)Mockito.times((int)1))).listPath((String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
    }

    private void verifyFileStatus(FileStatus fileStatus, boolean isDir) {
        Assertions.assertThat((Comparable)fileStatus).isNotNull();
        if (isDir) {
            Assertions.assertThat((long)fileStatus.getLen()).isEqualTo(0L);
            Assertions.assertThat((boolean)fileStatus.isDirectory()).isTrue();
        } else {
            Assertions.assertThat((boolean)fileStatus.isFile()).isTrue();
        }
        this.assertPathDns(fileStatus.getPath());
    }

    private void verifyFileNotFound(FileNotFoundException ex, String key) {
        Assertions.assertThat((Throwable)ex).isNotNull();
        Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{key});
    }

    private void testIsDirectory(boolean expected, String ... configName) throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());){
            this.assumeBlobServiceType();
            AbfsBlobClient abfsBlobClient = ITestAzureBlobFileSystemListStatus.mockIngressClientHandler(fs);
            ITestAzureBlobFileSystemListStatus.mockAbfsRestOperation(abfsBlobClient, configName);
            Path path = new Path("/testPath");
            fs.mkdirs(path);
            FileStatus fileStatus = fs.getFileStatus(path);
            AbfsHttpOperation op = abfsBlobClient.getPathStatus(path.toUri().getPath(), true, this.getTestTracingContext(fs, true), null).getResult();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsBlobClient.checkIsDir(op)).describedAs("Directory should be marked as " + expected, new Object[0])).isEqualTo(expected);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileStatus.isDirectory()).describedAs("Expected directory state: " + expected, new Object[0])).isEqualTo(expected);
            fs.delete(path, true);
        }
    }

    @Test
    public void testIsDirectoryWithDifferentCases() throws Exception {
        this.testIsDirectory(true, "HDI_ISFOLDER");
        this.testIsDirectory(true, "Hdi_ISFOLDER");
        this.testIsDirectory(true, "Hdi_isfolder");
        this.testIsDirectory(true, "hdi_isfolder");
        this.testIsDirectory(false, "Hdi_isfolder1");
        this.testIsDirectory(true, "HDI_ISFOLDER", "Hdi_ISFOLDER", "Hdi_isfolder");
        this.testIsDirectory(true, "HDI_ISFOLDER", "Hdi_ISFOLDER1", "Test");
    }
}

