/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientHandler;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AzureBlobIngressHandler;
import org.apache.hadoop.fs.azurebfs.services.AzureDFSIngressHandler;
import org.apache.hadoop.fs.azurebfs.services.AzureIngressHandler;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.store.BlockUploadStatistics;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemAppend
extends AbstractAbfsIntegrationTest {
    private static final String TEST_FILE_PATH = "testfile";
    private static final String TEST_FILE_PATH1 = "testfile1";
    private static final String TEST_FOLDER_PATH = "testFolder";
    private static final int TEN = 10;
    private static final int TWENTY = 20;
    private static final int THIRTY = 30;
    private static final int HUNDRED = 100;

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirShouldFail() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        fs.mkdirs(filePath);
        fs.append(filePath, 0).close();
    }

    @Test
    public void testAppendWithLength0() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(this.path(TEST_FILE_PATH));){
            byte[] b = new byte[1024];
            new Random().nextBytes(b);
            stream.write(b, 1000, 0);
            ITestAzureBlobFileSystemAppend.assertEquals((long)0L, (long)stream.getPos());
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        ContractTestUtils.touch((FileSystem)fs, (Path)filePath);
        fs.delete(filePath, false);
        fs.append(filePath).close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = this.path(TEST_FOLDER_PATH);
        fs.mkdirs(folderPath);
        fs.append(folderPath).close();
    }

    @Test
    public void testTracingForAppend() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_FILE_PATH);
        fs.create(testPath).close();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.APPEND, false, 0));
        fs.append(testPath, 10);
    }

    @Test
    public void testCloseOfDataBlockOnAppendComplete() throws Exception {
        HashSet<String> blockBufferTypes = new HashSet<String>();
        blockBufferTypes.add("disk");
        blockBufferTypes.add("bytebuffer");
        blockBufferTypes.add("array");
        for (String blockBufferType : blockBufferTypes) {
            Configuration configuration = new Configuration(this.getRawConfiguration());
            configuration.set("fs.azure.data.blocks.buffer", blockBufferType);
            AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration)));
            try {
                AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
                ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
                DataBlocks.DataBlock[] dataBlock = new DataBlocks.DataBlock[1];
                ((AzureBlobFileSystemStore)Mockito.doAnswer(getBlobFactoryInvocation -> {
                    DataBlocks.BlockFactory factory = (DataBlocks.BlockFactory)Mockito.spy((Object)((DataBlocks.BlockFactory)getBlobFactoryInvocation.callRealMethod()));
                    ((DataBlocks.BlockFactory)Mockito.doAnswer(factoryCreateInvocation -> {
                        dataBlock[0] = (DataBlocks.DataBlock)Mockito.spy((Object)((DataBlocks.DataBlock)factoryCreateInvocation.callRealMethod()));
                        return dataBlock[0];
                    }).when((Object)factory)).create(Mockito.anyLong(), Mockito.anyInt(), (BlockUploadStatistics)Mockito.any(BlockUploadStatistics.class));
                    return factory;
                }).when((Object)store)).getBlockFactory();
                FSDataOutputStream os = fs.create(new Path(this.getMethodName() + "_" + blockBufferType));
                try {
                    os.write(new byte[1]);
                    ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataBlock[0].getState()).describedAs("On write of data in outputStream, state should become Writing", new Object[0])).isEqualTo((Object)DataBlocks.DataBlock.DestState.Writing);
                    os.close();
                    ((DataBlocks.DataBlock)Mockito.verify((Object)dataBlock[0], (VerificationMode)Mockito.times((int)1))).close();
                    ((AbstractComparableAssert)Assertions.assertThat((Comparable)dataBlock[0].getState()).describedAs("On close of outputStream, state should become Closed", new Object[0])).isEqualTo((Object)DataBlocks.DataBlock.DestState.Closed);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            finally {
                if (fs == null) continue;
                fs.close();
            }
        }
    }

    @Test
    public void testCreateOverDfsAppendOverBlob() throws IOException {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_FILE_PATH);
        AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
        fs.getAbfsStore().getClientHandler().getDfsClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
        fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", AbfsServiceType.BLOB.name());
        FSDataOutputStream outputStream = fs.append(testPath);
        AzureIngressHandler ingressHandler = ((AbfsOutputStream)outputStream.getWrappedStream()).getIngressHandler();
        AbfsClient client = ingressHandler.getClient();
        ((ObjectAssert)Assertions.assertThat((Object)client).as("Blob client was not used before fallback", new Object[0])).isInstanceOf(AbfsBlobClient.class);
        outputStream.write(10);
        outputStream.hsync();
        outputStream.write(20);
        outputStream.hsync();
        outputStream.write(30);
        outputStream.hsync();
        AzureIngressHandler ingressHandlerFallback = ((AbfsOutputStream)outputStream.getWrappedStream()).getIngressHandler();
        AbfsClient clientFallback = ingressHandlerFallback.getClient();
        ((ObjectAssert)Assertions.assertThat((Object)clientFallback).as("DFS client was not used after fallback", new Object[0])).isInstanceOf(AbfsDfsClient.class);
    }

    @Test
    public void testMultipleAppendsQualifyForSwitch() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_FILE_PATH);
        AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
        fs.getAbfsStore().getClientHandler().getDfsClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
        fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", AbfsServiceType.BLOB.name());
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        ArrayList futures = new ArrayList();
        byte[] b1 = new byte[0x800000];
        new Random().nextBytes(b1);
        FSDataOutputStream out1 = fs.append(testPath);
        FSDataOutputStream out2 = fs.append(testPath);
        FSDataOutputStream out3 = fs.append(testPath);
        futures.add(executorService.submit(() -> {
            try {
                out1.write(10);
                out1.hsync();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        futures.add(executorService.submit(() -> {
            try {
                out2.write(20);
                out2.hsync();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        futures.add(executorService.submit(() -> {
            try {
                out3.write(30);
                out3.hsync();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        this.checkFuturesForExceptions(futures, 0);
        AzureIngressHandler ingressHandlerFallback = ((AbfsOutputStream)out1.getWrappedStream()).getIngressHandler();
        AbfsClient clientFallback = ingressHandlerFallback.getClient();
        ((ObjectAssert)Assertions.assertThat((Object)clientFallback).as("DFS client was not used after fallback", new Object[0])).isInstanceOf(AbfsDfsClient.class);
    }

    @Test
    public void testParallelWritesOnDfsAndBlob() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path(TEST_FILE_PATH);
        Path testPath1 = this.path(TEST_FILE_PATH1);
        AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
        fs.getAbfsStore().getClientHandler().getDfsClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
        fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", AbfsServiceType.BLOB.name());
        FSDataOutputStream out1 = fs.create(testPath);
        fs.getAbfsStore().getClientHandler().getDfsClient().createPath(this.makeQualified(testPath1).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        ArrayList futures = new ArrayList();
        byte[] b1 = new byte[0x800000];
        new Random().nextBytes(b1);
        FSDataOutputStream out2 = fs.append(testPath1);
        futures.add(executorService.submit(() -> {
            try {
                out1.write(10);
                out1.hsync();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        futures.add(executorService.submit(() -> {
            try {
                out2.write(20);
                out2.hsync();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        this.checkFuturesForExceptions(futures, 0);
    }

    @Test
    public void testCreateOverBlobAppendOverDfs() throws IOException {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        this.assumeDfsServiceType();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.dfstoblob.fallback", true);
        conf.set("fs.azure.ingress.service.type", String.valueOf(AbfsServiceType.DFS));
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);){
            Path testPath = this.path(TEST_FILE_PATH);
            AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
            fs.getAbfsStore().getAbfsConfiguration().setBoolean("fs.azure.enable.dfstoblob.fallback", true);
            fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", String.valueOf(AbfsServiceType.DFS));
            fs.getAbfsStore().getClientHandler().getBlobClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
            FSDataOutputStream outputStream = fs.append(testPath);
            outputStream.write(10);
            outputStream.hsync();
            outputStream.write(20);
            outputStream.hsync();
            outputStream.write(30);
            outputStream.hsync();
        }
    }

    @Test
    public void testCreateAppendBlobOverBlobEndpointAppendOverDfs() throws IOException, NoSuchFieldException, IllegalAccessException {
        this.assumeDfsServiceType();
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean("fs.azure.enable.dfstoblob.fallback", true);
        conf.set("fs.azure.ingress.service.type", String.valueOf(AbfsServiceType.DFS));
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf)));){
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)true).when((Object)store)).isAppendBlobKey(ArgumentMatchers.anyString());
            Field privateField = AzureBlobFileSystem.class.getDeclaredField("abfsStore");
            privateField.setAccessible(true);
            privateField.set(fs, store);
            Path testPath = this.path(TEST_FILE_PATH);
            AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
            fs.getAbfsStore().getAbfsConfiguration().setBoolean("fs.azure.enable.dfstoblob.fallback", true);
            fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", String.valueOf(AbfsServiceType.DFS));
            fs.getAbfsStore().getClientHandler().getBlobClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, true, null, null, this.getTestTracingContext(fs, true));
            FSDataOutputStream outputStream = fs.append(testPath);
            outputStream.write(10);
            outputStream.hsync();
            outputStream.write(20);
            outputStream.hsync();
            outputStream.write(30);
            outputStream.hsync();
        }
    }

    @Test
    public void testCreateAppendBlobOverDfsEndpointAppendOverBlob() throws IOException, NoSuchFieldException, IllegalAccessException {
        this.assumeHnsEnabled("FNS does not support append blob creation for DFS endpoint");
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)true).when((Object)store)).isAppendBlobKey(ArgumentMatchers.anyString());
        Field privateField = AzureBlobFileSystem.class.getDeclaredField("abfsStore");
        privateField.setAccessible(true);
        privateField.set(fs, store);
        Path testPath = this.path(TEST_FILE_PATH);
        AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
        fs.getAbfsStore().getClientHandler().getDfsClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, true, null, null, this.getTestTracingContext(fs, true));
        fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", AbfsServiceType.BLOB.name());
        FSDataOutputStream outputStream = fs.append(testPath);
        AzureIngressHandler ingressHandler = ((AbfsOutputStream)outputStream.getWrappedStream()).getIngressHandler();
        AbfsClient client = ingressHandler.getClient();
        ((ObjectAssert)Assertions.assertThat((Object)client).as("Blob client was not used before fallback", new Object[0])).isInstanceOf(AbfsBlobClient.class);
        outputStream.write(10);
        outputStream.hsync();
        outputStream.write(20);
        outputStream.hsync();
        outputStream.write(30);
        outputStream.flush();
        AzureIngressHandler ingressHandlerFallback = ((AbfsOutputStream)outputStream.getWrappedStream()).getIngressHandler();
        AbfsClient clientFallback = ingressHandlerFallback.getClient();
        ((ObjectAssert)Assertions.assertThat((Object)clientFallback).as("DFS client was not used after fallback", new Object[0])).isInstanceOf(AbfsDfsClient.class);
    }

    @Test
    public void testValidateIngressHandler() throws IOException {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.ingress.service.type", AbfsServiceType.BLOB.name());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            Path testPath = this.path(TEST_FILE_PATH);
            AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
            fs.getAbfsStore().getClientHandler().getBlobClient().createPath(this.makeQualified(testPath).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
            FSDataOutputStream outputStream = fs.append(testPath);
            AzureIngressHandler ingressHandler = ((AbfsOutputStream)outputStream.getWrappedStream()).getIngressHandler();
            ((ObjectAssert)Assertions.assertThat((Object)ingressHandler).as("Blob Ingress handler instance is not correct", new Object[0])).isInstanceOf(AzureBlobIngressHandler.class);
            AbfsClient client = ingressHandler.getClient();
            ((ObjectAssert)Assertions.assertThat((Object)client).as("Blob client was not used correctly", new Object[0])).isInstanceOf(AbfsBlobClient.class);
            Path testPath1 = new Path("testFile1");
            fs.getAbfsStore().getClientHandler().getBlobClient().createPath(this.makeQualified(testPath1).toUri().getPath(), true, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
            fs.getAbfsStore().getAbfsConfiguration().set("fs.azure.ingress.service.type", AbfsServiceType.DFS.name());
            FSDataOutputStream outputStream1 = fs.append(testPath1);
            AzureIngressHandler ingressHandler1 = ((AbfsOutputStream)outputStream1.getWrappedStream()).getIngressHandler();
            ((ObjectAssert)Assertions.assertThat((Object)ingressHandler1).as("DFS Ingress handler instance is not correct", new Object[0])).isInstanceOf(AzureDFSIngressHandler.class);
            AbfsClient client1 = ingressHandler1.getClient();
            ((ObjectAssert)Assertions.assertThat((Object)client1).as("Dfs client was not used correctly", new Object[0])).isInstanceOf(AbfsDfsClient.class);
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendImplicitDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = new Path(TEST_FOLDER_PATH);
        fs.mkdirs(folderPath);
        fs.append(folderPath.getParent());
    }

    @Test(expected=FileNotFoundException.class)
    public void testAppendFileNotExists() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = new Path(TEST_FOLDER_PATH);
        fs.append(folderPath);
    }

    @Test(expected=IOException.class)
    public void testCreateExplicitDirectoryOverDfsAppendOverBlob() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path folderPath = this.path(TEST_FOLDER_PATH);
        AzureBlobFileSystemStore.Permissions permissions = new AzureBlobFileSystemStore.Permissions(false, FsPermission.getDefault(), FsPermission.getUMask((Configuration)fs.getConf()));
        fs.getAbfsStore().getClientHandler().getDfsClient().createPath(this.makeQualified(folderPath).toUri().getPath(), false, false, permissions, false, null, null, this.getTestTracingContext(fs, true));
        FSDataOutputStream outputStream = fs.append(folderPath);
        outputStream.write(10);
        outputStream.hsync();
    }

    @Test(expected=IOException.class)
    public void testRecreateAppendAndFlush() throws IOException {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        fs.create(filePath);
        Assume.assumeTrue((this.getIngressServiceType() == AbfsServiceType.BLOB ? 1 : 0) != 0);
        FSDataOutputStream outputStream = fs.append(filePath);
        outputStream.write(10);
        try (AzureBlobFileSystem fs1 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());
             FSDataOutputStream outputStream1 = fs1.create(filePath);){
            outputStream.hsync();
        }
    }

    @Test(expected=IOException.class)
    public void testRecreateDirectoryAppendAndFlush() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        fs.create(filePath);
        FSDataOutputStream outputStream = fs.append(filePath);
        outputStream.write(10);
        try (AzureBlobFileSystem fs1 = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());){
            fs1.mkdirs(filePath);
            outputStream.hsync();
        }
    }

    @Test
    public void testParallelWriteSameOffsetDifferentOutputStreams() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.enable.conditional.create.overwrite", "false");
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);){
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            ArrayList futures = new ArrayList();
            byte[] b = new byte[0x800000];
            new Random().nextBytes(b);
            Path filePath = this.path(TEST_FILE_PATH);
            FSDataOutputStream out1 = fs.create(filePath);
            FSDataOutputStream out2 = fs.append(filePath);
            FSDataOutputStream out3 = fs.append(filePath);
            futures.add(executorService.submit(() -> {
                try {
                    out1.write(b, 10, 200);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    out2.write(b, 10, 200);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    out3.write(b, 10, 200);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            this.checkFuturesForExceptions(futures, 0);
        }
    }

    @Test
    public void testParallelWriteDifferentContentLength() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.enable.conditional.create.overwrite", "false");
        try (FileSystem fs = FileSystem.newInstance((Configuration)configuration);){
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            ArrayList futures = new ArrayList();
            Path filePath = this.path(TEST_FILE_PATH);
            FSDataOutputStream out1 = fs.create(filePath);
            byte[] b1 = new byte[0x800000];
            new Random().nextBytes(b1);
            FSDataOutputStream out2 = fs.append(filePath);
            FSDataOutputStream out3 = fs.append(filePath);
            futures.add(executorService.submit(() -> {
                try {
                    out1.write(b1, 10, 200);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    out2.write(b1, 20, 300);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            futures.add(executorService.submit(() -> {
                try {
                    out3.write(b1, 30, 400);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            this.checkFuturesForExceptions(futures, 0);
        }
    }

    @Test
    public void testParallelWriteOutputStreamClose() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        AzureBlobFileSystem fs = this.getFileSystem();
        Path secondarytestfile = new Path("secondarytestfile");
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ArrayList futures = new ArrayList();
        FSDataOutputStream out1 = fs.create(secondarytestfile);
        Assume.assumeTrue((this.getIngressServiceType() == AbfsServiceType.BLOB ? 1 : 0) != 0);
        AbfsOutputStream outputStream1 = (AbfsOutputStream)out1.getWrappedStream();
        String fileETag = outputStream1.getIngressHandler().getETag();
        byte[] b1 = new byte[0x800000];
        new Random().nextBytes(b1);
        byte[] b2 = new byte[0x800000];
        new Random().nextBytes(b2);
        FSDataOutputStream out2 = fs.append(secondarytestfile);
        futures.add(executorService.submit(() -> {
            try {
                out1.write(b1, 0, 200);
                out1.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        futures.add(executorService.submit(() -> {
            try {
                out2.write(b2, 0, 400);
                out2.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        this.checkFuturesForExceptions(futures, 1);
        byte[] readBuffer = new byte[0x800000];
        FSDataInputStream inputStream = fs.open(secondarytestfile);
        inputStream.seek(0L);
        AbfsOutputStream outputStream2 = (AbfsOutputStream)out1.getWrappedStream();
        String out1Etag = outputStream2.getIngressHandler().getETag();
        AbfsOutputStream outputStream3 = (AbfsOutputStream)out2.getWrappedStream();
        String out2Etag = outputStream3.getIngressHandler().getETag();
        if (!fileETag.equals(out1Etag)) {
            int result = inputStream.read(readBuffer, 0, 0x400000);
            ITestAzureBlobFileSystemAppend.assertEquals((long)result, (long)200L);
            ITestAzureBlobFileSystemAppend.assertArrayEquals((byte[])Arrays.copyOfRange(readBuffer, 0, result), (byte[])Arrays.copyOfRange(b1, 0, result));
        } else if (!fileETag.equals(out2Etag)) {
            int result = inputStream.read(readBuffer, 0, 0x400000);
            ITestAzureBlobFileSystemAppend.assertEquals((long)result, (long)400L);
            ITestAzureBlobFileSystemAppend.assertArrayEquals((byte[])Arrays.copyOfRange(readBuffer, 0, result), (byte[])Arrays.copyOfRange(b2, 0, result));
        } else {
            ITestAzureBlobFileSystemAppend.fail((String)"Neither out1 nor out2 was flushed successfully.");
        }
    }

    @Test
    public void testEtagMismatch() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        AzureBlobFileSystem fs = this.getFileSystem();
        Path filePath = this.path(TEST_FILE_PATH);
        FSDataOutputStream out1 = fs.create(filePath);
        FSDataOutputStream out2 = fs.create(filePath);
        Assume.assumeTrue((this.getIngressServiceType() == AbfsServiceType.BLOB ? 1 : 0) != 0);
        out2.write(10);
        out2.hsync();
        out1.write(10);
        LambdaTestUtils.intercept(IOException.class, () -> out1.hsync());
    }

    @Test
    public void testAppendWithLease() throws Exception {
        Path testFilePath = new Path(this.path(this.methodName.getMethodName()), TEST_FILE_PATH);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getCustomFileSystem(testFilePath.getParent(), 1));
        FsPermission permission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
        FsPermission umask = new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE);
        AbfsOutputStream outputStream = (AbfsOutputStream)fs.getAbfsStore().createFile(testFilePath, null, true, permission, umask, this.getTestTracingContext(fs, true));
        outputStream.write(10);
        outputStream.close();
        ITestAzureBlobFileSystemAppend.assertNotNull((Object)outputStream.getLeaseId());
    }

    private AzureBlobFileSystem getCustomFileSystem(Path infiniteLeaseDirs, int numLeaseThreads) throws Exception {
        Configuration conf = this.getRawConfiguration();
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", this.getAbfsScheme()), true);
        conf.set("fs.azure.infinite-lease.directories", infiniteLeaseDirs.toUri().getPath());
        conf.setInt("fs.azure.lease.threads", numLeaseThreads);
        FileSystem fileSystem = FileSystem.newInstance((Configuration)conf);
        return (AzureBlobFileSystem)fileSystem;
    }

    @Test
    public void testAppendImplicitDirectoryAzcopy() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.createAzCopyFolder(new Path("/src"));
        this.createAzCopyFile(new Path("/src/file"));
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.append(new Path("/src")));
    }

    @Test
    public void testIntermittentAppendFailureToBeReported() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration())));){
            this.assumeHnsDisabled();
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            this.assumeBlobServiceType();
            AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
            AbfsBlobClient blobClient = (AbfsBlobClient)Mockito.spy((Object)clientHandler.getBlobClient());
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)clientHandler).when((Object)store)).getClientHandler();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getBlobClient();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getIngressClient();
            ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{new AbfsRestOperationException(503, "", "", new Exception())}).when((Object)blobClient)).append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
            byte[] bytes = new byte[0x800000];
            new Random().nextBytes(bytes);
            LambdaTestUtils.intercept(IOException.class, () -> {
                try (FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file"), (AbfsClient)blobClient);){
                    os.write(bytes);
                }
            });
            LambdaTestUtils.intercept(IOException.class, () -> {
                FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file/file1"), (AbfsClient)blobClient);
                os.write(bytes);
                os.close();
            });
            LambdaTestUtils.intercept(IOException.class, () -> {
                FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file/file2"), (AbfsClient)blobClient);
                os.write(bytes);
                os.hsync();
            });
            LambdaTestUtils.intercept(IOException.class, () -> {
                FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file/file3"), (AbfsClient)blobClient);
                os.write(bytes);
                os.hflush();
            });
            LambdaTestUtils.intercept(IOException.class, () -> {
                AbfsOutputStream os = (AbfsOutputStream)this.createMockedOutputStream(fs, new Path("/test/file/file4"), (AbfsClient)blobClient).getWrappedStream();
                os.write(bytes);
                while (!os.areWriteOperationsTasksDone().booleanValue()) {
                }
                os.write(bytes);
            });
        }
    }

    private FSDataOutputStream createMockedOutputStream(AzureBlobFileSystem fs, Path path, AbfsClient client) throws IOException {
        AbfsOutputStream abfsOutputStream = (AbfsOutputStream)Mockito.spy((Object)((AbfsOutputStream)fs.create(path).getWrappedStream()));
        AzureIngressHandler ingressHandler = (AzureIngressHandler)Mockito.spy((Object)abfsOutputStream.getIngressHandler());
        ((AbfsOutputStream)Mockito.doReturn((Object)ingressHandler).when((Object)abfsOutputStream)).getIngressHandler();
        ((AzureIngressHandler)Mockito.doReturn((Object)client).when((Object)ingressHandler)).getClient();
        FSDataOutputStream fsDataOutputStream = (FSDataOutputStream)Mockito.spy((Object)new FSDataOutputStream((OutputStream)abfsOutputStream, null));
        return fsDataOutputStream;
    }

    @Test
    public void testWriteAsyncOpFailedAfterCloseCalled() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration())));){
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
            AbfsBlobClient blobClient = (AbfsBlobClient)Mockito.spy((Object)clientHandler.getBlobClient());
            AbfsDfsClient dfsClient = (AbfsDfsClient)Mockito.spy((Object)clientHandler.getDfsClient());
            AbfsClient client = clientHandler.getIngressClient();
            if (clientHandler.getIngressClient() instanceof AbfsBlobClient) {
                ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getBlobClient();
                ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getIngressClient();
            } else {
                ((AbfsClientHandler)Mockito.doReturn((Object)dfsClient).when((Object)clientHandler)).getDfsClient();
                ((AbfsClientHandler)Mockito.doReturn((Object)dfsClient).when((Object)clientHandler)).getIngressClient();
            }
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)clientHandler).when((Object)store)).getClientHandler();
            byte[] bytes = new byte[0x800000];
            new Random().nextBytes(bytes);
            AtomicInteger count = new AtomicInteger(0);
            ((AbfsClient)Mockito.doAnswer(answer -> {
                count.incrementAndGet();
                while (count.get() < 2) {
                }
                Thread.sleep(1000L);
                throw new AbfsRestOperationException(503, "", "", new Exception());
            }).when(client instanceof AbfsBlobClient ? blobClient : dfsClient)).append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
            ((AbfsClient)Mockito.doAnswer(answer -> {
                count.incrementAndGet();
                while (count.get() < 2) {
                }
                Thread.sleep(1000L);
                throw new AbfsRestOperationException(503, "", "", new Exception());
            }).when(client instanceof AbfsBlobClient ? blobClient : dfsClient)).append(Mockito.anyString(), (byte[])Mockito.any(byte[].class), (AppendRequestParameters)Mockito.any(AppendRequestParameters.class), (String)Mockito.any(), (ContextEncryptionAdapter)Mockito.any(), (TracingContext)Mockito.any(TracingContext.class));
            FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file"), (AbfsClient)(client instanceof AbfsBlobClient ? blobClient : dfsClient));
            os.write(bytes);
            os.write(bytes);
            LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)os).close());
            count.set(0);
            FSDataOutputStream os1 = this.createMockedOutputStream(fs, new Path("/test/file1"), (AbfsClient)(client instanceof AbfsBlobClient ? blobClient : dfsClient));
            os1.write(bytes);
            os1.write(bytes);
            LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)os1).hsync());
            count.set(0);
            FSDataOutputStream os2 = this.createMockedOutputStream(fs, new Path("/test/file2"), (AbfsClient)(client instanceof AbfsBlobClient ? blobClient : dfsClient));
            os2.write(bytes);
            os2.write(bytes);
            LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)os2).hflush());
        }
    }

    private String generateBlockId(AbfsOutputStream os, long position) {
        String streamId = os.getStreamID();
        String streamIdHash = Integer.toString(streamId.hashCode());
        String blockId = String.format("%d_%s", position, streamIdHash);
        byte[] blockIdByteArray = new byte[60];
        System.arraycopy(blockId.getBytes(), 0, blockIdByteArray, 0, Math.min(60, blockId.length()));
        return new String(Base64.encodeBase64((byte[])blockIdByteArray), StandardCharsets.UTF_8);
    }

    @Test
    public void testFlushSuccessWithConnectionResetOnResponseValidMd5() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration())));){
            this.assumeHnsDisabled();
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            this.assumeBlobServiceType();
            AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
            AbfsBlobClient blobClient = (AbfsBlobClient)Mockito.spy((Object)clientHandler.getBlobClient());
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)clientHandler).when((Object)store)).getClientHandler();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getBlobClient();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getIngressClient();
            AtomicInteger flushCount = new AtomicInteger(0);
            FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file"), (AbfsClient)blobClient);
            AbfsOutputStream out = (AbfsOutputStream)os.getWrappedStream();
            String eTag = out.getIngressHandler().getETag();
            byte[] bytes = new byte[0x800000];
            new Random().nextBytes(bytes);
            out.write(bytes);
            String blockId = this.generateBlockId(out, 0L);
            String blockListXml = AbfsBlobClient.generateBlockListXml((String)blockId);
            ((AbfsBlobClient)Mockito.doAnswer(answer -> {
                AbfsClientTestUtil.setMockAbfsRestOperationForFlushOperation((AbfsClient)blobClient, eTag, blockListXml, (FunctionRaisingIOE<AbfsHttpOperation, AbfsHttpOperation>)((FunctionRaisingIOE)httpOperation -> {
                    ((AbfsHttpOperation)Mockito.doAnswer(invocation -> {
                        invocation.callRealMethod();
                        int currentCount = flushCount.incrementAndGet();
                        if (currentCount == 1) {
                            Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)500);
                            Mockito.when((Object)httpOperation.getStorageErrorMessage()).thenReturn((Object)"CONNECTION_RESET");
                            throw new IOException("Connection Reset");
                        }
                        return null;
                    }).when(httpOperation)).processResponse((byte[])Mockito.nullable(byte[].class), Mockito.anyInt(), Mockito.anyInt());
                    return httpOperation;
                }));
                return answer.callRealMethod();
            }).when((Object)blobClient)).flush((byte[])Mockito.any(byte[].class), Mockito.anyString(), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (String)Mockito.nullable(String.class), Mockito.anyString(), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.any(TracingContext.class));
            out.hsync();
            out.close();
            ((AbfsBlobClient)Mockito.verify((Object)blobClient, (VerificationMode)Mockito.times((int)1))).flush((byte[])Mockito.any(byte[].class), Mockito.anyString(), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (String)Mockito.nullable(String.class), Mockito.anyString(), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.any(TracingContext.class));
        }
    }

    @Test
    public void testFlushSuccessWithConnectionResetOnResponseInvalidMd5() throws Exception {
        Assume.assumeFalse((String)"Not valid for APPEND BLOB", (boolean)this.isAppendBlobEnabled());
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration())));){
            this.assumeHnsDisabled();
            AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
            this.assumeBlobServiceType();
            AbfsClientHandler clientHandler = (AbfsClientHandler)Mockito.spy((Object)store.getClientHandler());
            AbfsBlobClient blobClient = (AbfsBlobClient)Mockito.spy((Object)clientHandler.getBlobClient());
            ((AzureBlobFileSystemStore)Mockito.doReturn((Object)clientHandler).when((Object)store)).getClientHandler();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getBlobClient();
            ((AbfsClientHandler)Mockito.doReturn((Object)blobClient).when((Object)clientHandler)).getIngressClient();
            AtomicInteger flushCount = new AtomicInteger(0);
            FSDataOutputStream os = this.createMockedOutputStream(fs, new Path("/test/file"), (AbfsClient)blobClient);
            AbfsOutputStream out = (AbfsOutputStream)os.getWrappedStream();
            String eTag = out.getIngressHandler().getETag();
            byte[] bytes = new byte[0x800000];
            new Random().nextBytes(bytes);
            out.write(bytes);
            String blockId = this.generateBlockId(out, 0L);
            String blockListXml = AbfsBlobClient.generateBlockListXml((String)blockId);
            ((AbfsBlobClient)Mockito.doAnswer(answer -> {
                AbfsClientTestUtil.setMockAbfsRestOperationForFlushOperation((AbfsClient)blobClient, eTag, blockListXml, (FunctionRaisingIOE<AbfsHttpOperation, AbfsHttpOperation>)((FunctionRaisingIOE)httpOperation -> {
                    ((AbfsHttpOperation)Mockito.doAnswer(invocation -> {
                        invocation.callRealMethod();
                        int currentCount = flushCount.incrementAndGet();
                        if (currentCount == 1) {
                            Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)500);
                            Mockito.when((Object)httpOperation.getStorageErrorMessage()).thenReturn((Object)"CONNECTION_RESET");
                            throw new IOException("Connection Reset");
                        }
                        if (currentCount == 2) {
                            Mockito.when((Object)httpOperation.getStatusCode()).thenReturn((Object)200);
                            Mockito.when((Object)httpOperation.getStorageErrorMessage()).thenReturn((Object)"HTTP_OK");
                        }
                        return null;
                    }).when(httpOperation)).processResponse((byte[])Mockito.nullable(byte[].class), Mockito.anyInt(), Mockito.anyInt());
                    return httpOperation;
                }));
                return answer.callRealMethod();
            }).when((Object)blobClient)).flush((byte[])Mockito.any(byte[].class), Mockito.anyString(), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (String)Mockito.nullable(String.class), Mockito.anyString(), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.any(TracingContext.class));
            FSDataOutputStream os1 = this.createMockedOutputStream(fs, new Path("/test/file"), (AbfsClient)blobClient);
            AbfsOutputStream out1 = (AbfsOutputStream)os1.getWrappedStream();
            byte[] bytes1 = new byte[0x800000];
            new Random().nextBytes(bytes1);
            out1.write(bytes1);
            Thread parallelFlushThread = new Thread(() -> {
                try {
                    out1.hsync();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            parallelFlushThread.start();
            parallelFlushThread.join();
            LambdaTestUtils.intercept(IOException.class, (String)"The condition specified using HTTP conditional header(s) is not met.", () -> ((AbfsOutputStream)out).hsync());
        }
    }
}

