/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.enums.AbfsReadFooterMetricsEnum;
import org.apache.hadoop.fs.azurebfs.enums.FileType;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsReadFooterMetrics;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.MetricFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;

public class ITestAbfsReadFooterMetrics
extends AbstractAbfsScaleTest {
    private static final String TEST_PATH = "/testfile";
    private static final String SLEEP_PERIOD = "90000";

    public ITestAbfsReadFooterMetrics() throws Exception {
        this.checkPrerequisites();
    }

    private void checkPrerequisites() {
        this.checkIfConfigIsSet("fs.azure.metric.account.name");
        this.checkIfConfigIsSet("fs.azure.metric.account.key");
        this.checkIfConfigIsSet("fs.azure.metric.uri");
    }

    private void checkIfConfigIsSet(String configKey) {
        AbfsConfiguration conf = this.getConfiguration();
        String value = conf.get(configKey);
        Assume.assumeTrue((String)(configKey + " config is mandatory for the test to run"), (value != null && value.trim().length() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReadFooterMetricsWithParquetAndNonParquet() throws Exception {
        this.testReadWriteAndSeek(0x800000, 0x400000, 1024, 4096);
    }

    private Configuration getConfiguration(int bufferSize) {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.metric.format", String.valueOf(MetricFormat.INTERNAL_FOOTER_METRIC_FORMAT));
        configuration.setInt("fs.azure.read.request.size", bufferSize);
        configuration.setInt("fs.azure.write.request.size", bufferSize);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToFile(AzureBlobFileSystem fs, Path testPath, byte[] data) throws IOException {
        try (FSDataOutputStream stream = fs.create(testPath);){
            stream.write(data);
        }
        IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)stream);
    }

    private void assertMetricsEquality(AzureBlobFileSystem fs, String expectedMetrics) {
        AbfsReadFooterMetrics actualMetrics = fs.getAbfsClient().getAbfsCounters().getAbfsReadFooterMetrics();
        ITestAbfsReadFooterMetrics.assertNotNull((String)"AbfsReadFooterMetrics is null", (Object)actualMetrics);
        ITestAbfsReadFooterMetrics.assertEquals((String)"The computed metrics differs from the actual metrics", (Object)expectedMetrics, (Object)actualMetrics.toString());
    }

    @Test
    public void testReadFooterMetrics() throws Exception {
        int result;
        int bufferSize = 16384;
        Configuration configuration = this.getConfiguration(bufferSize);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        byte[] b = new byte[2 * bufferSize];
        new Random().nextBytes(b);
        Path testPath = this.path(TEST_PATH);
        this.writeDataToFile(fs, testPath, b);
        byte[] readBuffer = new byte[2 * bufferSize];
        FSDataInputStream statisticsSource = null;
        try (FSDataInputStream inputStream = fs.open(testPath);){
            statisticsSource = inputStream;
            ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, true, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
            inputStream.seek((long)bufferSize);
            result = inputStream.read(readBuffer, bufferSize, bufferSize);
            ITestAbfsReadFooterMetrics.assertNotEquals((long)-1L, (long)result);
            inputStream.seek(0L);
            byte[] temp = new byte[5];
            int t = inputStream.read(temp, 0, 1);
            inputStream.seek(0L);
            result = inputStream.read(readBuffer, 0, bufferSize);
        }
        IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)"info", (Object)statisticsSource);
        ITestAbfsReadFooterMetrics.assertNotEquals((String)"data read in final read()", (long)-1L, (long)result);
        ITestAbfsReadFooterMetrics.assertArrayEquals((byte[])readBuffer, (byte[])b);
        AbfsReadFooterMetrics nonParquetMetrics = this.getNonParquetMetrics();
        String metrics = nonParquetMetrics.toString();
        this.assertMetricsEquality(fs, metrics);
        fs.close();
    }

    private AbfsReadFooterMetrics getNonParquetMetrics() {
        AbfsReadFooterMetrics nonParquetMetrics = new AbfsReadFooterMetrics();
        nonParquetMetrics.addMeanMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.AVG_FILE_LENGTH, Long.parseLong("32768"));
        nonParquetMetrics.addMeanMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.AVG_READ_LEN_REQUESTED, Long.parseLong("10923"));
        nonParquetMetrics.addMeanMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.AVG_SIZE_READ_BY_FIRST_READ, Long.parseLong("16384"));
        nonParquetMetrics.addMeanMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.AVG_OFFSET_DIFF_BETWEEN_FIRST_AND_SECOND_READ, 1L);
        nonParquetMetrics.addMeanMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.AVG_FIRST_OFFSET_DIFF, Long.parseLong("16384"));
        nonParquetMetrics.addMeanMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.AVG_SECOND_OFFSET_DIFF, Long.parseLong("16384"));
        nonParquetMetrics.incrementMetricValue(FileType.NON_PARQUET, AbfsReadFooterMetricsEnum.TOTAL_FILES);
        return nonParquetMetrics;
    }

    private AbfsReadFooterMetrics getParquetMetrics() {
        AbfsReadFooterMetrics parquetMetrics = new AbfsReadFooterMetrics();
        parquetMetrics.addMeanMetricValue(FileType.PARQUET, AbfsReadFooterMetricsEnum.AVG_FILE_LENGTH, Long.parseLong("8388608"));
        parquetMetrics.addMeanMetricValue(FileType.PARQUET, AbfsReadFooterMetricsEnum.AVG_READ_LEN_REQUESTED, Long.parseLong("2560"));
        parquetMetrics.addMeanMetricValue(FileType.PARQUET, AbfsReadFooterMetricsEnum.AVG_SIZE_READ_BY_FIRST_READ, Long.parseLong("1024"));
        parquetMetrics.addMeanMetricValue(FileType.PARQUET, AbfsReadFooterMetricsEnum.AVG_OFFSET_DIFF_BETWEEN_FIRST_AND_SECOND_READ, Long.parseLong("4096"));
        parquetMetrics.incrementMetricValue(FileType.PARQUET, AbfsReadFooterMetricsEnum.TOTAL_FILES);
        return parquetMetrics;
    }

    private void testReadWriteAndSeek(int fileSize, int bufferSize, Integer seek1, Integer seek2) throws Exception {
        FSDataInputStream inputStream1;
        FSDataInputStream inputStream;
        Configuration configuration = this.getConfiguration(bufferSize);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        byte[] b = new byte[fileSize];
        new Random().nextBytes(b);
        Path testPath = this.path(TEST_PATH);
        this.writeDataToFile(fs, testPath, b);
        byte[] readBuffer = new byte[fileSize];
        FSDataInputStream statisticsSource = null;
        statisticsSource = inputStream = fs.open(testPath);
        ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, true, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
        inputStream.seek((long)(fileSize - seek1));
        inputStream.read(readBuffer, 0, seek1.intValue());
        if (seek2 != 0) {
            inputStream.seek((long)(fileSize - seek1 - seek2));
            inputStream.read(readBuffer, 0, seek2.intValue());
        }
        inputStream.close();
        int bufferSize1 = 16384;
        abfsConfiguration.setWriteBufferSize(bufferSize1);
        abfsConfiguration.setReadBufferSize(bufferSize1);
        byte[] b1 = new byte[2 * bufferSize1];
        new Random().nextBytes(b1);
        Path testPath1 = this.path("/testfile1");
        this.writeDataToFile(fs, testPath1, b1);
        byte[] readBuffer1 = new byte[2 * bufferSize1];
        statisticsSource = inputStream1 = fs.open(testPath1);
        ((AbfsInputStream)inputStream1.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, true, 0, ((AbfsInputStream)inputStream1.getWrappedStream()).getStreamID()));
        inputStream1.seek((long)bufferSize1);
        inputStream1.read(readBuffer1, bufferSize1, bufferSize1);
        inputStream1.seek(0L);
        byte[] temp = new byte[5];
        int t = inputStream1.read(temp, 0, 1);
        inputStream1.seek(0L);
        inputStream1.read(readBuffer1, 0, bufferSize1);
        inputStream1.close();
        AbfsReadFooterMetrics parquetMetrics = this.getParquetMetrics();
        AbfsReadFooterMetrics nonParquetMetrics = this.getNonParquetMetrics();
        Object metrics = parquetMetrics.toString();
        metrics = (String)metrics + nonParquetMetrics.toString();
        this.assertMetricsEquality(fs, (String)metrics);
        fs.close();
    }

    @Test
    public void testMetricWithIdlePeriod() throws Exception {
        int bufferSize = 16384;
        Configuration configuration = this.getConfiguration(bufferSize);
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration);
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        byte[] b = new byte[2 * bufferSize];
        new Random().nextBytes(b);
        Path testPath = this.path(TEST_PATH);
        this.writeDataToFile(fs, testPath, b);
        byte[] readBuffer = new byte[2 * bufferSize];
        Object statisticsSource = null;
        try (FSDataInputStream inputStream = fs.open(testPath);){
            ((AbfsInputStream)inputStream.getWrappedStream()).registerListener((Listener)new TracingHeaderValidator(abfsConfiguration.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.READ, true, 0, ((AbfsInputStream)inputStream.getWrappedStream()).getStreamID()));
            inputStream.seek((long)bufferSize);
            inputStream.read(readBuffer, bufferSize, bufferSize);
            int sleepPeriod = Integer.parseInt(SLEEP_PERIOD);
            Thread.sleep(sleepPeriod);
            inputStream.seek(0L);
            byte[] temp = new byte[5];
            int t = inputStream.read(temp, 0, 1);
            inputStream.seek(0L);
            inputStream.read(readBuffer, 0, bufferSize);
            AbfsReadFooterMetrics nonParquetMetrics = this.getNonParquetMetrics();
            String metrics = nonParquetMetrics.toString();
            this.assertMetricsEquality(fs, metrics);
            Thread.sleep(sleepPeriod);
        }
    }
}

