/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.junit.Ignore;
import org.junit.Test;

public class TestNativeAzureFileSystemUploadLogic
extends AbstractWasbTestBase {
    static final int byteValuePeriod = 47;

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.createMock();
    }

    @Test
    @Ignore
    public void testConsistencyAfterSmallFlushes() throws Exception {
        this.testConsistencyAfterManyFlushes(FlushFrequencyVariation.BeforeSingleBufferFull);
    }

    @Test
    @Ignore
    public void testConsistencyAfterMediumFlushes() throws Exception {
        this.testConsistencyAfterManyFlushes(FlushFrequencyVariation.AfterSingleBufferFull);
    }

    @Test
    @Ignore
    public void testConsistencyAfterLargeFlushes() throws Exception {
        this.testConsistencyAfterManyFlushes(FlushFrequencyVariation.AfterAllRingBufferFull);
    }

    private void assertDataInStream(InputStream inStream, int expectedSize) throws Exception {
        int byteRead;
        int countBytes = 0;
        while ((byteRead = inStream.read()) != -1) {
            TestNativeAzureFileSystemUploadLogic.assertEquals((long)(countBytes % 47), (long)byteRead);
            ++countBytes;
        }
        TestNativeAzureFileSystemUploadLogic.assertEquals((long)expectedSize, (long)countBytes);
    }

    private void assertDataInFile(Path file, int expectedSize) throws Exception {
        try (FSDataInputStream inStream = this.getFileSystem().open(file);){
            this.assertDataInStream((InputStream)inStream, expectedSize);
        }
    }

    private void assertDataInTempBlob(int expectedSize) throws Exception {
        InMemoryBlockBlobStore backingStore = this.getTestAccount().getMockStorage().getBackingStore();
        String tempKey = null;
        for (String key : backingStore.getKeys()) {
            if (!key.contains("_$azuretmpfolder$")) continue;
            tempKey = key;
            break;
        }
        TestNativeAzureFileSystemUploadLogic.assertNotNull(tempKey);
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(backingStore.getContent(tempKey));){
            this.assertDataInStream(inStream, expectedSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConsistencyAfterManyFlushes(FlushFrequencyVariation variation) throws Exception {
        Path uploadedFile = this.methodPath();
        try {
            FSDataOutputStream outStream = this.getFileSystem().create(uploadedFile);
            int totalSize = 9123;
            int flushPeriod = switch (variation) {
                case FlushFrequencyVariation.BeforeSingleBufferFull -> 300;
                case FlushFrequencyVariation.AfterSingleBufferFull -> 600;
                case FlushFrequencyVariation.AfterAllRingBufferFull -> 1600;
                default -> throw new IllegalArgumentException("Unknown variation: " + variation);
            };
            for (int i = 0; i < 9123; ++i) {
                outStream.write(i % 47);
                if ((i + 1) % flushPeriod != 0) continue;
                outStream.flush();
                this.assertDataInTempBlob(i + 1);
            }
            outStream.close();
            this.assertDataInFile(uploadedFile, 9123);
        }
        finally {
            this.getFileSystem().delete(uploadedFile, false);
        }
    }

    private static enum FlushFrequencyVariation {
        BeforeSingleBufferFull,
        AfterSingleBufferFull,
        AfterAllRingBufferFull;

    }
}

