/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.MockWasbAuthorizerImpl;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.WasbAuthorizationException;
import org.apache.hadoop.fs.azure.WasbAuthorizationOperations;
import org.apache.hadoop.fs.azure.WasbAuthorizerInterface;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestNativeAzureFileSystemAuthorization
extends AbstractWasbTestBase {
    private static final short FULL_PERMISSION_WITH_STICKYBIT = 1777;
    @VisibleForTesting
    protected MockWasbAuthorizerImpl authorizer;
    @VisibleForTesting
    protected static final short STICKYBIT_PERMISSION_CONSTANT = 1700;
    @VisibleForTesting
    protected static final String READ = WasbAuthorizationOperations.READ.toString();
    @VisibleForTesting
    protected static final String WRITE = WasbAuthorizationOperations.WRITE.toString();
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.set("fs.azure.authorization", "true");
        conf.set("fs.azure.secure.mode", "true");
        conf.set("fs.azure.authorization.remote.service.urls", "http://localhost/");
        conf.set("fs.azure.chown.allowed.userlist", "user1 , user2");
        conf.set("fs.azure.authorization.caching.enable", "false");
        conf.set("fs.azure.chmod.allowed.userlist", "user1 , user2");
        conf.set("fs.azure.daemon.userlist", "hive , hcs , yarn");
        return conf;
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create(this.createConfiguration());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        boolean useSecureMode = this.fs.getConf().getBoolean("fs.azure.secure.mode", false);
        boolean useAuthorization = this.fs.getConf().getBoolean("fs.azure.authorization", false);
        Assume.assumeTrue((String)"Test valid when both SecureMode and Authorization are enabled .. skipping", (useSecureMode && useAuthorization ? 1 : 0) != 0);
        this.authorizer = new MockWasbAuthorizerImpl(this.fs);
        this.authorizer.init(this.fs.getConf());
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
    }

    protected void allowRecursiveDelete(NativeAzureFileSystem fs, String path) throws IOException {
        int index = path.lastIndexOf(47);
        String parent = index == 0 ? "/" : path.substring(0, index);
        this.authorizer.deleteAllAuthRules();
        this.authorizer.addAuthRule(parent, WRITE, this.getCurrentUserShortName(), true);
        this.authorizer.addAuthRule((String)(path.endsWith("*") ? path : path + "*"), WRITE, this.getCurrentUserShortName(), true);
        fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
    }

    protected void setExpectedFailureMessage(String operation, Path path) {
        this.expectedEx.expect(WasbAuthorizationException.class);
        this.expectedEx.expectMessage(String.format("%s operation for Path : %s not allowed", operation, path.makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory())));
    }

    protected String getCurrentUserShortName() throws IOException {
        return UserGroupInformation.getCurrentUser().getShortUserName();
    }

    @Test
    public void testCreateAccessWithoutCreateIntermediateFoldersCheckPositive() throws Throwable {
        Path parentDir = new Path("/");
        Path testPath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    @Test
    public void testCreateAccessWithCreateIntermediateFoldersCheckPositive() throws Throwable {
        Path parentDir = new Path("/testCreateAccessCheckPositive/1/2/3");
        Path testPath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, "/testCreateAccessCheckPositive");
            this.fs.delete(new Path("/testCreateAccessCheckPositive"), true);
        }
    }

    @Test
    public void testCreateAccessWithOverwriteCheckNegative() throws Throwable {
        Path parentDir = new Path("/");
        Path testPath = new Path(parentDir, "test.dat");
        this.setExpectedFailureMessage("create", testPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.fs.create(testPath, true);
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    @Test
    public void testCreateAccessWithOverwriteCheckPositive() throws Throwable {
        Path parentDir = new Path("/");
        Path testPath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.fs.create(testPath, true);
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    @Test
    public void testCreateAccessCheckNegative() throws Throwable {
        Path parentDir = new Path("/testCreateAccessCheckNegative");
        Path testPath = new Path(parentDir, "test.dat");
        this.setExpectedFailureMessage("create", testPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, false);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListAccessCheckPositive() throws Throwable {
        Path parentDir = new Path("/testListAccessCheckPositive");
        Path intermediateFolders = new Path(parentDir, "1/2/3/");
        Path testPath = new Path(intermediateFolders, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            this.fs.listStatus(testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    @Test
    public void testListAccessCheckNegative() throws Throwable {
        Path parentDir = new Path("/testListAccessCheckNegative");
        Path testPath = new Path(parentDir, "test.dat");
        this.setExpectedFailureMessage("liststatus", testPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, false);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            this.fs.listStatus(testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAccessCheckPositive() throws Throwable {
        Path parentDir = new Path("/testRenameAccessCheckPositive");
        Path srcPath = new Path(parentDir, "test1.dat");
        Path dstPath = new Path(parentDir, "test2.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            ContractTestUtils.assertRenameOutcome((FileSystem)this.fs, (Path)srcPath, (Path)dstPath, (boolean)true);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstPath);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"sourcePath exists after rename!", (Path)srcPath);
        }
        finally {
            this.recursiveDelete(parentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAccessCheckNegative() throws Throwable {
        Path parentDir = new Path("/testRenameAccessCheckNegative");
        Path srcPath = new Path(parentDir, "test1.dat");
        Path dstPath = new Path(parentDir, "test2.dat");
        this.setExpectedFailureMessage("rename", srcPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, false);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            this.fs.rename(srcPath, dstPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstPath);
        }
        finally {
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist after rename failure!", (Path)srcPath);
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAccessCheckNegativeOnDstFolder() throws Throwable {
        Path parentSrcDir = new Path("/testRenameAccessCheckNegativeSrc");
        Path srcPath = new Path(parentSrcDir, "test1.dat");
        Path parentDstDir = new Path("/testRenameAccessCheckNegativeDst");
        Path dstPath = new Path(parentDstDir, "test2.dat");
        this.setExpectedFailureMessage("rename", dstPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDstDir.toString(), WRITE, false);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            this.fs.mkdirs(parentDstDir);
            this.fs.rename(srcPath, dstPath);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstPath);
        }
        finally {
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist after rename !", (Path)srcPath);
            this.recursiveDelete(parentSrcDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAccessCheckPositiveOnDstFolder() throws Throwable {
        Path parentSrcDir = new Path("/testRenameAccessCheckPositiveSrc");
        Path srcPath = new Path(parentSrcDir, "test1.dat");
        Path parentDstDir = new Path("/testRenameAccessCheckPositiveDst");
        Path dstPath = new Path(parentDstDir, "test2.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDstDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            this.fs.mkdirs(parentDstDir);
            ContractTestUtils.assertRenameOutcome((FileSystem)this.fs, (Path)srcPath, (Path)dstPath, (boolean)true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstPath);
        }
        finally {
            this.recursiveDelete(parentSrcDir);
            this.recursiveDelete(parentDstDir);
        }
    }

    private void recursiveDelete(Path path) {
        try {
            this.allowRecursiveDelete(this.fs, path.toString());
            this.fs.delete(path, true);
        }
        catch (IOException e) {
            LOG.error("Failed to delete {}", (Object)path, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenamePositiveWhenDestinationFolderExists() throws Throwable {
        Path parentSrcDir = new Path("/testRenamePositiveForFolderSrc");
        Path srcFilePath = new Path(parentSrcDir, "test1.dat");
        Path srcFolderPath = new Path(parentSrcDir, "testFolder");
        Path dstDir = new Path("/testRenamePositiveForFolderDst");
        Path finalDstDir = new Path(dstDir, "testRenamePositiveForFolderSrc");
        Path dstFilePath = new Path(finalDstDir, "test1.dat");
        Path dstFolderPath = new Path(finalDstDir, "testFolder");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(dstDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner("/", READ, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), READ, true);
        this.authorizer.addAuthRuleForOwner(finalDstDir.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"srcFilePath does not exist", (Path)srcFilePath);
            this.fs.mkdirs(srcFolderPath);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)srcFolderPath);
            this.fs.mkdirs(dstDir);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)dstDir);
            ContractTestUtils.assertRenameOutcome((FileSystem)this.fs, (Path)parentSrcDir, (Path)dstDir, (boolean)true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"parentSrcDir exists", (Path)parentSrcDir);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"srcFilePath exists", (Path)srcFilePath);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"srcFolderPath exists", (Path)srcFolderPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstDir);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"dstFilePath does not exist", (Path)dstFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"dstFolderPath does not exist", (Path)dstFolderPath);
        }
        finally {
            this.recursiveDelete(parentSrcDir);
            this.recursiveDelete(dstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenamePositiveWhenDestinationFolderDoesNotExist() throws Throwable {
        Path srcParentDir = new Path("/testRenamePositiveWhenDestinationFolderDoesNotExist");
        Path srcDir = new Path(srcParentDir, "srcDir");
        Path srcFilePath = new Path(srcDir, "test1.dat");
        Path srcSubDirPath = new Path(srcDir, "testFolder");
        Path srcSubDirFilePath = new Path(srcSubDirPath, "test2.dat");
        Path dstDir = new Path(srcParentDir, "dstDir");
        Path dstFilePath = new Path(dstDir, "test1.dat");
        Path dstSubDirPath = new Path(dstDir, "testFolder");
        Path dstSubDirFilePath = new Path(dstSubDirPath, "test2.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(srcParentDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(srcDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(srcSubDirPath.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner("/", READ, true);
        this.authorizer.addAuthRuleForOwner(srcParentDir.toString(), READ, true);
        this.authorizer.addAuthRuleForOwner(srcDir.toString(), READ, true);
        this.authorizer.addAuthRuleForOwner(srcSubDirPath.toString(), READ, true);
        this.authorizer.addAuthRuleForOwner(dstDir.toString(), READ, true);
        this.authorizer.addAuthRuleForOwner(dstSubDirPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"srcFilePath does not exist", (Path)srcFilePath);
            this.fs.mkdirs(srcSubDirPath);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)srcSubDirPath);
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcSubDirFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"srcSubDirFilePath does not exist", (Path)srcSubDirFilePath);
            ContractTestUtils.assertRenameOutcome((FileSystem)this.fs, (Path)srcDir, (Path)dstDir, (boolean)true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"srcDir exists", (Path)srcDir);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"srcFilePath exists", (Path)srcFilePath);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"srcSubDirPath exists", (Path)srcSubDirPath);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"srcSubDirFilePath exists", (Path)srcSubDirFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstDir);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"dstFilePath does not exist", (Path)dstFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"dstSubDirPath does not exist", (Path)dstSubDirPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"dstSubDirFilePath does not exist", (Path)dstSubDirFilePath);
        }
        finally {
            this.recursiveDelete(srcParentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameOnNonExistentSource() throws Throwable {
        Path parentSrcDir = new Path("/testRenameOnNonExistentSourceFolderSrc");
        Path srcPath = new Path(parentSrcDir, "test1.dat");
        Path parentDstDir = new Path("/testRenameOnNonExistentSourceFolderDst");
        Path dstPath = new Path(parentDstDir, "test2.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDstDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner("/", READ, true);
        this.authorizer.addAuthRuleForOwner(parentDstDir.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(parentSrcDir);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)parentSrcDir);
            this.fs.mkdirs(parentDstDir);
            ContractTestUtils.assertRenameOutcome((FileSystem)this.fs, (Path)srcPath, (Path)dstPath, (boolean)false);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"destPath exists!", (Path)dstPath);
        }
        finally {
            this.recursiveDelete(parentSrcDir);
            this.recursiveDelete(parentDstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithStickyBitPositive() throws Throwable {
        Path parentSrcDir = new Path("/testRenameWithStickyBitPositiveSrc");
        Path srcPath = new Path(parentSrcDir, "test1.dat");
        Path parentDstDir = new Path("/testRenameWithStickyBitPositiveDst");
        Path dstPath = new Path(parentDstDir, "test2.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDstDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            this.fs.mkdirs(parentDstDir);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)parentDstDir);
            this.fs.setPermission(parentSrcDir, new FsPermission(1700));
            ContractTestUtils.assertRenameOutcome((FileSystem)this.fs, (Path)srcPath, (Path)dstPath, (boolean)true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"sourcePath exists", (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"destPath does not exist", (Path)dstPath);
        }
        finally {
            this.recursiveDelete(parentSrcDir);
            this.recursiveDelete(parentDstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithStickyBitNegative() throws Throwable {
        final Path parentSrcDir = new Path("/testRenameWithStickyBitNegativeSrc");
        final Path srcPath = new Path(parentSrcDir, "test1.dat");
        final Path parentDstDir = new Path("/testRenameWithStickyBitNegativeDst");
        final Path dstPath = new Path(parentDstDir, "test2.dat");
        this.expectedEx.expect(WasbAuthorizationException.class);
        this.expectedEx.expectMessage(String.format("Rename operation for %s is not permitted. Details : Stickybit check failed.", srcPath.toString()));
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            ContractTestUtils.touch((FileSystem)this.fs, (Path)srcPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"sourcePath does not exist", (Path)srcPath);
            this.fs.mkdirs(parentDstDir);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)parentDstDir);
            this.fs.setPermission(parentSrcDir, new FsPermission(1700));
            UserGroupInformation dummyUser = UserGroupInformation.createUserForTesting((String)"dummyUser", (String[])new String[]{"dummygroup"});
            dummyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule(parentSrcDir.toString(), WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule(parentDstDir.toString(), WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    try {
                        TestNativeAzureFileSystemAuthorization.this.fs.rename(srcPath, dstPath);
                    }
                    catch (WasbAuthorizationException wae) {
                        ContractTestUtils.assertPathExists((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"sourcePath does not exist", (Path)srcPath);
                        ContractTestUtils.assertPathDoesNotExist((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"destPath exists", (Path)dstPath);
                        throw wae;
                    }
                    return null;
                }
            });
        }
        finally {
            this.recursiveDelete(parentSrcDir);
            this.recursiveDelete(parentDstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameOnNonExistentSourceWithStickyBit() throws Throwable {
        final Path parentSrcDir = new Path("/testRenameOnNonExistentSourceWithStickyBitSrc");
        final Path srcPath = new Path(parentSrcDir, "test1.dat");
        final Path parentDstDir = new Path("/testRenameOnNonExistentSourceWithStickyBitDest");
        final Path dstPath = new Path(parentDstDir, "test2.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentSrcDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(parentSrcDir);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)parentSrcDir);
            this.fs.mkdirs(parentDstDir);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)parentDstDir);
            this.fs.setPermission(parentSrcDir, new FsPermission(1700));
            UserGroupInformation dummyUser = UserGroupInformation.createUserForTesting((String)"dummyUser", (String[])new String[]{"dummygroup"});
            dummyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule(parentSrcDir.toString(), WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule(parentDstDir.toString(), WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    ContractTestUtils.assertRenameOutcome((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (Path)srcPath, (Path)dstPath, (boolean)false);
                    ContractTestUtils.assertPathDoesNotExist((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"destPath exists", (Path)dstPath);
                    return null;
                }
            });
        }
        finally {
            this.recursiveDelete(parentSrcDir);
            this.recursiveDelete(parentDstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAccessCheckPositive() throws Throwable {
        Path parentDir = new Path("/testReadAccessCheckPositive");
        Path testPath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        FSDataInputStream inputStream = null;
        FSDataOutputStream fso = null;
        try {
            fso = this.fs.create(testPath);
            String data = "Hello World";
            fso.writeBytes(data);
            fso.close();
            inputStream = this.fs.open(testPath);
            ContractTestUtils.verifyRead((FSDataInputStream)inputStream, (byte[])data.getBytes(), (int)0, (int)data.length());
        }
        finally {
            if (fso != null) {
                fso.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAccessCheckNegative() throws Throwable {
        Path parentDir = new Path("/testReadAccessCheckNegative");
        Path testPath = new Path(parentDir, "test.dat");
        this.setExpectedFailureMessage("read", testPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, false);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        FSDataInputStream inputStream = null;
        FSDataOutputStream fso = null;
        try {
            fso = this.fs.create(testPath);
            String data = "Hello World";
            fso.writeBytes(data);
            fso.close();
            inputStream = this.fs.open(testPath);
            ContractTestUtils.verifyRead((FSDataInputStream)inputStream, (byte[])data.getBytes(), (int)0, (int)data.length());
        }
        finally {
            if (fso != null) {
                fso.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    @Test
    public void testFileDeleteAccessCheckPositive() throws Throwable {
        Path parentDir = new Path("/");
        Path testPath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
        }
        finally {
            this.fs.delete(testPath, false);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"testPath exists after deletion!", (Path)testPath);
        }
    }

    @Test
    public void testFileDeleteAccessCheckNegative() throws Throwable {
        Path parentDir = new Path("/");
        Path testPath = new Path(parentDir, "test.dat");
        this.setExpectedFailureMessage("delete", testPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.authorizer.deleteAllAuthRules();
            this.authorizer.addAuthRuleForOwner("/", WRITE, false);
            this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
            this.fs.delete(testPath, false);
        }
        finally {
            this.authorizer.deleteAllAuthRules();
            this.authorizer.addAuthRuleForOwner("/", WRITE, true);
            this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
            this.fs.delete(testPath, false);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"testPath exists after deletion!", (Path)testPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileDeleteAccessWithIntermediateFoldersCheckPositive() throws Throwable {
        Path parentDir = new Path("/testDeleteIntermediateFolder");
        Path childPath = new Path(parentDir, "1/2");
        Path testPath = new Path(childPath, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testDeleteIntermediateFolder*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.fs.delete(parentDir, true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"testPath exists after deletion!", (Path)parentDir);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAuthCheckFailureLeavesFilesUndeleted() throws Throwable {
        Path parentDir = new Path("/testDeleteAuthCheckFailureLeavesFilesUndeleted");
        Path childPath1 = new Path(parentDir, "child1");
        Path childPath2 = new Path(parentDir, "child2");
        Path testPath1 = new Path(childPath1, "test.dat");
        Path testPath2 = new Path(childPath2, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testDeleteAuthCheckFailureLeavesFilesUndeleted*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath1);
            this.fs.create(testPath2);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath1 was not created", (Path)testPath1);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath2 was not created", (Path)testPath2);
            this.authorizer.deleteAllAuthRules();
            this.authorizer.addAuthRuleForOwner("/", WRITE, true);
            this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
            this.authorizer.addAuthRuleForOwner(childPath2.toString(), WRITE, true);
            this.authorizer.addAuthRuleForOwner(childPath1.toString(), WRITE, false);
            TestNativeAzureFileSystemAuthorization.assertFalse((boolean)this.fs.delete(parentDir, true));
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"child1 is deleted!", (Path)testPath1);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"child2 exists after deletion!", (Path)testPath2);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"child2 exists after deletion!", (Path)childPath2);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"parentDir is deleted!", (Path)parentDir);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    @Test
    public void testSingleFileDeleteWithStickyBitPositive() throws Throwable {
        Path parentDir = new Path("/testSingleFileDeleteWithStickyBitPositive");
        Path testPath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.fs.setPermission(parentDir, new FsPermission(1700));
            TestNativeAzureFileSystemAuthorization.assertTrue((boolean)this.fs.delete(testPath, true));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"testPath exists after deletion!", (Path)testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleFileDeleteWithStickyBitNegative() throws Throwable {
        final Path parentDir = new Path("/testSingleFileDeleteWithStickyBitNegative");
        final Path testPath = new Path(parentDir, "test.dat");
        this.expectedEx.expect(WasbAuthorizationException.class);
        this.expectedEx.expectMessage(String.format("%s has sticky bit set. File %s cannot be deleted.", parentDir.toString(), testPath.toString()));
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.fs.setPermission(parentDir, new FsPermission(1700));
            UserGroupInformation dummyUser = UserGroupInformation.createUserForTesting((String)"dummyUser", (String[])new String[]{"dummygroup"});
            dummyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule(parentDir.toString(), WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                        TestNativeAzureFileSystemAuthorization.this.fs.delete(testPath, true);
                        return null;
                    }
                    catch (WasbAuthorizationException wae) {
                        ContractTestUtils.assertPathExists((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"testPath should not be deleted!", (Path)testPath);
                        throw wae;
                    }
                }
            });
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveDeleteSucceedsWithStickybit() throws Throwable {
        Path parentDir = new Path("/testRecursiveDeleteSucceedsWithStickybit");
        Path childDir = new Path(parentDir, "child");
        Path testFilePath = new Path(childDir, "test.dat");
        Path testFolderPath = new Path(childDir, "testDirectory");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testRecursiveDeleteSucceedsWithStickybit*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"file was not created", (Path)testFilePath);
            this.fs.mkdirs(testFolderPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"folder was not created", (Path)testFolderPath);
            this.fs.setPermission(new Path(parentDir, "child"), new FsPermission(1700));
            TestNativeAzureFileSystemAuthorization.assertTrue((boolean)this.fs.delete(parentDir, true));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"parentDir exists after deletion!", (Path)parentDir);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveDeleteFailsWithStickybit() throws Throwable {
        final Path parentDir = new Path("/testRecursiveDeleteFailsWithStickybit");
        Path childDir = new Path(parentDir, "child");
        Path testFilePath = new Path(childDir, "test.dat");
        Path testFolderPath = new Path(childDir, "testDirectory");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testRecursiveDeleteFailsWithStickybit*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"file was not created", (Path)testFilePath);
            this.fs.mkdirs(testFolderPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"folder was not created", (Path)testFolderPath);
            this.fs.setPermission(new Path(parentDir, "child"), new FsPermission(1700));
            UserGroupInformation dummyUser = UserGroupInformation.createUserForTesting((String)"dummyUser", (String[])new String[]{"dummygroup"});
            dummyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule("/", WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule("/testRecursiveDeleteFailsWithStickybit*", WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    Assert.assertFalse((boolean)TestNativeAzureFileSystemAuthorization.this.fs.delete(parentDir, true));
                    return null;
                }
            });
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"parentDir is deleted!", (Path)parentDir);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"file is deleted!", (Path)testFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"folder is deleted!", (Path)testFolderPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSucceedsForOnlyFilesOwnedByUserWithStickybitSet() throws Throwable {
        final Path parentDir = new Path("/testDeleteSucceedsForOnlyFilesOwnedByUserWithStickybitSet");
        final Path testFilePath = new Path(parentDir, "test.dat");
        final Path testFolderPath = new Path(parentDir, "testDirectory");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testDeleteSucceedsForOnlyFilesOwnedByUserWithStickybitSet*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testFilePath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"file was not created", (Path)testFilePath);
            this.fs.setPermission(parentDir, new FsPermission(1700));
            UserGroupInformation dummyUser = UserGroupInformation.createUserForTesting((String)"dummyuser", (String[])new String[]{"dummygroup"});
            dummyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule("/", WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule("/testDeleteSucceedsForOnlyFilesOwnedByUserWithStickybitSet*", WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    TestNativeAzureFileSystemAuthorization.this.fs.create(testFolderPath);
                    ContractTestUtils.assertPathExists((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"folder was not created", (Path)testFolderPath);
                    Assert.assertFalse((boolean)TestNativeAzureFileSystemAuthorization.this.fs.delete(parentDir, true));
                    ContractTestUtils.assertPathDoesNotExist((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"folder should have been deleted!", (Path)testFolderPath);
                    ContractTestUtils.assertPathExists((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"parentDir is deleted!", (Path)parentDir);
                    ContractTestUtils.assertPathExists((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"file is deleted!", (Path)testFilePath);
                    return null;
                }
            });
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSucceedsForParentDirectoryOwnerUserWithStickybit() throws Throwable {
        final Path parentDir = new Path("/testDeleteSucceedsForParentDirectoryOwnerUserWithStickybit");
        final Path testFilePath = new Path(parentDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testDeleteSucceedsForParentDirectoryOwnerUserWithStickybit*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(parentDir);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"folder was not created", (Path)parentDir);
            UserGroupInformation dummyUser = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"dummygroup"});
            dummyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.authorizer.addAuthRule(parentDir.toString(), WRITE, TestNativeAzureFileSystemAuthorization.this.getCurrentUserShortName(), true);
                    TestNativeAzureFileSystemAuthorization.this.fs.create(testFilePath);
                    ContractTestUtils.assertPathExists((FileSystem)TestNativeAzureFileSystemAuthorization.this.fs, (String)"file was not created", (Path)testFilePath);
                    TestNativeAzureFileSystemAuthorization.this.fs.setPermission(parentDir, new FsPermission(1700));
                    return null;
                }
            });
            TestNativeAzureFileSystemAuthorization.assertTrue((boolean)this.fs.delete(parentDir, true));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"parentDir is not deleted!", (Path)parentDir);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"file is not deleted!", (Path)testFilePath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteScenarioForRoot() throws Throwable {
        Path rootPath = new Path("/");
        Path parentDir = new Path("/testDeleteScenarioForRoot");
        Path childPath1 = new Path(parentDir, "child1");
        Path childPath2 = new Path(parentDir, "child2");
        Path testPath1 = new Path(childPath1, "test.dat");
        Path testPath2 = new Path(childPath2, "testFolder");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner("/testDeleteScenarioForRoot*", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(testPath1);
            this.fs.create(testPath2);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath1 was not created", (Path)testPath1);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath2 was not created", (Path)testPath2);
            TestNativeAzureFileSystemAuthorization.assertFalse((boolean)this.fs.delete(rootPath, true));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"file exists after deletion!", (Path)testPath1);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"folder exists after deletion!", (Path)testPath2);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"parentDir exists after deletion!", (Path)parentDir);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"Root should not have been deleted!", (Path)rootPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    @Test
    public void testGetFileStatusPositive() throws Throwable {
        Path testPath = new Path("/");
        this.authorizer.addAuthRuleForOwner("/", READ, true);
        ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)testPath);
    }

    @Test
    public void testMkdirsCheckPositive() throws Throwable {
        Path testPath = new Path("/testMkdirsAccessCheckPositive/1/2/3");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, "/testMkdirsAccessCheckPositive");
            this.fs.delete(new Path("/testMkdirsAccessCheckPositive"), true);
        }
    }

    @Test
    public void testMkdirsWithExistingHierarchyCheckPositive1() throws Throwable {
        Path testPath = new Path("/testMkdirsWithExistingHierarchyCheckPositive1");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)testPath);
            this.authorizer.deleteAllAuthRules();
            this.authorizer.addAuthRuleForOwner(testPath.getParent().toString(), READ, true);
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, testPath.toString());
            this.fs.delete(testPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMkdirsWithExistingHierarchyCheckPositive2() throws Throwable {
        Path testPath = new Path("/testMkdirsWithExistingHierarchyCheckPositive2");
        Path childPath1 = new Path(testPath, "1");
        Path childPath2 = new Path(childPath1, "2");
        Path childPath3 = new Path(childPath2, "3");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(childPath1.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(childPath1);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)childPath1);
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)testPath);
            this.fs.mkdirs(childPath1);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)childPath1);
            this.fs.mkdirs(childPath3);
            ContractTestUtils.assertIsDirectory((FileSystem)this.fs, (Path)childPath3);
        }
        finally {
            this.allowRecursiveDelete(this.fs, testPath.toString());
            this.fs.delete(testPath, true);
        }
    }

    @Test
    public void testMkdirsCheckNegative() throws Throwable {
        Path testPath = new Path("/testMkdirsAccessCheckNegative/1/2/3");
        this.setExpectedFailureMessage("mkdirs", testPath);
        this.authorizer.addAuthRuleForOwner("/", WRITE, false);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, "/testMkdirsAccessCheckNegative");
            this.fs.delete(new Path("/testMkdirsAccessCheckNegative"), true);
        }
    }

    @Test
    public void testListStatusWithTripleSlashCheckPositive() throws Throwable {
        Path testPath = new Path("/");
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        Path testPathWithTripleSlash = new Path("wasb:///" + testPath);
        this.fs.listStatus(testPathWithTripleSlash);
    }

    @Test
    public void testOwnerPermissionPositive() throws Throwable {
        Path parentDir = new Path("/testOwnerPermissionPositive");
        Path testPath = new Path(parentDir, "test.data");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(parentDir);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"parentDir does not exist", (Path)parentDir);
            this.fs.create(testPath);
            this.fs.getFileStatus(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath does not exist", (Path)testPath);
            this.fs.delete(parentDir, true);
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"testPath does not exist", (Path)testPath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwnerPermissionNegative() throws Throwable {
        Path parentDir = new Path("/testOwnerPermissionNegative");
        final Path childDir = new Path(parentDir, "childDir");
        this.setExpectedFailureMessage("mkdirs", childDir);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(parentDir);
            UserGroupInformation ugiSuperUser = UserGroupInformation.createUserForTesting((String)"testuser", (String[])new String[0]);
            ugiSuperUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.fs.mkdirs(childDir);
                    return null;
                }
            });
        }
        finally {
            this.allowRecursiveDelete(this.fs, parentDir.toString());
            this.fs.delete(parentDir, true);
        }
    }

    @Test
    public void testRetrievingOwnerDoesNotFailWhenFileDoesNotExist() throws Throwable {
        Path testdirectory = new Path("/testDirectory123454565");
        String owner = this.fs.getOwnerForPath(testdirectory);
        TestNativeAzureFileSystemAuthorization.assertEquals((Object)"", (Object)owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwnerThrowsForUnauthorisedUsers() throws Throwable {
        final Path testPath = new Path("/testSetOwnerNegative");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        UserGroupInformation unauthorisedUser = UserGroupInformation.createUserForTesting((String)"unauthoriseduser", (String[])new String[]{"group1"});
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            final String owner = this.fs.getFileStatus(testPath).getOwner();
            unauthorisedUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        TestNativeAzureFileSystemAuthorization.this.fs.setOwner(testPath, "newowner", null);
                        Assert.fail((String)"Failing test because setOwner call was expected to throw");
                    }
                    catch (WasbAuthorizationException wex) {
                        TestNativeAzureFileSystemAuthorization.this.assertOwnerEquals(testPath, owner);
                    }
                    return null;
                }
            });
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwnerSucceedsForAuthorisedUsers() throws Throwable {
        final Path testPath = new Path("/testSetOwnerPositive");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        final String newOwner = "user2";
        final String newGroup = "newgroup";
        UserGroupInformation authorisedUser = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"group1"});
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            String owner = this.fs.getFileStatus(testPath).getOwner();
            Assume.assumeTrue((String)"changing owner requires original and new owner to be different", (!StringUtils.equalsIgnoreCase((String)owner, (String)newOwner) ? 1 : 0) != 0);
            authorisedUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.fs.setOwner(testPath, newOwner, newGroup);
                    TestNativeAzureFileSystemAuthorization.this.assertOwnerEquals(testPath, newOwner);
                    Assert.assertEquals((Object)newGroup, (Object)TestNativeAzureFileSystemAuthorization.this.fs.getFileStatus(testPath).getGroup());
                    return null;
                }
            });
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwnerSucceedsForAnyUserWhenWildCardIsSpecified() throws Throwable {
        this.fs.updateChownAllowedUsers(Collections.singletonList("*"));
        final Path testPath = new Path("/testSetOwnerPositiveWildcard");
        Configuration conf = this.fs.getConf();
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        String newOwner = "newowner";
        String newGroup = "newgroup";
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"anyuser", (String[])new String[]{"group1"});
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            String owner = this.fs.getFileStatus(testPath).getOwner();
            Assume.assumeTrue((String)"changing owner requires original and new owner to be different", (!StringUtils.equalsIgnoreCase((String)owner, (String)"newowner") ? 1 : 0) != 0);
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.fs.setOwner(testPath, "newowner", "newgroup");
                    TestNativeAzureFileSystemAuthorization.this.assertOwnerEquals(testPath, "newowner");
                    Assert.assertEquals((Object)"newgroup", (Object)TestNativeAzureFileSystemAuthorization.this.fs.getFileStatus(testPath).getGroup());
                    return null;
                }
            });
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwnerFailsForIllegalSetup() throws Throwable {
        this.fs.updateChownAllowedUsers(Arrays.asList("user1", "*"));
        final Path testPath = new Path("/testSetOwnerFailsForIllegalSetup");
        Configuration conf = this.fs.getConf();
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"anyuser", (String[])new String[]{"group1"});
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            final String owner = this.fs.getFileStatus(testPath).getOwner();
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        TestNativeAzureFileSystemAuthorization.this.fs.setOwner(testPath, "newowner", null);
                        Assert.fail((String)"Failing test because setOwner call was expected to throw");
                    }
                    catch (IllegalArgumentException iex) {
                        TestNativeAzureFileSystemAuthorization.this.assertOwnerEquals(testPath, owner);
                    }
                    return null;
                }
            });
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenamePendingAuthorizationCalls() throws Throwable {
        Path testPath = new Path("/testRenamePendingAuthorizationCalls");
        Path srcPath = new Path(testPath, "srcPath");
        Path dstPath = new Path(testPath, "dstPath");
        Path srcFilePath = new Path(srcPath, "file.txt");
        Path dstFilePath = new Path(dstPath, "file.txt");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.create(srcFilePath);
            String srcKey = this.fs.pathToKey(srcPath);
            String dstKey = this.fs.pathToKey(dstPath);
            NativeAzureFileSystem.FolderRenamePending renamePending = new NativeAzureFileSystem.FolderRenamePending(srcKey, dstKey, null, this.fs);
            renamePending.writeFile(this.fs);
            this.fs.getFileStatus(srcPath);
        }
        catch (FileNotFoundException fnfe) {
            GenericTestUtils.assertExceptionContains((String)(srcPath.toString() + ": No such file or directory."), (Throwable)fnfe);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"dstFilePath does not exist -- pending rename failed", (Path)dstFilePath);
        }
        finally {
            this.allowRecursiveDelete(this.fs, testPath.toString());
            this.fs.delete(testPath, true);
        }
    }

    @Test
    public void testSetPermissionThrowsForUnauthorisedUsers() throws Throwable {
        this.testSetPermission("/testSetPermissionNegative", null, null, "unauthorizeduser", true, false);
    }

    @Test
    public void testSetPermissionForAuthorisedUsers() throws Throwable {
        this.testSetPermission("/testSetPermissionPositive", null, null, "user1", false, false);
    }

    @Test
    public void testSetPermissionForOwner() throws Throwable {
        this.testSetPermission("/testSetPermissionPositiveOwner", null, null, null, false, false);
    }

    @Test
    public void testSetPermissionWhenWildCardInAllowedUserList() throws Throwable {
        List<String> chmodAllowedUsers = Collections.singletonList("*");
        this.testSetPermission("/testSetPermissionWhenWildCardInAllowedUserList", chmodAllowedUsers, null, "testuser", false, false);
    }

    @Test
    public void testSetPermissionForInvalidAllowedUserList() throws Throwable {
        List<String> chmodAllowedUsers = Arrays.asList("*", "testuser");
        this.testSetPermission("/testSetPermissionForInvalidAllowedUserList", chmodAllowedUsers, null, "testuser", true, true);
    }

    @Test
    public void testSetPermissionForDaemonUser() throws Throwable {
        this.testSetPermission("/testSetPermissionForDaemonUser", null, null, "hive", false, false);
    }

    @Test
    public void testSetPermissionForInvalidDaemonUserList() throws Throwable {
        List<String> daemonUsers = Arrays.asList("*", "hive");
        this.testSetPermission("/testSetPermissionForInvalidDaemonUserList", null, daemonUsers, "testuser", true, true);
    }

    @Test
    public void testAccessWhenPermissionsMatchForAllAndReadWrite() throws Throwable {
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessWhenPermissionsMatchForAllAndReadWrite");
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            this.fs.access(testPath, FsAction.ALL);
            this.fs.access(testPath, FsAction.READ_WRITE);
        }
        finally {
            this.recursiveDelete(testPath);
        }
    }

    @Test
    public void testAccessWhenPermissionsMatchForWriteAndWriteExecute() throws Throwable {
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessWhenPermissionsMatchForWriteAndWriteExecute");
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            this.fs.access(testPath, FsAction.WRITE);
            this.fs.access(testPath, FsAction.WRITE_EXECUTE);
        }
        finally {
            this.recursiveDelete(testPath);
        }
    }

    @Test
    public void testAccessWhenPermissionsMatchForReadAndReadExecute() throws Throwable {
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessWhenPermissionsMatchForReadAndReadExecute");
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            this.fs.access(testPath, FsAction.READ);
            this.fs.access(testPath, FsAction.READ_EXECUTE);
        }
        finally {
            this.recursiveDelete(testPath);
        }
    }

    @Test
    public void testAccessWhenPermissionsMatchForExecuteAndNone() throws Throwable {
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessWhenPermissionsMatchForExecuteAndNone");
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            this.fs.access(testPath, FsAction.EXECUTE);
            this.fs.access(testPath, FsAction.NONE);
        }
        finally {
            this.recursiveDelete(testPath);
        }
    }

    @Test
    public void testAccessWhenPermissionsDoNotMatch() throws Throwable {
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessWhenPermissionsDoNotMatch");
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            this.assertNoAccess(testPath, FsAction.ALL);
            this.assertNoAccess(testPath, FsAction.WRITE);
            this.assertNoAccess(testPath, FsAction.WRITE_EXECUTE);
        }
        finally {
            this.recursiveDelete(testPath);
        }
    }

    @Test
    public void testAccessFileDoesNotExist() throws Throwable {
        this.expectedEx.expect(FileNotFoundException.class);
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessFileDoesNotExist");
        this.authorizer.init(conf);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), READ, true);
        this.authorizer.addAuthRuleForOwner(testPath.toString(), WRITE, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"test path exists", (Path)testPath);
        this.fs.access(testPath, FsAction.ALL);
    }

    @Test
    public void testAccessFileDoesNotExistWhenNoAccessPermission() throws Throwable {
        this.expectedEx.expect(FileNotFoundException.class);
        Configuration conf = this.fs.getConf();
        this.fs.setConf(conf);
        Path testPath = new Path("/testAccessFileDoesNotExistWhenNoAccessPermission");
        this.authorizer.init(conf);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)this.fs, (String)"test path exists", (Path)testPath);
        this.fs.access(testPath, FsAction.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessForFileAndIntermediateDirectoryCreated() throws Throwable {
        Path parentDir = new Path("/testAccessDirectory");
        Path intermediateDir = new Path(parentDir, "intermediateDir");
        Path testPath = new Path(intermediateDir, "test.dat");
        this.authorizer.addAuthRuleForOwner("/", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString(), WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString() + "/*", WRITE, true);
        this.authorizer.addAuthRuleForOwner(parentDir.toString() + "/*", READ, true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        try {
            this.fs.mkdirs(parentDir);
            this.fs.create(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"testPath was not created", (Path)testPath);
            this.fs.access(parentDir, FsAction.WRITE);
            this.fs.access(parentDir, FsAction.WRITE_EXECUTE);
            this.fs.access(intermediateDir, FsAction.ALL);
            this.fs.access(intermediateDir, FsAction.READ_WRITE);
            this.fs.access(testPath, FsAction.ALL);
            this.fs.access(testPath, FsAction.READ_WRITE);
        }
        finally {
            this.recursiveDelete(testPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSetPermission(String path, List<String> chmodAllowedUsers, List<String> daemonUsers, String user, boolean isSetPermissionFailureCase, boolean isInvalidSetup) throws Throwable {
        Path testPath = new Path(path);
        FsPermission newPermission = new FsPermission(1777);
        this.authorizer.addAuthRule("/", WRITE, this.getCurrentUserShortName(), true);
        this.fs.updateWasbAuthorizer((WasbAuthorizerInterface)this.authorizer);
        if (chmodAllowedUsers != null && !chmodAllowedUsers.isEmpty()) {
            this.fs.updateChmodAllowedUsers(chmodAllowedUsers);
        }
        if (daemonUsers != null && !daemonUsers.isEmpty()) {
            this.fs.updateDaemonUsers(daemonUsers);
        }
        UserGroupInformation testUser = user != null ? UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{"testgrp"}) : null;
        try {
            this.fs.mkdirs(testPath);
            ContractTestUtils.assertPathExists((FileSystem)this.fs, (String)"test path does not exist", (Path)testPath);
            FsPermission filePermission = this.fs.getFileStatus(testPath).getPermission();
            if (isSetPermissionFailureCase) {
                this.executeSetPermissionFailure(testUser, testPath, filePermission, newPermission, isInvalidSetup);
            } else {
                this.executeSetPermissionSuccess(testUser, testPath, filePermission, newPermission);
            }
        }
        finally {
            this.fs.delete(testPath, false);
        }
    }

    private void executeSetPermissionFailure(UserGroupInformation testUser, final Path testPath, final FsPermission oldPermission, final FsPermission newPermission, final boolean isInvalidSetup) throws Throwable {
        testUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    TestNativeAzureFileSystemAuthorization.this.fs.setPermission(testPath, newPermission);
                    Assert.fail((String)"Failing test because setPermission was expected to throw");
                }
                catch (IllegalArgumentException iex) {
                    if (!isInvalidSetup) {
                        Assert.fail((String)"Failing test because IllegalArgumentException is not expected to throw");
                    }
                    TestNativeAzureFileSystemAuthorization.this.assertPermissionEquals(testPath, oldPermission);
                }
                catch (WasbAuthorizationException wex) {
                    if (isInvalidSetup) {
                        Assert.fail((String)"Failing test because WasbAuthorizationException is not expected to throw");
                    }
                    TestNativeAzureFileSystemAuthorization.this.assertPermissionEquals(testPath, oldPermission);
                }
                return null;
            }
        });
    }

    private void executeSetPermissionSuccess(UserGroupInformation testUser, final Path testPath, FsPermission oldPermission, final FsPermission newPermission) throws Throwable {
        if (testUser != null) {
            testUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TestNativeAzureFileSystemAuthorization.this.fs.setPermission(testPath, newPermission);
                    return null;
                }
            });
        } else {
            this.fs.setPermission(testPath, newPermission);
        }
        this.assertPermissionEquals(testPath, newPermission);
        TestNativeAzureFileSystemAuthorization.assertNotEquals((Object)newPermission, (Object)oldPermission);
    }

    private void assertPermissionEquals(Path path, FsPermission newPermission) throws IOException {
        FileStatus status = this.fs.getFileStatus(path);
        TestNativeAzureFileSystemAuthorization.assertEquals((String)("Wrong permissions in " + status), (Object)newPermission, (Object)status.getPermission());
    }

    private void assertOwnerEquals(Path path, String owner) throws IOException {
        FileStatus status = this.fs.getFileStatus(path);
        TestNativeAzureFileSystemAuthorization.assertEquals((String)("Wrong owner in " + status), (Object)owner, (Object)status.getOwner());
    }

    private void assertNoAccess(final Path path, final FsAction action) throws Exception {
        LambdaTestUtils.intercept(AccessControlException.class, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                TestNativeAzureFileSystemAuthorization.this.fs.access(path, action);
                return "Access granted to " + path + " for action " + action;
            }
        });
    }
}

