/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.Closeable;
import java.io.FileNotFoundException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.ExceptionHandlingTestHelper;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;

public class ITestFileSystemOperationsExceptionHandlingMultiThreaded
extends AbstractWasbTestBase {
    FSDataInputStream inputStream = null;
    private Path testPath;
    private Path testFolderPath;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testPath = this.path("testfile.dat");
        this.testFolderPath = this.path("testfolder");
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Override
    public void tearDown() throws Exception {
        IOUtils.closeStream((Closeable)this.inputStream);
        ContractTestUtils.rm((FileSystem)this.fs, (Path)this.testPath, (boolean)true, (boolean)false);
        ContractTestUtils.rm((FileSystem)this.fs, (Path)this.testFolderPath, (boolean)true, (boolean)false);
        super.tearDown();
    }

    private void getInputStreamToTest(FileSystem fs, Path testPath) throws Throwable {
        FSDataOutputStream outputStream = fs.create(testPath);
        String testString = "This is a test string";
        outputStream.write(testString.getBytes());
        outputStream.close();
        this.inputStream = fs.open(testPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        Path base = this.methodPath();
        Path testFilePath1 = new Path(base, "test1.dat");
        Path renamePath = new Path(base, "test2.dat");
        this.getInputStreamToTest((FileSystem)fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread((FileSystem)fs, testFilePath1, renamePath));
        renameThread.start();
        renameThread.join();
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadBlockBlobSeekScenario() throws Throwable {
        Path base = this.methodPath();
        Path testFilePath1 = new Path(base, "test1.dat");
        Path renamePath = new Path(base, "test2.dat");
        this.getInputStreamToTest((FileSystem)this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread((FileSystem)this.fs, testFilePath1, renamePath));
        renameThread.start();
        renameThread.join();
        this.inputStream.seek(5L);
        this.inputStream.read();
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setPermission(this.testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
        }
        this.fs.setPermission(this.testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setPermission(this.testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
        }
        this.fs.setPermission(this.testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testPath));
        t.start();
        while (t.isAlive()) {
            this.inputStream = this.fs.open(this.testPath);
            this.inputStream.close();
        }
        this.inputStream = this.fs.open(this.testPath);
        this.inputStream.close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testPath));
        t.start();
        while (t.isAlive()) {
            this.inputStream = this.fs.open(this.testPath);
            this.inputStream.close();
        }
        this.inputStream = this.fs.open(this.testPath);
        this.inputStream.close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setOwner(this.testPath, "testowner", "testgroup");
        }
        this.fs.setOwner(this.testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setOwner(this.testPath, "testowner", "testgroup");
        }
        this.fs.setOwner(this.testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(this.createTestAccount(), this.testFolderPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testFolderPath));
        t.start();
        while (t.isAlive()) {
            this.fs.listStatus(this.testFolderPath);
        }
        this.fs.listStatus(this.testFolderPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testFolderPath);
        Thread t = new Thread(new DeleteThread((FileSystem)this.fs, this.testFolderPath));
        t.start();
        while (t.isAlive()) {
            this.fs.listStatus(this.testFolderPath);
        }
        this.fs.listStatus(this.testFolderPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobReadScenario() throws Throwable {
        this.bindToTestAccount(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount());
        Path base = this.methodPath();
        Path testFilePath1 = new Path(base, "test1.dat");
        Path renamePath = new Path(base, "test2.dat");
        this.getInputStreamToTest((FileSystem)this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread((FileSystem)this.fs, testFilePath1, renamePath));
        renameThread.start();
        renameThread.join();
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobSeekScenario() throws Throwable {
        this.bindToTestAccount(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount());
        Path base = this.methodPath();
        Path testFilePath1 = new Path(base, "test1.dat");
        Path renamePath = new Path(base, "test2.dat");
        this.getInputStreamToTest((FileSystem)this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread((FileSystem)this.fs, testFilePath1, renamePath));
        renameThread.start();
        renameThread.join();
        this.inputStream.seek(5L);
    }

    private static class RenameThread
    implements Runnable {
        private final FileSystem fs;
        private final Path testPath;
        private final Path renamePath;

        RenameThread(FileSystem fs, Path testPath, Path renamePath) {
            this.fs = fs;
            this.testPath = testPath;
            this.renamePath = renamePath;
        }

        @Override
        public void run() {
            try {
                this.fs.rename(this.testPath, this.renamePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class DeleteThread
    implements Runnable {
        private final FileSystem fs;
        private final Path testPath;

        DeleteThread(FileSystem fs, Path testPath) {
            this.fs = fs;
            this.testPath = testPath;
        }

        @Override
        public void run() {
            try {
                this.fs.delete(this.testPath, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

