/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.time.Instant;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.utils.SASGenerator;

public class ServiceSASGenerator
extends SASGenerator {
    private String permissions = "racwdl";

    public ServiceSASGenerator(byte[] accountKey) {
        super(accountKey);
    }

    public String getContainerSASWithFullControl(String accountName, String containerName) throws InvalidConfigurationValueException {
        accountName = this.getCanonicalAccountName(accountName);
        String sp = this.permissions;
        String sv = SASGenerator.AuthenticationVersion.Feb20.toString();
        String sr = "c";
        String st = ISO_8601_FORMATTER.format(Instant.now().minus(FIVE_MINUTES));
        String se = ISO_8601_FORMATTER.format(Instant.now().plus(ONE_DAY));
        String signature = this.computeSignatureForSAS(sp, st, se, sv, "c", accountName, containerName, null);
        AbfsUriQueryBuilder qb = new AbfsUriQueryBuilder();
        qb.addQuery("sp", sp);
        qb.addQuery("st", st);
        qb.addQuery("se", se);
        qb.addQuery("sv", sv);
        qb.addQuery("sr", sr);
        qb.addQuery("sig", signature);
        return qb.toString().substring(1);
    }

    private String computeSignatureForSAS(String sp, String st, String se, String sv, String sr, String accountName, String containerName, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(sp);
        sb.append("\n");
        sb.append(st);
        sb.append("\n");
        sb.append(se);
        sb.append("\n");
        sb.append("/blob/");
        sb.append(accountName);
        sb.append("/");
        sb.append(containerName);
        if (path != null && !sr.equals("c")) {
            sb.append(path);
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(sv);
        sb.append("\n");
        sb.append(sr);
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        String stringToSign = sb.toString();
        LOG.debug("Service SAS stringToSign: " + stringToSign.replace("\n", "."));
        return this.computeHmac256(stringToSign);
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }
}

