/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.azurebfs.utils.AzcopyExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AzcopyToolHelper {
    private File hadoopAzureDir;
    private String azcopyDirPath;
    private String azcopyExecutablePath;
    private String fileCreationScriptPath;
    private String folderCreationScriptPath;
    private String fileCreationScriptContent;
    private String folderCreationScriptContent;
    private String sasToken;
    private boolean initialized = false;
    private static final String USER_DIR_SYSTEM_PROPERTY = "user.dir";
    private static final String HADOOP_AZURE_DIR = "hadoop-azure";
    private static final String AZCOPY_DIR_NAME = "azcopy";
    private static final String AZCOPY_EXECUTABLE_NAME = "azcopy";
    private static final String FILE_CREATION_SCRIPT_NAME = "createAzcopyFile.sh";
    private static final String FOLDER_CREATION_SCRIPT_NAME = "createAzcopyFolder.sh";
    private static final String DIR_NOT_FOUND_ERROR = " directory not found";
    private static final String AZCOPY_DOWNLOADED_DIR_NAME = "/azcopy_linux_amd64_*/* ";
    private static final String AZCOPY_DOWNLOADED_TAR_NAME = "/azcopy_linux_amd64_* azcopy.tar.gz";
    private static final String SCRIPT_CREATION_ERROR = "Unable to create azcopy file/folder creation script. ";
    private static final String SCRIPT_RUN_ERROR = "Unable to run azcopy file/folder creation script. ";
    private static final String SCRIPT_NOT_FOUND_ERROR = "Azcopy file/folder creation script not found and should be regenerated. ";
    private static final String SCRIPT_EXECUTION_FAILED = "Azcopy file/folder creation script failed with non-zero exit code. This can be due to corrupt azcopy executable or invalid SAS Token. Exit code: ";
    private static final String AZCOPY_CMD_SHELL = "bash";
    private static final String AZCOPY_CMD_OPTION = "-c";
    private static final String AZCOPY_DOWNLOAD_URL = "https://aka.ms/downloadazcopy-v10-linux";
    private static final String AZCOPY_DOWNLOAD_CMD = "wget https://aka.ms/downloadazcopy-v10-linux -O azcopy.tar.gz --no-check-certificate";
    private static final String EXTRACT_CMD = "tar -xf azcopy.tar.gz -C ";
    private static final String MOVE_CMD = "mv ";
    private static final String REMOVE_CMD = "rm -rf ";
    private static final String CHMOD_CMD = "chmod +x ";
    private static final char QUESTION_MARK = '?';
    private static final int WAIT_TIME = 10000;
    private static final int MAX_WAIT_TIME = 120000;
    private static final Logger LOG = LoggerFactory.getLogger(AzcopyToolHelper.class);
    private static AzcopyToolHelper azcopyToolHelper;
    private static final ReentrantLock LOCK;

    private AzcopyToolHelper() {
    }

    public static AzcopyToolHelper getInstance(String sasToken) throws IOException, InterruptedException {
        if (azcopyToolHelper == null) {
            LOCK.lock();
            try {
                if (azcopyToolHelper == null) {
                    azcopyToolHelper = new AzcopyToolHelper();
                    azcopyToolHelper.init(sasToken);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return azcopyToolHelper;
    }

    public void createFileUsingAzcopy(String absolutePathToBeCreated) throws Exception {
        if (absolutePathToBeCreated != null) {
            absolutePathToBeCreated = absolutePathToBeCreated.replace(".dfs.", ".blob.") + this.sasToken;
            this.runShellScript(this.fileCreationScriptPath, absolutePathToBeCreated);
        }
    }

    public void createFolderUsingAzcopy(String absolutePathToBeCreated) throws Exception {
        if (absolutePathToBeCreated != null) {
            absolutePathToBeCreated = absolutePathToBeCreated.replace(".dfs.", ".blob.") + this.sasToken;
            this.runShellScript(this.folderCreationScriptPath, absolutePathToBeCreated);
        }
    }

    private void init(String sasToken) throws IOException, InterruptedException {
        if (this.initialized) {
            return;
        }
        this.sasToken = sasToken.charAt(0) == '?' ? sasToken : '?' + sasToken;
        this.hadoopAzureDir = this.findHadoopAzureDir();
        this.azcopyDirPath = this.hadoopAzureDir.getAbsolutePath() + "/" + "azcopy";
        this.azcopyExecutablePath = this.azcopyDirPath + "/" + "azcopy";
        this.fileCreationScriptPath = this.azcopyDirPath + "/" + FILE_CREATION_SCRIPT_NAME;
        this.folderCreationScriptPath = this.azcopyDirPath + "/" + FOLDER_CREATION_SCRIPT_NAME;
        this.fileCreationScriptContent = "blobPath=$1\necho $blobPath\n" + this.azcopyExecutablePath + " copy \"" + this.azcopyDirPath + "/NOTICE.txt\" $blobPath\n";
        this.folderCreationScriptContent = "blobPath=$1\necho $blobPath\n" + this.azcopyExecutablePath + " copy \"" + this.azcopyDirPath + "\" $blobPath --recursive\n";
        this.downloadAzcopyToolAndGenerateScripts();
        System.setProperty(USER_DIR_SYSTEM_PROPERTY, this.hadoopAzureDir.getAbsolutePath());
        this.initialized = true;
    }

    private void downloadAzcopyToolAndGenerateScripts() throws IOException, InterruptedException {
        File azcopyDir = new File(this.azcopyDirPath);
        if (!azcopyDir.exists()) {
            if (!azcopyDir.mkdir()) {
                LOG.info("Azcopy Directory not created by process: {}", (Object)Thread.currentThread().getName());
                return;
            }
            this.downloadAzcopyExecutable();
            this.createShellScript(this.fileCreationScriptPath, this.fileCreationScriptContent);
            this.createShellScript(this.folderCreationScriptPath, this.folderCreationScriptContent);
        } else {
            LOG.info("Azcopy directory already exists. Skipping download and script generation by the process: {}", (Object)Thread.currentThread().getName());
        }
    }

    private void downloadAzcopyExecutable() throws IOException, InterruptedException {
        File azcopyFile = new File(this.azcopyExecutablePath);
        if (!azcopyFile.exists()) {
            this.executeCommand(AZCOPY_DOWNLOAD_CMD);
            String extractCmd = EXTRACT_CMD + this.hadoopAzureDir.getAbsolutePath();
            this.executeCommand(extractCmd);
            String renameCmd = MOVE_CMD + this.hadoopAzureDir.getAbsolutePath() + AZCOPY_DOWNLOADED_DIR_NAME + this.azcopyDirPath;
            this.executeCommand(renameCmd);
            String cleanupCmd = REMOVE_CMD + this.hadoopAzureDir.getAbsolutePath() + AZCOPY_DOWNLOADED_TAR_NAME;
            this.executeCommand(cleanupCmd);
            String chmodCmd = CHMOD_CMD + this.azcopyDirPath;
            this.executeCommand(chmodCmd);
        } else {
            LOG.info("Azcopy executable already exists. Skipping download by process: {}", (Object)Thread.currentThread().getName());
        }
    }

    private void executeCommand(String command) throws IOException, InterruptedException {
        String[] commandArray = new String[]{AZCOPY_CMD_SHELL, AZCOPY_CMD_OPTION, command};
        Process process = Runtime.getRuntime().exec(commandArray);
        process.waitFor();
    }

    private void createShellScript(String scriptPath, String scriptContent) throws IOException {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            try {
                FileWriter writer = new FileWriter(scriptFile);
                writer.write(scriptContent);
                writer.close();
                scriptFile.setExecutable(true);
            }
            catch (IOException e) {
                LOG.error("Error creating shell script: {} by process {}", (Object)e.getMessage(), (Object)Thread.currentThread().getName());
                throw new AzcopyExecutionException(SCRIPT_CREATION_ERROR, this.azcopyDirPath, e);
            }
        }
    }

    private void runShellScript(String scriptPath, String argument) throws IOException {
        this.checkAndWaitOnScriptCreation(scriptPath);
        try {
            ProcessBuilder pb = new ProcessBuilder(scriptPath, argument);
            Process p = pb.start();
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new AzcopyExecutionException(SCRIPT_EXECUTION_FAILED + exitCode + "." + " ", this.azcopyDirPath);
            }
        }
        catch (AzcopyExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AzcopyExecutionException(SCRIPT_RUN_ERROR, this.azcopyDirPath, e);
        }
    }

    private void checkAndWaitOnScriptCreation(String scriptPath) throws IOException {
        File scriptFile = new File(scriptPath);
        int totalWaitTime = 0;
        while (!scriptFile.exists() || !scriptFile.canExecute()) {
            try {
                Thread.sleep(10000L);
                if ((totalWaitTime += 10000) <= 120000) continue;
                LOG.error("Timeout waiting for script creation: {} by process {}", (Object)scriptPath, (Object)Thread.currentThread().getName());
                throw new AzcopyExecutionException(SCRIPT_NOT_FOUND_ERROR, this.azcopyDirPath);
            }
            catch (InterruptedException e) {
                LOG.error("Error waiting for script creation: {} by process {}", (Object)scriptPath, (Object)Thread.currentThread().getName());
                throw new AzcopyExecutionException(SCRIPT_NOT_FOUND_ERROR, this.azcopyDirPath);
            }
        }
    }

    private File findHadoopAzureDir() throws FileNotFoundException {
        File hadoopAzureDir;
        File currentDir = new File(System.getProperty(USER_DIR_SYSTEM_PROPERTY));
        if (!currentDir.isDirectory() && !currentDir.getName().equals(HADOOP_AZURE_DIR)) {
            hadoopAzureDir = this.findHadoopAzureDir(currentDir);
            if (hadoopAzureDir == null) {
                throw new FileNotFoundException("hadoop-azure directory not found");
            }
        } else {
            hadoopAzureDir = currentDir;
        }
        return hadoopAzureDir;
    }

    private File findHadoopAzureDir(File dir) {
        if (dir == null) {
            return null;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (file.isDirectory() && file.getName().equals(HADOOP_AZURE_DIR)) {
                return file;
            }
            File hadoopAzureDir = this.findHadoopAzureDir(file);
            if (hadoopAzureDir == null) continue;
            return hadoopAzureDir;
        }
        return null;
    }

    static {
        LOCK = new ReentrantLock();
    }
}

