/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsTestWithTimeout;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobListResultSchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.ListActionTaker;
import org.apache.hadoop.fs.azurebfs.services.ListBlobQueue;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class TestListActionTaker
extends AbstractAbfsTestWithTimeout {
    @Test
    public void testProducerResumeOnlyOnConsumerLagBecomesTolerable() throws IOException {
        Path path = new Path("test");
        AbfsConfiguration abfsConfiguration = (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class);
        AbfsBlobClient client = (AbfsBlobClient)Mockito.mock(AbfsBlobClient.class);
        ((AbfsBlobClient)Mockito.doReturn((Object)abfsConfiguration).when((Object)client)).getAbfsConfiguration();
        ((AbfsConfiguration)Mockito.doReturn((Object)5000).when((Object)abfsConfiguration)).getListingMaxConsumptionLag();
        ((AbfsConfiguration)Mockito.doReturn((Object)10000).when((Object)abfsConfiguration)).getProducerQueueMaxSize();
        ListResponseData listResponseData = (ListResponseData)Mockito.mock(ListResponseData.class);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        AbfsHttpOperation httpOperation = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        ((AbfsRestOperation)Mockito.doReturn((Object)httpOperation).when((Object)op)).getResult();
        ((ListResponseData)Mockito.doReturn((Object)op).when((Object)listResponseData)).getOp();
        BlobListResultSchema listResultSchema = (BlobListResultSchema)Mockito.mock(BlobListResultSchema.class);
        ((AbfsHttpOperation)Mockito.doReturn((Object)listResultSchema).when((Object)httpOperation)).getListResultSchema();
        ((BlobListResultSchema)Mockito.doReturn((Object)"a").doReturn((Object)"b").doReturn((Object)"c").doReturn(null).when((Object)listResultSchema)).getNextMarker();
        TracingContext tracingContext = (TracingContext)Mockito.mock(TracingContext.class);
        ListActionTaker listActionTaker = new ListActionTaker(path, client, tracingContext){
            private ListBlobQueue listBlobQueue;
            private boolean isListAndEnqueueInProgress;
            private boolean completed;

            protected ListBlobQueue createListBlobQueue(AbfsConfiguration configuration) throws InvalidConfigurationValueException {
                this.listBlobQueue = super.createListBlobQueue(configuration);
                return this.listBlobQueue;
            }

            int getMaxConsumptionParallelism() {
                return 5;
            }

            boolean takeAction(Path path) throws AzureBlobFileSystemException {
                while (!this.isListAndEnqueueInProgress && this.listBlobQueue.size() < 5000 && !this.completed) {
                }
                return true;
            }

            protected String listAndEnqueue(ListBlobQueue listBlobQueue, String continuationToken) throws AzureBlobFileSystemException {
                this.isListAndEnqueueInProgress = true;
                String contToken = super.listAndEnqueue(listBlobQueue, continuationToken);
                this.isListAndEnqueueInProgress = false;
                if (contToken == null) {
                    this.completed = true;
                }
                return contToken;
            }

            protected void addPaths(List<Path> paths, ListResultSchema retrievedSchema) {
                for (int i = 0; i < 5000; ++i) {
                    paths.add(new Path("test" + i));
                }
            }
        };
        int[] occurrences = new int[]{0};
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            occurrences[0] = occurrences[0] + 1;
            Assertions.assertThat((int)((Integer)answer.getArgument(2))).isEqualTo(5000);
            return listResponseData;
        }).when((Object)client)).listPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class), (URI)Mockito.nullable(URI.class));
        listActionTaker.listRecursiveAndTakeAction();
    }
}

