/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.TestAbfsConfigurationFieldsValidation;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsApacheHttpExpect100Exception;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsAHCHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.http.HttpResponse;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class ITestAbfsRestOperation
extends AbstractAbfsIntegrationTest {
    private static final int HTTP_EXPECTATION_FAILED = 417;
    private static final int HTTP_ERROR = 0;
    private static final int ZERO = 0;
    private static final int REDUCED_RETRY_COUNT = 2;
    private static final int REDUCED_BACKOFF_INTERVAL = 100;
    private static final int BUFFER_LENGTH = 5;
    private static final int BUFFER_OFFSET = 0;
    private static final String TEST_PATH = "/testfile";
    @Parameterized.Parameter
    public boolean expectHeaderEnabled;
    @Parameterized.Parameter(value=1)
    public int responseCode;
    @Parameterized.Parameter(value=2)
    public String responseMessage;
    @Parameterized.Parameter(value=3)
    public ErrorType errorType;
    @Parameterized.Parameter(value=4)
    public HttpOperationType httpOperationType;
    private AbfsThrottlingIntercept intercept;

    @Parameterized.Parameters(name="expect={0}-code={1}-ErrorType={3}=NetLib={4}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({true, 200, "OK", ErrorType.WRITE, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {true, 200, "OK", ErrorType.WRITE, HttpOperationType.APACHE_HTTP_CLIENT}, {false, 200, "OK", ErrorType.WRITE, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {false, 200, "OK", ErrorType.WRITE, HttpOperationType.APACHE_HTTP_CLIENT}, {true, 503, "ServerBusy", ErrorType.OUTPUTSTREAM, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {true, 503, "ServerBusy", ErrorType.OUTPUTSTREAM, HttpOperationType.APACHE_HTTP_CLIENT}, {true, 404, "Resource Not Found", ErrorType.OUTPUTSTREAM, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {true, 404, "Resource Not Found", ErrorType.OUTPUTSTREAM, HttpOperationType.APACHE_HTTP_CLIENT}, {true, 417, "Expectation Failed", ErrorType.OUTPUTSTREAM, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {true, 417, "Expectation Failed", ErrorType.OUTPUTSTREAM, HttpOperationType.APACHE_HTTP_CLIENT}, {true, 0, "Error", ErrorType.OUTPUTSTREAM, HttpOperationType.JDK_HTTP_URL_CONNECTION}, {true, 0, "Error", ErrorType.OUTPUTSTREAM, HttpOperationType.APACHE_HTTP_CLIENT});
    }

    private byte[] getRandomBytesArray(int length) {
        byte[] b = new byte[length];
        new Random().nextBytes(b);
        return b;
    }

    @Override
    public AzureBlobFileSystem getFileSystem(Configuration configuration) throws Exception {
        Configuration conf = new Configuration(configuration);
        conf.set("fs.azure.networking.library", this.httpOperationType.toString());
        return (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
    }

    private AbfsRestOperation getRestOperation() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem(this.getRawConfiguration());
        Configuration configuration = fs.getConf();
        configuration.addResource("azure-test.xml");
        AbfsClient abfsClient = fs.getAbfsStore().getClient();
        AbfsConfiguration abfsConfiguration = fs.getAbfsStore().getAbfsConfiguration();
        AbfsConfiguration abfsConfig = TestAbfsConfigurationFieldsValidation.updateRetryConfigs(abfsConfiguration, 2, 100);
        this.intercept = (AbfsThrottlingIntercept)Mockito.mock(AbfsThrottlingIntercept.class);
        ((AbfsThrottlingIntercept)Mockito.doNothing().when((Object)this.intercept)).updateMetrics((AbfsRestOperationType)Mockito.any(), (AbfsHttpOperation)Mockito.any());
        AbfsClient testClient = (AbfsClient)Mockito.spy((Object)ITestAbfsClient.createTestClientFromCurrentContext(abfsClient, abfsConfig));
        ((AbfsClient)Mockito.doReturn((Object)this.intercept).when((Object)testClient)).getIntercept();
        AppendRequestParameters appendRequestParameters = new AppendRequestParameters(0L, 0, 5, AppendRequestParameters.Mode.APPEND_MODE, false, null, this.expectHeaderEnabled);
        byte[] buffer = this.getRandomBytesArray(5);
        Path testPath = this.path(TEST_PATH);
        fs.create(testPath);
        String finalTestPath = testPath.toString().substring(testPath.toString().lastIndexOf("/"));
        List<AbfsHttpHeader> requestHeaders = ITestAbfsClient.getTestRequestHeaders(testClient);
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        if (appendRequestParameters.isExpectHeaderEnabled()) {
            requestHeaders.add(new AbfsHttpHeader("Expect", "100-continue"));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = testClient.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "append");
        abfsUriQueryBuilder.addQuery("position", Long.toString(appendRequestParameters.getPosition()));
        URL url = testClient.createRequestUrl(finalTestPath, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.Append, testClient, "PUT", url, requestHeaders, buffer, appendRequestParameters.getoffset(), appendRequestParameters.getLength(), null, abfsConfig));
        ((AbfsRestOperation)Mockito.doAnswer(answer -> {
            AbfsHttpOperation httpOperation = (AbfsHttpOperation)Mockito.spy((Object)((AbfsHttpOperation)answer.callRealMethod()));
            this.mockHttpOperation(appendRequestParameters, buffer, url, httpOperation);
            ((AbfsRestOperation)Mockito.doReturn((Object)httpOperation).when((Object)op)).getResult();
            return httpOperation;
        }).when((Object)op)).createHttpOperation();
        return op;
    }

    private void mockHttpOperation(AppendRequestParameters appendRequestParameters, byte[] buffer, URL url, AbfsHttpOperation httpOperation) throws IOException {
        if (this.expectHeaderEnabled) {
            ((AbfsHttpOperation)Mockito.doReturn((Object)"100-continue").when((Object)httpOperation)).getConnProperty("Expect");
        }
        ((AbfsHttpOperation)Mockito.doNothing().when((Object)httpOperation)).setRequestProperty((String)Mockito.any(), (String)Mockito.any());
        switch (this.errorType) {
            case OUTPUTSTREAM: {
                ((AbfsHttpOperation)Mockito.doReturn((Object)this.responseCode).when((Object)httpOperation)).getStatusCode();
                ((AbfsHttpOperation)Mockito.doReturn((Object)this.responseCode).when((Object)httpOperation)).getConnResponseCode();
                if (this.responseCode == 503) {
                    ((AbfsHttpOperation)Mockito.doReturn((Object)AzureServiceErrorCode.EGRESS_OVER_ACCOUNT_LIMIT.getErrorMessage()).when((Object)httpOperation)).getStorageErrorMessage();
                }
                ((AbfsHttpOperation)Mockito.doReturn((Object)this.responseMessage).when((Object)httpOperation)).getConnResponseMessage();
                if (httpOperation instanceof AbfsJdkHttpOperation) {
                    ((AbfsJdkHttpOperation)Mockito.doThrow((Throwable[])new Throwable[]{new ProtocolException("Server rejected operation")}).when((Object)((AbfsJdkHttpOperation)httpOperation))).getConnOutputStream();
                }
                if (!(httpOperation instanceof AbfsAHCHttpOperation)) break;
                ((AbfsAHCHttpOperation)Mockito.doNothing().when((Object)((AbfsAHCHttpOperation)httpOperation))).parseResponseHeaderAndBody((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
                ((AbfsAHCHttpOperation)Mockito.doReturn((Object)404).when((Object)((AbfsAHCHttpOperation)httpOperation))).parseStatusCode((HttpResponse)Mockito.nullable(HttpResponse.class));
                ((AbfsAHCHttpOperation)Mockito.doThrow((Throwable[])new Throwable[]{new AbfsApacheHttpExpect100Exception((HttpResponse)Mockito.mock(HttpResponse.class))}).when((Object)((AbfsAHCHttpOperation)httpOperation))).executeRequest();
                break;
            }
            case WRITE: {
                if (httpOperation instanceof AbfsAHCHttpOperation) {
                    ((AbfsAHCHttpOperation)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)((AbfsAHCHttpOperation)httpOperation))).executeRequest();
                    return;
                }
                OutputStream outputStream = (OutputStream)Mockito.spy((Object)new OutputStream(){

                    @Override
                    public void write(int i) throws IOException {
                    }
                });
                ((AbfsJdkHttpOperation)Mockito.doReturn((Object)outputStream).when((Object)((AbfsJdkHttpOperation)httpOperation))).getConnOutputStream();
                ((OutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)outputStream)).write(buffer, appendRequestParameters.getoffset(), appendRequestParameters.getLength());
                break;
            }
        }
    }

    void assertTraceContextState(int retryCount, int assertRetryCount, int bytesSent, int assertBytesSent, int expectedBytesSent, int assertExpectedBytesSent) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)retryCount).describedAs("The retry count is incorrect", new Object[0])).isEqualTo(assertRetryCount);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bytesSent).describedAs("The bytes sent is incorrect", new Object[0])).isEqualTo(assertBytesSent);
        ((AbstractIntegerAssert)Assertions.assertThat((int)expectedBytesSent).describedAs("The expected bytes sent is incorrect", new Object[0])).isEqualTo(assertExpectedBytesSent);
    }

    @Test
    public void testExpectHundredContinue() throws Exception {
        AbfsRestOperation op = this.getRestOperation();
        TracingContext tracingContext = (TracingContext)Mockito.spy((Object)new TracingContext("abcd", "abcde", FSOperationType.APPEND, TracingHeaderFormat.ALL_ID_FORMAT, null));
        ((AbfsRestOperation)Mockito.doReturn((Object)tracingContext).when((Object)op)).createNewTracingContext((TracingContext)Mockito.any());
        block0 : switch (this.errorType) {
            case WRITE: {
                LambdaTestUtils.intercept(IOException.class, () -> op.execute(tracingContext));
                this.assertTraceContextState(tracingContext.getRetryCount(), 2, op.getResult().getBytesSent(), 5, 0, 0);
                break;
            }
            case OUTPUTSTREAM: {
                switch (this.responseCode) {
                    case 503: {
                        LambdaTestUtils.intercept(IOException.class, () -> op.execute(tracingContext));
                        this.assertTraceContextState(tracingContext.getRetryCount(), 2, op.getResult().getBytesSent(), 0, op.getResult().getExpectedBytesToBeSent(), 5);
                        ((AbfsThrottlingIntercept)Mockito.verify((Object)this.intercept, (VerificationMode)Mockito.times((int)3))).updateMetrics((AbfsRestOperationType)Mockito.any(), (AbfsHttpOperation)Mockito.any());
                        break block0;
                    }
                    case 0: {
                        LambdaTestUtils.intercept(IOException.class, () -> op.execute(tracingContext));
                        this.assertTraceContextState(tracingContext.getRetryCount(), 2, op.getResult().getBytesSent(), 0, 0, 0);
                        ((AbfsThrottlingIntercept)Mockito.verify((Object)this.intercept, (VerificationMode)Mockito.times((int)3))).updateMetrics((AbfsRestOperationType)Mockito.any(), (AbfsHttpOperation)Mockito.any());
                        break block0;
                    }
                    case 404: 
                    case 417: {
                        LambdaTestUtils.intercept(AzureBlobFileSystemException.class, () -> op.execute(tracingContext));
                        this.assertTraceContextState(tracingContext.getRetryCount(), 0, 0, 0, 0, 0);
                        ((AbfsThrottlingIntercept)Mockito.verify((Object)this.intercept, (VerificationMode)Mockito.never())).updateMetrics((AbfsRestOperationType)Mockito.any(), (AbfsHttpOperation)Mockito.any());
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public static enum ErrorType {
        OUTPUTSTREAM,
        WRITE;

    }
}

