/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsCountersImpl;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.TestAbfsConfigurationFieldsValidation;
import org.apache.hadoop.fs.azurebfs.constants.AbfsHttpConstants;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.constants.HttpOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsApacheHttpExpect100Exception;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsAHCHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContextBuilder;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingInterceptFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.ReflectionUtils;
import org.apache.http.HttpResponse;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public final class ITestAbfsClient
extends AbstractAbfsIntegrationTest {
    private static final String ACCOUNT_NAME = "bogusAccountName.dfs.core.windows.net";
    private static final String FS_AZURE_USER_AGENT_PREFIX = "Partner Service";
    private static final String HUNDRED_CONTINUE_USER_AGENT = " 100-continue;";
    private static final String TEST_PATH = "/testfile";
    public static final int REDUCED_RETRY_COUNT = 2;
    public static final int REDUCED_BACKOFF_INTERVAL = 100;
    public static final int BUFFER_LENGTH = 5;
    public static final int BUFFER_OFFSET = 0;
    private final Pattern userAgentStringPattern;
    @Parameterized.Parameter
    public HttpOperationType httpOperationType;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({HttpOperationType.JDK_HTTP_URL_CONNECTION}, {HttpOperationType.APACHE_HTTP_CLIENT});
    }

    public ITestAbfsClient() throws Exception {
        StringBuilder regEx = new StringBuilder();
        regEx.append("^");
        regEx.append("APN/1.0");
        regEx.append(" ");
        regEx.append(AbfsHttpConstants.CLIENT_VERSION);
        regEx.append(" ");
        regEx.append("\\(");
        regEx.append(System.getProperty("java.vendor").replaceAll(" ", ""));
        regEx.append(" ");
        regEx.append("JavaJRE");
        regEx.append(" ");
        regEx.append(System.getProperty("java.version"));
        regEx.append(";");
        regEx.append(" ");
        regEx.append(System.getProperty("os.name").replaceAll(" ", ""));
        regEx.append(" ");
        regEx.append(System.getProperty("os.version"));
        regEx.append("/");
        regEx.append(System.getProperty("os.arch"));
        regEx.append(";");
        regEx.append("([a-zA-Z].*; )?");
        regEx.append("([a-zA-Z].*; )?");
        regEx.append(" ?");
        regEx.append(".+");
        regEx.append("/");
        regEx.append(".+");
        regEx.append("\\)");
        regEx.append("( .*)?");
        regEx.append("$");
        this.userAgentStringPattern = Pattern.compile(regEx.toString());
    }

    private String getUserAgentString(AbfsConfiguration config, boolean includeSSLProvider) throws IOException, URISyntaxException {
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().withAbfsCounters(abfsCounters).build();
        Object client = AbfsServiceType.DFS.equals((Object)config.getFsConfiguredServiceType()) ? new AbfsDfsClient(new URL("https://azure.com"), null, config, (AccessTokenProvider)null, null, abfsClientContext) : new AbfsBlobClient(new URL("https://azure.com"), null, config, (AccessTokenProvider)null, null, abfsClientContext);
        String sslProviderName = null;
        if (includeSSLProvider) {
            sslProviderName = DelegatingSSLSocketFactory.getDefaultFactory().getProviderName();
        }
        return client.initializeUserAgent(config, sslProviderName);
    }

    @Test
    public void verifyBasicInfo() throws Exception {
        Assume.assumeTrue((HttpOperationType.JDK_HTTP_URL_CONNECTION == this.httpOperationType ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        this.verifyBasicInfo(this.getUserAgentString(abfsConfiguration, false));
    }

    private void verifyBasicInfo(String userAgentStr) {
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string [" + userAgentStr + "] should be of the pattern: " + this.userAgentStringPattern.pattern(), new Object[0])).matches(this.userAgentStringPattern)).describedAs("User-Agent string should contain java vendor", new Object[0])).contains(new CharSequence[]{System.getProperty("java.vendor").replaceAll(" ", "")})).describedAs("User-Agent string should contain java version", new Object[0])).contains(new CharSequence[]{System.getProperty("java.version")})).describedAs("User-Agent string should contain  OS name", new Object[0])).contains(new CharSequence[]{System.getProperty("os.name").replaceAll(" ", "")})).describedAs("User-Agent string should contain OS version", new Object[0])).contains(new CharSequence[]{System.getProperty("os.version")})).describedAs("User-Agent string should contain OS arch", new Object[0])).contains(new CharSequence[]{System.getProperty("os.arch")});
    }

    @Test
    public void verifyUserAgentPrefix() throws IOException, IllegalAccessException, URISyntaxException {
        Assume.assumeTrue((HttpOperationType.JDK_HTTP_URL_CONNECTION == this.httpOperationType ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.user.agent.prefix", FS_AZURE_USER_AGENT_PREFIX);
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain Partner Service", new Object[0])).contains(new CharSequence[]{FS_AZURE_USER_AGENT_PREFIX});
        configuration.unset("fs.azure.user.agent.prefix");
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain Partner Service", new Object[0])).doesNotContain(new CharSequence[]{FS_AZURE_USER_AGENT_PREFIX});
    }

    @Test
    public void verifyUserAgentExpectHeader() throws IOException, IllegalAccessException, URISyntaxException {
        Assume.assumeTrue((HttpOperationType.JDK_HTTP_URL_CONNECTION == this.httpOperationType ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.user.agent.prefix", FS_AZURE_USER_AGENT_PREFIX);
        configuration.setBoolean("fs.azure.account.expect.header.enabled", true);
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain  100-continue;", new Object[0])).contains(new CharSequence[]{HUNDRED_CONTINUE_USER_AGENT});
        configuration.setBoolean("fs.azure.account.expect.header.enabled", false);
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain  100-continue;", new Object[0])).doesNotContain(new CharSequence[]{HUNDRED_CONTINUE_USER_AGENT});
    }

    @Test
    public void verifyUserAgentWithoutSSLProvider() throws Exception {
        Assume.assumeTrue((HttpOperationType.JDK_HTTP_URL_CONNECTION == this.httpOperationType ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.ssl.channel.mode", DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE.name());
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, true);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain sslProvider", new Object[0])).contains(new CharSequence[]{DelegatingSSLSocketFactory.getDefaultFactory().getProviderName()});
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain sslProvider", new Object[0])).doesNotContain(new CharSequence[]{DelegatingSSLSocketFactory.getDefaultFactory().getProviderName()});
    }

    @Test
    public void verifyUserAgentClusterName() throws Exception {
        Assume.assumeTrue((HttpOperationType.JDK_HTTP_URL_CONNECTION == this.httpOperationType ? 1 : 0) != 0);
        String clusterName = "testClusterName";
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.cluster.name", "testClusterName");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain cluster name", new Object[0])).contains(new CharSequence[]{"testClusterName"});
        configuration.unset("fs.azure.cluster.name");
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain cluster name", new Object[0])).doesNotContain(new CharSequence[]{"testClusterName"})).describedAs("User-Agent string should contain UNKNOWN as cluster name config is absent", new Object[0])).contains(new CharSequence[]{"UNKNOWN"});
    }

    @Test
    public void verifyUserAgentClusterType() throws Exception {
        Assume.assumeTrue((HttpOperationType.JDK_HTTP_URL_CONNECTION == this.httpOperationType ? 1 : 0) != 0);
        String clusterType = "testClusterType";
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set("fs.azure.cluster.type", "testClusterType");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        String userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should contain cluster type", new Object[0])).contains(new CharSequence[]{"testClusterType"});
        configuration.unset("fs.azure.cluster.type");
        abfsConfiguration = new AbfsConfiguration(configuration, ACCOUNT_NAME);
        userAgentStr = this.getUserAgentString(abfsConfiguration, false);
        this.verifyBasicInfo(userAgentStr);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)userAgentStr).describedAs("User-Agent string should not contain cluster type", new Object[0])).doesNotContain(new CharSequence[]{"testClusterType"})).describedAs("User-Agent string should contain UNKNOWN as cluster type config is absent", new Object[0])).contains(new CharSequence[]{"UNKNOWN"});
    }

    public static AbfsClient createTestClientFromCurrentContext(AbfsClient baseAbfsClientInstance, AbfsConfiguration abfsConfig) throws IOException, URISyntaxException {
        AuthType currentAuthType = abfsConfig.getAuthType(abfsConfig.getAccountName());
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", abfsConfig.getAccountName(), abfsConfig);
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().withAbfsPerfTracker(tracker).withExponentialRetryPolicy(new ExponentialRetryPolicy(abfsConfig.getMaxIoRetries())).withAbfsCounters(abfsCounters).build();
        Object testClient = AbfsServiceType.DFS.equals((Object)abfsConfig.getFsConfiguredServiceType()) ? new AbfsDfsClient(baseAbfsClientInstance.getBaseUrl(), currentAuthType == AuthType.SharedKey ? new SharedKeyCredentials(abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), abfsConfig.getStorageAccountKey()) : null, abfsConfig, currentAuthType == AuthType.OAuth ? abfsConfig.getTokenProvider() : null, null, abfsClientContext) : new AbfsBlobClient(baseAbfsClientInstance.getBaseUrl(), currentAuthType == AuthType.SharedKey ? new SharedKeyCredentials(abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), abfsConfig.getStorageAccountKey()) : null, abfsConfig, currentAuthType == AuthType.OAuth ? abfsConfig.getTokenProvider() : null, null, abfsClientContext);
        return testClient;
    }

    public static AbfsClient createBlobClientFromCurrentContext(AbfsClient baseAbfsClientInstance, AbfsConfiguration abfsConfig) throws IOException, URISyntaxException {
        AuthType currentAuthType = abfsConfig.getAuthType(abfsConfig.getAccountName());
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", abfsConfig.getAccountName(), abfsConfig);
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        AbfsClientContext abfsClientContext = new AbfsClientContextBuilder().withAbfsPerfTracker(tracker).withExponentialRetryPolicy(new ExponentialRetryPolicy(abfsConfig.getMaxIoRetries())).withAbfsCounters(abfsCounters).build();
        AbfsBlobClient testClient = new AbfsBlobClient(baseAbfsClientInstance.getBaseUrl(), currentAuthType == AuthType.SharedKey ? new SharedKeyCredentials(abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), abfsConfig.getStorageAccountKey()) : null, abfsConfig, currentAuthType == AuthType.OAuth ? abfsConfig.getTokenProvider() : null, null, abfsClientContext);
        return testClient;
    }

    public static AbfsClient getMockAbfsClient(AbfsClient baseAbfsClientInstance, AbfsConfiguration abfsConfig) throws Exception {
        AuthType currentAuthType = abfsConfig.getAuthType(abfsConfig.getAccountName());
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        Assume.assumeTrue((currentAuthType == AuthType.SharedKey || currentAuthType == AuthType.OAuth ? 1 : 0) != 0);
        AbfsClient client = AbfsServiceType.DFS.equals((Object)abfsConfig.getFsConfiguredServiceType()) ? (AbfsClient)Mockito.mock(AbfsDfsClient.class) : (AbfsClient)Mockito.mock(AbfsBlobClient.class);
        AbfsPerfTracker tracker = new AbfsPerfTracker("test", abfsConfig.getAccountName(), abfsConfig);
        Mockito.when((Object)client.getAbfsPerfTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)client.getAuthType()).thenReturn((Object)currentAuthType);
        Mockito.when((Object)client.getExponentialRetryPolicy()).thenReturn((Object)new ExponentialRetryPolicy(1));
        Mockito.when((Object)client.getRetryPolicy((String)ArgumentMatchers.any())).thenReturn((Object)new ExponentialRetryPolicy(1));
        Mockito.when((Object)client.createDefaultUriQueryBuilder()).thenCallRealMethod();
        Mockito.when((Object)client.createRequestUrl((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)client.createRequestUrl((URL)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)client.getAccessToken()).thenCallRealMethod();
        Mockito.when((Object)client.getSharedKeyCredentials()).thenCallRealMethod();
        Mockito.when((Object)client.createDefaultHeaders()).thenCallRealMethod();
        Mockito.when((Object)client.getAbfsConfiguration()).thenReturn((Object)abfsConfig);
        Mockito.when((Object)client.getIntercept()).thenReturn((Object)AbfsThrottlingInterceptFactory.getInstance((String)abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), (AbfsConfiguration)abfsConfig));
        Mockito.when((Object)client.getAbfsCounters()).thenReturn((Object)abfsCounters);
        ((AbfsClient)Mockito.doReturn((Object)baseAbfsClientInstance.getAbfsApacheHttpClient()).when((Object)client)).getAbfsApacheHttpClient();
        ReflectionUtils.setFinalField(AbfsClient.class, (Object)client, (String)"abfsConfiguration", (Object)abfsConfig);
        ReflectionUtils.setFinalField(AbfsClient.class, (Object)client, (String)"baseUrl", (Object)baseAbfsClientInstance.getBaseUrl());
        ReflectionUtils.setFinalField(AbfsClient.class, (Object)client, (String)"xMsVersion", (Object)baseAbfsClientInstance.getxMsVersion());
        if (currentAuthType == AuthType.SharedKey) {
            ReflectionUtils.setFinalField(AbfsClient.class, (Object)client, (String)"sharedKeyCredentials", (Object)new SharedKeyCredentials(abfsConfig.getAccountName().substring(0, abfsConfig.getAccountName().indexOf(".")), abfsConfig.getStorageAccountKey()));
        } else {
            ReflectionUtils.setFinalField(AbfsClient.class, (Object)client, (String)"tokenProvider", (Object)abfsConfig.getTokenProvider());
        }
        String userAgent = "APN/1.0 Azure Blob FS/3.5.0-SNAPSHOT (PrivateBuild JavaJRE 1.8.0_252; Linux 5.3.0-59-generic/amd64; openssl-1.0; UNKNOWN/UNKNOWN) MSFT";
        ReflectionUtils.setFinalField(AbfsClient.class, (Object)client, (String)"userAgent", (Object)userAgent);
        return client;
    }

    public static URL getTestUrl(AbfsClient client, String path) throws AzureBlobFileSystemException {
        AbfsUriQueryBuilder abfsUriQueryBuilder = client.createDefaultUriQueryBuilder();
        return client.createRequestUrl(path, abfsUriQueryBuilder.toString());
    }

    public static List<AbfsHttpHeader> getTestRequestHeaders(AbfsClient client) {
        return client.createDefaultHeaders();
    }

    public static AbfsRestOperation getRestOp(AbfsRestOperationType type, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, AbfsConfiguration abfsConfiguration) {
        return new AbfsRestOperation(type, client, method, url, requestHeaders, abfsConfiguration);
    }

    public static AccessTokenProvider getAccessTokenProvider(AbfsClient client) {
        return client.getTokenProvider();
    }

    private byte[] getRandomBytesArray(int length) {
        byte[] b = new byte[length];
        new Random().nextBytes(b);
        return b;
    }

    @Override
    public AzureBlobFileSystem getFileSystem(Configuration configuration) throws Exception {
        Configuration conf = new Configuration(configuration);
        conf.set("fs.azure.networking.library", this.httpOperationType.toString());
        return (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
    }

    @Test
    public void testExpectHundredContinue() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem(this.getRawConfiguration());
        Configuration configuration = fs.getAbfsStore().getAbfsConfiguration().getRawConfiguration();
        configuration.addResource("azure-test.xml");
        AbfsClient abfsClient = fs.getAbfsStore().getClient();
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, configuration.get("fs.azure.abfs.account.name"));
        AbfsConfiguration abfsConfig = TestAbfsConfigurationFieldsValidation.updateRetryConfigs(abfsConfiguration, 2, 100);
        AbfsClient testClient = (AbfsClient)Mockito.spy((Object)ITestAbfsClient.createTestClientFromCurrentContext(abfsClient, abfsConfig));
        AppendRequestParameters appendRequestParameters = new AppendRequestParameters(0L, 0, 5, AppendRequestParameters.Mode.APPEND_MODE, false, null, true);
        byte[] buffer = this.getRandomBytesArray(5);
        Path testPath = this.path(TEST_PATH);
        fs.create(testPath);
        String finalTestPath = testPath.toString().substring(testPath.toString().lastIndexOf("/"));
        List<AbfsHttpHeader> requestHeaders = ITestAbfsClient.getTestRequestHeaders(testClient);
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        if (appendRequestParameters.isExpectHeaderEnabled()) {
            requestHeaders.add(new AbfsHttpHeader("Expect", "100-continue"));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = testClient.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "append");
        abfsUriQueryBuilder.addQuery("position", Long.toString(appendRequestParameters.getPosition()));
        URL url = testClient.createRequestUrl(finalTestPath, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.Append, testClient, "PUT", url, requestHeaders, buffer, appendRequestParameters.getoffset(), appendRequestParameters.getLength(), null, abfsConfig));
        ((AbfsRestOperation)Mockito.doAnswer(answer -> {
            AbfsHttpOperation httpOperation = (AbfsHttpOperation)Mockito.spy((Object)((AbfsHttpOperation)answer.callRealMethod()));
            if (appendRequestParameters.isExpectHeaderEnabled()) {
                ((AbfsHttpOperation)Mockito.doReturn((Object)"100-continue").when((Object)httpOperation)).getConnProperty("Expect");
            }
            ((AbfsHttpOperation)Mockito.doNothing().when((Object)httpOperation)).setRequestProperty((String)Mockito.any(), (String)Mockito.any());
            ((AbfsHttpOperation)Mockito.doReturn((Object)url).when((Object)httpOperation)).getConnUrl();
            ((AbfsHttpOperation)Mockito.doReturn((Object)"PUT").when((Object)httpOperation)).getMethod();
            ((AbfsHttpOperation)Mockito.doReturn((Object)404).when((Object)httpOperation)).getStatusCode();
            ((AbfsHttpOperation)Mockito.doReturn((Object)404).when((Object)httpOperation)).getConnResponseCode();
            ((AbfsHttpOperation)Mockito.doReturn((Object)"Resource Not Found").when((Object)httpOperation)).getConnResponseMessage();
            if (httpOperation instanceof AbfsJdkHttpOperation) {
                ((AbfsJdkHttpOperation)Mockito.doThrow((Throwable[])new Throwable[]{new ProtocolException("Server rejected operation")}).when((Object)((AbfsJdkHttpOperation)httpOperation))).getConnOutputStream();
            }
            if (httpOperation instanceof AbfsAHCHttpOperation) {
                ((AbfsAHCHttpOperation)Mockito.doNothing().when((Object)((AbfsAHCHttpOperation)httpOperation))).parseResponseHeaderAndBody((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
                ((AbfsAHCHttpOperation)Mockito.doReturn((Object)404).when((Object)((AbfsAHCHttpOperation)httpOperation))).parseStatusCode((HttpResponse)Mockito.nullable(HttpResponse.class));
                ((AbfsAHCHttpOperation)Mockito.doThrow((Throwable[])new Throwable[]{new AbfsApacheHttpExpect100Exception((HttpResponse)Mockito.mock(HttpResponse.class))}).when((Object)((AbfsAHCHttpOperation)httpOperation))).executeRequest();
            }
            return httpOperation;
        }).when((Object)op)).createHttpOperation();
        ((AbfsClient)Mockito.doReturn((Object)op).when((Object)testClient)).getAbfsRestOperation((AbfsRestOperationType)ArgumentMatchers.eq((Object)AbfsRestOperationType.Append), (String)Mockito.any(), (URL)Mockito.any(), (List)Mockito.any(), (byte[])Mockito.any(), ((Integer)Mockito.nullable(Integer.TYPE)).intValue(), ((Integer)Mockito.nullable(Integer.TYPE)).intValue(), (String)Mockito.any());
        TracingContext tracingContext = (TracingContext)Mockito.spy((Object)new TracingContext("abcd", "abcde", FSOperationType.APPEND, TracingHeaderFormat.ALL_ID_FORMAT, null));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)appendRequestParameters.isExpectHeaderEnabled()).describedAs("The expect header is not true before the append call", new Object[0])).isTrue();
        LambdaTestUtils.intercept(AzureBlobFileSystemException.class, () -> testClient.append(finalTestPath, buffer, appendRequestParameters, null, null, tracingContext));
        ((AbstractIntegerAssert)Assertions.assertThat((int)tracingContext.getRetryCount()).describedAs("The retry count is incorrect", new Object[0])).isEqualTo(0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)appendRequestParameters.isExpectHeaderEnabled()).describedAs("The expect header is not false", new Object[0])).isFalse();
    }

    @Test
    public void testIsNonEmptyDirectory() throws IOException {
        this.testIsNonEmptyDirectoryInternal("", true, "", true, 1, false);
        this.testIsNonEmptyDirectoryInternal("", false, "", false, 1, true);
        this.testIsNonEmptyDirectoryInternal("continuation", true, "", true, 2, false);
        this.testIsNonEmptyDirectoryInternal("continuation", true, "", false, 2, true);
        this.testIsNonEmptyDirectoryInternal("continuation1", true, "continuation2", true, 3, false);
        this.testIsNonEmptyDirectoryInternal("continuation1", true, "continuation2", false, 2, true);
        this.testIsNonEmptyDirectoryInternal("continuation", false, "", true, 1, true);
        this.testIsNonEmptyDirectoryInternal("continuation", false, "", false, 1, true);
        this.testIsNonEmptyDirectoryInternal("continuation1", false, "continuation2", true, 1, true);
        this.testIsNonEmptyDirectoryInternal("continuation1", false, "continuation2", false, 1, true);
    }

    private void testIsNonEmptyDirectoryInternal(String firstCT, boolean isfirstEmpty, String secondCT, boolean isSecondEmpty, int expectedInvocations, boolean isNonEmpty) throws IOException {
        this.assumeBlobServiceType();
        AzureBlobFileSystem spiedFs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)spiedFs.getAbfsStore());
        AbfsBlobClient spiedClient = (AbfsBlobClient)Mockito.spy((Object)spiedStore.getClientHandler().getBlobClient());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)spiedStore).when((Object)spiedFs)).getAbfsStore();
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)spiedClient).when((Object)spiedStore)).getClient();
        VersionedFileStatus status1 = new VersionedFileStatus("owner", "group", null, false, 0L, false, 0, 0L, 0L, new Path("/testPath/file1"), "version", "encryptionContext");
        VersionedFileStatus status2 = new VersionedFileStatus("owner", "group", null, false, 0L, false, 0, 0L, 0L, new Path("/testPath/file2"), "version", "encryptionContext");
        ArrayList<VersionedFileStatus> mockedList1 = new ArrayList<VersionedFileStatus>();
        mockedList1.add(status1);
        ArrayList<VersionedFileStatus> mockedList2 = new ArrayList<VersionedFileStatus>();
        mockedList2.add(status2);
        ListResponseData listResponseData1 = new ListResponseData();
        listResponseData1.setContinuationToken(firstCT);
        listResponseData1.setFileStatusList((List)(isfirstEmpty ? new ArrayList<VersionedFileStatus>() : mockedList1));
        listResponseData1.setOp((AbfsRestOperation)Mockito.mock(AbfsRestOperation.class));
        ListResponseData listResponseData2 = new ListResponseData();
        listResponseData2.setContinuationToken(secondCT);
        listResponseData2.setFileStatusList((List)(isSecondEmpty ? new ArrayList<VersionedFileStatus>() : mockedList2));
        listResponseData2.setOp((AbfsRestOperation)Mockito.mock(AbfsRestOperation.class));
        ListResponseData listResponseData3 = new ListResponseData();
        listResponseData3.setContinuationToken("");
        listResponseData3.setFileStatusList(new ArrayList());
        listResponseData3.setOp((AbfsRestOperation)Mockito.mock(AbfsRestOperation.class));
        ((AbfsBlobClient)Mockito.doReturn((Object)listResponseData1).doReturn((Object)listResponseData2).doReturn((Object)listResponseData3).when((Object)spiedClient)).listPath((String)ArgumentMatchers.eq((Object)"/testPath"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
        int[] itr = new int[1];
        String[] continuationTokenUsed = new String[3];
        ((AbfsBlobClient)Mockito.doAnswer(invocationOnMock -> {
            if (itr[0] == 0) {
                itr[0] = itr[0] + 1;
                continuationTokenUsed[0] = (String)invocationOnMock.getArgument(3);
                return listResponseData1;
            }
            if (itr[0] == 1) {
                itr[0] = itr[0] + 1;
                continuationTokenUsed[1] = (String)invocationOnMock.getArgument(3);
                return listResponseData2;
            }
            continuationTokenUsed[2] = (String)invocationOnMock.getArgument(3);
            return listResponseData3;
        }).when((Object)spiedClient)).listPath((String)ArgumentMatchers.eq((Object)"/testPath"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class), (URI)ArgumentMatchers.any());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)spiedClient.isNonEmptyDirectory("/testPath", (TracingContext)Mockito.mock(TracingContext.class))).describedAs("isNonEmptyDirectory in client giving unexpected results", new Object[0])).isEqualTo(isNonEmpty);
        ((AbstractStringAssert)Assertions.assertThat((String)continuationTokenUsed[0]).describedAs("First continuation token used is not as expected", new Object[0])).isNull();
        if (expectedInvocations > 1) {
            ((AbstractStringAssert)Assertions.assertThat((String)continuationTokenUsed[1]).describedAs("Second continuation token used is not as expected", new Object[0])).isEqualTo((Object)firstCT);
        }
        if (expectedInvocations > 2) {
            ((AbstractStringAssert)Assertions.assertThat((String)continuationTokenUsed[2]).describedAs("Third continuation token used is not as expected", new Object[0])).isEqualTo((Object)secondCT);
        }
        ((AbfsBlobClient)Mockito.verify((Object)spiedClient, (VerificationMode)Mockito.times((int)expectedInvocations))).listPath((String)ArgumentMatchers.eq((Object)"/testPath"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.any(), (TracingContext)ArgumentMatchers.any(TracingContext.class), (URI)ArgumentMatchers.any());
    }
}

