/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsCountersImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsJdkHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.BlobDeleteHandler;
import org.apache.hadoop.fs.azurebfs.services.BlobRenameHandler;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.services.ListResponseData;
import org.apache.hadoop.fs.azurebfs.services.StaticRetryPolicy;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.assertj.core.api.Assertions;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class AbfsClientTestUtil {
    private static final long ONE_SEC = 1000L;

    private AbfsClientTestUtil() {
    }

    public static void setMockAbfsRestOperationForListOperation(AbfsClient spiedClient, FunctionRaisingIOE<AbfsJdkHttpOperation, AbfsJdkHttpOperation> functionRaisingIOE) throws Exception {
        ExponentialRetryPolicy exponentialRetryPolicy = (ExponentialRetryPolicy)Mockito.mock(ExponentialRetryPolicy.class);
        StaticRetryPolicy staticRetryPolicy = (StaticRetryPolicy)Mockito.mock(StaticRetryPolicy.class);
        AbfsThrottlingIntercept intercept = (AbfsThrottlingIntercept)Mockito.mock(AbfsThrottlingIntercept.class);
        AbfsJdkHttpOperation httpOperation = (AbfsJdkHttpOperation)Mockito.mock(AbfsJdkHttpOperation.class);
        AbfsRestOperation abfsRestOperation = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.ListPaths, spiedClient, "GET", null, new ArrayList(), spiedClient.getAbfsConfiguration()));
        ListResponseData listResponseData1 = (ListResponseData)Mockito.spy((Object)new ListResponseData());
        listResponseData1.setRenamePendingJsonPaths(null);
        listResponseData1.setOp(abfsRestOperation);
        listResponseData1.setFileStatusList(new ArrayList());
        listResponseData1.setContinuationToken("continuation");
        ListResponseData listResponseData2 = (ListResponseData)Mockito.spy((Object)new ListResponseData());
        listResponseData2.setRenamePendingJsonPaths(null);
        listResponseData2.setOp(abfsRestOperation);
        listResponseData2.setFileStatusList(new ArrayList());
        listResponseData2.setContinuationToken("");
        ((AbfsClient)Mockito.doReturn((Object)abfsRestOperation).when((Object)spiedClient)).getAbfsRestOperation((AbfsRestOperationType)ArgumentMatchers.eq((Object)AbfsRestOperationType.ListPaths), (String)ArgumentMatchers.any(), (URL)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        ((AbfsClient)Mockito.doReturn((Object)abfsRestOperation).when((Object)spiedClient)).getAbfsRestOperation((AbfsRestOperationType)ArgumentMatchers.eq((Object)AbfsRestOperationType.ListBlobs), (String)ArgumentMatchers.any(), (URL)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        AbfsClientTestUtil.addGeneralMockBehaviourToAbfsClient(spiedClient, exponentialRetryPolicy, staticRetryPolicy, intercept, listResponseData1);
        AbfsClientTestUtil.addGeneralMockBehaviourToRestOpAndHttpOp(abfsRestOperation, (AbfsHttpOperation)httpOperation);
        ((AbfsClient)Mockito.doReturn((Object)listResponseData1).doReturn((Object)listResponseData2).when((Object)spiedClient)).parseListPathResults((AbfsHttpOperation)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
        functionRaisingIOE.apply((Object)httpOperation);
    }

    public static void setMockAbfsRestOperationForFlushOperation(AbfsClient spiedClient, String eTag, String blockListXml, FunctionRaisingIOE<AbfsHttpOperation, AbfsHttpOperation> functionRaisingIOE) throws Exception {
        List<AbfsHttpHeader> requestHeaders = ITestAbfsClient.getTestRequestHeaders(spiedClient);
        byte[] buffer = blockListXml.getBytes(StandardCharsets.UTF_8);
        requestHeaders.add(new AbfsHttpHeader("Content-Length", String.valueOf(buffer.length)));
        requestHeaders.add(new AbfsHttpHeader("Content-Type", "application/xml"));
        requestHeaders.add(new AbfsHttpHeader("If-Match", eTag));
        requestHeaders.add(new AbfsHttpHeader("x-ms-blob-content-md5", spiedClient.computeMD5Hash(buffer, 0, buffer.length)));
        AbfsUriQueryBuilder abfsUriQueryBuilder = spiedClient.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("comp", "blocklist");
        abfsUriQueryBuilder.addQuery("close", String.valueOf(false));
        URL url = spiedClient.createRequestUrl("/test/file", abfsUriQueryBuilder.toString());
        AbfsRestOperation abfsRestOperation = (AbfsRestOperation)Mockito.spy((Object)new AbfsRestOperation(AbfsRestOperationType.PutBlockList, spiedClient, "PUT", url, requestHeaders, buffer, 0, buffer.length, null, spiedClient.getAbfsConfiguration()));
        ((AbfsClient)Mockito.doReturn((Object)abfsRestOperation).when((Object)spiedClient)).getAbfsRestOperation((AbfsRestOperationType)ArgumentMatchers.eq((Object)AbfsRestOperationType.PutBlockList), Mockito.anyString(), (URL)Mockito.any(URL.class), Mockito.anyList(), (byte[])Mockito.nullable(byte[].class), Mockito.anyInt(), Mockito.anyInt(), (String)Mockito.nullable(String.class));
        AbfsClientTestUtil.addMockBehaviourToRestOpAndHttpOp(abfsRestOperation, functionRaisingIOE);
    }

    public static void addGeneralMockBehaviourToRestOpAndHttpOp(AbfsRestOperation abfsRestOperation, AbfsHttpOperation httpOperation) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((HttpURLConnection)Mockito.doNothing().when((Object)httpURLConnection)).setRequestProperty((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class));
        ((AbfsRestOperation)Mockito.doReturn((Object)"").when((Object)abfsRestOperation)).getClientLatency();
        ((AbfsRestOperation)Mockito.doReturn((Object)httpOperation).when((Object)abfsRestOperation)).createHttpOperation();
    }

    public static void addMockBehaviourToRestOpAndHttpOp(AbfsRestOperation abfsRestOperation, FunctionRaisingIOE<AbfsHttpOperation, AbfsHttpOperation> functionRaisingIOE) throws IOException {
        ((AbfsRestOperation)Mockito.doAnswer(answer -> {
            AbfsHttpOperation httpOp = (AbfsHttpOperation)Mockito.spy((Object)answer.callRealMethod());
            functionRaisingIOE.apply((Object)httpOp);
            return httpOp;
        }).when((Object)abfsRestOperation)).createHttpOperation();
    }

    public static void addGeneralMockBehaviourToAbfsClient(AbfsClient abfsClient, ExponentialRetryPolicy exponentialRetryPolicy, StaticRetryPolicy staticRetryPolicy, AbfsThrottlingIntercept intercept, ListResponseData listResponseData) throws IOException, URISyntaxException {
        ((AbfsClient)Mockito.doReturn((Object)AuthType.OAuth).when((Object)abfsClient)).getAuthType();
        ((AbfsClient)Mockito.doReturn((Object)"").when((Object)abfsClient)).getAccessToken();
        AbfsConfiguration abfsConfiguration = (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class);
        ((AbfsClient)Mockito.doReturn((Object)abfsConfiguration).when((Object)abfsClient)).getAbfsConfiguration();
        AbfsCounters abfsCounters = (AbfsCounters)Mockito.spy((Object)new AbfsCountersImpl(new URI("abcd")));
        ((AbfsClient)Mockito.doReturn((Object)abfsCounters).when((Object)abfsClient)).getAbfsCounters();
        ((AbfsClient)Mockito.doReturn((Object)intercept).when((Object)abfsClient)).getIntercept();
        ((AbfsThrottlingIntercept)Mockito.doNothing().when((Object)intercept)).sendingRequest((AbfsRestOperationType)ArgumentMatchers.any(), (AbfsCounters)ArgumentMatchers.nullable(AbfsCounters.class));
        ((AbfsThrottlingIntercept)Mockito.doNothing().when((Object)intercept)).updateMetrics((AbfsRestOperationType)ArgumentMatchers.any(), (AbfsHttpOperation)ArgumentMatchers.any());
        ((AbfsClient)Mockito.doReturn((Object)listResponseData).when((Object)abfsClient)).parseListPathResults((AbfsHttpOperation)ArgumentMatchers.any(), (URI)ArgumentMatchers.any());
        ((AbfsClient)Mockito.doReturn((Object)exponentialRetryPolicy).when((Object)abfsClient)).getExponentialRetryPolicy();
        ((AbfsClient)Mockito.doReturn((Object)staticRetryPolicy).when((Object)abfsClient)).getRetryPolicy("CT");
        ((AbfsClient)Mockito.doReturn((Object)exponentialRetryPolicy).when((Object)abfsClient)).getRetryPolicy((String)AdditionalMatchers.not((Object)ArgumentMatchers.eq((Object)"CT")));
        ((StaticRetryPolicy)Mockito.doReturn((Object)true).when((Object)staticRetryPolicy)).shouldRetry(((Integer)ArgumentMatchers.nullable(Integer.class)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.class)).intValue());
        ((StaticRetryPolicy)Mockito.doReturn((Object)false).when((Object)staticRetryPolicy)).shouldRetry(1, 200);
        ((StaticRetryPolicy)Mockito.doReturn((Object)false).when((Object)staticRetryPolicy)).shouldRetry(2, 200);
        ((StaticRetryPolicy)Mockito.doReturn((Object)true).when((Object)staticRetryPolicy)).shouldRetry(1, 503);
        ((StaticRetryPolicy)Mockito.doReturn((Object)false).when((Object)staticRetryPolicy)).shouldRetry(2, 503);
        ((StaticRetryPolicy)Mockito.doReturn((Object)"S").when((Object)staticRetryPolicy)).getAbbreviation();
        ((StaticRetryPolicy)Mockito.doReturn((Object)1000L).when((Object)staticRetryPolicy)).getRetryInterval(((Integer)ArgumentMatchers.nullable(Integer.class)).intValue());
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)true).when((Object)exponentialRetryPolicy)).shouldRetry(((Integer)ArgumentMatchers.nullable(Integer.class)).intValue(), ((Integer)ArgumentMatchers.nullable(Integer.class)).intValue());
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)false).when((Object)exponentialRetryPolicy)).shouldRetry(1, 200);
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)false).when((Object)exponentialRetryPolicy)).shouldRetry(2, 200);
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)true).when((Object)exponentialRetryPolicy)).shouldRetry(1, 503);
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)false).when((Object)exponentialRetryPolicy)).shouldRetry(2, 503);
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)"E").when((Object)exponentialRetryPolicy)).getAbbreviation();
        ((ExponentialRetryPolicy)Mockito.doReturn((Object)2000L).when((Object)exponentialRetryPolicy)).getRetryInterval(((Integer)ArgumentMatchers.nullable(Integer.class)).intValue());
        AbfsConfiguration configurations = (AbfsConfiguration)Mockito.mock(AbfsConfiguration.class);
        ((AbfsClient)Mockito.doReturn((Object)configurations).when((Object)abfsClient)).getAbfsConfiguration();
        ((AbfsConfiguration)Mockito.doReturn((Object)true).when((Object)configurations)).getStaticRetryForConnectionTimeoutEnabled();
    }

    public static void hookOnRestOpsForTracingContextSingularity(AbfsClient client) {
        final HashSet tracingContextSet = new HashSet();
        final ReentrantLock lock = new ReentrantLock();
        Answer answer = new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)((AbfsRestOperation)invocationOnMock.callRealMethod()));
                ((AbfsRestOperation)Mockito.doAnswer(completeExecuteInvocation -> {
                    lock.lock();
                    try {
                        TracingContext context = (TracingContext)completeExecuteInvocation.getArgument(0);
                        Assertions.assertThat((Iterable)tracingContextSet).doesNotContain((Object[])new TracingContext[]{context});
                        tracingContextSet.add(context);
                    }
                    finally {
                        lock.unlock();
                    }
                    return completeExecuteInvocation.callRealMethod();
                }).when((Object)op)).completeExecute((TracingContext)Mockito.any(TracingContext.class));
                return op;
            }
        };
        ((AbfsClient)Mockito.doAnswer((Answer)answer).when((Object)client)).getAbfsRestOperation((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), Mockito.anyString(), (URL)Mockito.any(URL.class), Mockito.anyList(), (byte[])Mockito.nullable(byte[].class), Mockito.anyInt(), Mockito.anyInt(), (String)Mockito.nullable(String.class));
        ((AbfsClient)Mockito.doAnswer((Answer)answer).when((Object)client)).getAbfsRestOperation((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), Mockito.anyString(), (URL)Mockito.any(URL.class), Mockito.anyList());
        ((AbfsClient)Mockito.doAnswer((Answer)answer).when((Object)client)).getAbfsRestOperation((AbfsRestOperationType)Mockito.any(AbfsRestOperationType.class), Mockito.anyString(), (URL)Mockito.any(URL.class), Mockito.anyList(), (String)Mockito.nullable(String.class));
    }

    public static void mockGetDeleteBlobHandler(AbfsBlobClient blobClient, FunctionRaisingIOE<BlobDeleteHandler, Void> functionRaisingIOE) {
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            BlobDeleteHandler blobDeleteHandler = (BlobDeleteHandler)Mockito.spy((Object)((BlobDeleteHandler)answer.callRealMethod()));
            ((BlobDeleteHandler)Mockito.doAnswer(answer1 -> {
                functionRaisingIOE.apply((Object)blobDeleteHandler);
                return answer1.callRealMethod();
            }).when((Object)blobDeleteHandler)).execute();
            return blobDeleteHandler;
        }).when((Object)blobClient)).getBlobDeleteHandler(Mockito.anyString(), Mockito.anyBoolean(), (TracingContext)Mockito.any(TracingContext.class));
    }

    public static void mockGetRenameBlobHandler(AbfsBlobClient blobClient, FunctionRaisingIOE<BlobRenameHandler, Void> functionRaisingIOE) {
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            BlobRenameHandler blobRenameHandler = (BlobRenameHandler)Mockito.spy((Object)((BlobRenameHandler)answer.callRealMethod()));
            ((BlobRenameHandler)Mockito.doAnswer(answer1 -> {
                functionRaisingIOE.apply((Object)blobRenameHandler);
                return answer1.callRealMethod();
            }).when((Object)blobRenameHandler)).execute(Mockito.anyBoolean());
            return blobRenameHandler;
        }).when((Object)blobClient)).getBlobRenameHandler(Mockito.anyString(), Mockito.anyString(), (String)Mockito.nullable(String.class), Mockito.anyBoolean(), (TracingContext)Mockito.any(TracingContext.class));
    }

    public static void mockAddClientTransactionIdToHeader(AbfsDfsClient abfsDfsClient, String[] clientTransactionId) {
        ((AbfsDfsClient)Mockito.doAnswer(addClientTransactionId -> {
            clientTransactionId[0] = UUID.randomUUID().toString();
            List headers = (List)addClientTransactionId.getArgument(0);
            headers.add(new AbfsHttpHeader("x-ms-client-transaction-id", clientTransactionId[0]));
            return clientTransactionId[0];
        }).when((Object)abfsDfsClient)).addClientTransactionIdToHeader(Mockito.anyList());
    }
}

