/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.azurebfs.AbfsCountersImpl;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAbfsNetworkStatistics
extends AbstractAbfsIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestAbfsNetworkStatistics.class);
    private static final int LARGE_OPERATIONS = 1000;
    private static final AbfsStatistic[] HTTP_DURATION_TRACKER_LIST = new AbfsStatistic[]{AbfsStatistic.HTTP_POST_REQUEST, AbfsStatistic.HTTP_PATCH_REQUEST};

    @Test
    public void testAbfsThrottlingStatistics() throws IOException {
        this.describe("Test to check correct values of read throttle and write throttle statistics in Abfs", new Object[0]);
        AbfsCountersImpl statistics = new AbfsCountersImpl(this.getFileSystem().getUri());
        for (int i = 0; i < 1000; ++i) {
            statistics.incrementCounter(AbfsStatistic.READ_THROTTLES, 1L);
            statistics.incrementCounter(AbfsStatistic.WRITE_THROTTLES, 1L);
        }
        Map metricMap = statistics.toMap();
        this.assertAbfsStatistics(AbfsStatistic.READ_THROTTLES, 1000L, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.WRITE_THROTTLES, 1000L, metricMap);
    }

    @Test
    public void testAbfsNetworkDurationTrackers() throws IOException, InterruptedException {
        this.describe("Test to verify the actual values of DurationTrackers are greater than 0.0 while tracking some work.", new Object[0]);
        AbfsCountersImpl abfsCounters = new AbfsCountersImpl(this.getFileSystem().getUri());
        AbfsStatistic[] abfsStatisticArray = null;
        try (DurationTracker ignoredPatch = abfsCounters.trackDuration(AbfsStatistic.getStatNameFromHttpCall((String)"PATCH"));
             DurationTracker ignoredPost = abfsCounters.trackDuration(AbfsStatistic.getStatNameFromHttpCall((String)"POST"));){
            Thread.sleep(10L);
            LOG.info("Execute some Http requests...");
        }
        catch (Throwable object) {
            abfsStatisticArray = object;
            throw object;
        }
        IOStatistics ioStatistics = IOStatisticAssertions.extractStatistics((Object)abfsCounters);
        for (AbfsStatistic abfsStatistic : HTTP_DURATION_TRACKER_LIST) {
            ((AbstractDoubleAssert)Assertions.assertThat((double)IOStatisticAssertions.lookupMeanStatistic((IOStatistics)ioStatistics, (String)(abfsStatistic.getStatName() + ".mean")).mean()).describedAs("The DurationTracker Named " + abfsStatistic.getStatName() + " Doesn't match the expected value", new Object[0])).isGreaterThan(0.0);
        }
    }

    @Test
    public void testAbfsHTTP503ErrorCounter() throws IOException {
        this.describe("tests to verify the expected value of the HTTP 503 error counter is equal to number of times incremented.", new Object[0]);
        AbfsCountersImpl abfsCounters = new AbfsCountersImpl(this.getFileSystem().getUri());
        for (int i = 0; i < 1000; ++i) {
            abfsCounters.incrementCounter(AbfsStatistic.SERVER_UNAVAILABLE, 1L);
        }
        Map metricsMap = abfsCounters.toMap();
        this.assertAbfsStatistics(AbfsStatistic.SERVER_UNAVAILABLE, 1000L, metricsMap);
    }
}

