/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.annotations.ConfigurationValidationAnnotations;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestAbfsConfigurationFieldsValidation {
    private AbfsConfiguration abfsConfiguration;
    private static final String INT_KEY = "intKey";
    private static final String LONG_KEY = "longKey";
    private static final String STRING_KEY = "stringKey";
    private static final String BASE64_KEY = "base64Key";
    private static final String BOOLEAN_KEY = "booleanKey";
    private static final int DEFAULT_INT = 0x400000;
    private static final int DEFAULT_LONG = 0x400000;
    private static final int TEST_INT = 1234565;
    private static final int TEST_LONG = 0x400000;
    private final String accountName;
    private final String encodedString = Base64.encode((byte[])"base64Value".getBytes(StandardCharsets.UTF_8));
    private final String encodedAccountKey = Base64.encode((byte[])"someAccountKey".getBytes(StandardCharsets.UTF_8));
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="intKey", MinValue=-2147483648, MaxValue=0x7FFFFFFF, DefaultValue=0x400000)
    private int intField;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="longKey", MinValue=-9223372036854775808L, MaxValue=0x7FFFFFFFFFFFFFFFL, DefaultValue=0x400000L)
    private int longField;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="stringKey", DefaultValue="default")
    private String stringField;
    @ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation(ConfigurationKey="base64Key", DefaultValue="base64")
    private String base64Field;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="booleanKey", DefaultValue=false)
    private boolean boolField;

    public TestAbfsConfigurationFieldsValidation() throws Exception {
        this.accountName = "testaccount1.blob.core.windows.net";
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.set(INT_KEY, "1234565");
        configuration.set(LONG_KEY, "4194304");
        configuration.set(STRING_KEY, "stringValue");
        configuration.set(BASE64_KEY, this.encodedString);
        configuration.set(BOOLEAN_KEY, "true");
        configuration.set("fs.azure.account.key." + this.accountName, this.encodedAccountKey);
        this.abfsConfiguration = new AbfsConfiguration(configuration, this.accountName);
    }

    @Test
    public void testValidateFunctionsInConfigServiceImpl() throws Exception {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class)) {
                Assertions.assertThat((int)this.abfsConfiguration.validateInt(field)).isEqualTo(1234565);
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class)) {
                Assertions.assertThat((long)this.abfsConfiguration.validateLong(field)).isEqualTo(0x400000L);
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class)) {
                Assertions.assertThat((String)this.abfsConfiguration.validateString(field)).isEqualTo((Object)"stringValue");
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class)) {
                Assertions.assertThat((String)this.abfsConfiguration.validateBase64String(field)).isEqualTo((Object)this.encodedString);
                continue;
            }
            if (!field.isAnnotationPresent(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class)) continue;
            Assertions.assertThat((boolean)this.abfsConfiguration.validateBoolean(field)).isEqualTo(true);
        }
    }

    @Test
    public void testConfigServiceImplAnnotatedFieldsInitialized() throws Exception {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getWriteBufferSize()).describedAs("Default value of write buffer size should be initialized", new Object[0])).isEqualTo(0x800000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getReadBufferSize()).describedAs("Default value of read buffer size should be initialized", new Object[0])).isEqualTo(0x400000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getMinBackoffIntervalMilliseconds()).describedAs("Default value of min backoff interval should be initialized", new Object[0])).isEqualTo(500);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getMaxBackoffIntervalMilliseconds()).describedAs("Default value of max backoff interval should be initialized", new Object[0])).isEqualTo(25000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getBackoffIntervalMilliseconds()).describedAs("Default value of backoff interval should be initialized", new Object[0])).isEqualTo(500);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getMaxIoRetries()).describedAs("Default value of max number of retries should be initialized", new Object[0])).isEqualTo(30);
        ((AbstractLongAssert)Assertions.assertThat((long)this.abfsConfiguration.getAzureBlockSize()).describedAs("Default value of azure block size should be initialized", new Object[0])).isEqualTo(0x10000000L);
        ((AbstractStringAssert)Assertions.assertThat((String)this.abfsConfiguration.getAzureBlockLocationHost()).describedAs("Default value of azure block location host should be initialized", new Object[0])).isEqualTo((Object)"localhost");
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getReadAheadRange()).describedAs("Default value of read ahead range should be initialized", new Object[0])).isEqualTo(65536);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getHttpConnectionTimeout()).describedAs("Default value of http connection timeout should be initialized", new Object[0])).isEqualTo(2000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.abfsConfiguration.getHttpReadTimeout()).describedAs("Default value of http read timeout should be initialized", new Object[0])).isEqualTo(30000);
    }

    @Test
    public void testConfigBlockSizeInitialized() throws Exception {
        ((AbstractLongAssert)Assertions.assertThat((long)this.abfsConfiguration.getAzureBlockSize()).describedAs("Default value of max azure block size should be initialized", new Object[0])).isEqualTo(0x10000000L);
    }

    @Test
    public void testGetAccountKey() throws Exception {
        String accountKey = this.abfsConfiguration.getStorageAccountKey();
        ((AbstractStringAssert)Assertions.assertThat((String)accountKey).describedAs("Account Key should be initialized in configs", new Object[0])).isEqualTo((Object)this.encodedAccountKey);
    }

    @Test(expected=KeyProviderException.class)
    public void testGetAccountKeyWithNonExistingAccountName() throws Exception {
        Configuration configuration = new Configuration();
        configuration.addResource("azure-test.xml");
        configuration.unset("fs.azure.account.key");
        AbfsConfiguration abfsConfig = new AbfsConfiguration(configuration, "bogusAccountName");
        abfsConfig.getStorageAccountKey();
    }

    @Test
    public void testSSLSocketFactoryConfiguration() throws InvalidConfigurationValueException, IllegalAccessException, IOException {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.abfsConfiguration.getPreferredSSLFactoryOption()).describedAs("By default SSL Channel Mode should be Default", new Object[0])).isEqualTo((Object)DelegatingSSLSocketFactory.SSLChannelMode.Default);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.abfsConfiguration.getPreferredSSLFactoryOption()).describedAs("By default SSL Channel Mode should be Default", new Object[0])).isNotEqualTo((Object)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.abfsConfiguration.getPreferredSSLFactoryOption()).describedAs("By default SSL Channel Mode should be Default", new Object[0])).isNotEqualTo((Object)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL);
        Configuration configuration = new Configuration();
        configuration.setEnum("fs.azure.ssl.channel.mode", (Enum)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE);
        AbfsConfiguration localAbfsConfiguration = new AbfsConfiguration(configuration, this.accountName);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)localAbfsConfiguration.getPreferredSSLFactoryOption()).describedAs("SSL Channel Mode should be Default_JSSE as set", new Object[0])).isEqualTo((Object)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE);
        configuration = new Configuration();
        configuration.setEnum("fs.azure.ssl.channel.mode", (Enum)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL);
        localAbfsConfiguration = new AbfsConfiguration(configuration, this.accountName);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)localAbfsConfiguration.getPreferredSSLFactoryOption()).describedAs("SSL Channel Mode should be OpenSSL as set", new Object[0])).isEqualTo((Object)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL);
    }

    public static AbfsConfiguration updateRetryConfigs(AbfsConfiguration abfsConfig, int retryCount, int backoffTime) {
        abfsConfig.setMaxIoRetries(retryCount);
        abfsConfig.setMaxBackoffIntervalMilliseconds(backoffTime);
        return abfsConfig;
    }
}

