/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsScaleTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ITestSmallWriteOptimization
extends AbstractAbfsScaleTest {
    private static final int ONE_MB = 0x100000;
    private static final int TWO_MB = 0x200000;
    private static final int TEST_BUFFER_SIZE = 0x200000;
    private static final int HALF_TEST_BUFFER_SIZE = 0x100000;
    private static final int QUARTER_TEST_BUFFER_SIZE = 524288;
    private static final int TEST_FLUSH_ITERATION = 2;
    @Parameterized.Parameter
    public String testScenario;
    @Parameterized.Parameter(value=1)
    public boolean enableSmallWriteOptimization;
    @Parameterized.Parameter(value=2)
    public boolean directCloseTest;
    @Parameterized.Parameter(value=3)
    public Integer startingFileSize;
    @Parameterized.Parameter(value=4)
    public Integer recurringClientWriteSize;
    @Parameterized.Parameter(value=5)
    public Integer numOfClientWrites;
    @Parameterized.Parameter(value=6)
    public boolean flushExpectedToBeMergedWithAppend;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({"OptmON_FlushCloseTest_EmptyFile_BufferSizeWrite", true, false, 0, 0x200000, 1, false}, {"OptmON_FlushCloseTest_NonEmptyFile_BufferSizeWrite", true, false, 0x400000, 0x200000, 1, false}, {"OptmON_CloseTest_EmptyFile_BufferSizeWrite", true, true, 0, 0x200000, 1, false}, {"OptmON_CloseTest_NonEmptyFile_BufferSizeWrite", true, true, 0x400000, 0x200000, 1, false}, {"OptmOFF_FlushCloseTest_EmptyFile_BufferSizeWrite", false, false, 0, 0x200000, 1, false}, {"OptmOFF_FlushCloseTest_NonEmptyFile_BufferSizeWrite", false, false, 0x400000, 0x200000, 1, false}, {"OptmOFF_CloseTest_EmptyFile_BufferSizeWrite", false, true, 0, 0x200000, 1, false}, {"OptmOFF_CloseTest_NonEmptyFile_BufferSizeWrite", false, true, 0x400000, 0x200000, 1, false}, {"OptmON_FlushCloseTest_EmptyFile_LessThanBufferSizeWrite", true, false, 0, Math.abs(0x100000), 1, true}, {"OptmON_FlushCloseTest_NonEmptyFile_LessThanBufferSizeWrite", true, false, 0x400000, Math.abs(0x100000), 1, true}, {"OptmON_CloseTest_EmptyFile_LessThanBufferSizeWrite", true, true, 0, Math.abs(0x100000), 1, true}, {"OptmON_CloseTest_NonEmptyFile_LessThanBufferSizeWrite", true, true, 0x400000, Math.abs(0x100000), 1, true}, {"OptmOFF_FlushCloseTest_EmptyFile_LessThanBufferSizeWrite", false, false, 0, Math.abs(0x100000), 1, false}, {"OptmOFF_FlushCloseTest_NonEmptyFile_LessThanBufferSizeWrite", false, false, 0x400000, Math.abs(0x100000), 1, false}, {"OptmOFF_CloseTest_EmptyFile_LessThanBufferSizeWrite", false, true, 0, Math.abs(0x100000), 1, false}, {"OptmOFF_CloseTest_NonEmptyFile_LessThanBufferSizeWrite", false, true, 0x400000, Math.abs(0x100000), 1, false}, {"OptmON_FlushCloseTest_EmptyFile_MultiSmallWritesStillLessThanBufferSize", true, false, 0, Math.abs(524288), 3, true}, {"OptmON_FlushCloseTest_NonEmptyFile_MultiSmallWritesStillLessThanBufferSize", true, false, 0x400000, Math.abs(524288), 3, true}, {"OptmON_CloseTest_EmptyFile_MultiSmallWritesStillLessThanBufferSize", true, true, 0, Math.abs(524288), 3, true}, {"OptmON_CloseTest_NonEmptyFile_MultiSmallWritesStillLessThanBufferSize", true, true, 0x400000, Math.abs(524288), 3, true}, {"OptmOFF_FlushCloseTest_EmptyFile_MultiSmallWritesStillLessThanBufferSize", false, false, 0, Math.abs(524288), 3, false}, {"OptmOFF_FlushCloseTest_NonEmptyFile_MultiSmallWritesStillLessThanBufferSize", false, false, 0x400000, Math.abs(524288), 3, false}, {"OptmOFF_CloseTest_EmptyFile_MultiSmallWritesStillLessThanBufferSize", false, true, 0, Math.abs(524288), 3, false}, {"OptmOFF_CloseTest_NonEmptyFile_MultiSmallWritesStillLessThanBufferSize", false, true, 0x400000, Math.abs(524288), 3, false}, {"OptmON_FlushCloseTest_EmptyFile_MultiBufferSizeWrite", true, false, 0, 0x200000, 3, false}, {"OptmON_FlushCloseTest_NonEmptyFile_MultiBufferSizeWrite", true, false, 0x400000, 0x200000, 3, false}, {"OptmON_CloseTest_EmptyFile_MultiBufferSizeWrite", true, true, 0, 0x200000, 3, false}, {"OptmON_CloseTest_NonEmptyFile_MultiBufferSizeWrite", true, true, 0x400000, 0x200000, 3, false}, {"OptmOFF_FlushCloseTest_EmptyFile_MultiBufferSizeWrite", false, false, 0, 0x200000, 3, false}, {"OptmOFF_FlushCloseTest_NonEmptyFile_MultiBufferSizeWrite", false, false, 0x400000, 0x200000, 3, false}, {"OptmOFF_CloseTest_EmptyFile_MultiBufferSizeWrite", false, true, 0, 0x200000, 3, false}, {"OptmOFF_CloseTest_NonEmptyFile_MultiBufferSizeWrite", false, true, 0x400000, 0x200000, 3, false}, {"OptmON_FlushCloseTest_EmptyFile_BufferAndExtraWrite", true, false, 0, 0x200000 + Math.abs(524288), 3, false}, {"OptmON_FlushCloseTest_NonEmptyFile_BufferAndExtraWrite", true, false, 0x400000, 0x200000 + Math.abs(524288), 3, false}, {"OptmON_CloseTest_EmptyFile__BufferAndExtraWrite", true, true, 0, 0x200000 + Math.abs(524288), 3, false}, {"OptmON_CloseTest_NonEmptyFile_BufferAndExtraWrite", true, true, 0x400000, 0x200000 + Math.abs(524288), 3, false}, {"OptmOFF_FlushCloseTest_EmptyFile_BufferAndExtraWrite", false, false, 0, 0x200000 + Math.abs(524288), 3, false}, {"OptmOFF_FlushCloseTest_NonEmptyFile_BufferAndExtraWrite", false, false, 0x400000, 0x200000 + Math.abs(524288), 3, false}, {"OptmOFF_CloseTest_EmptyFile_BufferAndExtraWrite", false, true, 0, 0x200000 + Math.abs(524288), 3, false}, {"OptmOFF_CloseTest_NonEmptyFile_BufferAndExtraWrite", false, true, 0x400000, 0x200000 + Math.abs(524288), 3, false}, {"OptmON_FlushCloseTest_EmptyFile_0ByteWrite", true, false, 0, 0, 1, false}, {"OptmON_FlushCloseTest_NonEmptyFile_0ByteWrite", true, false, 0x400000, 0, 1, false}, {"OptmON_CloseTest_EmptyFile_0ByteWrite", true, true, 0, 0, 1, false}, {"OptmON_CloseTest_NonEmptyFile_0ByteWrite", true, true, 0x400000, 0, 1, false}, {"OptmOFF_FlushCloseTest_EmptyFile_0ByteWrite", false, false, 0, 0, 1, false}, {"OptmOFF_FlushCloseTest_NonEmptyFile_0ByteWrite", false, false, 0x400000, 0, 1, false}, {"OptmOFF_CloseTest_EmptyFile_0ByteWrite", false, true, 0, 0, 1, false}, {"OptmOFF_CloseTest_NonEmptyFile_0ByteWrite", false, true, 0x400000, 0, 1, false});
    }

    @Test
    public void testSmallWriteOptimization() throws IOException {
        AzureBlobFileSystem currentfs;
        Configuration config;
        boolean serviceDefaultOptmSettings = false;
        if (this.enableSmallWriteOptimization) {
            Assume.assumeTrue((boolean)serviceDefaultOptmSettings);
        }
        boolean isAppendBlobTestSettingEnabled = (config = (currentfs = this.getFileSystem()).getConf()).get("fs.azure.test.appendblob.enabled") == "true";
        Assume.assumeFalse((boolean)isAppendBlobTestSettingEnabled);
        config.set("fs.azure.write.request.size", Integer.toString(0x200000));
        config.set("fs.azure.write.enableappendwithflush", Boolean.toString(this.enableSmallWriteOptimization));
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.get((URI)currentfs.getUri(), (Configuration)config);
        this.formulateSmallWriteTestAppendPattern(fs, this.startingFileSize, this.recurringClientWriteSize, this.numOfClientWrites, this.directCloseTest, this.flushExpectedToBeMergedWithAppend);
    }

    private void formulateSmallWriteTestAppendPattern(AzureBlobFileSystem fs, int startingFileSize, int recurringWriteSize, int numOfWrites, boolean isDirectCloseTest, boolean flushExpectedToBeMergedWithAppend) throws IOException {
        FSDataOutputStream opStream;
        int totalDataToBeAppended = 0;
        int testIteration = 0;
        int dataWrittenPerIteration = numOfWrites * recurringWriteSize;
        if (isDirectCloseTest) {
            totalDataToBeAppended = dataWrittenPerIteration;
            testIteration = 1;
        } else {
            testIteration = 2;
            totalDataToBeAppended = testIteration * dataWrittenPerIteration;
        }
        int totalFileSize = totalDataToBeAppended + startingFileSize;
        byte[] writeBuffer = new byte[totalFileSize];
        new Random().nextBytes(writeBuffer);
        int writeBufferCursor = 0;
        Path testPath = new Path(this.getMethodName() + UUID.randomUUID().toString());
        if (startingFileSize > 0) {
            writeBufferCursor += this.createFileWithStartingTestSize(fs, writeBuffer, writeBufferCursor, testPath, startingFileSize);
            opStream = fs.append(testPath);
        } else {
            opStream = fs.create(testPath);
        }
        int writeBufferSize = fs.getAbfsStore().getAbfsConfiguration().getWriteBufferSize();
        long expectedTotalRequestsMade = (Long)fs.getInstrumentationMap().get(AbfsStatistic.CONNECTIONS_MADE.getStatName());
        long expectedRequestsMadeWithData = (Long)fs.getInstrumentationMap().get(AbfsStatistic.SEND_REQUESTS.getStatName());
        long expectedBytesSent = (Long)fs.getInstrumentationMap().get(AbfsStatistic.BYTES_SENT.getStatName());
        AbfsClient client = fs.getAbfsStore().getClientHandler().getIngressClient();
        while (testIteration > 0) {
            writeBufferCursor += this.executeWritePattern(opStream, writeBuffer, writeBufferCursor, numOfWrites, recurringWriteSize);
            int numOfBuffersWrittenToStore = (int)Math.floor(dataWrittenPerIteration / writeBufferSize);
            int dataSizeWrittenToStore = numOfBuffersWrittenToStore * writeBufferSize;
            int pendingDataToStore = dataWrittenPerIteration - dataSizeWrittenToStore;
            expectedTotalRequestsMade += (long)numOfBuffersWrittenToStore;
            expectedRequestsMadeWithData += (long)numOfBuffersWrittenToStore;
            expectedBytesSent += (long)dataSizeWrittenToStore;
            if (isDirectCloseTest) {
                opStream.close();
            } else {
                opStream.hflush();
            }
            boolean wasDataPendingToBeWrittenToServer = pendingDataToStore > 0;
            boolean smallWriteOptimizationEnabled = fs.getAbfsStore().getAbfsConfiguration().isSmallWriteOptimizationEnabled();
            boolean flushWillBeMergedWithAppend = smallWriteOptimizationEnabled && numOfBuffersWrittenToStore == 0 && wasDataPendingToBeWrittenToServer;
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)flushWillBeMergedWithAppend).describedAs(flushExpectedToBeMergedWithAppend ? "Flush was to be merged with Append" : "Flush should not have been merged with Append", new Object[0])).isEqualTo(flushExpectedToBeMergedWithAppend);
            int totalAppendFlushCalls = flushWillBeMergedWithAppend ? 1 : (wasDataPendingToBeWrittenToServer ? 2 : (recurringWriteSize == 0 && client instanceof AbfsBlobClient ? 0 : 1));
            this.assertOpStats(fs.getInstrumentationMap(), expectedTotalRequestsMade += (long)totalAppendFlushCalls, expectedRequestsMadeWithData += (long)totalAppendFlushCalls, expectedBytesSent += wasDataPendingToBeWrittenToServer ? (long)pendingDataToStore : 0L);
            if (isDirectCloseTest) {
                this.validateStoreAppends(fs, testPath, totalFileSize, writeBuffer);
                return;
            }
            --testIteration;
        }
        opStream.close();
        if (client instanceof AbfsDfsClient) {
            ++expectedTotalRequestsMade;
            ++expectedRequestsMadeWithData;
        }
        this.assertOpStats(fs.getInstrumentationMap(), expectedTotalRequestsMade, expectedRequestsMadeWithData, expectedBytesSent);
        this.validateStoreAppends(fs, testPath, totalFileSize, writeBuffer);
    }

    private int createFileWithStartingTestSize(AzureBlobFileSystem fs, byte[] writeBuffer, int writeBufferCursor, Path testPath, int startingFileSize) throws IOException {
        FSDataOutputStream opStream = fs.create(testPath);
        writeBufferCursor += this.executeWritePattern(opStream, writeBuffer, writeBufferCursor, 1, startingFileSize);
        opStream.close();
        ((AbstractLongAssert)Assertions.assertThat((long)fs.getFileStatus(testPath).getLen()).describedAs("File should be of size %d at the start of test.", new Object[]{startingFileSize})).isEqualTo((long)startingFileSize);
        return writeBufferCursor;
    }

    private void validateStoreAppends(AzureBlobFileSystem fs, Path testPath, int totalFileSize, byte[] bufferWritten) throws IOException {
        ((AbstractLongAssert)Assertions.assertThat((long)fs.getFileStatus(testPath).getLen()).describedAs("File should be of size %d at the end of test.", new Object[]{totalFileSize})).isEqualTo((long)totalFileSize);
        byte[] fileReadFromStore = new byte[totalFileSize];
        fs.open(testPath).read(fileReadFromStore, 0, totalFileSize);
        ITestSmallWriteOptimization.assertArrayEquals((String)"Test file content incorrect", (byte[])bufferWritten, (byte[])fileReadFromStore);
    }

    private void assertOpStats(Map<String, Long> metricMap, long expectedTotalRequestsMade, long expectedRequestsMadeWithData, long expectedBytesSent) {
        this.assertAbfsStatistics(AbfsStatistic.CONNECTIONS_MADE, expectedTotalRequestsMade, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.SEND_REQUESTS, expectedRequestsMadeWithData, metricMap);
        this.assertAbfsStatistics(AbfsStatistic.BYTES_SENT, expectedBytesSent, metricMap);
    }

    private int executeWritePattern(FSDataOutputStream opStream, byte[] buffer, int startOffset, int writeLoopCount, int writeSize) throws IOException {
        int dataSizeWritten = startOffset;
        while (writeLoopCount > 0) {
            opStream.write(buffer, startOffset, writeSize);
            startOffset += writeSize;
            --writeLoopCount;
        }
        dataSizeWritten = startOffset - dataSizeWritten;
        return dataSizeWritten;
    }
}

