/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class ITestSharedKeyAuth
extends AbstractAbfsIntegrationTest {
    @Test
    public void testWithWrongSharedKey() throws Exception {
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
        Configuration config = this.getRawConfiguration();
        config.setBoolean("fs.azure.createRemoteFileSystemDuringInitialization", true);
        String accountName = this.getAccountName();
        String configkKey = "fs.azure.account.key." + accountName;
        String secret = "XjUjsGherkDpljuyThd7RpljhR6uhsFjhlxRpmhgD12lnj7lhfRn8kgPt5+MJHS7UJNDER+jn6KP6Jnm2ONQlm==";
        config.set(configkKey, secret);
        LambdaTestUtils.intercept(IOException.class, (String)"\"Server failed to authenticate the request. Make sure the value of Authorization header is formed correctly including the signature.\", 403", () -> FileSystem.newInstance((Configuration)config));
    }
}

