/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.MockIntercept;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsDriverException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.BlobRenameHandler;
import org.apache.hadoop.fs.azurebfs.services.RenameAtomicity;
import org.apache.hadoop.fs.azurebfs.services.RenameAtomicityTestUtils;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsClient;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.AbfsTestUtils;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderFormat;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemRename
extends AbstractAbfsIntegrationTest {
    private static final int MAX_ITERATIONS = 20;
    private static final int BLOB_COUNT = 11;
    private static final int TOTAL_FILES = 25;

    @Test
    public void testEnsureFileIsRenamed() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path src = this.path("testEnsureFileIsRenamed-src");
        this.touch(src);
        Path dest = this.path("testEnsureFileIsRenamed-dest");
        fs.delete(dest, true);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)src, (Path)dest, (boolean)true);
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)dest);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"expected renamed", (Path)src);
    }

    @Test
    public void testRenameWithPreExistingDestination() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path src = this.path("renameSrc");
        this.touch(src);
        Path dest = this.path("renameDest");
        this.touch(dest);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)src, (Path)dest, (boolean)false);
    }

    @Test
    public void testRenameFileUnderDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourceDir = this.path("/testSrc");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)sourceDir);
        String filename = "file1";
        Path file1 = new Path(sourceDir, filename);
        this.touch(file1);
        Path destDir = this.path("/testDst");
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)sourceDir, (Path)destDir, (boolean)true);
        FileStatus[] fileStatus = fs.listStatus(destDir);
        ITestAzureBlobFileSystemRename.assertNotNull((String)"Null file status", (Object)fileStatus);
        FileStatus status = fileStatus[0];
        ITestAzureBlobFileSystemRename.assertEquals((String)("Wrong filename in " + status), (Object)filename, (Object)status.getPath().getName());
    }

    @Test
    public void testRenameDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir = this.path("testDir");
        fs.mkdirs(testDir);
        Path test1 = new Path(testDir + "/test1");
        fs.mkdirs(test1);
        fs.mkdirs(new Path(testDir + "/test1/test2"));
        fs.mkdirs(new Path(testDir + "/test1/test2/test3"));
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)test1, (Path)new Path(testDir + "/test10"), (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"rename source dir", (Path)test1);
    }

    @Test
    public void testRenameFirstLevelDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        Path source = this.path("/test");
        for (int i = 0; i < 1000; ++i) {
            final Path path = new Path(source + "/" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemRename.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        Path dest = this.path("/renamedDir");
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)source, (Path)dest, (boolean)true);
        FileStatus[] fileStatusArray = fs.listStatus(dest);
        ITestAzureBlobFileSystemRename.assertEquals((String)"Wrong number of files in listing", (long)1000L, (long)fileStatusArray.length);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"rename source dir", (Path)source);
    }

    @Test
    public void testRenameRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)new Path("/"), (Path)new Path("/testRenameRoot"), (boolean)false);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)new Path(fs.getUri().toString() + "/"), (Path)new Path(fs.getUri().toString() + "/s"), (boolean)false);
    }

    @Test
    public void testPosixRenameDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir2 = this.path("testDir2");
        fs.mkdirs(new Path(testDir2 + "/test1/test2/test3"));
        fs.mkdirs(new Path(testDir2 + "/test4"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.rename(new Path(testDir2 + "/test1/test2/test3"), new Path(testDir2 + "/test4")));
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)testDir2);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)new Path(testDir2 + "/test1/test2"));
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)new Path(testDir2 + "/test4"));
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)new Path(testDir2 + "/test4/test3"));
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)new Path(testDir2 + "/test1/test2/test3"));
    }

    @Test
    public void testRenameWithNoDestinationParentDir() throws Exception {
        this.describe("Verifying the expected behaviour of ABFS rename when destination parent Dir doesn't exist.", new Object[0]);
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourcePath = this.path(this.getMethodName());
        Path destPath = new Path("falseParent", "someChildFile");
        byte[] data = ContractTestUtils.dataset((int)1024, (int)97, (int)122);
        ContractTestUtils.writeDataset((FileSystem)fs, (Path)sourcePath, (byte[])data, (int)data.length, (int)1024, (boolean)true);
        ITestAzureBlobFileSystemRename.assertFalse((String)"Rename result expected to be false with no Parent dir", (boolean)fs.rename(sourcePath, destPath));
        IOStatistics ioStatistics = fs.getIOStatistics();
        AbfsClient client = fs.getAbfsStore().getClient();
        ((AbstractLongAssert)IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)ioStatistics, (String)AbfsStatistic.RENAME_PATH_ATTEMPTS.getStatName()).describedAs("For Dfs endpoint: There should be 2 rename attempts if metadata incomplete state failure is hit.For Blob endpoint: There would be only one rename attempt which would have a failed precheck.", new Object[0])).isEqualTo(client instanceof AbfsDfsClient ? 2L : 1L);
    }

    @Test
    public void testRenameToRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("/src1/src2"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.rename(new Path("/src1/src2"), new Path("/")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("/src2")));
    }

    @Test
    public void testRenameNotFoundBlobToEmptyRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.rename(new Path("/file"), new Path("/")));
    }

    @Test
    public void testRenameBlobToDstWithColonInSourcePath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(new Path("/src:/file"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path("/src:"), new Path("/dst"))).describedAs("Rename should succeed", new Object[0])).isTrue();
    }

    @Test
    public void testRenameWithColonInDestinationPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(new Path("/src"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path("/src"), new Path("/dst:"))).describedAs("Rename should succeed", new Object[0])).isTrue();
    }

    @Test
    public void testRenameWithColonInSourcePath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String sourceDirectory = "/src:";
        String destinationDirectory = "/dst";
        String fileName = "file";
        fs.create(new Path(sourceDirectory, fileName));
        fs.create(new Path(sourceDirectory + "/Test:", fileName));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path(sourceDirectory), new Path(destinationDirectory))).describedAs("Rename should succeed", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(sourceDirectory, fileName))).describedAs("Source directory should not exist after rename", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(destinationDirectory, fileName))).describedAs("Destination directory should exist after rename", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path(destinationDirectory), new Path(sourceDirectory))).describedAs("Rename should succeed", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(sourceDirectory, fileName))).describedAs("Destination directory should exist after rename", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(destinationDirectory, fileName))).describedAs("Source directory should not exist after rename", new Object[0])).isFalse();
    }

    @Test
    public void testRenameBlobInSameDirectoryWithNoMarker() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsStore().getClient();
        fs.create(new Path("/srcDir/dir/file"));
        client.deleteBlobPath(new Path("/srcDir/dir"), null, this.getTestTracingContext(fs, true));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.rename(new Path("/srcDir/dir"), new Path("/srcDir")));
    }

    @Test
    public void testPosixRenameDirectoryWhereDirectoryAlreadyThereOnDestination() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("testDir2/test1/test2/test3"));
        fs.create(new Path("testDir2/test1/test2/test3/file"));
        fs.mkdirs(new Path("testDir2/test4/test3"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.rename(new Path("testDir2/test1/test2/test3"), new Path("testDir2/test4")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2/test3")));
        if (this.getIsNamespaceEnabled(fs) || fs.getAbfsClient() instanceof AbfsBlobClient) {
            ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test4/test3/file")));
            ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file")));
        } else {
            ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4/test3/file")));
            ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file")));
        }
    }

    @Test
    public void testPosixRenameDirectoryWherePartAlreadyThereOnDestination() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("testDir2/test1/test2/test3"));
        fs.create(new Path("testDir2/test1/test2/test3/file"));
        fs.create(new Path("testDir2/test1/test2/test3/file1"));
        fs.mkdirs(new Path("testDir2/test4/"));
        fs.create(new Path("testDir2/test4/file1"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file1")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.rename(new Path("testDir2/test1/test2/test3"), new Path("testDir2/test4")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test1/test2/test3")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test4/file")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4/file1")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4/test3/file")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4/test3/file1")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4/file1")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test1/test2/test3/file1")));
    }

    @Test
    public void testRenamePendingJsonIsRemovedPostSuccessfulRename() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        fs.mkdirs(new Path("hbase/test1/test2/test3"));
        fs.create(new Path("hbase/test1/test2/test3/file"));
        fs.create(new Path("hbase/test1/test2/test3/file1"));
        fs.mkdirs(new Path("hbase/test4/"));
        fs.create(new Path("hbase/test4/file1"));
        Integer[] correctDeletePathCount = new Integer[]{0};
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            String correctDeletePath = "/hbase/test1/test2/test3-RenamePending.json";
            if ("/hbase/test1/test2/test3-RenamePending.json".equals(((Path)answer.getArgument(0)).toUri().getPath())) {
                correctDeletePathCount[0] = 1;
            }
            return null;
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.rename(new Path("hbase/test1/test2/test3"), new Path("hbase/test4")));
        ITestAzureBlobFileSystemRename.assertEquals((String)"RenamePendingJson should be deleted", (long)1L, (long)correctDeletePathCount[0].intValue());
    }

    @Test
    public void testHBaseHandlingForFailedRenameWithListRecovery() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        String srcPath = "hbase/test1/test2";
        String failedCopyPath = srcPath + "/test3/file1";
        this.setupAndTestHBaseFailedRenameRecovery(fs, client, srcPath, failedCopyPath, (FunctionRaisingIOE<AzureBlobFileSystem, Void>)((FunctionRaisingIOE)abfsFs -> {
            abfsFs.listStatus(new Path(srcPath).getParent());
            return null;
        }));
    }

    @Test
    public void testHBaseHandlingForFailedRenameWithGetFileStatusRecovery() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        String srcPath = "hbase/test1/test2";
        String failedCopyPath = srcPath + "/test3/file1";
        this.setupAndTestHBaseFailedRenameRecovery(fs, client, srcPath, failedCopyPath, (FunctionRaisingIOE<AzureBlobFileSystem, Void>)((FunctionRaisingIOE)abfsFs -> {
            abfsFs.exists(new Path(srcPath));
            return null;
        }));
    }

    @Test
    public void testHbaseListStatusBeforeRenamePendingFileAppendedWithIngressOnBlob() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        fs.setWorkingDirectory(new Path("/"));
        this.testRenamePreRenameFailureResolution(fs);
        this.testAtomicityRedoInvalidFile(fs);
    }

    @Test
    public void testRenameJsonDeletedBeforeRenameAtomicityCanDelete() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path path = new Path("/hbase/test1/test2");
        fs.mkdirs(new Path(path, "test3"));
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        FSDataOutputStream os = fs.create(renameJson);
        os.write("{}".getBytes(StandardCharsets.UTF_8));
        os.close();
        int[] renameJsonDeleteCounter = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(deleteAnswer -> {
            Path ansPath = (Path)deleteAnswer.getArgument(0);
            if (renameJson.toUri().getPath().equalsIgnoreCase(ansPath.toUri().getPath())) {
                renameJsonDeleteCounter[0] = renameJsonDeleteCounter[0] + 1;
            }
            this.getFileSystem().delete(ansPath, true);
            return deleteAnswer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        new RenameAtomicity(renameJson, 2, this.getTestTracingContext(fs, true), null, (AbfsClient)client);
    }

    @Test
    public void testRenameCompleteBeforeRenameAtomicityRedo() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path path = new Path("/hbase/test1/test2");
        fs.mkdirs(new Path(path, "test3"));
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        VersionedFileStatus fileStatus = (VersionedFileStatus)fs.getFileStatus(path);
        int jsonLen = new RenameAtomicity(path, new Path("/hbase/test4"), renameJson, this.getTestTracingContext(fs, true), fileStatus.getEtag(), (AbfsClient)client).preRename();
        RenameAtomicity redoRenameAtomicity = (RenameAtomicity)Mockito.spy((Object)new RenameAtomicity(renameJson, jsonLen, this.getTestTracingContext(fs, true), null, (AbfsClient)client));
        RenameAtomicityTestUtils.addReadPathMock(redoRenameAtomicity, readCallbackAnswer -> {
            byte[] bytes = (byte[])readCallbackAnswer.callRealMethod();
            fs.delete(path, true);
            return bytes;
        });
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> ((RenameAtomicity)redoRenameAtomicity).redo());
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("RenameAtomicity redo should fail with 404", new Object[0])).isEqualTo(AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND.getStatusCode());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ex.getErrorCode()).describedAs("RenameAtomicity redo should fail with 404", new Object[0])).isEqualTo((Object)AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND);
    }

    @Test
    public void testCopyBlobIdempotency() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path src = new Path("/srcDir/src");
        Path dst = new Path("/dst");
        fs.create(src);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            Path srcCopy = (Path)answer.getArgument(0);
            Path dstCopy = (Path)answer.getArgument(1);
            String leaseId = (String)answer.getArgument(2);
            TracingContext tracingContext = (TracingContext)answer.getArgument(3);
            ((AbfsBlobClient)this.getFileSystem().getAbfsClient()).copyBlob(srcCopy, dstCopy, leaseId, tracingContext);
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should be successful and copyBlob shouldbe able to handle idempotency issue", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(src)).describedAs("Source should not exist after rename", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(dst)).describedAs("Destination should exist after rename", new Object[0])).isTrue();
    }

    @Test
    public void testRenameBlobIdempotencyWhereDstIsCreatedFromSomeOtherProcess() throws IOException {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path src = new Path("/src");
        Path dst = new Path("/dst");
        fs.create(src);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            Path dstCopy = (Path)answer.getArgument(1);
            fs.create(dstCopy);
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should be successful and copyBlob shouldbe able to handle idempotency issue", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(src)).describedAs("Source should exist after rename failure", new Object[0])).isTrue();
    }

    @Test
    public void testRenameDirWhenMarkerBlobIsAbsentOnDstDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        fs.mkdirs(new Path("/test1"));
        fs.mkdirs(new Path("/test1/test2"));
        fs.mkdirs(new Path("/test1/test2/test3"));
        fs.create(new Path("/test1/test2/test3/file"));
        ((AbfsBlobClient)fs.getAbfsClient()).deleteBlobPath(new Path("/test1/test2"), null, this.getTestTracingContext(fs, true));
        fs.mkdirs(new Path("/test4/test5"));
        fs.rename(new Path("/test4"), new Path("/test1/test2"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("/test1/test2/test4/test5")));
    }

    @Test
    public void testBlobRenameSrcDirHasNoMarker() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        fs.create(new Path("/test1/test2/file1"));
        ((AbfsBlobClient)fs.getAbfsStore().getClient()).deleteBlobPath(new Path("/test1"), null, this.getTestTracingContext(fs, true));
        fs.mkdirs(new Path("/test2"));
        fs.rename(new Path("/test1"), new Path("/test2"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("/test2/test1")));
    }

    @Test
    public void testCopyBlobTakeTime() throws Exception {
        AzureBlobFileSystem fileSystem = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient spiedClient = (AbfsBlobClient)this.addSpyHooksOnClient(fileSystem);
        this.addMockForProgressStatusOnCopyOperation(spiedClient);
        fileSystem.create(new Path("/test1/file"));
        BlobRenameHandler[] blobRenameHandlers = new BlobRenameHandler[1];
        AbfsClientTestUtil.mockGetRenameBlobHandler(spiedClient, (FunctionRaisingIOE<BlobRenameHandler, Void>)((FunctionRaisingIOE)blobRenameHandler -> {
            blobRenameHandlers[0] = blobRenameHandler;
            return null;
        }));
        fileSystem.rename(new Path("/test1/file"), new Path("/test1/file2"));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fileSystem.exists(new Path("/test1/file2")));
        ((BlobRenameHandler)Mockito.verify((Object)blobRenameHandlers[0], (VerificationMode)Mockito.times((int)1))).handleCopyInProgress((Path)Mockito.any(Path.class), (TracingContext)Mockito.any(TracingContext.class), (String)Mockito.any(String.class));
    }

    @Test
    public void testCopyBlobTakeTimeAndEventuallyFail() throws Exception {
        AzureBlobFileSystem fileSystem = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient spiedClient = (AbfsBlobClient)this.addSpyHooksOnClient(fileSystem);
        this.addMockForProgressStatusOnCopyOperation(spiedClient);
        fileSystem.create(new Path("/test1/file"));
        this.addMockForCopyOperationFinalStatus(spiedClient, "failed");
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fileSystem.rename(new Path("/test1/file"), new Path("/test1/file2")));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("Expecting COPY_FAILED status code", new Object[0])).isEqualTo(AzureServiceErrorCode.COPY_BLOB_FAILED.getStatusCode());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ex.getErrorCode()).describedAs("Expecting COPY_FAILED error code", new Object[0])).isEqualTo((Object)AzureServiceErrorCode.COPY_BLOB_FAILED);
    }

    @Test
    public void testCopyBlobTakeTimeAndEventuallyAborted() throws Exception {
        AzureBlobFileSystem fileSystem = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient spiedClient = (AbfsBlobClient)this.addSpyHooksOnClient(fileSystem);
        this.addMockForProgressStatusOnCopyOperation(spiedClient);
        fileSystem.create(new Path("/test1/file"));
        this.addMockForCopyOperationFinalStatus(spiedClient, "aborted");
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fileSystem.rename(new Path("/test1/file"), new Path("/test1/file2")));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("Expecting COPY_ABORTED status code", new Object[0])).isEqualTo(AzureServiceErrorCode.COPY_BLOB_ABORTED.getStatusCode());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)ex.getErrorCode()).describedAs("Expecting COPY_ABORTED error code", new Object[0])).isEqualTo((Object)AzureServiceErrorCode.COPY_BLOB_ABORTED);
    }

    @Test
    public void testCopyBlobTakeTimeAndBlobIsDeleted() throws Exception {
        AzureBlobFileSystem fileSystem = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient spiedClient = (AbfsBlobClient)this.addSpyHooksOnClient(fileSystem);
        String srcFile = "/test1/file";
        String dstFile = "/test1/file2";
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)((AbfsRestOperation)answer.callRealMethod()));
            fileSystem.delete(new Path(dstFile), false);
            AbfsHttpOperation httpOp = (AbfsHttpOperation)Mockito.spy((Object)op.getResult());
            ((AbfsHttpOperation)Mockito.doReturn((Object)"pending").when((Object)httpOp)).getResponseHeader("x-ms-copy-status");
            ((AbfsRestOperation)Mockito.doReturn((Object)httpOp).when((Object)op)).getResult();
            return op;
        }).when((Object)spiedClient)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        fileSystem.create(new Path(srcFile));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fileSystem.rename(new Path(srcFile), new Path(dstFile)));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fileSystem.exists(new Path(dstFile)));
    }

    @Test
    public void testCopyAfterSourceHasBeenDeleted() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        fs.create(new Path("/src"));
        TracingContext tracingContext = new TracingContext("clientCorrelationId", "fileSystemId", FSOperationType.TEST_OP, this.getConfiguration().getTracingHeaderFormat(), null);
        client.deleteBlobPath(new Path("/src"), null, this.getTestTracingContext(fs, true));
        Boolean srcBlobNotFoundExReceived = false;
        AbfsRestOperationException ex = (AbfsRestOperationException)LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> client.copyBlob(new Path("/src"), new Path("/dst"), null, this.getTestTracingContext(fs, true)));
        ((AbstractIntegerAssert)Assertions.assertThat((int)ex.getStatusCode()).describedAs("Source has to be not found at copy", new Object[0])).isEqualTo(404);
    }

    @Test
    public void testParallelRenameForAtomicRenameShouldFail() throws Exception {
        Configuration config = this.getRawConfiguration();
        config.set("fs.azure.lease.threads", "2");
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)config)));
        this.assumeBlobServiceType();
        fs.setWorkingDirectory(new Path("/"));
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        Path src = new Path("/hbase/src");
        Path dst = new Path("/hbase/dst");
        fs.mkdirs(src);
        AtomicBoolean leaseAcquired = new AtomicBoolean(false);
        AtomicBoolean exceptionOnParallelRename = new AtomicBoolean(false);
        AtomicBoolean parallelThreadDone = new AtomicBoolean(false);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            AbfsRestOperation op = (AbfsRestOperation)answer.callRealMethod();
            leaseAcquired.set(true);
            while (!parallelThreadDone.get()) {
            }
            return op;
        }).when((Object)client)).acquireLease(Mockito.anyString(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        new Thread(() -> {
            while (!leaseAcquired.get()) {
            }
            try {
                fs.rename(src, dst);
            }
            catch (Exception e) {
                if (e.getCause() instanceof AbfsLease.LeaseException && e.getCause().getCause() instanceof AbfsRestOperationException && ((AbfsRestOperationException)e.getCause().getCause()).getStatusCode() == 409) {
                    exceptionOnParallelRename.set(true);
                }
            }
            finally {
                parallelThreadDone.set(true);
            }
        }).start();
        fs.rename(src, dst);
        while (!parallelThreadDone.get()) {
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)exceptionOnParallelRename.get()).describedAs("Parallel rename should fail", new Object[0])).isTrue();
    }

    @Test
    public void testAppendAtomicBlobDuringRename() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        Path src = new Path("/hbase/src");
        Path dst = new Path("/hbase/dst");
        FSDataOutputStream os = fs.create(src);
        AtomicBoolean copyInProgress = new AtomicBoolean(false);
        AtomicBoolean outputStreamClosed = new AtomicBoolean(false);
        AtomicBoolean appendFailed = new AtomicBoolean(false);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            copyInProgress.set(true);
            while (!outputStreamClosed.get()) {
            }
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        new Thread(() -> {
            while (!copyInProgress.get()) {
            }
            try {
                os.write(1);
                os.close();
            }
            catch (IOException e) {
                appendFailed.set(true);
            }
            finally {
                outputStreamClosed.set(true);
            }
        }).start();
        fs.rename(src, dst);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)appendFailed.get()).describedAs("Append should fail", new Object[0])).isTrue();
    }

    @Test
    public void testBlobRenameOfDirectoryHavingNeighborWithSamePrefix() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        fs.mkdirs(new Path("/testDir/dir"));
        fs.mkdirs(new Path("/testDir/dirSamePrefix"));
        fs.create(new Path("/testDir/dir/file1"));
        fs.create(new Path("/testDir/dir/file2"));
        fs.create(new Path("/testDir/dirSamePrefix/file1"));
        fs.create(new Path("/testDir/dirSamePrefix/file2"));
        fs.rename(new Path("/testDir/dir"), new Path("/testDir/dir2"));
        Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dirSamePrefix/file1"))).isTrue();
        Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir/file1"))).isFalse();
        Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir/file2"))).isFalse();
        Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir/"))).isFalse();
    }

    @Test
    public void testBlobRenameWithListGivingPaginatedResultWithOneObjectPerList() throws Exception {
        int i;
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient spiedClient = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.mkdirs(new Path("/testDir/dir1"));
        for (i = 0; i < 10; ++i) {
            fs.create(new Path("/testDir/dir1/file" + i));
        }
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            String path = (String)answer.getArgument(0);
            boolean recursive = (Boolean)answer.getArgument(1);
            String continuation = (String)answer.getArgument(3);
            TracingContext context = (TracingContext)answer.getArgument(4);
            return this.getFileSystem().getAbfsClient().listPath(path, recursive, 1, continuation, context, null);
        }).when((Object)spiedClient)).listPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class), (URI)Mockito.nullable(URI.class));
        fs.rename(new Path("/testDir/dir1"), new Path("/testDir/dir2"));
        for (i = 0; i < 10; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir2/file" + i))).describedAs("File " + i + " should exist in /testDir/dir2", new Object[0])).isTrue();
        }
    }

    @Test
    public void testProducerStopOnRenameFailure() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        fs.mkdirs(new Path("/src"));
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList futureList = new ArrayList();
        int i = 0;
        while (i < 20) {
            int n = i++;
            Future<?> future = executorService.submit(() -> {
                try {
                    fs.create(new Path("/src/file" + iter));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            futureList.add(future);
        }
        for (Future future : futureList) {
            future.get();
        }
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        AbfsBlobClient abfsBlobClient = (AbfsBlobClient)Mockito.spy((Object)client);
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        store.setClient((AbfsClient)abfsBlobClient);
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        int[] copyCallInvocation = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            throw new AbfsRestOperationException(403, "", "", new Exception());
        }).when((Object)abfsBlobClient)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        AbfsClientTestUtil.mockGetRenameBlobHandler(abfsBlobClient, (FunctionRaisingIOE<BlobRenameHandler, Void>)((FunctionRaisingIOE)blobRenameHandler -> {
            ((BlobRenameHandler)Mockito.doAnswer(answer -> {
                try {
                    answer.callRealMethod();
                }
                catch (AbfsRestOperationException ex) {
                    if (ex.getStatusCode() == 403) {
                        copyCallInvocation[0] = copyCallInvocation[0] + 1;
                    }
                    throw ex;
                }
                throw new AssertionError((Object)"List Consumption should have failed");
            }).when(blobRenameHandler)).listRecursiveAndTakeAction();
            return null;
        }));
        int[] listCallInvocation = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            if (answer.getArgument(0).equals("/src")) {
                if (listCallInvocation[0] == 1) {
                    while (copyCallInvocation[0] == 0) {
                    }
                }
                listCallInvocation[0] = listCallInvocation[0] + 1;
                return this.getFileSystem().getAbfsClient().listPath((String)answer.getArgument(0), ((Boolean)answer.getArgument(1)).booleanValue(), 1, (String)answer.getArgument(3), (TracingContext)answer.getArgument(4), (URI)answer.getArgument(5));
            }
            return answer.callRealMethod();
        }).when((Object)abfsBlobClient)).listPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class), (URI)Mockito.nullable(URI.class));
        LambdaTestUtils.intercept(AccessDeniedException.class, () -> fs.rename(new Path("/src"), new Path("/dst")));
        ((AbstractIntegerAssert)Assertions.assertThat((int)listCallInvocation[0]).describedAs("List on src should have been invoked at-most twice.One before consumption and the other after consumption has starting.Once consumption fails, listing would be stopped.", new Object[0])).isLessThanOrEqualTo(2);
    }

    @Test
    public void testRenameResumeThroughListStatusWithSrcDirDeletedJustBeforeResume() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path srcPath = new Path("hbase/test1/");
        Path failurePath = new Path(srcPath, "file");
        fs.mkdirs(srcPath);
        fs.create(failurePath);
        this.crashRename(fs, client, srcPath.toUri().getPath());
        fs.delete(srcPath, true);
        AtomicInteger copiedBlobs = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            copiedBlobs.incrementAndGet();
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        fs.listStatus(new Path("hbase"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)copiedBlobs.get()).describedAs("No Copy on resume", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testRenameResumeThroughListStatusWithSrcDirETagChangedJustBeforeResume() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path srcPath = new Path("hbase/test1/");
        Path failurePath = new Path(srcPath, "file");
        fs.mkdirs(srcPath);
        fs.create(failurePath);
        this.crashRename(fs, client, srcPath.toUri().getPath());
        fs.delete(srcPath, true);
        fs.mkdirs(srcPath);
        AtomicInteger copiedBlobs = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            copiedBlobs.incrementAndGet();
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        AtomicInteger pendingJsonDeleted = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(listAnswer -> {
            Path path = (Path)listAnswer.getArgument(0);
            if (path.toUri().getPath().endsWith("-RenamePending.json")) {
                pendingJsonDeleted.incrementAndGet();
            }
            return listAnswer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        fs.listStatus(new Path("/hbase"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)copiedBlobs.get()).describedAs("No Copy on resume", new Object[0])).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pendingJsonDeleted.get()).describedAs("RenamePendingJson should be deleted", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testRenameResumeThroughGetStatusWithSrcDirETagChangedJustBeforeResume() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.setWorkingDirectory(new Path("/"));
        Path srcPath = new Path("hbase/test1/");
        Path failurePath = new Path(srcPath, "file");
        fs.mkdirs(srcPath);
        fs.create(failurePath);
        this.crashRename(fs, client, srcPath.toUri().getPath());
        fs.delete(srcPath, true);
        fs.mkdirs(srcPath);
        AtomicInteger copiedBlobs = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            copiedBlobs.incrementAndGet();
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        AtomicInteger pendingJsonDeleted = new AtomicInteger(0);
        ((AbfsBlobClient)Mockito.doAnswer(listAnswer -> {
            Path path = (Path)listAnswer.getArgument(0);
            if (path.toUri().getPath().endsWith("-RenamePending.json")) {
                pendingJsonDeleted.incrementAndGet();
            }
            return listAnswer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(srcPath)).describedAs("Source should exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)copiedBlobs.get()).describedAs("No Copy on resume", new Object[0])).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pendingJsonDeleted.get()).describedAs("RenamePendingJson should be deleted", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testRenameSrcDirDeleteEmitDeletionCountInClientRequestId() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        String dirPathStr = "/testDir/dir1";
        fs.mkdirs(new Path(dirPathStr));
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        ArrayList<Future<FSDataOutputStream>> futures = new ArrayList<Future<FSDataOutputStream>>();
        int i = 0;
        while (i < 10) {
            int n = i++;
            Future<FSDataOutputStream> future = executorService.submit(() -> fs.create(new Path("/testDir/dir1/file" + iter)));
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        TracingHeaderValidator tracingHeaderValidator = new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.RENAME, true, 0);
        fs.registerListener((Listener)tracingHeaderValidator);
        ((AbfsBlobClient)Mockito.doAnswer(copyAnswer -> {
            if (dirPathStr.equalsIgnoreCase(((Path)copyAnswer.getArgument(0)).toUri().getPath())) {
                tracingHeaderValidator.setOperatedBlobCount(11);
                return copyAnswer.callRealMethod();
            }
            return copyAnswer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsBlobClient)Mockito.doAnswer(deleteAnswer -> {
            if (dirPathStr.equalsIgnoreCase(((Path)deleteAnswer.getArgument(0)).toUri().getPath())) {
                Object result = deleteAnswer.callRealMethod();
                tracingHeaderValidator.setOperatedBlobCount(null);
                return result;
            }
            return deleteAnswer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        fs.rename(new Path(dirPathStr), new Path("/dst/"));
    }

    @Test
    public void testRenameDirWithDifferentParallelismConfig() throws Exception {
        try (AzureBlobFileSystem currentFs = this.getFileSystem();){
            this.assumeBlobServiceType();
            Path src = new Path("/hbase/A1/A2");
            Path dst = new Path("/hbase/A1/A3");
            AbfsTestUtils.createFiles(currentFs, src, 25);
            this.renameDir(currentFs, "10", "5", "2", src, dst);
            this.renameDir(currentFs, "100", "5", "2", dst, src);
            String errorMessage = ((PathIOException)LambdaTestUtils.intercept(PathIOException.class, () -> this.renameDir(currentFs, "50", "50", "5", src, dst))).getMessage();
            ((AbstractStringAssert)Assertions.assertThat((String)errorMessage).describedAs("maxConsumptionLag should be lesser than maxSize", new Object[0])).contains(new CharSequence[]{"Invalid configuration value detected for \"fs.azure.blob.dir.list.consumer.max.lag\". maxConsumptionLag should be lesser than maxSize"});
        }
    }

    @Test
    public void testRenameWhenDestinationPathContainsColon() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.setWorkingDirectory(new Path("/"));
        String fileName = "file";
        Path src = new Path("/test1/");
        Path dst = new Path("/test1:/");
        fs.create(new Path(src, fileName));
        this.performRenameAndValidate(fs, src, dst, fileName);
    }

    @Test
    public void testGetAtomicRenameKeyForRootFolder() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        AbfsBlobClient abfsBlobClient = (AbfsBlobClient)fs.getAbfsClient();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsBlobClient.isAtomicRenameKey("/hbase")).describedAs("Atomic rename key should return false for Root folder", new Object[0])).isFalse();
    }

    @Test
    public void testGetAtomicRenameKeyForNonRootFolder() throws Exception {
        AzureBlobFileSystem currentFs = this.getFileSystem();
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.atomic.rename.key", "/hbase,/a,/b");
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);
        this.assumeBlobServiceType();
        AbfsBlobClient abfsBlobClient = (AbfsBlobClient)fs.getAbfsClient();
        this.validateAtomicRenameKey(abfsBlobClient, "/hbase1/test", false);
        this.validateAtomicRenameKey(abfsBlobClient, "/hbase/test", true);
        this.validateAtomicRenameKey(abfsBlobClient, "/a/b/c", true);
        this.validateAtomicRenameKey(abfsBlobClient, "/test/a", false);
    }

    @Test
    public void testGetPathStatusWithoutPendingJsonFile() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());){
            this.assumeBlobServiceType();
            Path path = new Path("/hbase/A1/A2");
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.create(new Path(path, "file1.txt"));
            fs.create(new Path(path, "file2.txt"));
            AbfsConfiguration conf = fs.getAbfsStore().getAbfsConfiguration();
            AtomicInteger redoRenameCall = new AtomicInteger(0);
            ((AbfsBlobClient)Mockito.doAnswer(answer -> {
                redoRenameCall.incrementAndGet();
                return answer.callRealMethod();
            }).when((Object)client)).getRedoRenameAtomicity((Path)Mockito.any(Path.class), Mockito.anyInt(), (TracingContext)Mockito.any(TracingContext.class));
            TracingContext tracingContext = new TracingContext(conf.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.GET_FILESTATUS, TracingHeaderFormat.ALL_ID_FORMAT, null);
            AbfsHttpOperation abfsHttpOperation = client.getPathStatus(path.toUri().getPath(), true, tracingContext, null).getResult();
            ((AbstractIntegerAssert)Assertions.assertThat((int)abfsHttpOperation.getStatusCode()).describedAs("Path should be found.", new Object[0])).isEqualTo(200);
            ((AbstractStringAssert)Assertions.assertThat((String)AzureBlobFileSystemStore.extractEtagHeader((AbfsHttpOperation)abfsHttpOperation)).describedAs("Etag should be present.", new Object[0])).isNotNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)redoRenameCall.get()).describedAs("There should be no redo rename call.", new Object[0])).isEqualTo(0);
        }
    }

    @Test
    public void testGetPathStatusWithPendingJsonDir() throws Exception {
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());){
            this.assumeBlobServiceType();
            Path path = new Path("/hbase/A1/A2");
            AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
            fs.create(new Path(path, "file1.txt"));
            fs.create(new Path(path, "file2.txt"));
            fs.mkdirs(new Path(path.getParent(), path.getName() + "-RenamePending.json"));
            AbfsConfiguration conf = fs.getAbfsStore().getAbfsConfiguration();
            AtomicInteger redoRenameCall = new AtomicInteger(0);
            ((AbfsBlobClient)Mockito.doAnswer(answer -> {
                redoRenameCall.incrementAndGet();
                return answer.callRealMethod();
            }).when((Object)client)).getRedoRenameAtomicity((Path)Mockito.any(Path.class), Mockito.anyInt(), (TracingContext)Mockito.any(TracingContext.class));
            TracingContext tracingContext = new TracingContext(conf.getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.GET_FILESTATUS, TracingHeaderFormat.ALL_ID_FORMAT, null);
            AbfsHttpOperation abfsHttpOperation = client.getPathStatus(path.toUri().getPath(), true, tracingContext, null).getResult();
            ((AbstractIntegerAssert)Assertions.assertThat((int)abfsHttpOperation.getStatusCode()).describedAs("Path should be found.", new Object[0])).isEqualTo(200);
            ((AbstractStringAssert)Assertions.assertThat((String)AzureBlobFileSystemStore.extractEtagHeader((AbfsHttpOperation)abfsHttpOperation)).describedAs("Etag should be present.", new Object[0])).isNotNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)redoRenameCall.get()).describedAs("There should be no redo rename call.", new Object[0])).isEqualTo(0);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(path.getParent(), path.getName() + "-RenamePending.json"))).describedAs("Directory with suffix -RenamePending.json should exist.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testRenamePathRetryIdempotency() throws Exception {
        Configuration configuration = new Configuration(this.getRawConfiguration());
        configuration.set("fs.azure.enable.client.transaction.id", "true");
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeRecoveryThroughClientTransactionID(false);
            AbfsDfsClient abfsClient = (AbfsDfsClient)Mockito.spy((Object)fs.getAbfsClient());
            fs.getAbfsStore().setClient((AbfsClient)abfsClient);
            Path sourceDir = this.path("/testSrc");
            ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)sourceDir);
            String filename = "file1";
            Path sourceFilePath = new Path(sourceDir, filename);
            this.touch(sourceFilePath);
            Path destFilePath = new Path(sourceDir, "file2");
            ArrayList<AbfsHttpHeader> headers = new ArrayList<AbfsHttpHeader>();
            this.mockRetriedRequest(abfsClient, headers, 0);
            AbfsRestOperation getPathRestOp = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
            AbfsHttpOperation op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
            ((AbfsHttpOperation)Mockito.doAnswer(answer -> {
                String requiredHeader = null;
                for (AbfsHttpHeader httpHeader : headers) {
                    if (!"x-ms-client-transaction-id".equalsIgnoreCase(httpHeader.getName())) continue;
                    requiredHeader = httpHeader.getValue();
                    break;
                }
                return requiredHeader;
            }).when((Object)op)).getResponseHeader("x-ms-client-transaction-id");
            ((AbfsRestOperation)Mockito.doReturn((Object)true).when((Object)getPathRestOp)).hasResult();
            ((AbfsRestOperation)Mockito.doReturn((Object)op).when((Object)getPathRestOp)).getResult();
            ((AbfsHttpOperation)Mockito.doReturn((Object)"directory").when((Object)op)).getResponseHeader("x-ms-resource-type");
            ((AbfsDfsClient)Mockito.doReturn((Object)getPathRestOp).when((Object)abfsClient)).getPathStatus((String)Mockito.nullable(String.class), ((Boolean)Mockito.nullable(Boolean.class)).booleanValue(), (TracingContext)Mockito.nullable(TracingContext.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(sourceFilePath, destFilePath)).describedAs("Rename should succeed.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testGetClientTransactionIdAfterRename() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeRecoveryThroughClientTransactionID(false);
            AbfsDfsClient abfsDfsClient = (AbfsDfsClient)Mockito.spy((Object)fs.getAbfsClient());
            fs.getAbfsStore().setClient((AbfsClient)abfsDfsClient);
            String[] clientTransactionId = new String[1];
            AbfsClientTestUtil.mockAddClientTransactionIdToHeader(abfsDfsClient, clientTransactionId);
            Path sourceDir = this.path("/testSrc");
            ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)sourceDir);
            String filename = "file1";
            Path sourceFilePath = new Path(sourceDir, filename);
            this.touch(sourceFilePath);
            Path destFilePath = new Path(sourceDir, "file2");
            fs.rename(sourceFilePath, destFilePath);
            AbfsHttpOperation getPathStatusOp = abfsDfsClient.getPathStatus(destFilePath.toUri().getPath(), false, this.getTestTracingContext(fs, true), null).getResult();
            ((AbstractStringAssert)Assertions.assertThat((String)getPathStatusOp.getResponseHeader("x-ms-client-transaction-id")).describedAs("Client transaction id should be present in dest file", new Object[0])).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)getPathStatusOp.getResponseHeader("x-ms-client-transaction-id")).describedAs("Client transaction ID should be equal to the one set in the header", new Object[0])).isEqualTo((Object)clientTransactionId[0]);
        }
    }

    @Test
    public void testFailureInGetPathStatusDuringRenameRecovery() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeRecoveryThroughClientTransactionID(false);
            AbfsDfsClient abfsDfsClient = (AbfsDfsClient)Mockito.spy((Object)fs.getAbfsClient());
            fs.getAbfsStore().setClient((AbfsClient)abfsDfsClient);
            String[] clientTransactionId = new String[1];
            AbfsClientTestUtil.mockAddClientTransactionIdToHeader(abfsDfsClient, clientTransactionId);
            this.mockRetriedRequest(abfsDfsClient, new ArrayList<AbfsHttpHeader>(), 1);
            int[] flag = new int[1];
            ((AbfsDfsClient)Mockito.doAnswer(getPathStatus -> {
                if (flag[0] == 1) {
                    flag[0] = flag[0] + 1;
                    throw new AbfsRestOperationException(408, "", "", new Exception());
                }
                flag[0] = flag[0] + 1;
                return getPathStatus.callRealMethod();
            }).when((Object)abfsDfsClient)).getPathStatus((String)Mockito.nullable(String.class), ((Boolean)Mockito.nullable(Boolean.class)).booleanValue(), (TracingContext)Mockito.nullable(TracingContext.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class));
            Path sourceDir = this.path("/testSrc");
            ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)sourceDir);
            String filename = "file1";
            Path sourceFilePath = new Path(sourceDir, filename);
            this.touch(sourceFilePath);
            Path destFilePath = new Path(sourceDir, "file2");
            String errorMessage = ((AbfsDriverException)LambdaTestUtils.intercept(AbfsDriverException.class, () -> fs.rename(sourceFilePath, destFilePath))).getErrorMessage();
            ((AbstractStringAssert)Assertions.assertThat((String)errorMessage).describedAs("getPathStatus should fail while recovering", new Object[0])).contains(new CharSequence[]{"Error while recovering from rename failure for path: "});
        }
    }

    @Test
    public void testRenameWithDestParentNotExist() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path src = new Path("/A1/A2");
            Path dst = new Path("/A3/A4");
            fs.create(new Path(src, "file.txt"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should fail as destination parent not exist.", new Object[0])).isFalse();
        }
    }

    @Test
    public void testRenameWithDestParentAsRoot() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path src = new Path("/A1/A2");
            Path dst = new Path("/A3");
            fs.create(new Path(src, "file.txt"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should succeed.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(dst, "file.txt"))).describedAs("File should exist in destination directory.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testFileRenameWithDestAsRoot() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path src = new Path("/A1/A2/file.txt");
            Path dst = new Path("/");
            fs.create(src);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should succeed.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(dst, "file.txt"))).describedAs("File should exist in root.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testDirRenameWithDestAsRoot() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            Path src = new Path("/A1/A2");
            Path dst = new Path("/");
            fs.create(new Path(src, "file.txt"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should succeed.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(dst, src.getName()))).describedAs("A2 directory should exist in root.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testRenameWithMultipleDirsInSource() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeBlobServiceType();
            fs.mkdirs(new Path("/testDir/dir1"));
            for (int i = 0; i < 10; ++i) {
                fs.create(new Path("/testDir/dir1/file" + i));
            }
            fs.mkdirs(new Path("/testDir/dir2"));
            fs.create(new Path("/testDir/dir2/file2"));
            this.createAzCopyFolder(new Path("/testDir/dir3"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path("/testDir"), new Path("/testDir2"))).describedAs("Rename should succeed.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir"))).describedAs("Old directory should not exist.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir2"))).describedAs("New directory should exist.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testRenameWithMultipleImplicitDirsInSource() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeBlobServiceType();
            this.createAzCopyFolder(new Path("/testDir/dir1"));
            for (int i = 0; i < 10; ++i) {
                this.createAzCopyFile(new Path("/testDir/dir1/file" + i));
            }
            this.createAzCopyFolder(new Path("/testDir/dir2"));
            this.createAzCopyFile(new Path("/testDir/dir2/file2"));
            this.createAzCopyFolder(new Path("/testDir/dir3"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path("/testDir"), new Path("/testDir2"))).describedAs("Rename should succeed.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir"))).describedAs("Old directory should not exist.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir2"))).describedAs("New directory should exist.", new Object[0])).isTrue();
        }
    }

    @Test
    public void testRenameWithExplicitDirInSource() throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystem();){
            this.assumeBlobServiceType();
            fs.create(new Path("/testDir/dir3/file2"));
            fs.create(new Path("/testDir/dir3/file1"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(new Path("/testDir"), new Path("/testDir2"))).describedAs("Rename should succeed.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir"))).describedAs("Old directory should not exist.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir2"))).describedAs("New directory should exist.", new Object[0])).isTrue();
        }
    }

    private AbfsClient addSpyHooksOnClient(AzureBlobFileSystem fs) {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        return client;
    }

    private void crashRenameAndRecover(AzureBlobFileSystem fs, AbfsBlobClient client, String srcPath, FunctionRaisingIOE<AzureBlobFileSystem, Void> recoveryCallable) throws Exception {
        this.crashRename(fs, client, srcPath);
        AzureBlobFileSystem fs2 = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        fs2.setWorkingDirectory(new Path("/"));
        client = (AbfsBlobClient)this.addSpyHooksOnClient(fs2);
        int[] renameJsonDeleteCounter = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            if (("/" + srcPath + "-RenamePending.json").equalsIgnoreCase(((Path)answer.getArgument(0)).toUri().getPath())) {
                renameJsonDeleteCounter[0] = 1;
            }
            return answer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        recoveryCallable.apply((Object)fs2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)renameJsonDeleteCounter[0]).describedAs("RenamePendingJson should be deleted", new Object[0])).isEqualTo(1);
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs2.exists(new Path("hbase/test1/test2")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs2.exists(new Path("hbase/test1/test2/test3")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs2.exists(new Path("hbase/test4/test2/test3")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs2.exists(new Path("hbase/test1/test2/test3/file")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs2.exists(new Path("hbase/test4/test2/test3/file")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs2.exists(new Path("hbase/test1/test2/test3/file1")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs2.exists(new Path("hbase/test4/test2/test3/file1")));
    }

    private void crashRename(AzureBlobFileSystem fs, AbfsBlobClient client, String srcPath) throws Exception {
        BlobRenameHandler[] blobRenameHandlers = new BlobRenameHandler[1];
        AbfsClientTestUtil.mockGetRenameBlobHandler(client, (FunctionRaisingIOE<BlobRenameHandler, Void>)((FunctionRaisingIOE)blobRenameHandler -> {
            blobRenameHandlers[0] = blobRenameHandler;
            return null;
        }));
        ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{new AbfsRestOperationException(403, "", "", new Exception())}).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        LambdaTestUtils.intercept(AccessDeniedException.class, () -> fs.rename(new Path(srcPath), new Path("hbase/test4")));
        ArrayList leases = new ArrayList(blobRenameHandlers[0].getLeases());
        for (AbfsLease lease : leases) {
            lease.free();
        }
    }

    private void setupAndTestHBaseFailedRenameRecovery(AzureBlobFileSystem fs, AbfsBlobClient client, String srcPath, String failedCopyPath, FunctionRaisingIOE<AzureBlobFileSystem, Void> recoveryAction) throws Exception {
        fs.setWorkingDirectory(new Path("/"));
        fs.mkdirs(new Path(srcPath));
        fs.mkdirs(new Path(srcPath, "test3"));
        fs.create(new Path(srcPath + "/test3/file"));
        fs.create(new Path(failedCopyPath));
        fs.mkdirs(new Path("hbase/test4/"));
        fs.create(new Path("hbase/test4/file1"));
        this.crashRenameAndRecover(fs, client, srcPath, recoveryAction);
    }

    private void testRenamePreRenameFailureResolution(AzureBlobFileSystem fs) throws Exception {
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        Path src = new Path("hbase/test1/test2");
        Path dest = new Path("hbase/test4");
        fs.mkdirs(src);
        fs.mkdirs(new Path(src, "test3"));
        int[] renamePendingJsonWriteCounter = new int[1];
        Answer renamePendingJsonCreateAns = createAnswer -> {
            Path path = (Path)createAnswer.getArgument(0);
            ((AbfsBlobClient)Mockito.doAnswer(clientFlushAns -> {
                int n = renamePendingJsonWriteCounter[0];
                renamePendingJsonWriteCounter[0] = n + 1;
                if (n == 0) {
                    fs.delete(path, true);
                }
                return clientFlushAns.callRealMethod();
            }).when((Object)client)).flush((byte[])Mockito.any(byte[].class), Mockito.anyString(), Mockito.anyBoolean(), (String)Mockito.nullable(String.class), (String)Mockito.nullable(String.class), Mockito.anyString(), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), (TracingContext)Mockito.any(TracingContext.class));
            return createAnswer.callRealMethod();
        };
        RenameAtomicityTestUtils.addCreatePathMock(client, renamePendingJsonCreateAns);
        fs.rename(src, dest);
        ((AbstractIntegerAssert)Assertions.assertThat((int)renamePendingJsonWriteCounter[0]).describedAs("Creation of RenamePendingJson should be attempted twice", new Object[0])).isEqualTo(2);
    }

    private void testAtomicityRedoInvalidFile(AzureBlobFileSystem fs) throws Exception {
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        Path path = new Path("/hbase/test1/test2");
        fs.mkdirs(new Path(path, "test3"));
        Path renameJson = new Path(path.getParent(), path.getName() + "-RenamePending.json");
        FSDataOutputStream os = fs.create(renameJson);
        os.write("{".getBytes(StandardCharsets.UTF_8));
        os.close();
        int[] renameJsonDeleteCounter = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(deleteAnswer -> {
            Path ansPath = (Path)deleteAnswer.getArgument(0);
            if (renameJson.toUri().getPath().equalsIgnoreCase(ansPath.toUri().getPath())) {
                renameJsonDeleteCounter[0] = renameJsonDeleteCounter[0] + 1;
            }
            return deleteAnswer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        new RenameAtomicity(renameJson, 1, this.getTestTracingContext(fs, true), null, (AbfsClient)client).redo();
        ((AbstractIntegerAssert)Assertions.assertThat((int)renameJsonDeleteCounter[0]).describedAs("RenamePendingJson should be deleted", new Object[0])).isEqualTo(1);
        ((AbfsBlobClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)0))).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
    }

    private void addMockForProgressStatusOnCopyOperation(AbfsBlobClient spiedClient) throws AzureBlobFileSystemException {
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)((AbfsRestOperation)answer.callRealMethod()));
            AbfsHttpOperation httpOp = (AbfsHttpOperation)Mockito.spy((Object)op.getResult());
            ((AbfsHttpOperation)Mockito.doReturn((Object)"pending").when((Object)httpOp)).getResponseHeader("x-ms-copy-status");
            ((AbfsRestOperation)Mockito.doReturn((Object)httpOp).when((Object)op)).getResult();
            return op;
        }).when((Object)spiedClient)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
    }

    private void addMockForCopyOperationFinalStatus(AbfsBlobClient spiedClient, String requiredCopyFinalStatus) {
        AbfsClientTestUtil.mockGetRenameBlobHandler(spiedClient, (FunctionRaisingIOE<BlobRenameHandler, Void>)((FunctionRaisingIOE)blobRenameHandler -> {
            ((BlobRenameHandler)Mockito.doAnswer(onHandleCopyInProgress -> {
                Path handlePath = (Path)onHandleCopyInProgress.getArgument(0);
                TracingContext tracingContext = (TracingContext)onHandleCopyInProgress.getArgument(1);
                ((AbfsBlobClient)Mockito.doAnswer(onStatusCheck -> {
                    AbfsRestOperation op = (AbfsRestOperation)Mockito.spy((Object)((AbfsRestOperation)onStatusCheck.callRealMethod()));
                    AbfsHttpOperation httpOp = (AbfsHttpOperation)Mockito.spy((Object)op.getResult());
                    ((AbfsHttpOperation)Mockito.doReturn((Object)requiredCopyFinalStatus).when((Object)httpOp)).getResponseHeader("x-ms-copy-status");
                    ((AbfsRestOperation)Mockito.doReturn((Object)httpOp).when((Object)op)).getResult();
                    return op;
                }).when((Object)spiedClient)).getPathStatus(handlePath.toUri().getPath(), tracingContext, null, false);
                return onHandleCopyInProgress.callRealMethod();
            }).when(blobRenameHandler)).handleCopyInProgress((Path)Mockito.any(Path.class), (TracingContext)Mockito.any(TracingContext.class), (String)Mockito.any(String.class));
            return null;
        }));
    }

    private void renameDir(AzureBlobFileSystem currentFs, String producerQueueSize, String consumerMaxLag, String maxThread, Path src, Path dst) throws Exception {
        Configuration config = new Configuration(this.getRawConfiguration());
        config.set("fs.azure.blob.dir.list.producer.queue.max.size", producerQueueSize);
        config.set("fs.azure.blob.dir.list.consumer.max.lag", consumerMaxLag);
        config.set("fs.azure.blob.dir.rename.max.thread", maxThread);
        try (AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((URI)currentFs.getUri(), (Configuration)config);){
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should succeed.", new Object[0])).isTrue();
        }
    }

    private void performRenameAndValidate(AzureBlobFileSystem fs, Path src, Path dst, String fileName) throws IOException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(src)).describedAs("Old directory should exist before rename", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.rename(src, dst)).describedAs("Rename should succeed.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(dst, fileName))).describedAs("Rename should be successful", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(src)).describedAs("Old directory should not exist", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(dst)).describedAs("New directory should exist", new Object[0])).isTrue();
    }

    private void validateAtomicRenameKey(AbfsBlobClient abfsBlobClient, String path, boolean expected) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)abfsBlobClient.isAtomicRenameKey(path)).describedAs("Atomic rename key check for path: " + path, new Object[0])).isEqualTo(expected);
    }

    private void mockRetriedRequest(AbfsDfsClient abfsDfsClient, final List<AbfsHttpHeader> headers, int failedCall) throws Exception {
        TestAbfsClient.mockAbfsOperationCreation((AbfsClient)abfsDfsClient, new MockIntercept<AbfsRestOperation>(){
            private int count = 0;

            @Override
            public void answer(AbfsRestOperation mockedObj, InvocationOnMock answer) throws AbfsRestOperationException {
                if (this.count == 0) {
                    this.count = 1;
                    AbfsHttpOperation op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
                    ((AbfsHttpOperation)Mockito.doReturn((Object)"PUT").when((Object)op)).getMethod();
                    ((AbfsHttpOperation)Mockito.doReturn((Object)"").when((Object)op)).getStorageErrorMessage();
                    ((AbfsHttpOperation)Mockito.doReturn((Object)AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND.getErrorCode()).when((Object)op)).getStorageErrorCode();
                    ((AbfsRestOperation)Mockito.doReturn((Object)true).when((Object)mockedObj)).hasResult();
                    ((AbfsRestOperation)Mockito.doReturn((Object)op).when((Object)mockedObj)).getResult();
                    ((AbfsHttpOperation)Mockito.doReturn((Object)404).when((Object)op)).getStatusCode();
                    headers.addAll(mockedObj.getRequestHeaders());
                    throw new AbfsRestOperationException(404, AzureServiceErrorCode.SOURCE_PATH_NOT_FOUND.getErrorCode(), "", null, op);
                }
            }
        }, failedCall);
    }
}

