/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.AbfsServiceType;
import org.apache.hadoop.fs.azurebfs.utils.Parallelized;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parallelized.class)
public class ITestAzureBlobFileSystemPermission
extends AbstractAbfsIntegrationTest {
    private static Path testRoot = new Path("/test");
    private static final String DEFAULT_UMASK_VALUE = "027";
    private static final FsPermission DEFAULT_UMASK_PERMISSION = new FsPermission("027");
    private static final int KILOBYTE = 1024;
    private FsPermission permission;
    private Path path;

    public ITestAzureBlobFileSystemPermission(FsPermission testPermission) throws Exception {
        this.permission = testPermission;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection abfsCreateNonRecursiveTestData() throws Exception {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        for (FsAction g : FsAction.values()) {
            for (FsAction o : FsAction.values()) {
                datas.add(new Object[]{new FsPermission(FsAction.ALL, g, o)});
            }
        }
        return datas;
    }

    @Test
    public void testFilePermission() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(fs));
        Assume.assumeTrue((this.getIngressServiceType() == AbfsServiceType.DFS ? 1 : 0) != 0);
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.mkdirs(this.path.getParent(), new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        fs.removeDefaultAcl(this.path.getParent());
        fs.create(this.path, this.permission, true, 1024, (short)1, 1023L, null).close();
        FileStatus status = fs.getFileStatus(this.path);
        Assert.assertEquals((Object)this.permission.applyUMask(DEFAULT_UMASK_PERMISSION), (Object)status.getPermission());
    }

    @Test
    public void testFolderPermission() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)this.getIsNamespaceEnabled(fs));
        Assume.assumeTrue((this.getIngressServiceType() == AbfsServiceType.DFS ? 1 : 0) != 0);
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.mkdirs(this.path.getParent(), new FsPermission(FsAction.ALL, FsAction.WRITE, FsAction.NONE));
        fs.removeDefaultAcl(this.path.getParent());
        fs.mkdirs(this.path, this.permission);
        FileStatus status = fs.getFileStatus(this.path);
        Assert.assertEquals((Object)this.permission.applyUMask(DEFAULT_UMASK_PERMISSION), (Object)status.getPermission());
    }
}

