/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.TestAbfsConfigurationFieldsValidation;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.StorageErrorResponseSchema;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientTestUtil;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.BlobDeleteHandler;
import org.apache.hadoop.fs.azurebfs.services.ITestAbfsClient;
import org.apache.hadoop.fs.azurebfs.services.TestAbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.TracingHeaderValidator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.ReflectionUtils;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestAzureBlobFileSystemDelete
extends AbstractAbfsIntegrationTest {
    private static final int REDUCED_RETRY_COUNT = 1;
    private static final int REDUCED_MAX_BACKOFF_INTERVALS_MS = 5000;
    private static final int MAX_ITERATIONS = 20;
    private static final int BLOB_COUNT = 11;

    @Test
    public void testDeleteRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testPath = this.path("/testFolder");
        fs.mkdirs(new Path(testPath + "_0"));
        fs.mkdirs(new Path(testPath + "_1"));
        fs.mkdirs(new Path(testPath + "_2"));
        this.touch(new Path(testPath + "_1/testfile"));
        this.touch(new Path(testPath + "_1/testfile2"));
        this.touch(new Path(testPath + "_1/testfile3"));
        Path root = new Path("/");
        FileStatus[] ls = fs.listStatus(root);
        ITestAzureBlobFileSystemDelete.assertEquals((long)3L, (long)ls.length);
        fs.delete(root, true);
        ls = fs.listStatus(root);
        ITestAzureBlobFileSystemDelete.assertEquals((String)"listing size", (long)0L, (long)ls.length);
    }

    @Test
    public void testOpenFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testfile = this.path("/testFile");
        this.touch(testfile);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)testfile, (boolean)false);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.open(testfile));
    }

    @Test
    public void testEnsureFileIsDeleted() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testfile = this.path("testfile");
        this.touch(testfile);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)testfile, (boolean)false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)testfile);
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dir = this.path("testfile");
        fs.mkdirs(dir);
        fs.mkdirs(new Path(dir + "/test1"));
        fs.mkdirs(new Path(dir + "/test1/test2"));
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)dir, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)dir);
    }

    @Test
    public void testDeleteFirstLevelDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        Path dir = this.path("/test");
        for (int i = 0; i < 1000; ++i) {
            final Path path = new Path(dir + "/" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemDelete.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        fs.registerListener((Listener)new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.DELETE, false, 0));
        LambdaTestUtils.intercept(IOException.class, () -> fs.delete(dir, false));
        fs.registerListener(null);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)dir, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)dir);
    }

    @Test
    public void testDeleteIdempotency() throws Exception {
        Assume.assumeTrue((boolean)true);
        AbfsConfiguration abfsConfig = TestAbfsConfigurationFieldsValidation.updateRetryConfigs(this.getConfiguration(), 1, 5000);
        AzureBlobFileSystem fs = this.getFileSystem();
        AbfsClient abfsClient = fs.getAbfsStore().getClient();
        AbfsClient testClient = ITestAbfsClient.createTestClientFromCurrentContext(abfsClient, abfsConfig);
        AbfsRestOperation op = (AbfsRestOperation)Mockito.mock(AbfsRestOperation.class);
        Mockito.when((Object)op.isARetriedRequest()).thenReturn((Object)true);
        AbfsHttpOperation http504Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http504Op.getStatusCode()).thenReturn((Object)504);
        Mockito.when((Object)op.getResult()).thenReturn((Object)http504Op);
        Mockito.when((Object)op.hasResult()).thenReturn((Object)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testClient.deleteIdempotencyCheckOp(op).getResult().getStatusCode()).describedAs("Idempotency check to happen only for HTTP 404 response.", new Object[0])).isEqualTo(504);
        AbfsHttpOperation http404Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http404Op.getStatusCode()).thenReturn((Object)404);
        Mockito.when((Object)op.getResult()).thenReturn((Object)http404Op);
        Mockito.when((Object)op.hasResult()).thenReturn((Object)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testClient.deleteIdempotencyCheckOp(op).getResult().getStatusCode()).describedAs("Delete is considered idempotent by default and should return success.", new Object[0])).isEqualTo(200);
        AbfsHttpOperation http400Op = (AbfsHttpOperation)Mockito.mock(AbfsHttpOperation.class);
        Mockito.when((Object)http400Op.getStatusCode()).thenReturn((Object)400);
        Mockito.when((Object)op.getResult()).thenReturn((Object)http400Op);
        Mockito.when((Object)op.hasResult()).thenReturn((Object)true);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testClient.deleteIdempotencyCheckOp(op).getResult().getStatusCode()).describedAs("Idempotency check to happen only for HTTP 404 response.", new Object[0])).isEqualTo(400);
    }

    @Test
    public void testDeleteIdempotencyTriggerHttp404() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeDfsServiceType();
        AbfsClient client = ITestAbfsClient.createTestClientFromCurrentContext(fs.getAbfsStore().getClient(), this.getConfiguration());
        LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> fs.getAbfsStore().delete(new Path("/NonExistingPath"), false, this.getTestTracingContext(fs, false)));
        LambdaTestUtils.intercept(AbfsRestOperationException.class, () -> client.deletePath("/NonExistingPath", false, null, this.getTestTracingContext(fs, true)));
        AbfsClient mockClient = ITestAbfsClient.getMockAbfsClient(fs.getAbfsStore().getClient(), this.getConfiguration());
        AzureBlobFileSystemStore mockStore = (AzureBlobFileSystemStore)Mockito.mock(AzureBlobFileSystemStore.class);
        ReflectionUtils.setFinalField(AzureBlobFileSystemStore.class, (Object)mockStore, (String)"client", (Object)mockClient);
        ReflectionUtils.setFinalField(AzureBlobFileSystemStore.class, (Object)mockStore, (String)"abfsPerfTracker", (Object)TestAbfsPerfTracker.getAPerfTrackerInstance(this.getConfiguration()));
        ((AzureBlobFileSystemStore)Mockito.doCallRealMethod().when((Object)mockStore)).delete(new Path("/NonExistingPath"), false, this.getTestTracingContext(fs, false));
        StorageErrorResponseSchema storageErrorResponse = new StorageErrorResponseSchema("NotFound", "NotFound", "NotFound");
        ((AbfsClient)Mockito.doReturn((Object)storageErrorResponse).when((Object)mockClient)).processStorageErrorResponse((InputStream)ArgumentMatchers.any());
        AbfsRestOperation idempotencyRetOp = (AbfsRestOperation)Mockito.spy((Object)ITestAbfsClient.getRestOp(AbfsRestOperationType.DeletePath, mockClient, "DELETE", ITestAbfsClient.getTestUrl(mockClient, "/NonExistingPath"), ITestAbfsClient.getTestRequestHeaders(mockClient), this.getConfiguration()));
        idempotencyRetOp.hardSetResult(200);
        ((AbfsClient)Mockito.doReturn((Object)idempotencyRetOp).when((Object)mockClient)).deleteIdempotencyCheckOp((AbfsRestOperation)ArgumentMatchers.any());
        TracingContext tracingContext = this.getTestTracingContext(fs, false);
        ((AbfsRestOperation)Mockito.doReturn((Object)tracingContext).when((Object)idempotencyRetOp)).createNewTracingContext((TracingContext)ArgumentMatchers.any());
        if (mockClient instanceof AbfsBlobClient) {
            ((AbfsBlobClient)Mockito.doCallRealMethod().when((Object)((AbfsBlobClient)mockClient))).getBlobDeleteHandler((String)Mockito.nullable(String.class), Mockito.anyBoolean(), (TracingContext)Mockito.nullable(TracingContext.class));
            ((AbfsClient)Mockito.doCallRealMethod().when((Object)mockClient)).listPath((String)Mockito.nullable(String.class), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.nullable(TracingContext.class), (URI)Mockito.nullable(URI.class));
            ((AbfsBlobClient)Mockito.doCallRealMethod().when((Object)((AbfsBlobClient)mockClient))).listPath((String)Mockito.nullable(String.class), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.nullable(TracingContext.class), (URI)Mockito.nullable(URI.class));
            ((AbfsBlobClient)Mockito.doCallRealMethod().when((Object)((AbfsBlobClient)mockClient))).getPathStatus((String)Mockito.nullable(String.class), (TracingContext)Mockito.nullable(TracingContext.class), (ContextEncryptionAdapter)Mockito.nullable(ContextEncryptionAdapter.class), Mockito.anyBoolean());
        }
        Mockito.when((Object)mockClient.deletePath("/NonExistingPath", false, null, tracingContext)).thenCallRealMethod();
        ((AbstractIntegerAssert)Assertions.assertThat((int)mockClient.deletePath("/NonExistingPath", false, null, tracingContext).getResult().getStatusCode()).describedAs("Idempotency check reports successful delete. 200OK should be returned", new Object[0])).isEqualTo(idempotencyRetOp.getResult().getStatusCode());
        mockStore.delete(new Path("/NonExistingPath"), false, this.getTestTracingContext(fs, false));
    }

    @Test
    public void deleteBlobDirParallelThreadToDeleteOnDifferentTracingContext() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.newInstance((Configuration)configuration)));
        AzureBlobFileSystemStore spiedStore = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        AbfsClient spiedClient = (AbfsClient)Mockito.spy((Object)fs.getAbfsClient());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)spiedStore).when((Object)fs)).getAbfsStore();
        spiedStore.setClient(spiedClient);
        fs.mkdirs(new Path("/testDir"));
        fs.create(new Path("/testDir/file1"));
        fs.create(new Path("/testDir/file2"));
        AbfsClientTestUtil.hookOnRestOpsForTracingContextSingularity(spiedClient);
        fs.delete(new Path("/testDir"), true);
        fs.close();
    }

    @Test
    public void testDeleteFileInImplicitDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        Path file1 = new Path("/testDir/dir1/file1");
        Path file2 = new Path("/testDir/dir1/file2");
        Path implicitDir = file1.getParent();
        this.createAzCopyFile(file1);
        this.createAzCopyFile(file2);
        fs.delete(file1, false);
        fs.delete(file2, true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(implicitDir)).describedAs("The directory should exist.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(file1)).describedAs("Deleted file should not be present.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(file2)).describedAs("Deleted file should not be present.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(implicitDir)).describedAs("The parent dir should exist.", new Object[0])).isTrue();
    }

    @Test
    public void testDeleteEmptyExplicitDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path p1 = new Path("/testDir1/");
        fs.mkdirs(p1);
        fs.delete(p1, false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(p1)).describedAs("The deleted directory should not exist.", new Object[0])).isFalse();
    }

    @Test
    public void testDeleteNonEmptyExplicitDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path p1 = new Path("/testDir1");
        Path p2 = new Path("/testDir2");
        fs.mkdirs(p1);
        fs.mkdirs(p2);
        fs.create(new Path("/testDir1/f1.txt"));
        fs.create(new Path("/testDir2/f2.txt"));
        fs.delete(p1, true);
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.delete(p2, false));
        ((AbstractBooleanAssert)Assertions.assertThat((!fs.exists(p1) ? 1 : 0) != 0).describedAs("FileStatus of the deleted directory should not exist.", new Object[0])).isTrue();
    }

    @Test
    public void testDeleteNonExistingPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path p = new Path("/nonExistingPath");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.delete(p, true)).describedAs("Delete operation on non-existing path should return false", new Object[0])).isFalse();
    }

    @Test
    public void testExceptionForDeletedFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = this.path("/testFile");
        fs.create(testFile);
        fs.delete(testFile, false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.delete(testFile, true)).describedAs("Delete operation on deleted path should return false.", new Object[0])).isFalse();
    }

    @Test
    public void testDeleteImplicitDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        fs.mkdirs(new Path("/testDir/dir1"));
        fs.create(new Path("/testDir/dir1/file1"));
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        client.deleteBlobPath(new Path("/testDir/dir1"), null, this.getTestTracingContext(fs, true));
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.delete(new Path("/testDir/dir1"), false));
        fs.delete(new Path("/testDir/dir1"), true);
        ((AbstractBooleanAssert)Assertions.assertThat((!fs.exists(new Path("/testDir/dir1")) ? 1 : 0) != 0).describedAs("FileStatus of the deleted directory should not exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((!fs.exists(new Path("/testDir/dir1/file1")) ? 1 : 0) != 0).describedAs("Child of a deleted directory should not be present", new Object[0])).isTrue();
    }

    @Test
    public void testDeleteImplicitDirWithSingleListResults() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        AbfsBlobClient spiedClient = (AbfsBlobClient)Mockito.spy((Object)client);
        fs.getAbfsStore().setClient((AbfsClient)spiedClient);
        fs.mkdirs(new Path("/testDir/dir1"));
        for (int i = 0; i < 10; ++i) {
            fs.create(new Path("/testDir/dir1/file" + i));
        }
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            String path = (String)answer.getArgument(0);
            boolean recursive = (Boolean)answer.getArgument(1);
            String continuation = (String)answer.getArgument(3);
            TracingContext context = (TracingContext)answer.getArgument(4);
            return client.listPath(path, recursive, 1, continuation, context, null);
        }).when((Object)spiedClient)).listPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class), (URI)Mockito.nullable(URI.class));
        client.deleteBlobPath(new Path("/testDir/dir1"), null, this.getTestTracingContext(fs, true));
        fs.delete(new Path("/testDir/dir1"), true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir1"))).describedAs("FileStatus of the deleted directory should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDeleteExplicitDirInImplicitParentDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        fs.mkdirs(new Path("/testDir/dir1"));
        fs.create(new Path("/testDir/dir1/file1"));
        client.deleteBlobPath(new Path("/testDir/"), null, this.getTestTracingContext(fs, true));
        fs.delete(new Path("/testDir/dir1"), true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir1"))).describedAs("Deleted directory should not exist", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir/dir1/file1"))).describedAs("Child of a deleted directory should not be present", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path("/testDir"))).describedAs("Parent Implicit directory should exist", new Object[0])).isTrue();
    }

    @Test
    public void testDeleteParallelBlobFailure() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)Mockito.spy((Object)((AbfsBlobClient)fs.getAbfsClient()));
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        store.setClient((AbfsClient)client);
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        fs.mkdirs(new Path("/testDir"));
        fs.create(new Path("/testDir/file1"));
        fs.create(new Path("/testDir/file2"));
        fs.create(new Path("/testDir/file3"));
        ((AbfsBlobClient)Mockito.doThrow((Throwable[])new Throwable[]{new AbfsRestOperationException(403, "", "", new Exception())}).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        LambdaTestUtils.intercept(AccessDeniedException.class, () -> fs.delete(new Path("/testDir"), true));
    }

    @Test
    public void testDeleteRootWithNonRecursion() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("/testDir"));
        Assertions.assertThat((boolean)fs.delete(new Path("/"), false)).isFalse();
    }

    @Test
    public void testProducerStopOnDeleteFailure() throws Exception {
        this.assumeBlobServiceType();
        Configuration configuration = (Configuration)Mockito.spy((Object)this.getRawConfiguration());
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)((AzureBlobFileSystem)FileSystem.get((Configuration)configuration)));
        fs.mkdirs(new Path("/src"));
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList futureList = new ArrayList();
        int i = 0;
        while (i < 20) {
            int n = i++;
            Future<?> future = executorService.submit(() -> {
                try {
                    fs.create(new Path("/src/file" + iter));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            futureList.add(future);
        }
        for (Future future : futureList) {
            future.get();
        }
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        AbfsBlobClient abfsBlobClient = (AbfsBlobClient)Mockito.spy((Object)client);
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        store.setClient((AbfsClient)abfsBlobClient);
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        int[] deleteCallInvocation = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            throw new AbfsRestOperationException(403, "", "", new Exception());
        }).when((Object)abfsBlobClient)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
        AbfsClientTestUtil.mockGetDeleteBlobHandler(abfsBlobClient, (FunctionRaisingIOE<BlobDeleteHandler, Void>)((FunctionRaisingIOE)blobDeleteHandler -> {
            ((BlobDeleteHandler)Mockito.doAnswer(answer -> {
                try {
                    answer.callRealMethod();
                }
                catch (AbfsRestOperationException ex) {
                    if (ex.getStatusCode() == 403) {
                        deleteCallInvocation[0] = deleteCallInvocation[0] + 1;
                    }
                    throw ex;
                }
                throw new AssertionError((Object)"List Consumption should have failed");
            }).when(blobDeleteHandler)).listRecursiveAndTakeAction();
            return null;
        }));
        int[] listCallInvocation = new int[1];
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            if (listCallInvocation[0] == 1) {
                while (deleteCallInvocation[0] == 0) {
                }
            }
            listCallInvocation[0] = listCallInvocation[0] + 1;
            return answer.callRealMethod();
        }).when((Object)abfsBlobClient)).listPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class), (URI)Mockito.nullable(URI.class));
        LambdaTestUtils.intercept(AccessDeniedException.class, () -> fs.delete(new Path("/src"), true));
        ((AbfsBlobClient)Mockito.verify((Object)abfsBlobClient, (VerificationMode)Mockito.times((int)1))).listPath(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyInt(), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class), (URI)Mockito.nullable(URI.class));
    }

    @Test
    public void testDeleteEmitDeletionCountInClientRequestId() throws Exception {
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)fs.getAbfsClient();
        AbfsBlobClient spiedClient = (AbfsBlobClient)Mockito.spy((Object)client);
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        store.setClient((AbfsClient)spiedClient);
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        String dirPathStr = "/testDir/dir1";
        fs.mkdirs(new Path(dirPathStr));
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        ArrayList<Future<FSDataOutputStream>> futures = new ArrayList<Future<FSDataOutputStream>>();
        int i = 0;
        while (i < 10) {
            int n = i++;
            Future<FSDataOutputStream> future = executorService.submit(() -> fs.create(new Path("/testDir/dir1/file" + iter)));
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        TracingHeaderValidator tracingHeaderValidator = new TracingHeaderValidator(fs.getAbfsStore().getAbfsConfiguration().getClientCorrelationId(), fs.getFileSystemId(), FSOperationType.DELETE, false, 0);
        fs.registerListener((Listener)tracingHeaderValidator);
        ((AzureBlobFileSystemStore)Mockito.doAnswer(answer -> {
            ((AbfsBlobClient)Mockito.doAnswer(deleteAnswer -> {
                if (dirPathStr.equalsIgnoreCase(((Path)deleteAnswer.getArgument(0)).toUri().getPath())) {
                    tracingHeaderValidator.setOperatedBlobCount(11);
                    Object result = deleteAnswer.callRealMethod();
                    tracingHeaderValidator.setOperatedBlobCount(null);
                    return result;
                }
                return deleteAnswer.callRealMethod();
            }).when((Object)spiedClient)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.nullable(String.class), (TracingContext)Mockito.any(TracingContext.class));
            return answer.callRealMethod();
        }).when((Object)store)).delete((Path)Mockito.any(Path.class), Mockito.anyBoolean(), (TracingContext)Mockito.any(TracingContext.class));
        fs.delete(new Path(dirPathStr), true);
    }
}

