/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.extensions.MockDelegationSASTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAzureBlobFileSystemDelegationSAS
extends AbstractAbfsIntegrationTest {
    private static final String TEST_GROUP = UUID.randomUUID().toString();
    private static final Logger LOG = LoggerFactory.getLogger(ITestAzureBlobFileSystemDelegationSAS.class);
    private boolean isHNSEnabled;

    public ITestAzureBlobFileSystemDelegationSAS() throws Exception {
        String sasProvider = this.getRawConfiguration().get("fs.azure.sas.token.provider.type");
        Assume.assumeTrue((boolean)MockDelegationSASTokenProvider.class.getCanonicalName().equals(sasProvider));
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.id")});
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.secret")});
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.service.principal.tenant.id")});
        Assume.assumeNotNull((Object[])new Object[]{this.getRawConfiguration().get("fs.azure.test.app.service.principal.object.id")});
        Assume.assumeTrue((this.getAuthType() == AuthType.SharedKey ? 1 : 0) != 0);
    }

    @Override
    public void setup() throws Exception {
        this.isHNSEnabled = this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false);
        if (!this.isHNSEnabled) {
            this.assumeBlobServiceType();
        }
        this.createFilesystemForSASTests();
        super.setup();
    }

    @Test
    public void testCheckAccess() throws Exception {
        this.assumeHnsEnabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path rootPath = new Path("/");
        fs.setOwner(rootPath, "325f1619-4205-432f-9fce-3fd594325ce5", null);
        fs.setPermission(rootPath, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE));
        FileStatus rootStatus = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory permissions are not expected.", (Object)"rwxr-x--x", (Object)rootStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)rootStatus.getOwner());
        Path dirPath = new Path(UUID.randomUUID().toString());
        fs.mkdirs(dirPath);
        Path filePath = new Path(dirPath, "file1");
        fs.create(filePath).close();
        fs.setPermission(filePath, new FsPermission(FsAction.READ, FsAction.READ, FsAction.NONE));
        FileStatus dirStatus = fs.getFileStatus(dirPath);
        FileStatus fileStatus = fs.getFileStatus(filePath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)dirStatus.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)fileStatus.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory permissions are not expected.", (Object)"rwxr-xr-x", (Object)dirStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"r--r-----", (Object)fileStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)this.isAccessible((FileSystem)fs, dirPath, FsAction.READ_WRITE));
        ITestAzureBlobFileSystemDelegationSAS.assertFalse((boolean)this.isAccessible((FileSystem)fs, filePath, FsAction.READ_WRITE));
        fs.setPermission(filePath, new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE));
        fileStatus = fs.getFileStatus(filePath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"rw-r-----", (Object)fileStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)this.isAccessible((FileSystem)fs, filePath, FsAction.READ_WRITE));
        fs.setPermission(dirPath, new FsPermission(FsAction.EXECUTE, FsAction.NONE, FsAction.NONE));
        dirStatus = fs.getFileStatus(dirPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"--x------", (Object)dirStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertFalse((boolean)this.isAccessible((FileSystem)fs, dirPath, FsAction.READ_WRITE));
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)this.isAccessible((FileSystem)fs, dirPath, FsAction.EXECUTE));
        fs.setPermission(dirPath, new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE));
        dirStatus = fs.getFileStatus(dirPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The file permissions are not expected.", (Object)"---------", (Object)dirStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertFalse((boolean)this.isAccessible((FileSystem)fs, filePath, FsAction.READ_WRITE));
    }

    private boolean isAccessible(FileSystem fs, Path path, FsAction fsAction) throws IOException {
        try {
            fs.access(path, fsAction);
        }
        catch (AccessControlException ace) {
            return false;
        }
        return true;
    }

    @Test
    public void testReadAndWrite() throws Exception {
        String fileContent;
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path(UUID.randomUUID().toString());
        String msg1 = "purple";
        String msg2 = "yellow";
        int expectedFileLength = "purple".length() * 2;
        byte[] readBuffer = new byte[1024];
        try (FSDataOutputStream stream = fs.create(reqPath);){
            stream.writeBytes("purple");
            stream.hflush();
            stream.writeBytes("purple");
        }
        stream = fs.open(reqPath);
        var8_8 = null;
        try {
            int bytesRead = stream.read(readBuffer, 0, readBuffer.length);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)expectedFileLength, (long)bytesRead);
            fileContent = new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"purplepurple", (Object)fileContent);
        }
        catch (Throwable bytesRead) {
            var8_8 = bytesRead;
            throw bytesRead;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable bytesRead) {
                        var8_8.addSuppressed(bytesRead);
                    }
                } else {
                    stream.close();
                }
            }
        }
        stream = fs.create(reqPath);
        var8_8 = null;
        try {
            stream.writeBytes("yellow");
            stream.hflush();
            stream.writeBytes("yellow");
        }
        catch (Throwable bytesRead) {
            var8_8 = bytesRead;
            throw bytesRead;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable bytesRead) {
                        var8_8.addSuppressed(bytesRead);
                    }
                } else {
                    stream.close();
                }
            }
        }
        stream = fs.open(reqPath);
        var8_8 = null;
        try {
            int bytesRead = stream.read(readBuffer, 0, readBuffer.length);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)expectedFileLength, (long)bytesRead);
            fileContent = new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"yellowyellow", (Object)fileContent);
        }
        catch (Throwable bytesRead) {
            var8_8 = bytesRead;
            throw bytesRead;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable bytesRead) {
                        var8_8.addSuppressed(bytesRead);
                    }
                } else {
                    stream.close();
                }
            }
        }
        stream = fs.append(reqPath);
        var8_8 = null;
        try {
            stream.writeBytes("purple");
            stream.hflush();
            stream.writeBytes("purple");
        }
        catch (Throwable bytesRead) {
            var8_8 = bytesRead;
            throw bytesRead;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable bytesRead) {
                        var8_8.addSuppressed(bytesRead);
                    }
                } else {
                    stream.close();
                }
            }
        }
        stream = fs.open(reqPath);
        var8_8 = null;
        try {
            int bytesRead = stream.read(readBuffer, 0, readBuffer.length);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)(2 * expectedFileLength), (long)bytesRead);
            fileContent = new String(readBuffer, 0, bytesRead, StandardCharsets.UTF_8);
            ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"yellowyellowpurplepurple", (Object)fileContent);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    public void checkExceptionForRenameOverwrites() throws Exception {
        this.assumeHnsEnabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path src = new Path("a/b/f1.txt");
        Path dest = new Path("a/b/f2.txt");
        this.touch(src);
        this.touch(dest);
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, (String)"File already exists.", () -> fs.rename(src, dest));
    }

    @Test
    public void testRename() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourceDir = new Path(UUID.randomUUID().toString());
        Path sourcePath = new Path(sourceDir, UUID.randomUUID().toString());
        Path destinationPath = new Path(sourceDir, UUID.randomUUID().toString());
        Path destinationDir = new Path(UUID.randomUUID().toString());
        try (FSDataOutputStream stream = fs.create(sourcePath);){
            stream.writeBytes("hello");
        }
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)destinationPath);
        fs.rename(sourcePath, destinationPath);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)sourcePath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)destinationPath);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)destinationDir);
        fs.rename(sourceDir, destinationDir);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)sourceDir);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)destinationDir);
    }

    @Test
    public void testDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dirPath = new Path(UUID.randomUUID().toString());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        try (FSDataOutputStream stream = fs.create(filePath);){
            stream.writeBytes("hello");
        }
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)filePath);
        fs.delete(filePath, false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)filePath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)dirPath);
        fs.delete(dirPath, false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)dirPath);
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dirPath = new Path(UUID.randomUUID().toString());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        try (FSDataOutputStream stream = fs.create(filePath);){
            stream.writeBytes("hello");
        }
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)dirPath);
        ContractTestUtils.assertPathExists((FileSystem)fs, (String)"This path should exist", (Path)filePath);
        fs.delete(dirPath, true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)filePath);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"This path should not exist", (Path)dirPath);
    }

    @Test
    public void testList() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dirPath = new Path(UUID.randomUUID().toString());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        Path filePath2 = new Path(dirPath, UUID.randomUUID().toString());
        fs.mkdirs(dirPath);
        try (FSDataOutputStream stream = fs.create(filePath);){
            stream.writeBytes("hello");
        }
        stream = fs.create(filePath2);
        var6_6 = null;
        try {
            stream.writeBytes("bye");
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var6_6 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        fs.listStatus(filePath);
        fs.listStatus(dirPath);
        fs.listStatus(new Path("/"));
    }

    @Test
    public void testAcl() throws Exception {
        this.assumeHnsEnabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path(UUID.randomUUID().toString());
        fs.create(reqPath).close();
        fs.setAcl(reqPath, Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, TEST_GROUP, FsAction.ALL)));
        AclStatus acl = fs.getAclStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)acl.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)("[group::r--, group:" + TEST_GROUP + ":rwx]"), (Object)acl.getEntries().toString());
        fs.removeAcl(reqPath);
        acl = fs.getAclStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"[]", (Object)acl.getEntries().toString());
        fs.setPermission(reqPath, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        FileStatus status = fs.getFileStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwx------", (Object)status.getPermission().toString());
        acl = fs.getAclStatus(reqPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwx------", (Object)acl.getPermission().toString());
    }

    @Test
    public void testRootPath() throws Exception {
        this.assumeHnsEnabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path rootPath = new Path("/");
        fs.setOwner(rootPath, "325f1619-4205-432f-9fce-3fd594325ce5", null);
        FileStatus status = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwxr-x---", (Object)status.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)status.getOwner());
        ITestAzureBlobFileSystemDelegationSAS.assertTrue((boolean)status.isDirectory());
        AclStatus acl = fs.getAclStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((Object)"rwxr-x---", (Object)acl.getPermission().toString());
        ArrayList<AclEntry> aclSpec = new ArrayList<AclEntry>();
        int count = 0;
        for (AclEntry entry : acl.getEntries()) {
            aclSpec.add(entry);
            if (entry.getScope() != AclEntryScope.DEFAULT) continue;
            ++count;
        }
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)0L, (long)count);
        aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "cd548981-afec-4ab9-9d39-f6f2add2fd9b", FsAction.EXECUTE));
        fs.modifyAclEntries(rootPath, aclSpec);
        acl = fs.getAclStatus(rootPath);
        count = 0;
        for (AclEntry entry : acl.getEntries()) {
            aclSpec.add(entry);
            if (entry.getScope() != AclEntryScope.DEFAULT) continue;
            ++count;
        }
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)5L, (long)count);
        fs.removeDefaultAcl(rootPath);
        acl = fs.getAclStatus(rootPath);
        count = 0;
        for (AclEntry entry : acl.getEntries()) {
            aclSpec.add(entry);
            if (entry.getScope() != AclEntryScope.DEFAULT) continue;
            ++count;
        }
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path reqPath = new Path(UUID.randomUUID().toString());
        fs.create(reqPath).close();
        String propertyName = "user.mime_type";
        byte[] propertyValue = "text/plain".getBytes("utf-8");
        fs.setXAttr(reqPath, "user.mime_type", propertyValue);
        ITestAzureBlobFileSystemDelegationSAS.assertArrayEquals((byte[])propertyValue, (byte[])fs.getXAttr(reqPath, "user.mime_type"));
    }

    @Test
    public void testSetFileSystemProperties() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("FileSystemProperties", "true");
        TracingContext tracingContext = this.getTestTracingContext(fs, true);
        ITestAzureBlobFileSystemDelegationSAS.assertThrows(IOException.class, () -> fs.getAbfsStore().setFilesystemProperties(properties, tracingContext));
        ITestAzureBlobFileSystemDelegationSAS.assertThrows(IOException.class, () -> fs.getAbfsStore().getFilesystemProperties(tracingContext));
    }

    @Test
    public void testListAndDeleteImplicitPaths() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        this.assumeBlobServiceType();
        AbfsBlobClient client = (AbfsBlobClient)this.getFileSystem().getAbfsClient();
        Path file1 = new Path("/testDir/dir1/file1");
        Path file2 = new Path("/testDir/dir1/file2");
        Path implicitDir = file1.getParent();
        this.createAzCopyFolder(implicitDir);
        this.createAzCopyFile(file1);
        this.createAzCopyFile(file2);
        AbfsRestOperation op = client.listPath(implicitDir.toString(), false, 2, null, this.getTestTracingContext(this.getFileSystem(), false), null).getOp();
        List list = op.getResult().getListResultSchema().paths();
        Assertions.assertThat((List)list).hasSize(2);
        client.deletePath(implicitDir.toString(), true, "", this.getTestTracingContext(fs, false));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(file1)).describedAs("Deleted file1 should not exist.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(file2)).describedAs("Deleted file2 should not exist.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(implicitDir)).describedAs("The parent dir should not exist.", new Object[0])).isFalse();
    }

    private AbfsClient addSpyHooksOnClient(AzureBlobFileSystem fs) {
        AzureBlobFileSystemStore store = (AzureBlobFileSystemStore)Mockito.spy((Object)fs.getAbfsStore());
        ((AzureBlobFileSystem)Mockito.doReturn((Object)store).when((Object)fs)).getAbfsStore();
        AbfsClient client = (AbfsClient)Mockito.spy((Object)store.getClient());
        ((AzureBlobFileSystemStore)Mockito.doReturn((Object)client).when((Object)store)).getClient();
        return client;
    }

    private void checkSignatureMaskAssertions(AbfsRestOperation op) {
        AbfsHttpOperation result = op.getResult();
        String url = result.getMaskedUrl();
        String encodedUrl = result.getMaskedEncodedUrl();
        ((AbstractStringAssert)Assertions.assertThat((String)url.substring(url.indexOf("sig="))).describedAs("Signature query param should be masked", new Object[0])).startsWith((CharSequence)"sig=XXXXX");
        ((AbstractStringAssert)Assertions.assertThat((String)encodedUrl.substring(encodedUrl.indexOf("sig%3D"))).describedAs("Signature query param should be masked", new Object[0])).startsWith((CharSequence)"sig%3DXXXXX");
    }

    @Test
    public void testSignatureMaskforBlob() throws Exception {
        this.assumeBlobServiceType();
        AzureBlobFileSystem fs = (AzureBlobFileSystem)Mockito.spy((Object)this.getFileSystem());
        AbfsBlobClient client = (AbfsBlobClient)this.addSpyHooksOnClient(fs);
        fs.getAbfsStore().setClient((AbfsClient)client);
        String src = String.format("/testABC/test%s.xt", UUID.randomUUID());
        String dest = "/testABC/abc.txt";
        fs.create(new Path(src)).close();
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            Path srcCopy = (Path)answer.getArgument(0);
            Path dstCopy = (Path)answer.getArgument(1);
            String leaseId = (String)answer.getArgument(2);
            TracingContext tracingContext = (TracingContext)answer.getArgument(3);
            AbfsRestOperation op = ((AbfsBlobClient)this.getFileSystem().getAbfsClient()).copyBlob(srcCopy, dstCopy, leaseId, tracingContext);
            this.checkSignatureMaskAssertions(op);
            return answer.callRealMethod();
        }).when((Object)client)).copyBlob((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (String)Mockito.any(String.class), (TracingContext)Mockito.any(TracingContext.class));
        ((AbfsBlobClient)Mockito.doAnswer(answer -> {
            Path blobPath = (Path)answer.getArgument(0);
            String leaseId = (String)answer.getArgument(1);
            TracingContext tracingContext = (TracingContext)answer.getArgument(2);
            AbfsRestOperation op = ((AbfsBlobClient)this.getFileSystem().getAbfsClient()).deleteBlobPath(blobPath, leaseId, tracingContext);
            this.checkSignatureMaskAssertions(op);
            return answer.callRealMethod();
        }).when((Object)client)).deleteBlobPath((Path)Mockito.any(Path.class), (String)Mockito.any(String.class), (TracingContext)Mockito.any(TracingContext.class));
        client.renamePath(src, dest, null, this.getTestTracingContext(fs, false), null, false);
    }

    @Test
    public void testSignatureMask() throws Exception {
        this.assumeDfsServiceType();
        AzureBlobFileSystem fs = this.getFileSystem();
        String src = String.format("/testABC/test%s.xt", UUID.randomUUID());
        fs.create(new Path(src)).close();
        AbfsRestOperation abfsHttpRestOperation = fs.getAbfsClient().renamePath(src, "/testABC/abc.txt", null, this.getTestTracingContext(fs, false), null, false).getOp();
        this.checkSignatureMaskAssertions(abfsHttpRestOperation);
    }

    @Test
    public void testSignatureMaskOnExceptionMessage() throws Exception {
        LambdaTestUtils.intercept(IOException.class, (String)"sig=XXXX", () -> this.getFileSystem().getAbfsClient().renamePath("testABC/test.xt", "testABC/abc.txt", null, this.getTestTracingContext(this.getFileSystem(), false), null, false));
    }

    @Test
    public void testSetPermissionForNonOwner() throws Exception {
        this.assumeHnsEnabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path rootPath = new Path("/");
        FileStatus rootStatus = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"rwxr-x---", (Object)rootStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertNotEquals((String)"The owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)rootStatus.getOwner());
        LambdaTestUtils.intercept(AccessDeniedException.class, (String)AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH.getErrorCode(), () -> {
            fs.setPermission(rootPath, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE));
            return "Set permission should fail because saoid is not the owner.";
        });
        fs.setOwner(rootPath, "325f1619-4205-432f-9fce-3fd594325ce5", null);
        fs.setPermission(rootPath, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE));
        rootStatus = fs.getFileStatus(rootPath);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"rwxr-x--x", (Object)rootStatus.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The directory owner is not expected.", (Object)"325f1619-4205-432f-9fce-3fd594325ce5", (Object)rootStatus.getOwner());
    }

    @Test
    public void testSetPermissionWithoutAgentForNonOwner() throws Exception {
        this.assumeHnsEnabled();
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("NoAgentPath");
        fs.create(path).close();
        FileStatus status = fs.getFileStatus(path);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"rw-r--r--", (Object)status.getPermission().toString());
        ITestAzureBlobFileSystemDelegationSAS.assertNotEquals((String)"The owner is not expected.", (Object)"fs.azure.test.app.service.principal.object.id", (Object)status.getOwner());
        fs.setPermission(path, new FsPermission(FsAction.READ, FsAction.READ, FsAction.NONE));
        FileStatus fileStatus = fs.getFileStatus(path);
        ITestAzureBlobFileSystemDelegationSAS.assertEquals((String)"The permissions are not expected.", (Object)"r--r-----", (Object)fileStatus.getPermission().toString());
    }

    @Test
    public void testSASQuesMarkPrefix() throws Exception {
        AbfsConfiguration testConfig = this.getConfiguration();
        testConfig.set("fs.azure.sas.token.provider.type", "org.apache.hadoop.fs.azurebfs.extensions.MockWithPrefixSASTokenProvider");
        AzureBlobFileSystem testFs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getRawConfiguration());
        Path testFile = new Path("/testSASPrefixQuesMark");
        testFs.create(testFile).close();
    }
}

