/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.services.AbfsListStatusRemoteIterator;
import org.apache.hadoop.fs.azurebfs.services.ListingSupport;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestAbfsListStatusRemoteIterator
extends AbstractAbfsIntegrationTest {
    private static final int TEST_FILES_NUMBER = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(ITestAbfsListStatusRemoteIterator.class);

    @Test
    public void testAbfsIteratorWithHasNext() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        List<String> fileNames = this.createFilesUnderDirectory(testDir);
        ListingSupport listingSupport = (ListingSupport)Mockito.spy((Object)this.getFileSystem().getAbfsStore());
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(testDir, listingSupport, this.getTestTracingContext(this.getFileSystem(), true));
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should be instance of AbfsListStatusRemoteIterator by default", new Object[0])).isInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        while (fsItr.hasNext()) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            this.verifyIteratorResultContent(fileStatus, fileNames);
            ++itrCount;
        }
        this.verifyIteratorResultCount(itrCount, fileNames);
        int minNumberOfInvocations = 100;
        ((ListingSupport)Mockito.verify((Object)listingSupport, (VerificationMode)Mockito.atLeast((int)minNumberOfInvocations))).listStatus((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyList(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    @Test
    public void testAbfsIteratorWithoutHasNext() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        List<String> fileNames = this.createFilesUnderDirectory(testDir);
        ListingSupport listingSupport = (ListingSupport)Mockito.spy((Object)this.getFileSystem().getAbfsStore());
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(testDir, listingSupport, this.getTestTracingContext(this.getFileSystem(), true));
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should be instance of AbfsListStatusRemoteIterator by default", new Object[0])).isInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        for (int i = 0; i < 1000; ++i) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            this.verifyIteratorResultContent(fileStatus, fileNames);
            ++itrCount;
        }
        LambdaTestUtils.intercept(NoSuchElementException.class, () -> ((RemoteIterator)fsItr).next());
        this.verifyIteratorResultCount(itrCount, fileNames);
        int minNumberOfInvocations = 100;
        ((ListingSupport)Mockito.verify((Object)listingSupport, (VerificationMode)Mockito.atLeast((int)minNumberOfInvocations))).listStatus((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyList(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    @Test
    public void testWithAbfsIteratorDisabled() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        this.disableAbfsIterator();
        List<String> fileNames = this.createFilesUnderDirectory(testDir);
        RemoteIterator fsItr = this.getFileSystem().listStatusIterator(testDir);
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should not be instance of AbfsListStatusRemoteIterator when it is disabled", new Object[0])).isNotInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        while (fsItr.hasNext()) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            this.verifyIteratorResultContent(fileStatus, fileNames);
            ++itrCount;
        }
        this.verifyIteratorResultCount(itrCount, fileNames);
    }

    @Test
    public void testWithAbfsIteratorDisabledWithoutHasNext() throws Exception {
        int itrCount;
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        this.disableAbfsIterator();
        List<String> fileNames = this.createFilesUnderDirectory(testDir);
        RemoteIterator fsItr = this.getFileSystem().listStatusIterator(testDir);
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should not be instance of AbfsListStatusRemoteIterator when it is disabled", new Object[0])).isNotInstanceOf(AbfsListStatusRemoteIterator.class);
        for (itrCount = 0; itrCount < 1000; ++itrCount) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            this.verifyIteratorResultContent(fileStatus, fileNames);
        }
        LambdaTestUtils.intercept(NoSuchElementException.class, () -> ((RemoteIterator)fsItr).next());
        this.verifyIteratorResultCount(itrCount, fileNames);
    }

    @Test
    public void testNextWhenNoMoreElementsPresent() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(testDir, (ListingSupport)this.getFileSystem().getAbfsStore(), this.getTestTracingContext(this.getFileSystem(), true));
        fsItr = (RemoteIterator)Mockito.spy((Object)fsItr);
        ((RemoteIterator)Mockito.doReturn((Object)false).when((Object)fsItr)).hasNext();
        LambdaTestUtils.intercept(NoSuchElementException.class, () -> ((RemoteIterator)fsItr).next());
    }

    @Test
    public void testHasNextForEmptyDir() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        RemoteIterator fsItr = this.getFileSystem().listStatusIterator(testDir);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsItr.hasNext()).describedAs("hasNext returns false for empty directory", new Object[0])).isFalse();
    }

    @Test
    public void testHasNextForFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = this.path("testFile");
        String testFileName = testFile.toString();
        this.getFileSystem().create(testFile);
        this.setPageSize(10);
        RemoteIterator fsItr = fs.listStatusIterator(testFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsItr.hasNext()).describedAs("hasNext returns true for file", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)((FileStatus)fsItr.next()).getPath().toString()).describedAs("next returns the file itself", new Object[0])).endsWith((CharSequence)testFileName);
    }

    @Test
    public void testIOException() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        this.getFileSystem().mkdirs(testDir);
        String exceptionMessage = "test exception";
        ListingSupport lsSupport = this.getMockListingSupport(exceptionMessage);
        LambdaTestUtils.intercept(IOException.class, () -> new AbfsListStatusRemoteIterator(testDir, lsSupport, this.getTestTracingContext(this.getFileSystem(), true)));
    }

    @Test
    public void testNonExistingPath() throws Exception {
        Path nonExistingDir = new Path("nonExistingPath");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.getFileSystem().listStatusIterator(nonExistingDir));
    }

    private void verifyIteratorResultContent(FileStatus fileStatus, List<String> fileNames) {
        this.assertPathDns(fileStatus.getPath());
        String pathStr = fileStatus.getPath().toString();
        Assert.assertTrue((String)String.format("Could not remove path %s from filenames %s", pathStr, fileNames), (boolean)fileNames.remove(pathStr));
    }

    private void verifyIteratorResultCount(int itrCount, List<String> fileNames) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)itrCount).describedAs("Number of iterations should be equal to the files created", new Object[0])).isEqualTo(1000);
        ((ListAssert)Assertions.assertThat(fileNames).describedAs("After removing every item found from the iterator, there should be no more elements in the fileNames", new Object[0])).hasSize(0);
    }

    private ListingSupport getMockListingSupport(final String exceptionMessage) {
        return new ListingSupport(){

            public FileStatus[] listStatus(Path path, TracingContext tracingContext) {
                return null;
            }

            public FileStatus[] listStatus(Path path, String startFrom, TracingContext tracingContext) {
                return null;
            }

            public String listStatus(Path path, String startFrom, List<FileStatus> fileStatuses, boolean fetchAll, String continuation, TracingContext tracingContext) throws IOException {
                throw new IOException(exceptionMessage);
            }
        };
    }

    private Path createTestDirectory() throws IOException {
        Path testDirectory = this.path("testDirectory");
        this.getFileSystem().mkdirs(testDirectory);
        return testDirectory;
    }

    private void disableAbfsIterator() throws IOException {
        AzureBlobFileSystemStore abfsStore = this.getAbfsStore(this.getFileSystem());
        abfsStore.getAbfsConfiguration().setEnableAbfsListIterator(false);
    }

    private void setPageSize(int pageSize) throws IOException {
        AzureBlobFileSystemStore abfsStore = this.getAbfsStore(this.getFileSystem());
        abfsStore.getAbfsConfiguration().setListMaxResults(pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createFilesUnderDirectory(Path rootPath) throws ExecutionException, InterruptedException, IOException {
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        List<String> fileNames = Collections.synchronizedList(new ArrayList());
        ExecutorService es = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < 1000; ++i) {
                Path path = this.makeQualified(new Path(rootPath, "testListPath" + i));
                tasks.add(es.submit(() -> {
                    this.touch(filePath);
                    List list = fileNames;
                    synchronized (list) {
                        Assert.assertTrue((boolean)fileNames.add(filePath.toString()));
                    }
                    return null;
                }));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        finally {
            es.shutdownNow();
        }
        LOG.debug(fileNames.toString());
        ((ListAssert)Assertions.assertThat(fileNames).describedAs("File creation incorrect or fileNames not added to list", new Object[0])).hasSize(1000);
        return fileNames;
    }
}

