/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobAppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.extensions.EncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.extensions.MockEncryptionContextProvider;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.security.ContextProviderEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.security.EncodingHelper;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientUtils;
import org.apache.hadoop.fs.azurebfs.services.AbfsDfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.VersionedFileStatus;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.azurebfs.utils.EncryptionType;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ITestAbfsCustomEncryption
extends AbstractAbfsIntegrationTest {
    public static final String SERVER_FILE_CONTENT = "123";
    private final byte[] cpk = new byte[32];
    private final String cpkSHAEncoded;
    private static final String BLOCK_ID = "MF8tNDE1MjkzOTE4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    private List<AzureBlobFileSystem> fileSystemsOpenedInTest = new ArrayList<AzureBlobFileSystem>();
    @Parameterized.Parameter
    public EncryptionType fileEncryptionType;
    @Parameterized.Parameter(value=1)
    public EncryptionType requestEncryptionType;
    @Parameterized.Parameter(value=2)
    public FSOperationType operation;
    @Parameterized.Parameter(value=3)
    public boolean responseHeaderServerEnc;
    @Parameterized.Parameter(value=4)
    public boolean responseHeaderReqServerEnc;
    @Parameterized.Parameter(value=5)
    public boolean isExceptionCase;
    @Parameterized.Parameter(value=6)
    public boolean isCpkResponseHdrExpected;
    @Parameterized.Parameter(value=7)
    public Boolean isCpkResponseKeyExpected = false;
    @Parameterized.Parameter(value=8)
    public Boolean fileSystemListStatusResultToBeUsedForOpeningFile = false;

    @Parameterized.Parameters(name="{0} mode, {2}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.READ, true, false, false, true, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.READ, true, false, false, true, false, true}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.WRITE, false, true, false, true, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.APPEND, false, true, false, true, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.SET_ACL, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.GET_ATTR, true, false, false, true, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.SET_ATTR, false, true, false, true, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.LISTSTATUS, false, false, false, false, true, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.RENAME, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.ENCRYPTION_CONTEXT, FSOperationType.DELETE, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.WRITE, false, false, true, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.GET_ATTR, true, false, true, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.READ, false, false, true, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.SET_ATTR, false, true, true, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.RENAME, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.LISTSTATUS, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.DELETE, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.SET_ACL, false, false, false, false, false, false}, {EncryptionType.ENCRYPTION_CONTEXT, EncryptionType.NONE, FSOperationType.SET_PERMISSION, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.READ, true, false, false, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.WRITE, false, true, false, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.APPEND, false, true, false, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.SET_ACL, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.LISTSTATUS, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.RENAME, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.DELETE, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.GET_ATTR, true, false, false, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.GLOBAL_KEY, FSOperationType.SET_ATTR, false, true, false, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.READ, true, false, true, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.WRITE, false, true, true, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.SET_ATTR, false, false, true, true, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.SET_ACL, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.RENAME, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.LISTSTATUS, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.DELETE, false, false, false, false, false, false}, {EncryptionType.GLOBAL_KEY, EncryptionType.NONE, FSOperationType.SET_PERMISSION, false, false, false, false, false, false});
    }

    public ITestAbfsCustomEncryption() throws Exception {
        new Random().nextBytes(this.cpk);
        this.cpkSHAEncoded = EncodingHelper.getBase64EncodedString((byte[])EncodingHelper.getSHA256Hash((byte[])this.cpk));
    }

    @Test
    public void testCustomEncryptionCombinations() throws Exception {
        try (AzureBlobFileSystem fs = this.getOrCreateFS();){
            this.validateCpkResponseHeadersForCombination(fs);
        }
    }

    private void validateCpkResponseHeadersForCombination(AzureBlobFileSystem fs) throws Exception {
        MockEncryptionContextProvider ecp;
        Path testPath = this.path("/testFile");
        String relativePath = fs.getAbfsStore().getRelativePath(testPath);
        AbfsRestOperation op = this.callOperation(fs, new Path(relativePath), ecp = (MockEncryptionContextProvider)this.createEncryptedFile(testPath));
        if (op == null) {
            return;
        }
        AbfsHttpOperation httpOp = op.getResult();
        if (this.isCpkResponseHdrExpected) {
            if (this.requestEncryptionType == EncryptionType.ENCRYPTION_CONTEXT) {
                String encryptionContext = ecp.getEncryptionContextForTest(relativePath);
                String expectedKeySHA = EncodingHelper.getBase64EncodedString((byte[])EncodingHelper.getSHA256Hash((byte[])ecp.getEncryptionKeyForTest(encryptionContext)));
                Assertions.assertThat((String)httpOp.getResponseHeader("x-ms-encryption-key-sha256")).isEqualTo((Object)expectedKeySHA);
            } else {
                Assertions.assertThat((String)httpOp.getResponseHeader("x-ms-encryption-key-sha256")).isEqualTo((Object)this.cpkSHAEncoded);
            }
        } else if (this.isCpkResponseKeyExpected.booleanValue()) {
            if (this.requestEncryptionType == EncryptionType.ENCRYPTION_CONTEXT) {
                String encryptionContext = ecp.getEncryptionContextForTest(relativePath);
                String expectedKeySHA = EncodingHelper.getBase64EncodedString((byte[])EncodingHelper.getSHA256Hash((byte[])ecp.getEncryptionKeyForTest(encryptionContext)));
                Assertions.assertThat((String)((ListResultEntrySchema)httpOp.getListResultSchema().paths().get(0)).getCustomerProvidedKeySha256()).isEqualTo((Object)expectedKeySHA);
            }
        } else {
            Assertions.assertThat((String)httpOp.getResponseHeader("x-ms-encryption-key-sha256")).isEqualTo(null);
        }
        Assertions.assertThat((String)httpOp.getResponseHeader("x-ms-server-encrypted")).isEqualTo((Object)(this.responseHeaderServerEnc ? "true" : null));
        Assertions.assertThat((String)httpOp.getResponseHeader("x-ms-request-server-encrypted")).isEqualTo((Object)(this.responseHeaderReqServerEnc ? "true" : null));
    }

    private AbfsRestOperation callOperation(AzureBlobFileSystem fs, Path testPath, EncryptionContextProvider ecp) throws Exception {
        AbfsClient client = fs.getAbfsClient();
        AbfsClient ingressClient = fs.getAbfsStore().getClientHandler().getIngressClient();
        AbfsClientUtils.setEncryptionContextProvider(client, ecp);
        AbfsClientUtils.setEncryptionContextProvider(ingressClient, ecp);
        if (this.isExceptionCase) {
            LambdaTestUtils.intercept(IOException.class, () -> this.lambda$callOperation$0(fs, testPath));
            return null;
        }
        ContextProviderEncryptionAdapter encryptionAdapter = null;
        if (this.fileEncryptionType == EncryptionType.ENCRYPTION_CONTEXT) {
            encryptionAdapter = new ContextProviderEncryptionAdapter(ecp, fs.getAbfsStore().getRelativePath(testPath), Base64.getEncoder().encode(((MockEncryptionContextProvider)ecp).getEncryptionContextForTest(testPath.toString()).getBytes(StandardCharsets.UTF_8)));
        }
        String path = testPath.toString();
        switch (this.operation) {
            case READ: {
                if (!this.fileSystemListStatusResultToBeUsedForOpeningFile.booleanValue() || this.fileEncryptionType != EncryptionType.ENCRYPTION_CONTEXT) {
                    TracingContext tracingContext = this.getTestTracingContext(fs, true);
                    AbfsHttpOperation statusOp = client.getPathStatus(path, false, tracingContext, null).getResult();
                    return client.read(path, 0L, new byte[5], 0, 5, statusOp.getResponseHeader("ETag"), null, (ContextEncryptionAdapter)encryptionAdapter, tracingContext);
                }
                FileStatus status = fs.listStatus(testPath)[0];
                Assertions.assertThat((Comparable)status).isInstanceOf(VersionedFileStatus.class);
                Assertions.assertThat((String)((VersionedFileStatus)status).getEncryptionContext()).isNotNull();
                try (FSDataInputStream in = (FSDataInputStream)fs.openFileWithOptions(testPath, new OpenFileParameters().withMandatoryKeys(new HashSet()).withStatus(fs.listStatus(testPath)[0])).get();){
                    byte[] readBuffer = new byte[3];
                    Assertions.assertThat((int)in.read(readBuffer)).isGreaterThan(0);
                    Assertions.assertThat((byte[])readBuffer).isEqualTo((Object)SERVER_FILE_CONTENT.getBytes());
                    AbfsRestOperation abfsRestOperation = null;
                    return abfsRestOperation;
                }
            }
            case WRITE: {
                if (ingressClient instanceof AbfsDfsClient) {
                    return ingressClient.flush(path, 3L, false, false, null, null, (ContextEncryptionAdapter)encryptionAdapter, this.getTestTracingContext(fs, false));
                }
                byte[] buffer = AbfsBlobClient.generateBlockListXml((String)"").getBytes(StandardCharsets.UTF_8);
                return ingressClient.flush(buffer, path, false, null, null, null, (ContextEncryptionAdapter)encryptionAdapter, this.getTestTracingContext(fs, false));
            }
            case APPEND: {
                if (ingressClient instanceof AbfsDfsClient) {
                    return ingressClient.append(path, "val".getBytes(), new AppendRequestParameters(3L, 0, 3, AppendRequestParameters.Mode.APPEND_MODE, false, null, true), null, (ContextEncryptionAdapter)encryptionAdapter, this.getTestTracingContext(fs, false));
                }
                return ingressClient.append(path, "val".getBytes(), new AppendRequestParameters(3L, 0, 3, AppendRequestParameters.Mode.APPEND_MODE, false, null, true, new BlobAppendRequestParameters(BLOCK_ID, null)), null, (ContextEncryptionAdapter)encryptionAdapter, this.getTestTracingContext(fs, false));
            }
            case SET_ACL: {
                return client.setAcl(path, AclEntry.aclSpecToString((List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)})), this.getTestTracingContext(fs, false));
            }
            case LISTSTATUS: {
                return client.listPath(path, false, 5, null, this.getTestTracingContext(fs, true), null).getOp();
            }
            case RENAME: {
                TracingContext tc = this.getTestTracingContext(fs, true);
                return client.renamePath(path, new Path(path + "_2").toString(), null, tc, null, false).getOp();
            }
            case DELETE: {
                TracingContext testTC = this.getTestTracingContext(fs, false);
                return client.deletePath(path, false, null, testTC);
            }
            case GET_ATTR: {
                return client.getPathStatus(path, true, this.getTestTracingContext(fs, false), (ContextEncryptionAdapter)this.createEncryptionAdapterFromServerStoreContext(path, this.getTestTracingContext(fs, false), client));
            }
            case SET_ATTR: {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("key", "{ value: valueTest }");
                return client.setPathProperties(path, properties, this.getTestTracingContext(fs, false), (ContextEncryptionAdapter)this.createEncryptionAdapterFromServerStoreContext(path, this.getTestTracingContext(fs, false), client));
            }
            case SET_PERMISSION: {
                return client.setPermission(path, FsPermission.getDefault().toString(), this.getTestTracingContext(fs, false));
            }
        }
        throw new NoSuchFieldException();
    }

    private ContextProviderEncryptionAdapter createEncryptionAdapterFromServerStoreContext(String path, TracingContext tracingContext, AbfsClient client) throws IOException {
        if (client.getEncryptionType() != EncryptionType.ENCRYPTION_CONTEXT) {
            return null;
        }
        String responseHeaderEncryptionContext = client.getPathStatus(path, false, tracingContext, null).getResult().getResponseHeader("x-ms-encryption-context");
        if (responseHeaderEncryptionContext == null) {
            throw new PathIOException(path, "EncryptionContext not present in GetPathStatus response");
        }
        byte[] encryptionContext = responseHeaderEncryptionContext.getBytes(StandardCharsets.UTF_8);
        return new ContextProviderEncryptionAdapter(client.getEncryptionContextProvider(), new Path(path).toUri().getPath(), encryptionContext);
    }

    private AzureBlobFileSystem getECProviderEnabledFS() throws Exception {
        Configuration configuration = this.getRawConfiguration();
        configuration.set("fs.azure.encryption.context.provider.type." + this.getAccountName(), MockEncryptionContextProvider.class.getCanonicalName());
        configuration.unset("fs.azure.encryption.encoded.client-provided-key." + this.getAccountName());
        configuration.unset("fs.azure.encryption.encoded.client-provided-key-sha." + this.getAccountName());
        return this.getAzureBlobFileSystem(configuration);
    }

    private AzureBlobFileSystem getCPKEnabledFS() throws IOException {
        Configuration conf = this.getRawConfiguration();
        String cpkEncoded = EncodingHelper.getBase64EncodedString((byte[])this.cpk);
        String cpkEncodedSHA = EncodingHelper.getBase64EncodedString((byte[])EncodingHelper.getSHA256Hash((byte[])this.cpk));
        conf.set("fs.azure.encryption.encoded.client-provided-key." + this.getAccountName(), cpkEncoded);
        conf.set("fs.azure.encryption.encoded.client-provided-key-sha." + this.getAccountName(), cpkEncodedSHA);
        conf.unset("fs.azure.encryption.context.provider.type");
        return this.getAzureBlobFileSystem(conf);
    }

    private AzureBlobFileSystem getAzureBlobFileSystem(Configuration conf) {
        try {
            AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
            this.fileSystemsOpenedInTest.add(fs);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", true)).describedAs("Encryption tests should run only on namespace enabled account", new Object[0])).isTrue();
            return fs;
        }
        catch (IOException ex) {
            GenericTestUtils.assertExceptionContains((String)"Non hierarchical-namespace account can not have configs enabled for Customer Provided Keys. Following configs can not be given with non-hierarchical-namespace account:fs.azure.encryption.context.provider.type, fs.azure.encryption.encoded.client-provided-key, fs.azure.encryption.encoded.client-provided-key-sha", (Throwable)ex, (String)"Exception message should contain the expected message");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getConfiguration().getBoolean("fs.azure.test.namespace.enabled", false)).describedAs("Encryption tests should run only on namespace enabled account", new Object[0])).isFalse();
            Assumptions.assumeThat((boolean)true).isFalse();
            return null;
        }
    }

    private AzureBlobFileSystem getOrCreateFS() throws Exception {
        if (this.getFileSystem().getAbfsClient().getEncryptionType() == this.requestEncryptionType) {
            return this.getFileSystem();
        }
        if (this.requestEncryptionType == EncryptionType.ENCRYPTION_CONTEXT) {
            return this.getECProviderEnabledFS();
        }
        if (this.requestEncryptionType == EncryptionType.GLOBAL_KEY) {
            return this.getCPKEnabledFS();
        }
        Configuration conf = this.getRawConfiguration();
        conf.unset("fs.azure.encryption.context.provider.type");
        AzureBlobFileSystem fs = (AzureBlobFileSystem)FileSystem.newInstance((Configuration)conf);
        this.fileSystemsOpenedInTest.add(fs);
        return fs;
    }

    private EncryptionContextProvider createEncryptedFile(Path testPath) throws Exception {
        try (AzureBlobFileSystem fs = this.getFileSystemForFileEncryption();){
            String relativePath = fs.getAbfsStore().getRelativePath(testPath);
            try (FSDataOutputStream out = fs.create(new Path(relativePath));){
                out.write(SERVER_FILE_CONTENT.getBytes());
            }
            this.verifyFileEncryption(fs, relativePath);
            EncryptionContextProvider encryptionContextProvider = fs.getAbfsClient().getEncryptionContextProvider();
            return encryptionContextProvider;
        }
    }

    private void verifyFileEncryption(AzureBlobFileSystem fs, String relativePath) throws Exception {
        if (this.fileEncryptionType != EncryptionType.NONE) {
            AbfsClient abfsClient = fs.getAbfsClient();
            abfsClient.setEncryptionType(EncryptionType.NONE);
            LambdaTestUtils.intercept(IOException.class, () -> abfsClient.getPathStatus(relativePath, true, this.getTestTracingContext(fs, false), (ContextEncryptionAdapter)this.createEncryptionAdapterFromServerStoreContext(relativePath, this.getTestTracingContext(fs, false), abfsClient)));
            fs.getAbfsClient().setEncryptionType(this.fileEncryptionType);
        }
    }

    private AzureBlobFileSystem getFileSystemForFileEncryption() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem().getAbfsClient().getEncryptionType() == this.fileEncryptionType ? (AzureBlobFileSystem)FileSystem.newInstance((Configuration)this.getConfiguration().getRawConfiguration()) : (this.fileEncryptionType == EncryptionType.ENCRYPTION_CONTEXT ? this.getECProviderEnabledFS() : this.getCPKEnabledFS());
        return fs;
    }

    @Override
    public void teardown() throws Exception {
        super.teardown();
        for (AzureBlobFileSystem azureBlobFileSystem : this.fileSystemsOpenedInTest) {
            azureBlobFileSystem.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$callOperation$0(AzureBlobFileSystem fs, Path testPath) throws Exception {
        switch (1.$SwitchMap$org$apache$hadoop$fs$azurebfs$constants$FSOperationType[this.operation.ordinal()]) {
            case 2: {
                out = fs.append(testPath);
                var4_5 = null;
                out.write("bytes".getBytes());
                if (out == null) break;
                if (var4_5 == null) ** GOTO lbl15
                try {
                    out.close();
                }
                catch (Throwable var5_7) {
                    var4_5.addSuppressed(var5_7);
                }
                break;
lbl15:
                // 1 sources

                out.close();
                break;
                catch (Throwable var5_8) {
                    try {
                        var4_5 = var5_8;
                        throw var5_8;
                    }
                    catch (Throwable var6_11) {
                        if (out != null) {
                            if (var4_5 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var7_12) {
                                    var4_5.addSuppressed(var7_12);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var6_11;
                    }
                }
            }
            case 1: {
                in = fs.open(testPath);
                var4_6 = null;
                in.read(new byte[5]);
                if (in == null) break;
                if (var4_6 == null) ** GOTO lbl46
                try {
                    in.close();
                }
                catch (Throwable var5_9) {
                    var4_6.addSuppressed(var5_9);
                }
                break;
lbl46:
                // 1 sources

                in.close();
                break;
                catch (Throwable var5_10) {
                    try {
                        var4_6 = var5_10;
                        throw var5_10;
                    }
                    catch (Throwable var8_13) {
                        if (in != null) {
                            if (var4_6 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable var9_14) {
                                    var4_6.addSuppressed(var9_14);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw var8_13;
                    }
                }
            }
            case 9: {
                fs.setXAttr(testPath, "attribute", "value".getBytes());
                break;
            }
            case 8: {
                fs.getXAttr(testPath, "attribute");
                break;
            }
            default: {
                throw new NoSuchFieldException();
            }
        }
    }
}

