/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.azure.SyncableDataOutputStream;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public class TestSyncableDataOutputStream {
    @Test
    public void testCloseWhenFlushThrowingIOException() throws Exception {
        MockOutputStream out = new MockOutputStream();
        SyncableDataOutputStream sdos = new SyncableDataOutputStream((OutputStream)out);
        out.flushThrowIOE = true;
        LambdaTestUtils.intercept(IOException.class, (String)"An IOE from flush", () -> sdos.close());
        MockOutputStream out2 = new MockOutputStream();
        out2.flushThrowIOE = true;
        LambdaTestUtils.intercept(IOException.class, (String)"An IOE from flush", () -> {
            SyncableDataOutputStream sdos2 = new SyncableDataOutputStream((OutputStream)out2);
            Throwable throwable = null;
            if (sdos2 != null) {
                if (throwable != null) {
                    try {
                        sdos2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    sdos2.close();
                }
            }
        });
    }

    private static class MockOutputStream
    extends OutputStream {
        private boolean flushThrowIOE = false;
        private IOException lastException = null;

        private MockOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
        }

        @Override
        public void flush() throws IOException {
            if (this.flushThrowIOE) {
                this.lastException = new IOException("An IOE from flush");
                throw this.lastException;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.lastException != null) {
                throw this.lastException;
            }
        }
    }
}

