/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import com.microsoft.azure.datalake.store.SSLSocketFactoryEx;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestAdlSdkConfiguration {
    @Test
    public void testDefaultTimeout() throws IOException {
        AdlFileSystem fs = null;
        Configuration conf = null;
        conf = AdlStorageConfiguration.getConfiguration();
        conf.setInt("adl.http.timeout", -1);
        try {
            fs = (AdlFileSystem)AdlStorageConfiguration.createStorageConnector(conf);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem. Please check test.fs.adl.name property.", e);
        }
        Assumptions.assumeTrue((fs != null ? 1 : 0) != 0);
        int effectiveTimeout = fs.getAdlClient().getDefaultTimeout();
        Assertions.assertFalse((effectiveTimeout < 0 ? 1 : 0) != 0, (String)"A negative timeout is not supposed to take effect");
        conf = AdlStorageConfiguration.getConfiguration();
        conf.setInt("adl.http.timeout", 17);
        try {
            fs = (AdlFileSystem)AdlStorageConfiguration.createStorageConnector(conf);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem. Please check test.fs.adl.name property.", e);
        }
        effectiveTimeout = fs.getAdlClient().getDefaultTimeout();
        Assertions.assertEquals((int)effectiveTimeout, (int)17, (String)"Timeout is getting set");
    }

    @Test
    public void testSSLChannelModeConfig() throws IOException, URISyntaxException {
        this.testSSLChannelMode(SSLSocketFactoryEx.SSLChannelMode.OpenSSL, "OpenSSL");
        this.testSSLChannelMode(SSLSocketFactoryEx.SSLChannelMode.Default_JSE, "Default_JSE");
        this.testSSLChannelMode(SSLSocketFactoryEx.SSLChannelMode.Default, "Default");
        this.testSSLChannelMode(SSLSocketFactoryEx.SSLChannelMode.Default, "Invalid");
        this.testSSLChannelMode(SSLSocketFactoryEx.SSLChannelMode.OpenSSL, "openssl");
    }

    public void testSSLChannelMode(SSLSocketFactoryEx.SSLChannelMode expectedMode, String sslChannelModeConfigValue) throws IOException, URISyntaxException {
        AdlFileSystem fs = null;
        Configuration conf = null;
        conf = AdlStorageConfiguration.getConfiguration();
        conf.set("adl.ssl.channel.mode", sslChannelModeConfigValue);
        fs = (AdlFileSystem)AdlStorageConfiguration.createStorageConnector(conf);
        Assumptions.assumeTrue((fs != null ? 1 : 0) != 0);
        SSLSocketFactoryEx.SSLChannelMode sslChannelMode = fs.getAdlClient().getSSLChannelMode();
        Assertions.assertEquals((Object)expectedMode, (Object)sslChannelMode, (String)("Unexpected SSL Channel Mode for adl.ssl.channel.mode config value : " + sslChannelModeConfigValue));
    }
}

