/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestAdlPermissionLive {
    private static Path testRoot = new Path("/test");
    private FsPermission permission;
    private Path path;
    private FileSystem adlStore;

    public void initTestAdlPermissionLive(FsPermission pTestPermission) throws Exception {
        this.permission = pTestPermission;
        this.setUp();
    }

    public static Collection adlCreateNonRecursiveTestData() throws UnsupportedEncodingException {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        for (FsAction g : FsAction.values()) {
            for (FsAction o : FsAction.values()) {
                datas.add(new Object[]{new FsPermission(FsAction.ALL, g, o)});
            }
        }
        return datas;
    }

    @AfterAll
    public static void cleanUp() throws IOException, URISyntaxException {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            Assertions.assertTrue((boolean)AdlStorageConfiguration.createStorageConnector().delete(testRoot, true));
        }
    }

    public void setUp() throws Exception {
        Assumptions.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"adlCreateNonRecursiveTestData"})
    public void testFilePermission(FsPermission pTestPermission) throws Exception {
        this.initTestAdlPermissionLive(pTestPermission);
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        this.adlStore.getConf().set("fs.permissions.umask-mode", "000");
        this.adlStore.mkdirs(this.path.getParent(), new FsPermission(FsAction.ALL, FsAction.WRITE, FsAction.NONE));
        this.adlStore.removeDefaultAcl(this.path.getParent());
        this.adlStore.create(this.path, this.permission, true, 1024, (short)1, 1023L, null);
        FileStatus status = this.adlStore.getFileStatus(this.path);
        Assertions.assertEquals((Object)this.permission, (Object)status.getPermission());
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"adlCreateNonRecursiveTestData"})
    public void testFolderPermission(FsPermission pTestPermission) throws Exception {
        this.initTestAdlPermissionLive(pTestPermission);
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        this.adlStore.getConf().set("fs.permissions.umask-mode", "000");
        this.adlStore.mkdirs(this.path.getParent(), new FsPermission(FsAction.ALL, FsAction.WRITE, FsAction.NONE));
        this.adlStore.removeDefaultAcl(this.path.getParent());
        this.adlStore.mkdirs(this.path, this.permission);
        FileStatus status = this.adlStore.getFileStatus(this.path);
        Assertions.assertEquals((Object)this.permission, (Object)status.getPermission());
    }
}

