/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;

public class TestAdlFileSystemContractLive
extends FileSystemContractBaseTest {
    private FileSystem adlStore;

    @BeforeEach
    public void setUp() throws Exception {
        this.skipTestCheck();
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.fs = this.adlStore;
        }
        Assumptions.assumeTrue((this.fs != null ? 1 : 0) != 0);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.cleanup();
        }
        super.tearDown();
    }

    private void cleanup() throws IOException {
        this.adlStore.delete(new Path("/test"), true);
    }

    private void skipTestCheck() {
        Assumptions.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }
}

