/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestValidateConfiguration {
    @Test
    public void validateConfigurationKeys() {
        Assertions.assertEquals((Object)"fs.adl.oauth2.refresh.url", (Object)"fs.adl.oauth2.refresh.url");
        Assertions.assertEquals((Object)"fs.adl.oauth2.access.token.provider", (Object)"fs.adl.oauth2.access.token.provider");
        Assertions.assertEquals((Object)"fs.adl.oauth2.client.id", (Object)"fs.adl.oauth2.client.id");
        Assertions.assertEquals((Object)"fs.adl.oauth2.refresh.token", (Object)"fs.adl.oauth2.refresh.token");
        Assertions.assertEquals((Object)"fs.adl.oauth2.credential", (Object)"fs.adl.oauth2.credential");
        Assertions.assertEquals((Object)"adl.debug.override.localuserasfileowner", (Object)"adl.debug.override.localuserasfileowner");
        Assertions.assertEquals((Object)"fs.adl.oauth2.access.token.provider.type", (Object)"fs.adl.oauth2.access.token.provider.type");
        Assertions.assertEquals((Object)"adl.feature.client.cache.readahead", (Object)"adl.feature.client.cache.readahead");
        Assertions.assertEquals((Object)"adl.feature.client.cache.drop.behind.writes", (Object)"adl.feature.client.cache.drop.behind.writes");
        Assertions.assertEquals((Object)"RefreshToken", (Object)"RefreshToken");
        Assertions.assertEquals((Object)"ClientCredential", (Object)"ClientCredential");
        Assertions.assertEquals((Object)"adl.enable.client.latency.tracker", (Object)"adl.enable.client.latency.tracker");
        Assertions.assertEquals((Object)true, (Object)true);
        Assertions.assertEquals((Object)true, (Object)true);
        Assertions.assertEquals((Object)"adl.feature.experiment.positional.read.enable", (Object)"adl.feature.experiment.positional.read.enable");
        Assertions.assertEquals((int)1, (int)1);
        Assertions.assertEquals((long)0x10000000L, (long)0x10000000L);
        Assertions.assertEquals((Object)false, (Object)false);
        Assertions.assertEquals((int)0x400000, (int)0x400000);
        Assertions.assertEquals((int)0x400000, (int)0x400000);
        Assertions.assertEquals((Object)"adl.feature.ownerandgroup.enableupn", (Object)"adl.feature.ownerandgroup.enableupn");
        Assertions.assertEquals((Object)false, (Object)false);
    }

    @Test
    public void testSetDeprecatedKeys() throws ClassNotFoundException {
        Configuration conf = new Configuration(true);
        this.setDeprecatedKeys(conf);
        Class.forName(AdlFileSystem.class.getName());
        this.assertDeprecatedKeys(conf);
    }

    @Test
    public void testLoadDeprecatedKeys() throws IOException, ClassNotFoundException {
        Configuration saveConf = new Configuration(false);
        this.setDeprecatedKeys(saveConf);
        File testRootDir = GenericTestUtils.getTestDir();
        File confXml = new File(testRootDir, "testLoadDeprecatedKeys.xml");
        FileOutputStream out = new FileOutputStream(confXml);
        saveConf.writeXml((OutputStream)out);
        ((OutputStream)out).close();
        Configuration conf = new Configuration(true);
        conf.addResource(confXml.toURI().toURL());
        conf.get("dummy.key");
        Class.forName(AdlFileSystem.class.getName());
        this.assertDeprecatedKeys(conf);
    }

    @Test
    public void testGetAccountNameFromFQDN() {
        Assertions.assertEquals((Object)"dummy", (Object)AdlFileSystem.getAccountNameFromFQDN((String)"dummy.azuredatalakestore.net"));
        Assertions.assertEquals((Object)"localhost", (Object)AdlFileSystem.getAccountNameFromFQDN((String)"localhost"));
    }

    @Test
    public void testPropagateAccountOptionsDefault() {
        Configuration conf = new Configuration(false);
        conf.set("fs.adl.oauth2.client.id", "defaultClientId");
        conf.set("fs.adl.oauth2.credential", "defaultCredential");
        conf.set("some.other.config", "someValue");
        Configuration propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy");
        Assertions.assertEquals((Object)"defaultClientId", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals((Object)"defaultCredential", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
    }

    @Test
    public void testPropagateAccountOptionsSpecified() {
        Configuration conf = new Configuration(false);
        conf.set("fs.adl.account.dummy.oauth2.client.id", "dummyClientId");
        conf.set("fs.adl.account.dummy.oauth2.credential", "dummyCredential");
        conf.set("some.other.config", "someValue");
        Configuration propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy");
        Assertions.assertEquals((Object)"dummyClientId", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals((Object)"dummyCredential", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
        propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"anotherDummy");
        Assertions.assertEquals(null, (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals(null, (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
    }

    @Test
    public void testPropagateAccountOptionsAll() {
        Configuration conf = new Configuration(false);
        conf.set("fs.adl.oauth2.client.id", "defaultClientId");
        conf.set("fs.adl.oauth2.credential", "defaultCredential");
        conf.set("some.other.config", "someValue");
        conf.set("fs.adl.account.dummy1.oauth2.client.id", "dummyClientId1");
        conf.set("fs.adl.account.dummy1.oauth2.credential", "dummyCredential1");
        conf.set("fs.adl.account.dummy2.oauth2.client.id", "dummyClientId2");
        conf.set("fs.adl.account.dummy2.oauth2.credential", "dummyCredential2");
        Configuration propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy1");
        Assertions.assertEquals((Object)"dummyClientId1", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals((Object)"dummyCredential1", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
        propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"dummy2");
        Assertions.assertEquals((Object)"dummyClientId2", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals((Object)"dummyCredential2", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
        propagatedConf = AdlFileSystem.propagateAccountOptions((Configuration)conf, (String)"anotherDummy");
        Assertions.assertEquals((Object)"defaultClientId", (Object)propagatedConf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals((Object)"defaultCredential", (Object)propagatedConf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"someValue", (Object)propagatedConf.get("some.other.config"));
    }

    private void setDeprecatedKeys(Configuration conf) {
        conf.set("dfs.adls.oauth2.access.token.provider.type", "dummyType");
        conf.set("dfs.adls.oauth2.client.id", "dummyClientId");
        conf.set("dfs.adls.oauth2.refresh.token", "dummyRefreshToken");
        conf.set("dfs.adls.oauth2.refresh.url", "dummyRefreshUrl");
        conf.set("dfs.adls.oauth2.credential", "dummyCredential");
        conf.set("dfs.adls.oauth2.access.token.provider", "dummyClass");
        conf.set("adl.dfs.enable.client.latency.tracker", "dummyTracker");
    }

    private void assertDeprecatedKeys(Configuration conf) {
        Assertions.assertEquals((Object)"dummyType", (Object)conf.get("fs.adl.oauth2.access.token.provider.type"));
        Assertions.assertEquals((Object)"dummyClientId", (Object)conf.get("fs.adl.oauth2.client.id"));
        Assertions.assertEquals((Object)"dummyRefreshToken", (Object)conf.get("fs.adl.oauth2.refresh.token"));
        Assertions.assertEquals((Object)"dummyRefreshUrl", (Object)conf.get("fs.adl.oauth2.refresh.url"));
        Assertions.assertEquals((Object)"dummyCredential", (Object)conf.get("fs.adl.oauth2.credential"));
        Assertions.assertEquals((Object)"dummyClass", (Object)conf.get("fs.adl.oauth2.access.token.provider"));
        Assertions.assertEquals((Object)"dummyTracker", (Object)conf.get("adl.enable.client.latency.tracker"));
    }
}

