/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.common.Parallelized;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parallelized.class)
public class TestAdlSupportedCharsetInPath {
    private static final String TEST_ROOT = "/test/";
    private static final Logger LOG = LoggerFactory.getLogger(TestAdlSupportedCharsetInPath.class);
    private String path;

    public TestAdlSupportedCharsetInPath(String filePath) {
        this.path = filePath;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> adlCharTestData() throws UnsupportedEncodingException {
        ArrayList<String> filePathList = new ArrayList<String>();
        for (int i = 32; i < 127; ++i) {
            String specialChar = "" + (char)i;
            if (i >= 48 && i <= 57 || i >= 65 && i <= 90 || i >= 97 && i <= 122) continue;
            if (i != 92 && i != 58 && i != 46 && i != 47) {
                filePathList.add(specialChar);
            }
            if (i != 92 && i != 47 && i != 58) {
                filePathList.add("file " + i + " " + specialChar);
            }
            if (i == 47 || i == 58 || i == 92) continue;
            filePathList.add("file " + i + " " + specialChar + "_name");
        }
        filePathList.add("a  ");
        filePathList.add("a..b");
        TestAdlSupportedCharsetInPath.fillUnicodes(filePathList);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (String item : filePathList) {
            result.add(new Object[]{item});
        }
        return result;
    }

    private static void fillUnicodes(ArrayList<String> filePathList) {
        filePathList.add("\u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0643\u0628\u064a\u0631\u0629");
        filePathList.add("T\u00eb dh\u00ebnat i madh");
        filePathList.add("\u0574\u0565\u056e \u057f\u057e\u0575\u0561\u056c\u0576\u0565\u0580\u0568");
        filePathList.add("b\u00f6y\u00fck data");
        filePathList.add("\u0432\u044f\u043b\u0456\u043a\u0456\u044f \u0434\u0430\u0434\u0437\u0435\u043d\u044b\u044f");
        filePathList.add("\u09ac\u09bf\u0997 \u09a1\u09c7\u099f\u09be");
        filePathList.add("veliki podataka");
        filePathList.add("\u0433\u043e\u043b\u044f\u043c\u0430 \u0434\u0430\u043d\u043d\u0438");
        filePathList.add("\u5927\u6570\u636e");
        filePathList.add("\u5927\u6578\u64da");
        filePathList.add("\u10d3\u10d8\u10d3\u10d8 \u10db\u10dd\u10dc\u10d0\u10ea\u10d4\u10db\u10d7\u10d0");
        filePathList.add("gro\u00dfe Daten");
        filePathList.add("\u03bc\u03b5\u03b3\u03ac\u03bb\u03bf \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1");
        filePathList.add("\u0aae\u0acb\u0a9f\u0abe \u0aae\u0abe\u0ab9\u0abf\u0aa4\u0ac0");
        filePathList.add("\u05e0\u05ea\u05d5\u05e0\u05d9\u05dd \u05d2\u05d3\u05d5\u05dc\u05d9\u05dd");
        filePathList.add("\u092c\u0921\u093c\u093e \u0921\u0947\u091f\u093e");
        filePathList.add("st\u00f3r g\u00f6gn");
        filePathList.add("sonra\u00ed m\u00f3r");
        filePathList.add("\u30d3\u30c3\u30b0\u30c7\u30fc\u30bf");
        filePathList.add("\u04af\u043b\u043a\u0435\u043d \u0434\u0435\u0440\u0435\u043a\u0442\u0435\u0440");
        filePathList.add("\u1791\u17b7\u1793\u17d2\u1793\u1793\u17d0\u1799\u1792\u17c6");
        filePathList.add("\ube45 \ub370\uc774\ud130");
        filePathList.add("\u0e82\u0ecd\u0ec9\u0ea1\u0eb9\u0e99 \u0e82\u0eb0\u0eab\u0e99\u0eb2\u0e94\u0ec3\u0eab\u0e8d\u0ec8");
        filePathList.add("\u0433\u043e\u043b\u0435\u043c\u0438 \u043f\u043e\u0434\u0430\u0442\u043e\u0446\u0438");
        filePathList.add("\u0920\u0942\u0932\u094b \u0921\u093e\u091f\u093e");
        filePathList.add("\u0d35\u0d32\u0d3f\u0d2f \u0d21\u0d3e\u0d31\u0d4d\u0d31");
        filePathList.add("\u092e\u094b\u0920\u0947 \u0921\u0947\u091f\u093e");
        filePathList.add("\u0442\u043e\u043c \u043c\u044d\u0434\u044d\u044d\u043b\u044d\u043b");
        filePathList.add("\u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u0632\u0631\u06af");
        filePathList.add("\u0a35\u0a71\u0a21\u0a47 \u0a21\u0a3e\u0a1f\u0a47 \u0a28\u0a42\u0a70");
        filePathList.add("\u0431\u043e\u043b\u044c\u0448\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
        filePathList.add("\u0412\u0435\u043b\u0438\u043a\u0438 \u043f\u043e\u0434\u0430\u0442\u0430\u043a\u0430");
        filePathList.add("\u0dc0\u0dd2\u0dc1\u0dcf\u0dbd \u0daf\u0dad\u0dca\u0dad");
        filePathList.add("big d\u00e1t");
        filePathList.add("\u043c\u0430\u044a\u043b\u0443\u043c\u043e\u0442\u0438 \u043a\u0430\u043b\u043e\u043d");
        filePathList.add("\u0baa\u0bc6\u0bb0\u0bbf\u0baf \u0ba4\u0bb0\u0bb5\u0bc1");
        filePathList.add("\u0c2a\u0c46\u0c26\u0c4d\u0c26 \u0c21\u0c47\u0c1f\u0c3e");
        filePathList.add("\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e43\u0e2b\u0e0d\u0e48");
        filePathList.add("b\u00fcy\u00fck veri");
        filePathList.add("\u0432\u0435\u043b\u0438\u043a\u0456 \u0434\u0430\u043d\u0456");
        filePathList.add("\u0628\u0691\u06d2 \u0627\u0639\u062f\u0627\u062f \u0648 \u0634\u0645\u0627\u0631");
        filePathList.add("katta ma'lumotlar");
        filePathList.add("d\u1eef li\u1ec7u l\u1edbn");
        filePathList.add("\u05d2\u05e8\u05d5\u05d9\u05e1 \u05d3\u05d0\u05b7\u05d8\u05df");
        filePathList.add("big idatha");
        filePathList.add("rachel\u03c7");
        filePathList.add("jessica\u03bf");
        filePathList.add("sarah\u03b4");
        filePathList.add("katie\u03bd");
        filePathList.add("wendy\u03be");
        filePathList.add("david\u03bc");
        filePathList.add("priscilla\u03c5");
        filePathList.add("oscar\u03b8");
        filePathList.add("xavier\u03c7");
        filePathList.add("gabriella\u03b8");
        filePathList.add("david\u03c5");
        filePathList.add("irene\u03bc");
        filePathList.add("fred\u03c1");
        filePathList.add("david\u03c4");
        filePathList.add("ulysses\u03bd");
        filePathList.add("gabriella\u03bc");
        filePathList.add("zach\u03b6");
        filePathList.add("gabriella\u03bb");
        filePathList.add("ulysses\u03c6");
        filePathList.add("david\u03c7");
        filePathList.add("sarah\u03c3");
        filePathList.add("holly\u03c8");
        filePathList.add("nick\u03b1");
        filePathList.add("ulysses\u03b9");
        filePathList.add("mike\u03b2");
        filePathList.add("priscilla\u03ba");
        filePathList.add("wendy\u03b8");
        filePathList.add("jessica\u03c2");
        filePathList.add("fred\u03c7");
        filePathList.add("fred\u03b6");
        filePathList.add("sarah\u03ba");
        filePathList.add("calvin\u03b7");
        filePathList.add("xavier\u03c7");
        filePathList.add("yuri\u03c7");
        filePathList.add("ethan\u03bb");
        filePathList.add("holly\u03b5");
        filePathList.add("xavier\u03c3");
        filePathList.add("victor\u03c4");
        filePathList.add("wendy\u03b2");
        filePathList.add("jessica\u03c2");
        filePathList.add("quinn\u03c6");
        filePathList.add("xavier\u03c5");
        filePathList.add("nick\u03b9");
        filePathList.add("rachel\u03c6");
        filePathList.add("oscar\u03be");
        filePathList.add("zach\u03b4");
        filePathList.add("zach\u03bb");
        filePathList.add("rachel\u03b1");
        filePathList.add("jessica\u03c6");
        filePathList.add("luke\u03c6");
        filePathList.add("tom\u03b6");
        filePathList.add("nick\u03be");
        filePathList.add("nick\u03ba");
        filePathList.add("ethan\u03b4");
        filePathList.add("fred\u03c7");
        filePathList.add("priscilla\u03b8");
        filePathList.add("zach\u03be");
        filePathList.add("xavier\u03be");
        filePathList.add("zach\u03c8");
        filePathList.add("ethan\u03b1");
        filePathList.add("oscar\u03b9");
        filePathList.add("irene\u03b4");
        filePathList.add("irene\u03b6");
        filePathList.add("victor\u03bf");
        filePathList.add("wendy\u03b2");
        filePathList.add("mike\u03c3");
        filePathList.add("fred\u03bf");
        filePathList.add("mike\u03b7");
        filePathList.add("sarah\u03c1");
        filePathList.add("quinn\u03b2");
        filePathList.add("mike\u03c5");
        filePathList.add("nick\u03b6");
        filePathList.add("nick\u03bf");
        filePathList.add("tom\u03ba");
        filePathList.add("bob\u03bb");
        filePathList.add("yuri\u03c0");
        filePathList.add("david\u03c4");
        filePathList.add("quinn\u03c0");
        filePathList.add("mike\u03bb");
        filePathList.add("david\u03b7");
        filePathList.add("ethan\u03c4");
        filePathList.add("nick\u03c6");
        filePathList.add("yuri\u03bf");
        filePathList.add("ethan\u03c5");
        filePathList.add("bob\u03b8");
        filePathList.add("david\u03bb");
        filePathList.add("priscilla\u03be");
        filePathList.add("nick\u03b3");
        filePathList.add("luke\u03c5");
        filePathList.add("irene\u03bb");
        filePathList.add("xavier\u03bf");
        filePathList.add("fred\u03c5");
        filePathList.add("ulysses\u03bc");
        filePathList.add("wendy\u03b3");
        filePathList.add("zach\u03bb");
        filePathList.add("rachel\u03c2");
        filePathList.add("sarah\u03c0");
        filePathList.add("alice\u03c8");
        filePathList.add("bob\u03c4");
    }

    @AfterClass
    public static void testReport() throws IOException, URISyntaxException {
        if (!AdlStorageConfiguration.isContractTestEnabled()) {
            return;
        }
        FileSystem fs = AdlStorageConfiguration.createStorageConnector();
        fs.delete(new Path(TEST_ROOT), true);
    }

    @Test
    public void testAllowedSpecialCharactersMkdir() throws IOException, URISyntaxException {
        Path parentPath = new Path(TEST_ROOT, UUID.randomUUID().toString() + "/");
        Path specialFile = new Path(parentPath, this.path);
        FileSystem fs = AdlStorageConfiguration.createStorageConnector();
        Assert.assertTrue((String)("Mkdir failed : " + specialFile), (boolean)fs.mkdirs(specialFile));
        Assert.assertTrue((String)("File not Found after Mkdir success" + specialFile), (boolean)fs.exists(specialFile));
        Assert.assertTrue((String)("Not listed under parent " + parentPath), (boolean)this.contains(fs.listStatus(parentPath), fs.makeQualified(specialFile).toString()));
        Assert.assertTrue((String)("Delete failed : " + specialFile), (boolean)fs.delete(specialFile, true));
        Assert.assertFalse((String)("File still exist after delete " + specialFile), (boolean)fs.exists(specialFile));
    }

    private boolean contains(FileStatus[] statuses, String remotePath) {
        for (FileStatus status : statuses) {
            if (!status.getPath().toString().equals(remotePath)) continue;
            return true;
        }
        Arrays.stream(statuses).forEach(s -> LOG.info(s.getPath().toString()));
        return false;
    }

    @Before
    public void setup() throws Exception {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }

    @Test
    public void testAllowedSpecialCharactersRename() throws IOException, URISyntaxException {
        String parentPath = TEST_ROOT + UUID.randomUUID().toString() + "/";
        Path specialFile = new Path(parentPath + this.path);
        Path anotherLocation = new Path(parentPath + UUID.randomUUID().toString());
        FileSystem fs = AdlStorageConfiguration.createStorageConnector();
        Assert.assertTrue((String)("Could not create " + specialFile.toString()), (boolean)fs.createNewFile(specialFile));
        Assert.assertTrue((String)("Failed to rename " + specialFile.toString() + " --> " + anotherLocation.toString()), (boolean)fs.rename(specialFile, anotherLocation));
        Assert.assertFalse((String)("File should not be present after successful rename : " + specialFile.toString()), (boolean)fs.exists(specialFile));
        Assert.assertTrue((String)("File should be present after successful rename : " + anotherLocation.toString()), (boolean)fs.exists(anotherLocation));
        Assert.assertFalse((String)("Listed under parent whereas expected not listed : " + parentPath), (boolean)this.contains(fs.listStatus(new Path(parentPath)), fs.makeQualified(specialFile).toString()));
        Assert.assertTrue((String)("Failed to rename " + anotherLocation.toString() + " --> " + specialFile.toString()), (boolean)fs.rename(anotherLocation, specialFile));
        Assert.assertTrue((String)("File should be present after successful rename : " + specialFile.toString()), (boolean)fs.exists(specialFile));
        Assert.assertFalse((String)("File should not be present after successful rename : " + anotherLocation.toString()), (boolean)fs.exists(anotherLocation));
        Assert.assertTrue((String)("Not listed under parent " + parentPath), (boolean)this.contains(fs.listStatus(new Path(parentPath)), fs.makeQualified(specialFile).toString()));
        Assert.assertTrue((String)("Failed to delete " + parentPath), (boolean)fs.delete(new Path(parentPath), true));
    }
}

