/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class S3Guard {
    private static final Logger LOG = LoggerFactory.getLogger(S3Guard.class);
    static final String NULL_METADATA_STORE = "org.apache.hadoop.fs.s3a.s3guard.NullMetadataStore";

    private S3Guard() {
    }

    public static boolean checkNoS3Guard(URI fsURI, Configuration conf) throws PathIOException {
        String classname = conf.getTrimmed("fs.s3a.metadatastore.impl", "");
        if (classname.isEmpty()) {
            return false;
        }
        String[] sources = conf.getPropertySources("fs.s3a.metadatastore.impl");
        String origin = sources == null ? "unknown" : sources[0];
        String fsPath = fsURI.toString();
        switch (classname) {
            case "org.apache.hadoop.fs.s3a.s3guard.NullMetadataStore": {
                LOG.debug("Ignoring S3Guard store option of {} -no longer needed Origin {}", (Object)NULL_METADATA_STORE, (Object)origin);
                break;
            }
            case "org.apache.hadoop.fs.s3a.s3guard.LocalMetadataStore": {
                LOG.warn("Ignoring S3Guard store option of {} -no longer needed or supported. Origin {}", (Object)"org.apache.hadoop.fs.s3a.s3guard.LocalMetadataStore", (Object)origin);
                break;
            }
            case "org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore": {
                String message = String.format("S3Guard is no longer needed/supported, yet %s is configured to use DynamoDB as the S3Guard metadata store. This is no longer needed or supported. Origin of setting is %s", fsPath, origin);
                LOG.error(message);
                throw new PathIOException(fsPath, message);
            }
            default: {
                throw new PathIOException(fsPath, "Filesystem is configured to use unknown S3Guard store " + classname + " origin " + origin);
            }
        }
        return true;
    }

    @VisibleForTesting
    static Collection<String> getAuthoritativePaths(URI uri, Configuration conf, Function<Path, String> qualifyToDir) {
        String[] rawAuthoritativePaths = conf.getTrimmedStrings("fs.s3a.authoritative.path", Constants.DEFAULT_AUTHORITATIVE_PATH);
        ArrayList<String> authoritativePaths = new ArrayList<String>();
        if (rawAuthoritativePaths.length > 0) {
            for (int i = 0; i < rawAuthoritativePaths.length; ++i) {
                Path path = new Path(rawAuthoritativePaths[i]);
                URI pathURI = path.toUri();
                if (pathURI.getAuthority() != null && !pathURI.getAuthority().equals(uri.getAuthority()) || pathURI.getScheme() != null && !pathURI.getScheme().equals(uri.getScheme())) continue;
                authoritativePaths.add(qualifyToDir.apply(path));
            }
        }
        return authoritativePaths;
    }

    public static boolean allowAuthoritative(Path p, S3AFileSystem fs, Collection<String> authPaths) {
        String haystack = fs.maybeAddTrailingSlash(fs.qualify(p).toString());
        if (!authPaths.isEmpty()) {
            for (String needle : authPaths) {
                if (!haystack.startsWith(needle)) continue;
                return true;
            }
        }
        return false;
    }
}

