/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.util.Arrays;
import java.util.EnumSet;
import org.apache.hadoop.fs.s3a.VectoredIOContext;

public class StreamFactoryRequirements {
    private final int sharedThreads;
    private final int streamThreads;
    private final VectoredIOContext vectoredIOContext;
    private final EnumSet<Requirements> requirementFlags;

    public StreamFactoryRequirements(int sharedThreads, int streamThreads, VectoredIOContext vectoredIOContext, Requirements ... requirements) {
        this.sharedThreads = sharedThreads;
        this.streamThreads = streamThreads;
        this.vectoredIOContext = vectoredIOContext.build();
        this.requirementFlags = requirements.length == 0 ? EnumSet.noneOf(Requirements.class) : EnumSet.copyOf(Arrays.asList(requirements));
    }

    public int sharedThreads() {
        return this.sharedThreads;
    }

    public int streamThreads() {
        return this.streamThreads;
    }

    public boolean requiresFuturePool() {
        return this.requires(Requirements.RequiresFuturePool);
    }

    public VectoredIOContext vectoredIOContext() {
        return this.vectoredIOContext;
    }

    public boolean requires(Requirements r) {
        return this.requirementFlags.contains((Object)r);
    }

    public String toString() {
        return "StreamFactoryRequirements{sharedThreads=" + this.sharedThreads + ", streamThreads=" + this.streamThreads + ", requirementFlags=" + this.requirementFlags + ", vectoredIOContext=" + this.vectoredIOContext + "}";
    }

    public static enum Requirements {
        ExpectUnauditedGetRequests,
        RequiresFuturePool;

    }
}

