/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.LeakReporter;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.VectoredIOContext;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectInputStream
extends FSInputStream
implements StreamCapabilities,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectInputStream.class);
    private final IOStatistics ioStatistics;
    private final S3AReadOpContext context;
    private final ObjectInputStreamCallbacks callbacks;
    private final ExecutorService boundedThreadPool;
    private final String uri;
    private final String bucket;
    private final String key;
    private final String pathStr;
    private final long contentLength;
    private final S3ObjectAttributes objectAttributes;
    private final S3AInputStreamStatistics streamStatistics;
    private final IOStatisticsAggregator threadIOStatistics;
    private final LeakReporter leakReporter;
    private final InputStreamType streamType;
    private S3AInputPolicy inputPolicy;
    private final VectoredIOContext vectoredIOContext;

    protected ObjectInputStream(InputStreamType streamType, ObjectReadParameters parameters) {
        this.streamType = Objects.requireNonNull(streamType);
        this.objectAttributes = parameters.getObjectAttributes();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.objectAttributes.getBucket()), (Object)"No Bucket");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.objectAttributes.getKey()), (Object)"No Key");
        long l = this.objectAttributes.getLen();
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Negative content length");
        this.context = parameters.getContext();
        this.contentLength = l;
        this.bucket = this.objectAttributes.getBucket();
        this.key = this.objectAttributes.getKey();
        this.pathStr = this.objectAttributes.getPath().toString();
        this.callbacks = parameters.getCallbacks();
        this.uri = "s3a://" + this.bucket + "/" + this.key;
        this.streamStatistics = parameters.getStreamStatistics();
        this.ioStatistics = this.streamStatistics.getIOStatistics();
        this.inputPolicy = this.context.getInputPolicy();
        this.streamStatistics.inputPolicySet(this.inputPolicy.ordinal());
        this.boundedThreadPool = parameters.getBoundedThreadPool();
        this.threadIOStatistics = Objects.requireNonNull(this.context.getIOStatisticsAggregator());
        this.leakReporter = new LeakReporter("Stream not closed while reading " + this.uri, this::isStreamOpen, this::abortInFinalizer);
        this.vectoredIOContext = this.getContext().getVectoredIOContext();
    }

    protected abstract boolean isStreamOpen();

    protected abstract void abortInFinalizer();

    public synchronized void close() throws IOException {
        this.callbacks.close();
        this.streamStatistics.close();
        this.mergeThreadIOStatistics(this.streamStatistics.getIOStatistics());
    }

    protected void mergeThreadIOStatistics(IOStatistics streamIOStats) {
        this.threadIOStatistics.aggregate(streamIOStats);
    }

    protected void finalize() throws Throwable {
        this.leakReporter.close();
        super.finalize();
    }

    @VisibleForTesting
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    protected void setInputPolicy(S3AInputPolicy inputPolicy) {
        LOG.debug("Switching to input policy {}", (Object)inputPolicy);
        this.inputPolicy = inputPolicy;
        this.streamStatistics.inputPolicySet(inputPolicy.ordinal());
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public S3AInputStreamStatistics getS3AStreamStatistics() {
        return this.streamStatistics;
    }

    public IOStatistics getIOStatistics() {
        return this.ioStatistics;
    }

    public boolean hasCapability(String capability) {
        switch (org.apache.hadoop.util.StringUtils.toLowerCase((String)capability)) {
            case "iostatistics": 
            case "stream_leaks": {
                return true;
            }
        }
        return this.streamType.capability().equals(capability);
    }

    protected final S3AReadOpContext getContext() {
        return this.context;
    }

    protected final ObjectInputStreamCallbacks getCallbacks() {
        return this.callbacks;
    }

    protected final ExecutorService getBoundedThreadPool() {
        return this.boundedThreadPool;
    }

    protected final String getUri() {
        return this.uri;
    }

    protected final String getBucket() {
        return this.bucket;
    }

    protected final String getKey() {
        return this.key;
    }

    protected final String getPathStr() {
        return this.pathStr;
    }

    protected final long getContentLength() {
        return this.contentLength;
    }

    protected final IOStatisticsAggregator getThreadIOStatistics() {
        return this.threadIOStatistics;
    }

    protected final S3ObjectAttributes getObjectAttributes() {
        return this.objectAttributes;
    }

    protected VectoredIOContext getVectoredIOContext() {
        return this.vectoredIOContext;
    }

    public int minSeekForVectorReads() {
        return this.vectoredIOContext.getMinSeekForVectorReads();
    }

    public int maxReadSizeForVectorReads() {
        return this.vectoredIOContext.getMaxReadSizeForVectorReads();
    }

    public InputStreamType streamType() {
        return this.streamType;
    }

    public String toString() {
        return "ObjectInputStream{streamType=" + this.streamType + ", uri='" + this.uri + "', contentLength=" + this.contentLength + ", inputPolicy=" + this.inputPolicy + ", vectoredIOContext=" + this.vectoredIOContext + "} " + super.toString();
    }
}

