/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.VectoredIOContext;
import org.apache.hadoop.fs.s3a.impl.streams.AbstractObjectInputStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.AnalyticsStream;
import org.apache.hadoop.fs.s3a.impl.streams.FactoryBindingParameters;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.impl.streams.StreamFactoryRequirements;
import org.apache.hadoop.fs.s3a.impl.streams.StreamIntegration;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.LazyAutoCloseableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStreamConfiguration;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStreamFactory;
import software.amazon.s3.analyticsaccelerator.S3SyncSdkObjectClient;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;

public class AnalyticsStreamFactory
extends AbstractObjectInputStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsStreamFactory.class);
    private S3SeekableInputStreamConfiguration seekableInputStreamConfiguration;
    private LazyAutoCloseableReference<S3SeekableInputStreamFactory> s3SeekableInputStreamFactory;
    private boolean requireCrt;

    public AnalyticsStreamFactory() {
        super("AnalyticsStreamFactory");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        ConnectorConfiguration configuration = new ConnectorConfiguration((Iterable)conf, "fs.s3a.analytics.accelerator");
        this.seekableInputStreamConfiguration = S3SeekableInputStreamConfiguration.fromConfiguration((ConnectorConfiguration)configuration);
        this.requireCrt = false;
    }

    @Override
    public void bind(FactoryBindingParameters factoryBindingParameters) throws IOException {
        super.bind(factoryBindingParameters);
        this.s3SeekableInputStreamFactory = new LazyAutoCloseableReference(this.createS3SeekableInputStreamFactory());
    }

    @Override
    public ObjectInputStream readObject(ObjectReadParameters parameters) throws IOException {
        return new AnalyticsStream(parameters, this.getOrCreateS3SeekableInputStreamFactory());
    }

    @Override
    public InputStreamType streamType() {
        return InputStreamType.Analytics;
    }

    @Override
    public StreamFactoryRequirements factoryRequirements() {
        VectoredIOContext vectorContext = StreamIntegration.populateVectoredIOContext(this.getConfig());
        vectorContext.setMinSeekForVectoredReads(0);
        return new StreamFactoryRequirements(0, 0, vectorContext, new StreamFactoryRequirements.Requirements[0]);
    }

    protected void serviceStop() throws Exception {
        try {
            this.s3SeekableInputStreamFactory.close();
        }
        catch (Exception ignored) {
            LOG.debug("Ignored exception while closing stream factory", (Throwable)ignored);
        }
        this.callbacks().incrementFactoryStatistic(Statistic.ANALYTICS_STREAM_FACTORY_CLOSED);
        super.serviceStop();
    }

    private S3SeekableInputStreamFactory getOrCreateS3SeekableInputStreamFactory() throws IOException {
        return (S3SeekableInputStreamFactory)this.s3SeekableInputStreamFactory.eval();
    }

    private CallableRaisingIOE<S3SeekableInputStreamFactory> createS3SeekableInputStreamFactory() {
        return () -> new S3SeekableInputStreamFactory((ObjectClient)new S3SyncSdkObjectClient(this.callbacks().getOrCreateSyncClient()), this.seekableInputStreamConfiguration);
    }
}

