/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3AEncryption {
    private static final Logger LOG = LoggerFactory.getLogger(S3AEncryption.class);

    private S3AEncryption() {
    }

    public static String getS3EncryptionContext(String bucket, Configuration conf) throws IOException {
        String encryptionContext = S3AUtils.lookupBucketSecret(bucket, conf, "fs.s3a.encryption.context");
        if (encryptionContext == null) {
            encryptionContext = S3AUtils.lookupPassword(null, conf, "fs.s3a.encryption.context");
        }
        if (encryptionContext == null) {
            return "";
        }
        return encryptionContext;
    }

    public static String getS3EncryptionContextBase64Encoded(String bucket, Configuration conf, boolean propagateExceptions) throws IOException {
        try {
            String encryptionContextValue = S3AEncryption.getS3EncryptionContext(bucket, conf);
            if (StringUtils.isBlank((CharSequence)encryptionContextValue)) {
                return "";
            }
            Map<String, String> encryptionContextMap = S3AUtils.getTrimmedStringCollectionSplitByEquals(encryptionContextValue);
            if (encryptionContextMap.isEmpty()) {
                return "";
            }
            String encryptionContextJson = new ObjectMapper().writeValueAsString(encryptionContextMap);
            return Base64.encodeBase64String((byte[])encryptionContextJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            if (propagateExceptions) {
                throw e;
            }
            LOG.warn("Cannot retrieve {} for bucket {}", new Object[]{"fs.s3a.encryption.context", bucket, e});
            return "";
        }
    }
}

