/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecretOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.impl.AWSClientConfig;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.impl.write.WriteObjectFlags;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.MetadataDirective;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.SdkPartType;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.Md5Utils;

public class RequestFactoryImpl
implements RequestFactory {
    public static final Logger LOG = LoggerFactory.getLogger(RequestFactoryImpl.class);
    private final String bucket;
    private EncryptionSecrets encryptionSecrets;
    private final String cannedACL;
    private final long multipartPartCountLimit;
    private final PrepareRequest requestPreparer;
    private final String contentEncoding;
    private final StorageClass storageClass;
    private final boolean isMultipartUploadEnabled;
    private final Duration partUploadTimeout;
    private final ChecksumAlgorithm checksumAlgorithm;

    protected RequestFactoryImpl(RequestFactoryBuilder builder) {
        this.bucket = builder.bucket;
        this.cannedACL = builder.cannedACL;
        this.encryptionSecrets = builder.encryptionSecrets;
        this.multipartPartCountLimit = builder.multipartPartCountLimit;
        this.requestPreparer = builder.requestPreparer;
        this.contentEncoding = builder.contentEncoding;
        this.storageClass = builder.storageClass;
        this.isMultipartUploadEnabled = builder.isMultipartUploadEnabled;
        this.partUploadTimeout = builder.partUploadTimeout;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    private <T extends SdkRequest.Builder> T prepareRequest(T t) {
        if (this.requestPreparer != null) {
            this.requestPreparer.prepareRequest(t);
        }
        return t;
    }

    @Override
    public String getCannedACL() {
        return this.cannedACL;
    }

    protected String getBucket() {
        return this.bucket;
    }

    @Override
    public S3AEncryptionMethods getServerSideEncryptionAlgorithm() {
        return this.encryptionSecrets.getEncryptionMethod();
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    protected void uploadPartEncryptionParameters(UploadPartRequest.Builder builder) {
        EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> builder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
    }

    private CopyObjectRequest.Builder buildCopyObjectRequest() {
        CopyObjectRequest.Builder copyObjectRequestBuilder = CopyObjectRequest.builder();
        if (this.contentEncoding != null) {
            copyObjectRequestBuilder.contentEncoding(this.contentEncoding);
        }
        if (this.checksumAlgorithm != null) {
            copyObjectRequestBuilder.checksumAlgorithm(this.checksumAlgorithm);
        }
        return copyObjectRequestBuilder;
    }

    @Override
    public CopyObjectRequest.Builder newCopyObjectRequestBuilder(String srcKey, String dstKey, HeadObjectResponse srcom) {
        CopyObjectRequest.Builder copyObjectRequestBuilder = this.buildCopyObjectRequest();
        HashMap<String, String> dstom = new HashMap<String, String>();
        HeaderProcessing.cloneObjectMetadata(srcom, dstom, copyObjectRequestBuilder);
        this.copyEncryptionParameters(srcom, copyObjectRequestBuilder);
        copyObjectRequestBuilder.metadata(dstom).metadataDirective(MetadataDirective.REPLACE).acl(this.cannedACL);
        if (srcom.storageClass() != null && srcom.storageClass() != StorageClass.UNKNOWN_TO_SDK_VERSION) {
            copyObjectRequestBuilder.storageClass(srcom.storageClass());
        }
        copyObjectRequestBuilder.destinationBucket(this.getBucket()).destinationKey(dstKey).sourceBucket(this.getBucket()).sourceKey(srcKey);
        return this.prepareRequest(copyObjectRequestBuilder);
    }

    protected void copyEncryptionParameters(HeadObjectResponse srcom, CopyObjectRequest.Builder copyObjectRequestBuilder) {
        S3AEncryptionMethods algorithm = this.getServerSideEncryptionAlgorithm();
        String sourceKMSId = srcom.ssekmsKeyId();
        if (StringUtils.isNotEmpty((CharSequence)sourceKMSId)) {
            LOG.debug("Propagating SSE-KMS settings from source {}", (Object)sourceKMSId);
            copyObjectRequestBuilder.ssekmsKeyId(sourceKMSId);
            EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((CopyObjectRequest.Builder)copyObjectRequestBuilder).ssekmsEncryptionContext(arg_0));
            return;
        }
        switch (algorithm) {
            case SSE_S3: {
                copyObjectRequestBuilder.serverSideEncryption(algorithm.getMethod());
                break;
            }
            case SSE_KMS: {
                copyObjectRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS);
                EncryptionSecretOperations.getSSEAwsKMSKey(this.encryptionSecrets).ifPresent(arg_0 -> ((CopyObjectRequest.Builder)copyObjectRequestBuilder).ssekmsKeyId(arg_0));
                EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((CopyObjectRequest.Builder)copyObjectRequestBuilder).ssekmsEncryptionContext(arg_0));
                break;
            }
            case DSSE_KMS: {
                copyObjectRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS_DSSE);
                EncryptionSecretOperations.getSSEAwsKMSKey(this.encryptionSecrets).ifPresent(arg_0 -> ((CopyObjectRequest.Builder)copyObjectRequestBuilder).ssekmsKeyId(arg_0));
                EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((CopyObjectRequest.Builder)copyObjectRequestBuilder).ssekmsEncryptionContext(arg_0));
                break;
            }
            case SSE_C: {
                EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> copyObjectRequestBuilder.copySourceSSECustomerAlgorithm(ServerSideEncryption.AES256.name()).copySourceSSECustomerKey(base64customerKey).copySourceSSECustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))).sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
                break;
            }
            case CSE_KMS: 
            case CSE_CUSTOM: 
            case NONE: {
                break;
            }
            default: {
                LOG.warn("Unknown encryption algorithm : " + algorithm);
            }
        }
    }

    @Override
    public PutObjectRequest.Builder newPutObjectRequestBuilder(String key, PutObjectOptions options, long length, boolean isDirectoryMarker) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)"Null/empty key");
        PutObjectRequest.Builder putObjectRequestBuilder = this.buildPutObjectRequest(length, isDirectoryMarker);
        putObjectRequestBuilder.bucket(this.getBucket()).key(key);
        if (options != null) {
            putObjectRequestBuilder.metadata(options.getHeaders());
        }
        this.putEncryptionParameters(putObjectRequestBuilder);
        if (this.storageClass != null) {
            putObjectRequestBuilder.storageClass(this.storageClass);
        }
        if (!isDirectoryMarker) {
            AWSClientConfig.setRequestTimeout((AwsRequest.Builder)putObjectRequestBuilder, this.partUploadTimeout);
        }
        if (options != null) {
            if (options.isNoObjectOverwrite()) {
                LOG.debug("setting If-None-Match");
                putObjectRequestBuilder.overrideConfiguration(override -> override.putHeader("If-None-Match", "*"));
            }
            if (options.hasFlag(WriteObjectFlags.ConditionalOverwriteEtag)) {
                LOG.debug("setting If-Match");
                putObjectRequestBuilder.overrideConfiguration(override -> override.putHeader("If-Match", options.getEtagOverwrite()));
            }
        }
        return this.prepareRequest(putObjectRequestBuilder);
    }

    private PutObjectRequest.Builder buildPutObjectRequest(long length, boolean isDirectoryMarker) {
        PutObjectRequest.Builder putObjectRequestBuilder = PutObjectRequest.builder();
        putObjectRequestBuilder.acl(this.cannedACL);
        if (length >= 0L) {
            putObjectRequestBuilder.contentLength(Long.valueOf(length));
        }
        if (this.contentEncoding != null && !isDirectoryMarker) {
            putObjectRequestBuilder.contentEncoding(this.contentEncoding);
        }
        if (this.checksumAlgorithm != null) {
            putObjectRequestBuilder.checksumAlgorithm(this.checksumAlgorithm);
        }
        return putObjectRequestBuilder;
    }

    private void putEncryptionParameters(PutObjectRequest.Builder putObjectRequestBuilder) {
        S3AEncryptionMethods algorithm = this.getServerSideEncryptionAlgorithm();
        switch (algorithm) {
            case SSE_S3: {
                putObjectRequestBuilder.serverSideEncryption(algorithm.getMethod());
                break;
            }
            case SSE_KMS: {
                putObjectRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS);
                EncryptionSecretOperations.getSSEAwsKMSKey(this.encryptionSecrets).ifPresent(arg_0 -> ((PutObjectRequest.Builder)putObjectRequestBuilder).ssekmsKeyId(arg_0));
                EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((PutObjectRequest.Builder)putObjectRequestBuilder).ssekmsEncryptionContext(arg_0));
                break;
            }
            case DSSE_KMS: {
                putObjectRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS_DSSE);
                EncryptionSecretOperations.getSSEAwsKMSKey(this.encryptionSecrets).ifPresent(arg_0 -> ((PutObjectRequest.Builder)putObjectRequestBuilder).ssekmsKeyId(arg_0));
                EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((PutObjectRequest.Builder)putObjectRequestBuilder).ssekmsEncryptionContext(arg_0));
                break;
            }
            case SSE_C: {
                EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> putObjectRequestBuilder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
                break;
            }
            case CSE_KMS: 
            case CSE_CUSTOM: 
            case NONE: {
                break;
            }
            default: {
                LOG.warn("Unknown encryption algorithm : " + algorithm);
            }
        }
    }

    @Override
    public PutObjectRequest.Builder newDirectoryMarkerRequest(String directory) {
        Object key = directory.endsWith("/") ? directory : directory + "/";
        PutObjectRequest.Builder putObjectRequestBuilder = this.buildPutObjectRequest(0L, true);
        putObjectRequestBuilder.bucket(this.getBucket()).key((String)key).contentType("application/x-directory");
        this.putEncryptionParameters(putObjectRequestBuilder);
        return this.prepareRequest(putObjectRequestBuilder);
    }

    @Override
    public ListMultipartUploadsRequest.Builder newListMultipartUploadsRequestBuilder(String prefix) {
        ListMultipartUploadsRequest.Builder requestBuilder = ListMultipartUploadsRequest.builder();
        requestBuilder.bucket(this.getBucket());
        if (prefix != null) {
            requestBuilder.prefix(prefix);
        }
        return this.prepareRequest(requestBuilder);
    }

    @Override
    public AbortMultipartUploadRequest.Builder newAbortMultipartUploadRequestBuilder(String destKey, String uploadId) {
        AbortMultipartUploadRequest.Builder requestBuilder = AbortMultipartUploadRequest.builder().bucket(this.getBucket()).key(destKey).uploadId(uploadId);
        return this.prepareRequest(requestBuilder);
    }

    private void multipartUploadEncryptionParameters(CreateMultipartUploadRequest.Builder mpuRequestBuilder) {
        S3AEncryptionMethods algorithm = this.getServerSideEncryptionAlgorithm();
        switch (algorithm) {
            case SSE_S3: {
                mpuRequestBuilder.serverSideEncryption(algorithm.getMethod());
                break;
            }
            case SSE_KMS: {
                mpuRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS);
                EncryptionSecretOperations.getSSEAwsKMSKey(this.encryptionSecrets).ifPresent(arg_0 -> ((CreateMultipartUploadRequest.Builder)mpuRequestBuilder).ssekmsKeyId(arg_0));
                EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((CreateMultipartUploadRequest.Builder)mpuRequestBuilder).ssekmsEncryptionContext(arg_0));
                break;
            }
            case DSSE_KMS: {
                mpuRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS_DSSE);
                EncryptionSecretOperations.getSSEAwsKMSKey(this.encryptionSecrets).ifPresent(arg_0 -> ((CreateMultipartUploadRequest.Builder)mpuRequestBuilder).ssekmsKeyId(arg_0));
                EncryptionSecretOperations.getSSEAwsKMSEncryptionContext(this.encryptionSecrets).ifPresent(arg_0 -> ((CreateMultipartUploadRequest.Builder)mpuRequestBuilder).ssekmsEncryptionContext(arg_0));
                break;
            }
            case SSE_C: {
                EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> mpuRequestBuilder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
                break;
            }
            case CSE_KMS: 
            case CSE_CUSTOM: 
            case NONE: {
                break;
            }
            default: {
                LOG.warn("Unknown encryption algorithm : " + algorithm);
            }
        }
    }

    @Override
    public CreateMultipartUploadRequest.Builder newMultipartUploadRequestBuilder(String destKey, @Nullable PutObjectOptions options) throws PathIOException {
        if (!this.isMultipartUploadEnabled) {
            throw new PathIOException(destKey, "Multipart uploads are disabled.");
        }
        CreateMultipartUploadRequest.Builder requestBuilder = CreateMultipartUploadRequest.builder();
        if (this.contentEncoding != null) {
            requestBuilder.contentEncoding(this.contentEncoding);
        }
        if (options != null) {
            requestBuilder.metadata(options.getHeaders());
        }
        requestBuilder.bucket(this.getBucket()).key(destKey).acl(this.cannedACL);
        this.multipartUploadEncryptionParameters(requestBuilder);
        if (this.storageClass != null) {
            requestBuilder.storageClass(this.storageClass);
        }
        if (this.checksumAlgorithm != null) {
            requestBuilder.checksumAlgorithm(this.checksumAlgorithm);
        }
        return this.prepareRequest(requestBuilder);
    }

    @Override
    public CompleteMultipartUploadRequest.Builder newCompleteMultipartUploadRequestBuilder(String destKey, String uploadId, List<CompletedPart> partETags, PutObjectOptions putOptions) {
        CompleteMultipartUploadRequest.Builder requestBuilder = CompleteMultipartUploadRequest.builder().bucket(this.bucket).key(destKey).uploadId(uploadId).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(partETags).build());
        if (putOptions.isNoObjectOverwrite()) {
            LOG.debug("setting If-None-Match");
            requestBuilder.overrideConfiguration(override -> override.putHeader("If-None-Match", "*"));
        }
        if (!StringUtils.isEmpty((CharSequence)putOptions.getEtagOverwrite())) {
            LOG.debug("setting if If-Match");
            requestBuilder.overrideConfiguration(override -> override.putHeader("If-Match", putOptions.getEtagOverwrite()));
        }
        if (this.checksumAlgorithm != null && this.getServerSideEncryptionAlgorithm() == S3AEncryptionMethods.SSE_C) {
            EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> requestBuilder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
        }
        return this.prepareRequest(requestBuilder);
    }

    @Override
    public HeadObjectRequest.Builder newHeadObjectRequestBuilder(String key) {
        HeadObjectRequest.Builder headObjectRequestBuilder = HeadObjectRequest.builder().bucket(this.getBucket()).key(key);
        EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> headObjectRequestBuilder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
        return this.prepareRequest(headObjectRequestBuilder);
    }

    @Override
    public HeadBucketRequest.Builder newHeadBucketRequestBuilder(String bucketName) {
        HeadBucketRequest.Builder headBucketRequestBuilder = HeadBucketRequest.builder().bucket(bucketName);
        return this.prepareRequest(headBucketRequestBuilder);
    }

    @Override
    public GetObjectRequest.Builder newGetObjectRequestBuilder(String key) {
        GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(this.bucket).key(key);
        EncryptionSecretOperations.getSSECustomerKey(this.encryptionSecrets).ifPresent(base64customerKey -> builder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(base64customerKey).sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])Base64.getDecoder().decode((String)base64customerKey))));
        return this.prepareRequest(builder);
    }

    @Override
    public UploadPartRequest.Builder newUploadPartRequestBuilder(String destKey, String uploadId, int partNumber, boolean isLastPart, long size) throws PathIOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"Invalid partition size %s", (Object[])new Object[]{size});
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber must be between 1 and %s inclusive, but is %s", (Object[])new Object[]{this.multipartPartCountLimit, partNumber});
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        String pathErrorMsg = "Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ";
        if ((long)partNumber > this.multipartPartCountLimit) {
            throw new PathIOException(destKey, String.format("Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ", partNumber, this.multipartPartCountLimit));
        }
        UploadPartRequest.Builder builder = UploadPartRequest.builder().bucket(this.getBucket()).key(destKey).uploadId(uploadId).partNumber(Integer.valueOf(partNumber)).contentLength(Long.valueOf(size));
        if (isLastPart) {
            builder.sdkPartType(SdkPartType.LAST);
        }
        this.uploadPartEncryptionParameters(builder);
        AWSClientConfig.setRequestTimeout((AwsRequest.Builder)builder, this.partUploadTimeout);
        if (this.checksumAlgorithm != null) {
            builder.checksumAlgorithm(this.checksumAlgorithm);
        }
        return this.prepareRequest(builder);
    }

    @Override
    public ListObjectsRequest.Builder newListObjectsV1RequestBuilder(String key, String delimiter, int maxKeys) {
        ListObjectsRequest.Builder requestBuilder = ListObjectsRequest.builder().bucket(this.bucket).maxKeys(Integer.valueOf(maxKeys)).prefix(key);
        if (delimiter != null) {
            requestBuilder.delimiter(delimiter);
        }
        return this.prepareRequest(requestBuilder);
    }

    @Override
    public ListObjectsV2Request.Builder newListObjectsV2RequestBuilder(String key, String delimiter, int maxKeys) {
        ListObjectsV2Request.Builder requestBuilder = ListObjectsV2Request.builder().bucket(this.bucket).maxKeys(Integer.valueOf(maxKeys)).prefix(key);
        if (delimiter != null) {
            requestBuilder.delimiter(delimiter);
        }
        return this.prepareRequest(requestBuilder);
    }

    @Override
    public DeleteObjectRequest.Builder newDeleteObjectRequestBuilder(String key) {
        return this.prepareRequest(DeleteObjectRequest.builder().bucket(this.bucket).key(key));
    }

    @Override
    public DeleteObjectsRequest.Builder newBulkDeleteRequestBuilder(List<ObjectIdentifier> keysToDelete) {
        return this.prepareRequest(DeleteObjectsRequest.builder().bucket(this.bucket).delete(d -> d.objects((Collection)keysToDelete).quiet(Boolean.valueOf(!LOG.isTraceEnabled()))));
    }

    @Override
    public void setEncryptionSecrets(EncryptionSecrets secrets) {
        this.encryptionSecrets = secrets;
    }

    public static RequestFactoryBuilder builder() {
        return new RequestFactoryBuilder();
    }

    public static final class RequestFactoryBuilder {
        private String bucket;
        private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
        private String cannedACL = null;
        private String contentEncoding;
        private StorageClass storageClass;
        private long multipartPartCountLimit = 10000L;
        private PrepareRequest requestPreparer;
        private boolean isMultipartUploadEnabled = true;
        private Duration partUploadTimeout = Constants.DEFAULT_PART_UPLOAD_TIMEOUT;
        private ChecksumAlgorithm checksumAlgorithm;

        private RequestFactoryBuilder() {
        }

        public RequestFactory build() {
            return new RequestFactoryImpl(this);
        }

        public RequestFactoryBuilder withContentEncoding(String value) {
            this.contentEncoding = value;
            return this;
        }

        public RequestFactoryBuilder withStorageClass(StorageClass value) {
            this.storageClass = value;
            return this;
        }

        public RequestFactoryBuilder withBucket(String value) {
            this.bucket = value;
            return this;
        }

        public RequestFactoryBuilder withEncryptionSecrets(EncryptionSecrets value) {
            this.encryptionSecrets = value;
            return this;
        }

        public RequestFactoryBuilder withCannedACL(String value) {
            this.cannedACL = value;
            return this;
        }

        public RequestFactoryBuilder withMultipartPartCountLimit(long value) {
            this.multipartPartCountLimit = value;
            return this;
        }

        public RequestFactoryBuilder withRequestPreparer(PrepareRequest value) {
            this.requestPreparer = value;
            return this;
        }

        public RequestFactoryBuilder withMultipartUploadEnabled(boolean value) {
            this.isMultipartUploadEnabled = value;
            return this;
        }

        public RequestFactoryBuilder withPartUploadTimeout(Duration value) {
            this.partUploadTimeout = value;
            return this;
        }

        public RequestFactoryBuilder withChecksumAlgorithm(ChecksumAlgorithm value) {
            this.checksumAlgorithm = value;
            return this;
        }
    }

    @FunctionalInterface
    public static interface PrepareRequest {
        public void prepareRequest(SdkRequest.Builder var1);
    }
}

