/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.HttpChannelEOFException;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;

public final class ErrorTranslation {
    public static final String OPENSSL_STREAM_CLOSED = "WFOPENSSL0035";
    private static final String RAW_NO_HTTP_RESPONSE_EXCEPTION = "org.apache.http.NoHttpResponseException";
    private static final String SHADED_NO_HTTP_RESPONSE_EXCEPTION = "software.amazon.awssdk.thirdparty.org.apache.http.NoHttpResponseException";
    private static final String S3_ENCRYPTION_CLIENT_EXCEPTION = "software.amazon.encryption.s3.S3EncryptionClientException";

    private ErrorTranslation() {
    }

    public static boolean isUnknownBucket(AwsServiceException e) {
        return e.statusCode() == 404 && "NoSuchBucket".equals(e.awsErrorDetails().errorCode());
    }

    public static boolean isObjectNotFound(AwsServiceException e) {
        return e.statusCode() == 404 && !ErrorTranslation.isUnknownBucket(e);
    }

    private static Throwable getInnermostThrowable(Throwable thrown, Throwable outer) {
        if (thrown == null) {
            return outer;
        }
        return ErrorTranslation.getInnermostThrowable(thrown.getCause(), thrown);
    }

    public static SdkException maybeProcessEncryptionClientException(SdkException exception) {
        if (exception == null) {
            return null;
        }
        if (!exception.toString().contains(S3_ENCRYPTION_CLIENT_EXCEPTION)) {
            return exception;
        }
        Throwable cause = exception.getCause();
        if (!(cause instanceof SdkException)) {
            return exception;
        }
        SdkException sdkCause = (SdkException)cause;
        if (sdkCause.getCause() instanceof AwsServiceException) {
            return (SdkException)sdkCause.getCause();
        }
        return sdkCause;
    }

    public static IOException maybeExtractIOException(String path, Throwable thrown, String message) {
        if (thrown == null) {
            return null;
        }
        Throwable cause = ErrorTranslation.getInnermostThrowable(thrown.getCause(), thrown);
        HttpChannelEOFException channelException = ErrorTranslation.maybeExtractChannelException(path, message, cause);
        if (channelException != null) {
            return channelException;
        }
        if (!(cause instanceof IOException)) {
            return null;
        }
        IOException ioe = (IOException)cause;
        return ErrorTranslation.wrapWithInnerIOE(path, message, thrown, ioe);
    }

    private static <T extends IOException> IOException wrapWithInnerIOE(String path, String message, Throwable outer, T inner) {
        String msg = (String)(StringUtils.isNotEmpty((CharSequence)message) ? message + ":    " : "") + outer.toString() + ": " + inner.getMessage();
        Class<?> clazz = inner.getClass();
        try {
            Constructor<?> ctor = clazz.getConstructor(String.class);
            Throwable t = (Throwable)ctor.newInstance(msg);
            return (IOException)t.initCause(outer);
        }
        catch (Throwable e) {
            return new PathIOException(path, msg, outer);
        }
    }

    @VisibleForTesting
    public static HttpChannelEOFException maybeExtractChannelException(String path, String message, Throwable thrown) {
        String classname = thrown.getClass().getName();
        if (thrown instanceof IOException && (classname.equals(RAW_NO_HTTP_RESPONSE_EXCEPTION) || classname.equals(SHADED_NO_HTTP_RESPONSE_EXCEPTION))) {
            return new HttpChannelEOFException(path, message, thrown);
        }
        if (thrown.getMessage().contains(OPENSSL_STREAM_CLOSED)) {
            return new HttpChannelEOFException(path, message, thrown);
        }
        return null;
    }

    public static final class AwsErrorCodes {
        public static final String E_NO_SUCH_BUCKET = "NoSuchBucket";

        private AwsErrorCodes() {
        }
    }
}

