/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirMarkerTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DirMarkerTracker.class);
    private final Map<Path, Marker> leafMarkers = new TreeMap<Path, Marker>();
    private final Map<Path, Marker> surplusMarkers = new TreeMap<Path, Marker>();
    private final Path basePath;
    private final boolean recordSurplusMarkers;
    private Path lastDirChecked;
    private int scanCount;
    private int filesFound;
    private int markersFound;
    private int objectsFound;

    public DirMarkerTracker(Path basePath, boolean recordSurplusMarkers) {
        this.basePath = basePath;
        this.recordSurplusMarkers = recordSurplusMarkers;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public List<Marker> markerFound(Path path, String key, S3ALocatedFileStatus source) {
        ++this.markersFound;
        this.leafMarkers.put(path, new Marker(path, key, source));
        return this.pathFound(path, key, source);
    }

    public List<Marker> fileFound(Path path, String key, S3ALocatedFileStatus source) {
        ++this.filesFound;
        return this.pathFound(path, key, source);
    }

    private List<Marker> pathFound(Path path, String key, S3ALocatedFileStatus source) {
        ++this.objectsFound;
        ArrayList<Marker> removed = new ArrayList<Marker>();
        Path parent = path.getParent();
        if (parent == null || parent.equals((Object)this.lastDirChecked)) {
            return removed;
        }
        this.removeParentMarkers(parent, removed);
        this.lastDirChecked = parent;
        return removed;
    }

    private void removeParentMarkers(Path path, List<Marker> removed) {
        if (path == null || path.isRoot()) {
            return;
        }
        ++this.scanCount;
        this.removeParentMarkers(path.getParent(), removed);
        Marker value = this.leafMarkers.remove(path);
        if (value != null) {
            removed.add(value);
            if (this.recordSurplusMarkers) {
                this.surplusMarkers.put(path, value);
            }
        }
    }

    public Map<Path, Marker> getLeafMarkers() {
        return this.leafMarkers;
    }

    public Map<Path, Marker> getSurplusMarkers() {
        return this.surplusMarkers;
    }

    public Path getLastDirChecked() {
        return this.lastDirChecked;
    }

    public int getObjectsFound() {
        return this.objectsFound;
    }

    public int getScanCount() {
        return this.scanCount;
    }

    public int getFilesFound() {
        return this.filesFound;
    }

    public int getMarkersFound() {
        return this.markersFound;
    }

    public String toString() {
        return "DirMarkerTracker{leafMarkers=" + this.leafMarkers.size() + ", surplusMarkers=" + this.surplusMarkers.size() + ", lastDirChecked=" + this.lastDirChecked + ", filesFound=" + this.filesFound + ", scanCount=" + this.scanCount + "}";
    }

    public static final class Marker {
        private final Path path;
        private final String key;
        private final S3ALocatedFileStatus status;

        private Marker(Path path, String key, S3ALocatedFileStatus status) {
            this.path = path;
            this.key = key;
            this.status = status;
        }

        public Path getPath() {
            return this.path;
        }

        public String getKey() {
            return this.key;
        }

        public S3ALocatedFileStatus getStatus() {
            return this.status;
        }

        public String getVersionId() {
            return this.status.getVersionId();
        }

        public String toString() {
            return "Marker{path=" + this.path + ", key='" + this.key + "', status=" + this.status + "}";
        }
    }
}

