/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTracker;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.impl.write.WriteObjectFlags;
import org.apache.hadoop.fs.s3a.statistics.PutTrackerStatistics;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.Preconditions;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3MagicCommitTracker
extends MagicCommitTracker {
    public S3MagicCommitTracker(Path path, String bucket, String originalDestKey, String destKey, String pendingsetKey, WriteOperationHelper writer, PutTrackerStatistics trackerStatistics) {
        super(path, bucket, originalDestKey, destKey, pendingsetKey, writer, trackerStatistics);
    }

    @Override
    public boolean aboutToComplete(String uploadId, List<CompletedPart> parts, long bytesWritten, IOStatistics iostatistics) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)uploadId), (Object)("empty/null upload ID: " + uploadId));
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (Object)"No uploaded parts list");
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0, (Object)"No uploaded parts to save");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-hadoop-s3a-magic-data-length", Long.toString(bytesWritten));
        PutObjectRequest originalDestPut = this.getWriter().createPutObjectRequest(this.getOriginalDestKey(), 0L, new PutObjectOptions(null, headers, EnumSet.noneOf(WriteObjectFlags.class), ""));
        this.upload(originalDestPut, EMPTY);
        SinglePendingCommit commitData = new SinglePendingCommit();
        commitData.touch(System.currentTimeMillis());
        commitData.setDestinationKey(this.getDestKey());
        commitData.setBucket(this.getBucket());
        commitData.setUri(this.getPath().toUri().toString());
        commitData.setUploadId(uploadId);
        commitData.setText("");
        commitData.setLength(bytesWritten);
        commitData.bindCommitData(parts);
        commitData.setIOStatistics(new IOStatisticsSnapshot(iostatistics));
        byte[] bytes = commitData.toBytes(SinglePendingCommit.serializer());
        LOG.info("Uncommitted data pending to file {}; commit metadata for {} parts in {}. size: {} byte(s)", new Object[]{this.getPath().toUri(), parts.size(), this.getPendingPartKey(), bytesWritten});
        LOG.debug("Closed MPU to {}, saved commit information to {}; data=:\n{}", new Object[]{this.getPath(), this.getPendingPartKey(), commitData});
        PutObjectRequest put = this.getWriter().createPutObjectRequest(this.getPendingPartKey(), bytes.length, PutObjectOptions.defaultOptions());
        this.upload(put, bytes);
        return false;
    }

    private void upload(PutObjectRequest request, byte[] bytes) throws IOException {
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.getTrackerStatistics(), (String)Statistic.COMMITTER_MAGIC_MARKER_PUT.getSymbol(), () -> this.getWriter().putObject(request, PutObjectOptions.defaultOptions(), new S3ADataBlocks.BlockUploadData(bytes, null), null));
    }
}

