/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.WriteOperations;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.files.SuccessData;
import org.apache.hadoop.fs.s3a.commit.files.UploadEtag;
import org.apache.hadoop.fs.s3a.commit.impl.CommitContext;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.impl.UploadContentProviders;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

public class CommitOperations
extends AbstractStoreOperation
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(CommitOperations.class);
    private final S3AFileSystem fs;
    private final CommitterStatistics statistics;
    private final WriteOperations writeOperations;
    public static final PathFilter PENDINGSET_FILTER = path -> path.toString().endsWith(".pendingset");
    public static final PathFilter PENDING_FILTER = path -> path.toString().endsWith(".pending");

    public CommitOperations(S3AFileSystem fs) throws IOException {
        this(Objects.requireNonNull(fs), fs.newCommitterStatistics(), "/");
    }

    public CommitOperations(S3AFileSystem fs, CommitterStatistics committerStatistics, String outputPath) throws IOException {
        super(Objects.requireNonNull(fs).createStoreContext());
        this.fs = fs;
        this.statistics = Objects.requireNonNull(committerStatistics);
        this.writeOperations = fs.createWriteOperationHelper(fs.getAuditSpanSource().createSpan(Statistic.COMMITTER_COMMIT_JOB.getSymbol(), outputPath, null));
    }

    public static List<CompletedPart> toPartEtags(List<UploadEtag> tagIds) {
        return IntStream.range(0, tagIds.size()).mapToObj(i -> UploadEtag.toCompletedPart((UploadEtag)tagIds.get(i), i + 1)).collect(Collectors.toList());
    }

    public String toString() {
        return "CommitOperations{" + this.fs.getUri() + "}";
    }

    protected CommitterStatistics getStatistics() {
        return this.statistics;
    }

    public IOStatistics getIOStatistics() {
        return this.statistics.getIOStatistics();
    }

    public void commitOrFail(SinglePendingCommit commit) throws IOException {
        this.commit(commit, commit.getFilename()).maybeRethrow();
    }

    public MaybeIOE commit(SinglePendingCommit commit, String origin) {
        MaybeIOE outcome;
        LOG.debug("Committing single commit {}", (Object)commit);
        String destKey = "unknown destination";
        try (DurationInfo d = new DurationInfo(LOG, "Committing file %s size %s", new Object[]{commit.getDestinationKey(), commit.getLength()});){
            commit.validate();
            destKey = commit.getDestinationKey();
            long l = (Long)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.statistics, (String)Statistic.COMMITTER_MATERIALIZE_FILE.getSymbol(), () -> this.innerCommit(commit));
            LOG.debug("Successful commit of file length {}", (Object)l);
            outcome = MaybeIOE.NONE;
            this.statistics.commitCompleted(commit.getLength());
        }
        catch (IOException e) {
            String msg = String.format("Failed to commit upload against %s: %s", destKey, e);
            LOG.warn(msg, (Throwable)e);
            outcome = new MaybeIOE(e);
            this.statistics.commitFailed();
        }
        catch (Exception e) {
            String msg = String.format("Failed to commit upload against %s, described in %s: %s", destKey, origin, e);
            LOG.warn(msg, (Throwable)e);
            outcome = new MaybeIOE((IOException)((Object)new PathCommitException(origin, msg, e)));
            this.statistics.commitFailed();
        }
        return outcome;
    }

    private long innerCommit(SinglePendingCommit commit) throws IOException {
        this.writeOperations.commitUpload(commit.getDestinationKey(), commit.getUploadId(), CommitOperations.toPartEtags(commit.getEtags()), commit.getLength());
        return commit.getLength();
    }

    public RemoteIterator<LocatedFileStatus> locateAllSinglePendingCommits(Path pendingDir, boolean recursive) throws IOException {
        return S3AUtils.listAndFilter(this.fs, pendingDir, recursive, PENDING_FILTER);
    }

    public Pair<PendingSet, List<Pair<LocatedFileStatus, IOException>>> loadSinglePendingCommits(Path pendingDir, boolean recursive, CommitContext commitContext) throws IOException {
        PendingSet commits = new PendingSet();
        List<SinglePendingCommit> pendingFiles = Collections.synchronizedList(new ArrayList(1));
        List failures = Collections.synchronizedList(new ArrayList(1));
        TaskPool.foreach(this.locateAllSinglePendingCommits(pendingDir, recursive)).suppressExceptions(false).executeWith(commitContext.getOuterSubmitter()).run(status -> {
            Path path = status.getPath();
            try {
                SinglePendingCommit singleCommit = (SinglePendingCommit)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.statistics, (String)Statistic.COMMITTER_LOAD_SINGLE_PENDING_FILE.getSymbol(), () -> SinglePendingCommit.load((FileSystem)this.fs, path, (FileStatus)status, commitContext.getSinglePendingFileSerializer()));
                commits.getIOStatistics().aggregate((IOStatistics)singleCommit.getIOStatistics());
                singleCommit.getIOStatistics().clear();
                pendingFiles.add(singleCommit);
            }
            catch (IOException e) {
                LOG.warn("Failed to load commit file {}", (Object)path, (Object)e);
                failures.add(Pair.of((Object)status, (Object)e));
            }
        });
        commits.setCommits(pendingFiles);
        return Pair.of((Object)commits, failures);
    }

    public IOException makeIOE(String key, Exception ex) {
        return ex instanceof IOException ? (IOException)ex : new PathCommitException(key, ex.toString(), ex);
    }

    public void abortSingleCommit(SinglePendingCommit commit) throws IOException {
        String destKey = commit.getDestinationKey();
        String origin = commit.getFilename() != null ? " defined in " + commit.getFilename() : "";
        String uploadId = commit.getUploadId();
        LOG.info("Aborting commit ID {} to object {}{}", new Object[]{uploadId, destKey, origin});
        this.abortMultipartCommit(destKey, uploadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Aborting commit ID %s to path %s", new Object[]{uploadId, destKey});){
            this.writeOperations.abortMultipartCommit(destKey, uploadId);
        }
        finally {
            this.statistics.commitAborted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaybeIOE abortAllSinglePendingCommits(Path pendingDir, CommitContext commitContext, boolean recursive) throws IOException {
        RemoteIterator<LocatedFileStatus> pendingFiles;
        Preconditions.checkArgument((pendingDir != null ? 1 : 0) != 0, (Object)"null pendingDir");
        LOG.debug("Aborting all pending commit filess under {} (recursive={}", (Object)pendingDir, (Object)recursive);
        try {
            pendingFiles = this.ls(pendingDir, recursive);
        }
        catch (FileNotFoundException fnfe) {
            LOG.info("No directory to abort {}", (Object)pendingDir);
            return MaybeIOE.NONE;
        }
        MaybeIOE outcome = MaybeIOE.NONE;
        if (!pendingFiles.hasNext()) {
            LOG.debug("No files to abort under {}", (Object)pendingDir);
        }
        while (pendingFiles.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)pendingFiles.next();
            Path pendingFile = status.getPath();
            if (!pendingFile.getName().endsWith(".pending")) continue;
            try {
                this.abortSingleCommit(SinglePendingCommit.load((FileSystem)this.fs, pendingFile, (FileStatus)status, commitContext.getSinglePendingFileSerializer()));
            }
            catch (FileNotFoundException e) {
                LOG.debug("listed file already deleted: {}", (Object)pendingFile);
            }
            catch (IOException | IllegalArgumentException e) {
                if (!MaybeIOE.NONE.equals(outcome)) continue;
                outcome = new MaybeIOE(this.makeIOE(pendingFile.toString(), e));
            }
            finally {
                S3AUtils.deleteQuietly(this.fs, pendingFile, false);
            }
        }
        RemoteIterators.cleanupRemoteIterator(pendingFiles);
        return outcome;
    }

    protected RemoteIterator<LocatedFileStatus> ls(Path path, boolean recursive) throws IOException {
        return this.fs.listFiles(path, recursive);
    }

    public List<MultipartUpload> listPendingUploadsUnderPath(Path dest) throws IOException {
        return this.writeOperations.listMultipartUploads(this.fs.pathToKey(dest));
    }

    public int abortPendingUploadsUnderPath(Path dest) throws IOException {
        return this.writeOperations.abortMultipartUploadsUnderPath(this.fs.pathToKey(dest));
    }

    public void deleteSuccessMarker(Path outputPath) throws IOException {
        this.fs.delete(new Path(outputPath, "_SUCCESS"), false);
    }

    public void createSuccessMarker(Path outputPath, SuccessData successData, boolean addMetrics) throws IOException {
        Preconditions.checkArgument((outputPath != null ? 1 : 0) != 0, (Object)"null outputPath");
        if (addMetrics) {
            this.addFileSystemStatistics(successData.getMetrics());
        }
        Path markerPath = new Path(outputPath, "_SUCCESS");
        LOG.debug("Touching success marker for job {}: {}", (Object)markerPath, (Object)successData);
        try (DurationInfo ignored = new DurationInfo(LOG, "Writing success file %s", new Object[]{markerPath});){
            successData.save((FileSystem)this.fs, markerPath, SuccessData.serializer());
        }
    }

    public void revertCommit(SinglePendingCommit commit) throws IOException {
        LOG.info("Revert {}", (Object)commit);
        try {
            this.writeOperations.revertCommit(commit.getDestinationKey());
        }
        finally {
            this.statistics.commitReverted();
        }
    }

    /*
     * Loose catch block
     */
    public SinglePendingCommit uploadFileToPendingCommit(File localFile, Path destPath, String partition, long uploadPartSize, Progressable progress) throws IOException {
        SinglePendingCommit singlePendingCommit;
        DurationInfo d;
        DurationTracker tracker;
        boolean threw;
        String uploadId;
        String destKey;
        block17: {
            LOG.debug("Initiating multipart upload from {} to {}", (Object)localFile, (Object)destPath);
            Preconditions.checkArgument((destPath != null ? 1 : 0) != 0);
            if (!localFile.isFile()) {
                throw new FileNotFoundException("Not a file: " + localFile);
            }
            String destURI = destPath.toUri().toString();
            destKey = this.fs.pathToKey(destPath);
            uploadId = null;
            threw = true;
            tracker = this.statistics.trackDuration(Statistic.COMMITTER_STAGE_FILE_UPLOAD.getSymbol());
            d = new DurationInfo(LOG, "Upload staged file from %s to %s", new Object[]{localFile.getAbsolutePath(), destPath});
            this.statistics.commitCreated();
            uploadId = this.writeOperations.initiateMultiPartUpload(destKey, PutObjectOptions.defaultOptions());
            long length = localFile.length();
            SinglePendingCommit commitData = new SinglePendingCommit();
            commitData.setDestinationKey(destKey);
            commitData.setBucket(this.fs.getBucket());
            commitData.touch(System.currentTimeMillis());
            commitData.setUploadId(uploadId);
            commitData.setUri(destURI);
            commitData.setText((String)(partition != null ? "partition: " + partition : ""));
            commitData.setLength(length);
            long numParts = length / uploadPartSize + (long)(length % uploadPartSize > 0L ? 1 : 0);
            if (numParts == 0L) {
                numParts = 1L;
            }
            if (numParts > 10000L) {
                throw new PathIOException(destPath.toString(), String.format("File to upload (size %d) is too big to be uploaded in parts of size %d", numParts, length));
            }
            int partCount = (int)numParts;
            LOG.debug("File size is {}, number of parts to upload = {}", (Object)length, (Object)partCount);
            List<CompletedPart> parts = this.uploadFileData(uploadId, localFile, destKey, progress, length, partCount, uploadPartSize);
            commitData.bindCommitData(parts);
            this.statistics.commitUploaded(length);
            threw = false;
            singlePendingCommit = commitData;
            d.close();
            if (!threw || uploadId == null) break block17;
            try {
                this.abortMultipartCommit(destKey, uploadId);
            }
            catch (IOException e) {
                LOG.error("Failed to abort upload {} to {}", new Object[]{uploadId, destKey, e});
            }
        }
        if (threw) {
            tracker.failed();
        }
        tracker.close();
        return singlePendingCommit;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        d.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (threw && uploadId != null) {
                        try {
                            this.abortMultipartCommit(destKey, uploadId);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to abort upload {} to {}", new Object[]{uploadId, destKey, e});
                        }
                    }
                    if (threw) {
                        tracker.failed();
                    }
                    tracker.close();
                    throw throwable3;
                }
            }
        }
    }

    private List<CompletedPart> uploadFileData(String uploadId, File localFile, String destKey, Progressable progress, long length, int numParts, long uploadPartSize) throws IOException {
        ArrayList<CompletedPart> parts = new ArrayList<CompletedPart>(numParts);
        long offset = 0L;
        for (int partNumber = 1; partNumber <= numParts; ++partNumber) {
            progress.progress();
            int size = (int)Math.min(length - offset, uploadPartSize);
            UploadPartRequest.Builder partBuilder = this.writeOperations.newUploadPartRequestBuilder(destKey, uploadId, partNumber, partNumber == numParts, size);
            RequestBody body = RequestBody.fromContentProvider(UploadContentProviders.fileContentProvider(localFile, offset, size), (long)size, (String)"application/octet-stream");
            UploadPartResponse response = this.writeOperations.uploadPart((UploadPartRequest)partBuilder.build(), body, this.statistics);
            offset += uploadPartSize;
            parts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(partNumber)).eTag(response.eTag()).checksumCRC32(response.checksumCRC32()).checksumCRC32C(response.checksumCRC32C()).checksumSHA1(response.checksumSHA1()).checksumSHA256(response.checksumSHA256()).build());
        }
        return parts;
    }

    public void addFileSystemStatistics(Map<String, Long> dest) {
        dest.putAll(this.fs.getInstrumentation().toMap());
    }

    public void taskCompleted(boolean success) {
        this.statistics.taskCompleted(success);
    }

    public void jobCompleted(boolean success) {
        this.statistics.jobCompleted(success);
    }

    public CommitContext createCommitContext(JobContext context, Path path, int committerThreads, IOStatisticsContext ioStatisticsContext) throws IOException {
        return new CommitContext(this, context, committerThreads, ioStatisticsContext);
    }

    public CommitContext createCommitContextForTesting(Path path, @Nullable String jobId, int committerThreads) throws IOException {
        String id = jobId != null ? jobId : UUID.randomUUID().toString();
        return new CommitContext(this, this.getStoreContext().getConfiguration(), id, committerThreads, IOStatisticsContext.getCurrentIOStatisticsContext());
    }

    public static Optional<Long> extractMagicFileLength(FileSystem fs, Path path) throws IOException {
        byte[] bytes;
        try {
            bytes = fs.getXAttr(path, "header.x-hadoop-s3a-magic-data-length");
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("Filesystem {} doesn't support XAttr API", (Object)fs);
            return Optional.empty();
        }
        return HeaderProcessing.extractXAttrLongValue(bytes);
    }

    public static class MaybeIOE {
        private final IOException exception;
        public static final MaybeIOE NONE = new MaybeIOE(null);

        public MaybeIOE(IOException exception) {
            this.exception = exception;
        }

        public IOException getException() {
            return this.exception;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void maybeRethrow() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MaybeIOE{");
            sb.append(this.hasException() ? this.exception : "");
            sb.append('}');
            return sb.toString();
        }

        public static MaybeIOE of(IOException ex) {
            return ex != null ? new MaybeIOE(ex) : NONE;
        }
    }
}

