/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BulkDelete;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.Globber;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.FlagSet;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.fs.impl.prefetch.ExecutorServiceFuturePool;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.ArnResource;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.MultipartUtils;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.RenameFailedException;
import org.apache.hadoop.fs.s3a.S3ABlockOutputStream;
import org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AInternals;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.s3a.S3ListResult;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.UnknownStoreException;
import org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.hadoop.fs.s3a.VectoredIOContext;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.api.PerformanceFlagEnum;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.audit.AuditIntegration;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.AuditorFlags;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.auth.CredentialProviderListFactory;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.RolePolicies;
import org.apache.hadoop.fs.s3a.auth.SignerManager;
import org.apache.hadoop.fs.s3a.auth.delegation.AWSPolicyProvider;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenProvider;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.S3ADelegationTokens;
import org.apache.hadoop.fs.s3a.commit.MagicCommitIntegration;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.commit.magic.InMemoryMagicCommitTracker;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTrackerUtils;
import org.apache.hadoop.fs.s3a.impl.AWSCannedACL;
import org.apache.hadoop.fs.s3a.impl.BaseS3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteOperation;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteOperationCallbacksImpl;
import org.apache.hadoop.fs.s3a.impl.CSEMaterials;
import org.apache.hadoop.fs.s3a.impl.CSES3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.CSEUtils;
import org.apache.hadoop.fs.s3a.impl.CSEV1CompatibleS3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.ChecksumSupport;
import org.apache.hadoop.fs.s3a.impl.ClientManager;
import org.apache.hadoop.fs.s3a.impl.ClientManagerImpl;
import org.apache.hadoop.fs.s3a.impl.ConfigurationHelper;
import org.apache.hadoop.fs.s3a.impl.ContextAccessors;
import org.apache.hadoop.fs.s3a.impl.CopyFromLocalOperation;
import org.apache.hadoop.fs.s3a.impl.CreateFileBuilder;
import org.apache.hadoop.fs.s3a.impl.DeleteOperation;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.apache.hadoop.fs.s3a.impl.GetContentSummaryOperation;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.fs.s3a.impl.InputStreamCallbacksImpl;
import org.apache.hadoop.fs.s3a.impl.ListingOperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.MkdirOperation;
import org.apache.hadoop.fs.s3a.impl.MultiObjectDeleteException;
import org.apache.hadoop.fs.s3a.impl.NetworkBinding;
import org.apache.hadoop.fs.s3a.impl.OpenFileSupport;
import org.apache.hadoop.fs.s3a.impl.OperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.impl.RenameOperation;
import org.apache.hadoop.fs.s3a.impl.RequestFactoryImpl;
import org.apache.hadoop.fs.s3a.impl.S3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.S3AMultipartUploaderBuilder;
import org.apache.hadoop.fs.s3a.impl.S3AStoreBuilder;
import org.apache.hadoop.fs.s3a.impl.S3ExpressStorage;
import org.apache.hadoop.fs.s3a.impl.StatusProbeEnum;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.impl.StoreContextBuilder;
import org.apache.hadoop.fs.s3a.impl.StoreContextFactory;
import org.apache.hadoop.fs.s3a.impl.UploadContentProviders;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.impl.streams.StreamFactoryRequirements;
import org.apache.hadoop.fs.s3a.impl.streams.StreamIntegration;
import org.apache.hadoop.fs.s3a.impl.write.WriteObjectFlags;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.statistics.BlockOutputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.s3a.statistics.impl.BondedS3AStatisticsContext;
import org.apache.hadoop.fs.s3a.tools.MarkerToolOperations;
import org.apache.hadoop.fs.s3a.tools.MarkerToolOperationsImpl;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.store.EtagChecksum;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.fs.store.audit.ActiveThreadSpanSource;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DelegationTokenIssuer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.LambdaUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.RateLimitingFactory;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.transfer.s3.model.CompletedCopy;
import software.amazon.awssdk.transfer.s3.model.Copy;
import software.amazon.awssdk.transfer.s3.model.CopyRequest;
import software.amazon.awssdk.transfer.s3.model.ObjectTransfer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileSystem
extends FileSystem
implements StreamCapabilities,
AWSPolicyProvider,
DelegationTokenProvider,
IOStatisticsSource,
AuditSpanSource<AuditSpanS3A>,
ActiveThreadSpanSource<AuditSpanS3A>,
StoreContextFactory {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    private URI uri;
    private Path workingDir;
    private String username;
    private S3AStore store;
    private S3Client s3Client;
    private Invoker invoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private final Invoker.Retried onRetry = this::operationRetried;
    private String bucket;
    private int maxKeys;
    private Listing listing;
    private long partSize;
    private boolean enableMultiObjectsDelete;
    private ExecutorService boundedThreadPool;
    private ThreadPoolExecutor unboundedThreadPool;
    private ExecutorServiceFuturePool futurePool;
    private int executorCapacity;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private static final LogExactlyOnce STORAGE_CLASS_WARNING = new LogExactlyOnce(LOG);
    private String cannedACL;
    private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
    private S3AInstrumentation instrumentation;
    private S3AStatisticsContext statisticsContext;
    private S3AStorageStatistics storageStatistics;
    private FlagSet<PerformanceFlagEnum> performanceFlags;
    private S3AInputPolicy inputPolicy;
    private VectoredIOContext vectoredIOContext;
    private long readAhead;
    private ChangeDetectionPolicy changeDetectionPolicy;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean isClosed = false;
    private Optional<S3ADelegationTokens> delegationTokens = Optional.empty();
    private UserGroupInformation owner;
    private String blockOutputBuffer;
    private S3ADataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private boolean useListV1;
    private MagicCommitIntegration committerIntegration;
    private AWSCredentialProviderList credentials;
    private SignerManager signerManager;
    private S3AInternals s3aInternals;
    private boolean dirOperationsPurgeUploads;
    private int pageSize;
    private final ListingOperationCallbacks listingOperationCallbacks = new ListingOperationCallbacksImpl();
    private OpenFileSupport openFileHelper;
    private final ContextAccessors contextAccessors = new ContextAccessorsImpl();
    private RequestFactory requestFactory;
    private AuditManagerS3A auditManager = AuditIntegration.stubAuditManager();
    private boolean isCSEEnabled;
    private boolean isAnalyticsAcceleratorEnabled;
    private ArnResource accessPoint;
    private S3AFileSystemOperations fsHandler;
    private boolean isMultipartUploadEnabled = true;
    private boolean isMultipartCopyEnabled;
    private boolean fipsEnabled;
    private final Set<Path> deleteOnExit = new TreeSet<Path>();
    private String scheme = "s3a";
    private boolean optimizedCopyFromLocal;
    private boolean s3ExpressStore;
    private String endpoint;
    private String configuredRegion;
    private boolean s3AccessGrantsEnabled;
    private boolean conditionalCreateEnabled;

    private static void addDeprecatedKeys() {
        Configuration.DeprecationDelta[] deltas = new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("fs.s3a.committer.staging.abort.pending.uploads", "fs.s3a.committer.abort.pending.uploads"), new Configuration.DeprecationDelta("fs.s3a.server-side-encryption-algorithm", "fs.s3a.encryption.algorithm"), new Configuration.DeprecationDelta("fs.s3a.server-side-encryption.key", "fs.s3a.encryption.key")};
        if (deltas.length > 0) {
            Configuration.addDeprecations((Configuration.DeprecationDelta[])deltas);
            Configuration.reloadExistingConfigurations();
        }
    }

    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.bucket = name.getHost();
        AuditSpanS3A span = null;
        Optional<Object> trackInitialization = Optional.empty();
        try {
            String arn;
            LOG.debug("Initializing S3AFileSystem for {}", (Object)this.bucket);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Filesystem for {} created; fs.s3a.impl.disable.cache = {}", new Object[]{name, originalConf.getBoolean("fs.s3a.impl.disable.cache", false), new RuntimeException(super.toString())});
            }
            Configuration conf = S3AUtils.propagateBucketOptions(originalConf, this.bucket);
            String configuredArn = (conf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class)).getTrimmed(arn = String.format("fs.s3a.bucket.%s.accesspoint.arn", this.bucket), "");
            if (!configuredArn.isEmpty()) {
                this.accessPoint = ArnResource.accessPointFromArn(configuredArn);
                LOG.info("Using AccessPoint ARN \"{}\" for bucket {}", (Object)configuredArn, (Object)this.bucket);
                this.bucket = this.accessPoint.getFullArn();
            } else if (conf.getBoolean("fs.s3a.accesspoint.required", false)) {
                LOG.warn("Access Point usage is required because \"{}\" is enabled, but not configured for the bucket: {}", (Object)"fs.s3a.accesspoint.required", (Object)this.bucket);
                throw new PathIOException(this.bucket, "Access Points usage is required but not configured for the bucket.");
            }
            S3AUtils.maybeIsolateClassloader(conf, this.getClass().getClassLoader());
            S3AUtils.patchSecurityCredentialProviders(conf);
            boolean delegationTokensEnabled = S3ADelegationTokens.hasDelegationTokenBinding(conf);
            if (delegationTokensEnabled) {
                LOG.debug("Using delegation tokens");
            }
            this.setUri(name, delegationTokensEnabled);
            super.initialize(this.uri, conf);
            this.setConf(conf);
            this.instrumentation = new S3AInstrumentation(this.uri);
            this.initializeStatisticsBinding();
            trackInitialization = Optional.of(this.instrumentation.trackDuration("filesystem_initialization"));
            this.s3aInternals = this.createS3AInternals();
            this.setEncryptionSecrets(S3AUtils.buildEncryptionSecrets(this.bucket, conf));
            this.invoker = new Invoker(new S3ARetryPolicy(this.getConf()), this.onRetry);
            this.isCSEEnabled = CSEUtils.isCSEEnabled(this.getS3EncryptionAlgorithm().getMethod());
            this.isAnalyticsAcceleratorEnabled = StreamIntegration.determineInputStreamType(conf).equals((Object)InputStreamType.Analytics);
            this.fsHandler = this.createFileSystemHandler();
            this.fsHandler.setCSEGauge((IOStatisticsStore)this.getIOStatistics());
            this.owner = UserGroupInformation.getCurrentUser();
            this.username = this.owner.getShortUserName();
            this.workingDir = new Path("/user", this.username).makeQualified(this.uri, this.getWorkingDirectory());
            this.maxKeys = S3AUtils.intOption(conf, "fs.s3a.paging.maximum", 5000, 1);
            this.partSize = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.size", 0x4000000L);
            this.multiPartThreshold = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.threshold", 0x8000000L);
            S3AUtils.longBytesOption(conf, "fs.s3a.block.size", 0x2000000L, 1L);
            this.enableMultiObjectsDelete = conf.getBoolean("fs.s3a.multiobjectdelete.enable", true);
            this.endpoint = this.accessPoint == null ? conf.getTrimmed("fs.s3a.endpoint", "") : this.accessPoint.getEndpoint();
            this.configuredRegion = this.accessPoint == null ? conf.getTrimmed("fs.s3a.endpoint.region") : this.accessPoint.getRegion();
            this.fipsEnabled = conf.getBoolean("fs.s3a.endpoint.fips", false);
            this.s3ExpressStore = S3ExpressStorage.isS3ExpressStore(this.bucket, this.endpoint);
            this.dirOperationsPurgeUploads = conf.getBoolean("fs.s3a.directory.operations.purge.uploads", false);
            this.isMultipartCopyEnabled = this.isMultipartUploadEnabled = conf.getBoolean("fs.s3a.multipart.uploads.enabled", true);
            int listVersion = conf.getInt("fs.s3a.list.version", 2);
            if (listVersion < 1 || listVersion > 2) {
                LOG.warn("Configured fs.s3a.list.version {} is invalid, forcing version 2", (Object)listVersion);
            }
            boolean bl = this.useListV1 = listVersion == 1;
            if (this.accessPoint != null && this.useListV1) {
                LOG.warn("V1 list configured in fs.s3a.list.version. This is not supported in by access points. Upgrading to V2");
                this.useListV1 = false;
            }
            this.conditionalCreateEnabled = conf.getBoolean("fs.s3a.create.conditional.enabled", true);
            this.signerManager = new SignerManager(this.bucket, this, conf, this.owner);
            this.signerManager.initCustomSigners();
            this.initializeAuditService();
            this.requestFactory = this.createRequestFactory();
            span = this.createSpan("initialize", this.bucket, null);
            ClientManager clientManager = this.createClientManager(name, delegationTokensEnabled);
            this.inputPolicy = S3AInputPolicy.getPolicy(conf.getTrimmed("fs.s3a.experimental.input.fadvise", "default"), S3AInputPolicy.Normal);
            LOG.debug("Input fadvise policy = {}", (Object)this.inputPolicy);
            this.changeDetectionPolicy = ChangeDetectionPolicy.getPolicy(conf);
            LOG.debug("Change detection policy = {}", (Object)this.changeDetectionPolicy);
            boolean magicCommitterEnabled = conf.getBoolean("fs.s3a.committer.magic.enabled", true);
            LOG.debug("Filesystem support for magic committers {} enabled", (Object)(magicCommitterEnabled ? "is" : "is not"));
            this.committerIntegration = new MagicCommitIntegration(this, magicCommitterEnabled);
            boolean blockUploadEnabled = conf.getBoolean("fs.s3a.fast.upload", true);
            if (!blockUploadEnabled) {
                LOG.warn("The \"slow\" output stream is no longer supported");
            }
            this.blockOutputBuffer = conf.getTrimmed("fs.s3a.fast.upload.buffer", "disk");
            this.blockFactory = S3ADataBlocks.createFactory(this.createStoreContext(), this.blockOutputBuffer);
            this.blockOutputActiveBlocks = S3AUtils.intOption(conf, "fs.s3a.fast.upload.active.blocks", 4, 1);
            if (this.isCSEEnabled) {
                this.blockOutputActiveBlocks = 1;
            }
            LOG.debug("Using S3ABlockOutputStream with buffer = {}; block={}; queue limit={}; multipart={}", new Object[]{this.blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks, this.isMultipartUploadEnabled});
            S3Guard.checkNoS3Guard(this.getUri(), this.getConf());
            this.performanceFlags = FlagSet.buildFlagSet(PerformanceFlagEnum.class, (Configuration)conf, (String)"fs.s3a.performance.flags", (boolean)true);
            boolean performanceCreation = conf.getBoolean("fs.s3a.create.performance", this.performanceFlags.enabled((Enum)PerformanceFlagEnum.Create));
            this.performanceFlags.set((Enum)PerformanceFlagEnum.Create, performanceCreation);
            this.performanceFlags.makeImmutable();
            LOG.debug("{} = {}", (Object)"fs.s3a.create.performance", (Object)performanceCreation);
            this.pageSize = S3AUtils.intOption(this.getConf(), "fs.s3a.bulk.delete.page.size", 250, 0);
            Preconditions.checkArgument((this.pageSize <= 1000 ? 1 : 0) != 0, (String)"page size out of range: %s", (Object[])new Object[]{this.pageSize});
            this.listing = new Listing(this.listingOperationCallbacks, this.createStoreContext());
            this.openFileHelper = new OpenFileSupport(this.changeDetectionPolicy, S3AUtils.longBytesOption(conf, "fs.s3a.readahead.range", 65536L, 0L), this.username, S3AUtils.intOption(conf, "io.file.buffer.size", 4096, 0), S3AUtils.longBytesOption(conf, "fs.s3a.input.async.drain.threshold", 16000L, 0L), this.inputPolicy);
            this.scheme = this.uri != null && this.uri.getScheme() != null ? this.uri.getScheme() : "s3a";
            this.optimizedCopyFromLocal = conf.getBoolean("fs.s3a.optimized.copy.from.local.enabled", true);
            LOG.debug("Using optimized copyFromLocal implementation: {}", (Object)this.optimizedCopyFromLocal);
            this.s3AccessGrantsEnabled = conf.getBoolean("fs.s3a.access.grants.enabled", false);
            int rateLimitCapacity = S3AUtils.intOption(conf, "fs.s3a.io.rate.limit", 0, 0);
            this.store = this.createS3AStore(clientManager, rateLimitCapacity);
            this.s3Client = this.getStore().getOrCreateS3Client();
            StreamFactoryRequirements factoryRequirements = this.getStore().factoryRequirements();
            EnumSet<AuditorFlags> flags = EnumSet.noneOf(AuditorFlags.class);
            if (factoryRequirements.requires(StreamFactoryRequirements.Requirements.ExpectUnauditedGetRequests)) {
                flags.add(AuditorFlags.PermitOutOfBandOperations);
            }
            this.getAuditManager().setAuditFlags(flags);
            this.vectoredIOContext = factoryRequirements.vectoredIOContext();
            this.initThreadPools();
            this.doBucketProbing();
            this.initMultipartUploads(conf);
            trackInitialization.ifPresent(DurationTracker::close);
        }
        catch (SdkException e) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{span});
            this.stopAllServices();
            trackInitialization.ifPresent(DurationTracker::failed);
            throw S3AUtils.translateException("initializing ", new Path(name), e);
        }
        catch (IOException | RuntimeException e) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{span});
            this.stopAllServices();
            trackInitialization.ifPresent(DurationTracker::failed);
            throw e;
        }
    }

    private S3AFileSystemOperations createFileSystemHandler() {
        if (this.isCSEEnabled) {
            if (this.getConf().getBoolean("fs.s3a.encryption.cse.v1.compatibility.enabled", false)) {
                return new CSEV1CompatibleS3AFileSystemOperations();
            }
            return new CSES3AFileSystemOperations();
        }
        return new BaseS3AFileSystemOperations();
    }

    @VisibleForTesting
    protected S3AStore createS3AStore(ClientManager clientManager, int rateLimitCapacity) {
        S3AStore st = new S3AStoreBuilder().withAuditSpanSource(this.getAuditManager()).withClientManager(clientManager).withDurationTrackerFactory(this.getDurationTrackerFactory()).withFsStatistics(this.getFsStatistics()).withInstrumentation(this.getInstrumentation()).withStatisticsContext(this.statisticsContext).withStoreContextFactory(this).withStorageStatistics(this.getStorageStatistics()).withReadRateLimiter(RateLimitingFactory.unlimitedRate()).withWriteRateLimiter(RateLimitingFactory.create((int)rateLimitCapacity)).build();
        st.init(this.getConf());
        st.start();
        return st;
    }

    private void doBucketProbing() throws IOException {
        int bucketProbe = this.getConf().getInt("fs.s3a.bucket.probe", 0);
        Preconditions.checkArgument((bucketProbe >= 0 ? 1 : 0) != 0, (Object)"Value of fs.s3a.bucket.probe should be >= 0");
        switch (bucketProbe) {
            case 0: {
                LOG.debug("skipping check for bucket existence");
                break;
            }
            case 1: 
            case 2: {
                NetworkBinding.logDnsLookup(this.getConf());
                this.verifyBucketExists();
                break;
            }
            default: {
                LOG.warn("Unknown bucket probe option {}: {}; skipping check for bucket existence", (Object)"fs.s3a.bucket.probe", (Object)bucketProbe);
            }
        }
    }

    protected void initializeStatisticsBinding() {
        this.storageStatistics = S3AFileSystem.createStorageStatistics(Objects.requireNonNull(this.getIOStatistics()));
        this.statisticsContext = new BondedS3AStatisticsContext(new BondedS3AStatisticsContext.S3AFSStatisticsSource(){

            @Override
            public S3AInstrumentation getInstrumentation() {
                return S3AFileSystem.this.getInstrumentation();
            }

            @Override
            public FileSystem.Statistics getInstanceStatistics() {
                return S3AFileSystem.this.statistics;
            }
        });
    }

    private void initThreadPools() {
        Configuration conf = this.getConf();
        String name = "s3a-transfer-" + this.getBucket();
        int maxThreads = conf.getInt("fs.s3a.threads.max", 96);
        if (maxThreads < 2) {
            LOG.warn("fs.s3a.threads.max must be at least 2: forcing to 2.");
            maxThreads = 2;
        }
        int totalTasks = S3AUtils.intOption(conf, "fs.s3a.max.total.tasks", 32, 1);
        long keepAliveTime = ConfigurationHelper.getDuration(conf, "fs.s3a.threads.keepalivetime", Duration.ofSeconds(Constants.DEFAULT_KEEPALIVE_TIME), TimeUnit.SECONDS, Duration.ZERO).getSeconds();
        StreamFactoryRequirements factoryRequirements = this.getStore().factoryRequirements();
        int numPrefetchThreads = factoryRequirements.sharedThreads();
        int activeTasksForBoundedThreadPool = maxThreads;
        int waitingTasksForBoundedThreadPool = maxThreads + totalTasks + numPrefetchThreads;
        this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance((int)activeTasksForBoundedThreadPool, (int)waitingTasksForBoundedThreadPool, (long)keepAliveTime, (TimeUnit)TimeUnit.SECONDS, (String)(name + "-bounded"));
        this.unboundedThreadPool = new ThreadPoolExecutor(maxThreads, Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)(name + "-unbounded")));
        this.unboundedThreadPool.allowCoreThreadTimeOut(true);
        this.executorCapacity = S3AUtils.intOption(conf, "fs.s3a.executor.capacity", 16, 1);
        if (factoryRequirements.requiresFuturePool()) {
            S3AInputStreamStatistics s3AInputStreamStatistics = this.statisticsContext.newInputStreamStatistics();
            this.futurePool = new ExecutorServiceFuturePool((ExecutorService)new SemaphoredDelegatingExecutor(this.boundedThreadPool, activeTasksForBoundedThreadPool + waitingTasksForBoundedThreadPool, true, (DurationTrackerFactory)s3AInputStreamStatistics));
        }
    }

    protected static S3AStorageStatistics createStorageStatistics(IOStatistics ioStatistics) {
        return (S3AStorageStatistics)GlobalStorageStatistics.INSTANCE.put("S3AStorageStatistics", () -> new S3AStorageStatistics(ioStatistics));
    }

    protected void verifyBucketExists() throws UnknownStoreException, IOException {
        if (!((Boolean)this.trackDurationAndSpan(Statistic.STORE_EXISTS_PROBE, this.bucket, null, () -> (Boolean)this.invoker.retry("doesBucketExist", this.bucket, true, () -> {
            try {
                this.getS3Client().headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucket).build());
                return true;
            }
            catch (AwsServiceException ex) {
                int statusCode = ex.statusCode();
                if (statusCode == 404 || statusCode == 403 && this.accessPoint != null) {
                    return false;
                }
                return true;
            }
        }))).booleanValue()) {
            throw new UnknownStoreException("s3a://" + this.bucket + "/", " Bucket does not exist. Accessing with fs.s3a.endpoint set to " + this.getConf().getTrimmed("fs.s3a.endpoint", null));
        }
    }

    @VisibleForTesting
    public S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @VisibleForTesting
    public FileSystem.Statistics getFsStatistics() {
        return this.statistics;
    }

    public Listing getListing() {
        return this.listing;
    }

    private ClientManager createClientManager(URI fsURI, boolean dtEnabled) throws IOException {
        Configuration conf = this.getConf();
        this.credentials = null;
        String uaSuffix = "";
        if (dtEnabled) {
            LOG.debug("Using delegation tokens");
            S3ADelegationTokens tokens = new S3ADelegationTokens();
            this.delegationTokens = Optional.of(tokens);
            tokens.bindToFileSystem(this.getCanonicalUri(), this.createStoreContext(), this.createDelegationOperations());
            tokens.init(conf);
            tokens.start();
            if (tokens.isBoundToDT()) {
                LOG.debug("Using existing delegation token");
            } else {
                LOG.debug("No delegation token for this instance");
            }
            this.credentials = tokens.getCredentialProviders();
            tokens.getEncryptionSecrets().ifPresent(this::setEncryptionSecrets);
            uaSuffix = tokens.getUserAgentField();
        } else {
            this.credentials = CredentialProviderListFactory.createAWSCredentialProviderList(fsURI, conf);
        }
        LOG.debug("Using credential provider {}", (Object)this.credentials);
        S3ClientFactory clientFactory = this.fsHandler.getS3ClientFactory(conf);
        S3ClientFactory unencryptedClientFactory = this.fsHandler.getUnencryptedS3ClientFactory(conf);
        CSEMaterials cseMaterials = this.fsHandler.getClientSideEncryptionMaterials(conf, this.bucket, this.getS3EncryptionAlgorithm());
        S3ClientFactory.S3ClientCreationParameters parameters = new S3ClientFactory.S3ClientCreationParameters().withCredentialSet(this.credentials).withPathUri(fsURI).withEndpoint(this.endpoint).withMetrics(this.statisticsContext.newStatisticsFromAwsSdk()).withPathStyleAccess(conf.getBoolean("fs.s3a.path.style.access", false)).withUserAgentSuffix(uaSuffix).withRequesterPays(conf.getBoolean("fs.s3a.requester.pays.enabled", false)).withExecutionInterceptors(this.auditManager.createExecutionInterceptors()).withMinimumPartSize(this.partSize).withMultipartCopyEnabled(this.isMultipartCopyEnabled).withMultipartThreshold(this.multiPartThreshold).withTransferManagerExecutor(this.unboundedThreadPool).withRegion(this.configuredRegion).withFipsEnabled(this.fipsEnabled).withExpressCreateSession(conf.getBoolean("fs.s3a.s3express.create.session", true)).withChecksumValidationEnabled(conf.getBoolean("fs.s3a.checksum.validation", false)).withClientSideEncryptionEnabled(this.isCSEEnabled).withClientSideEncryptionMaterials(cseMaterials).withAnalyticsAcceleratorEnabled(this.isAnalyticsAcceleratorEnabled).withKMSRegion(conf.get("fs.s3a.encryption.cse.kms.region"));
        return this.createClientManager(clientFactory, unencryptedClientFactory, parameters, this.getDurationTrackerFactory());
    }

    @VisibleForTesting
    protected ClientManager createClientManager(S3ClientFactory clientFactory, S3ClientFactory unencryptedClientFactory, S3ClientFactory.S3ClientCreationParameters clientCreationParameters, DurationTrackerFactory durationTrackerFactory) {
        return new ClientManagerImpl(clientFactory, unencryptedClientFactory, clientCreationParameters, durationTrackerFactory);
    }

    protected void initializeAuditService() throws IOException {
        this.auditManager = AuditIntegration.createAndStartAuditManager(this.getConf(), this.instrumentation.createMetricsUpdatingStore());
    }

    @InterfaceAudience.Private
    public AuditManagerS3A getAuditManager() {
        return this.auditManager;
    }

    @InterfaceAudience.Private
    public OperationAuditor getAuditor() {
        return this.getAuditManager().getAuditor();
    }

    @InterfaceAudience.Private
    public AuditSpanS3A getActiveAuditSpan() {
        return (AuditSpanS3A)this.getAuditManager().getActiveAuditSpan();
    }

    @InterfaceAudience.Private
    public AuditSpanSource getAuditSpanSource() {
        return this;
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return (AuditSpanS3A)this.getAuditManager().createSpan(operation, path1, path2);
    }

    protected RequestFactory createRequestFactory() {
        long partCountLimit = S3AUtils.longOption(this.getConf(), "fs.s3a.internal.upload.part.count.limit", 10000L, 1L);
        if (partCountLimit != 10000L) {
            LOG.warn("Configuration property {} shouldn't be overridden by client", (Object)"fs.s3a.internal.upload.part.count.limit");
        }
        this.initCannedAcls(this.getConf());
        String contentEncoding = this.getConf().getTrimmed("fs.s3a.object.content.encoding", null);
        if (contentEncoding != null) {
            LOG.debug("Using content encoding set in {} = {}", (Object)"fs.s3a.object.content.encoding", (Object)contentEncoding);
        }
        String storageClassConf = this.getConf().getTrimmed("fs.s3a.create.storage.class", "").toUpperCase(Locale.US);
        StorageClass storageClass = null;
        if (!storageClassConf.isEmpty()) {
            storageClass = StorageClass.fromValue((String)storageClassConf);
            LOG.debug("Using storage class {}", (Object)storageClass);
            if (storageClass.equals((Object)StorageClass.UNKNOWN_TO_SDK_VERSION)) {
                STORAGE_CLASS_WARNING.warn("Unknown storage class \"{}\" from option: {}; falling back to default storage class", new Object[]{storageClassConf, "fs.s3a.create.storage.class"});
                storageClass = null;
            }
        } else {
            LOG.debug("Unset storage class property {}; falling back to default storage class", (Object)"fs.s3a.create.storage.class");
        }
        Duration partUploadTimeout = ConfigurationHelper.getDuration(this.getConf(), "fs.s3a.connection.part.upload.timeout", Constants.DEFAULT_PART_UPLOAD_TIMEOUT, TimeUnit.MILLISECONDS, Duration.ZERO);
        return RequestFactoryImpl.builder().withBucket(Objects.requireNonNull(this.bucket)).withCannedACL(this.getCannedACL()).withEncryptionSecrets(Objects.requireNonNull(this.encryptionSecrets)).withMultipartPartCountLimit(partCountLimit).withRequestPreparer(this.getAuditManager()::requestCreated).withContentEncoding(contentEncoding).withStorageClass(storageClass).withMultipartUploadEnabled(this.isMultipartUploadEnabled).withPartUploadTimeout(partUploadTimeout).withChecksumAlgorithm(ChecksumSupport.getChecksumAlgorithm(this.getConf())).build();
    }

    @VisibleForTesting
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public FlagSet<PerformanceFlagEnum> getPerformanceFlags() {
        return this.performanceFlags;
    }

    private S3AStore getStore() {
        return this.store;
    }

    @VisibleForTesting
    public DelegationOperations createDelegationOperations() {
        return new DelegationOperationsImpl();
    }

    protected void setEncryptionSecrets(EncryptionSecrets secrets) {
        this.encryptionSecrets = secrets;
        if (this.requestFactory != null) {
            this.requestFactory.setEncryptionSecrets(secrets);
        }
    }

    public EncryptionSecrets getEncryptionSecrets() {
        return this.encryptionSecrets;
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? AWSCannedACL.valueOf(cannedACLName).toString() : null;
    }

    private void initMultipartUploads(Configuration conf) throws IOException {
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        if (purgeExistingMultipart) {
            try {
                Duration purgeDuration = ConfigurationHelper.getDuration(conf, "fs.s3a.multipart.purge.age", Duration.ofSeconds(Constants.DEFAULT_PURGE_EXISTING_MULTIPART_AGE), TimeUnit.SECONDS, Duration.ZERO);
                this.abortOutstandingMultipartUploads(purgeDuration.getSeconds());
            }
            catch (AccessDeniedException e) {
                this.instrumentation.errorIgnored();
                LOG.debug("Failed to purge multipart uploads against {}, FS may be read only", (Object)this.bucket);
            }
        }
    }

    public void abortOutstandingMultipartUploads(long seconds) throws IOException {
        Preconditions.checkArgument((seconds >= 0L ? 1 : 0) != 0);
        Instant purgeBefore = Instant.now().minusSeconds(seconds);
        LOG.debug("Purging outstanding multipart uploads older than {}", (Object)purgeBefore);
        this.invoker.retry("Purging multipart uploads", this.bucket, true, () -> {
            RemoteIterator<MultipartUpload> uploadIterator = MultipartUtils.listMultipartUploads(this.createStoreContext(), this.getS3Client(), null, this.maxKeys);
            while (uploadIterator.hasNext()) {
                MultipartUpload upload = (MultipartUpload)uploadIterator.next();
                if (upload.initiated().compareTo(purgeBefore) >= 0) continue;
                this.abortMultipartUpload(upload);
            }
        });
    }

    public String getScheme() {
        return this.scheme;
    }

    public URI getUri() {
        return this.uri;
    }

    @VisibleForTesting
    protected void setUri(URI fsUri, boolean canonicalize) {
        URI u = S3xLoginHelper.buildFSURI(fsUri);
        this.uri = canonicalize ? u : this.canonicalizeUri(u);
    }

    public URI getCanonicalUri() {
        return this.uri;
    }

    @VisibleForTesting
    public int getDefaultPort() {
        return 0;
    }

    @VisibleForTesting
    protected void setAmazonS3Client(S3Client client) {
        Preconditions.checkNotNull((Object)client, (Object)"clientV2");
        LOG.debug("Setting S3V2 client to {}", (Object)client);
        this.s3Client = client;
    }

    @VisibleForTesting
    protected S3Client getS3Client() {
        return this.s3Client;
    }

    public String getBucketLocation() throws IOException {
        return this.s3aInternals.getBucketLocation(this.bucket);
    }

    protected S3AInternals createS3AInternals() {
        return new S3AInternalsImpl();
    }

    public S3AInternals getS3AInternals() {
        return this.s3aInternals;
    }

    @InterfaceStability.Unstable
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    @VisibleForTesting
    public ChangeDetectionPolicy getChangeDetectionPolicy() {
        return this.changeDetectionPolicy;
    }

    public S3AEncryptionMethods getS3EncryptionAlgorithm() {
        return this.encryptionSecrets.getEncryptionMethod();
    }

    File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        return this.getS3AInternals().getStore().createTemporaryFileForWriting(pathStr, size, conf);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public String getBucket() {
        return this.bucket;
    }

    @VisibleForTesting
    protected void setBucket(String bucket) {
        this.bucket = bucket;
    }

    String getCannedACL() {
        return this.cannedACL;
    }

    @InterfaceStability.Unstable
    @Deprecated
    public void setInputPolicy(S3AInputPolicy inputPolicy) {
        LOG.warn("setInputPolicy is no longer supported");
    }

    @VisibleForTesting
    public String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    @InterfaceAudience.Private
    public String maybeAddTrailingSlash(String key) {
        return S3AUtils.maybeAddTrailingSlash(key);
    }

    Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public Path keyToQualifiedPath(String key) {
        return this.qualify(this.keyToPath(key));
    }

    public Path makeQualified(Path path) {
        String urlString;
        Path q = super.makeQualified(path);
        if (!q.isRoot() && (urlString = q.toUri().toString()).endsWith("/")) {
            LOG.debug("Stripping trailing '/' from {}", (Object)q);
            q = new Path(urlString.substring(0, urlString.length() - 1));
        }
        if (!q.isRoot() && q.getName().isEmpty()) {
            q = q.getParent();
        }
        return q;
    }

    public Path qualify(Path path) {
        return this.makeQualified(path);
    }

    public void checkPath(Path path) {
        S3xLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return S3xLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.executeOpen(this.qualify(f), this.openFileHelper.openSimpleFile(bufferSize));
    }

    private FSDataInputStream executeOpen(Path path, OpenFileSupport.OpenFileInformation fileInformation) throws IOException {
        S3AInputStreamStatistics inputStreamStats = this.statisticsContext.newInputStreamStatistics();
        AuditSpan auditSpan = this.entryPoint(Statistic.INVOCATION_OPEN, path);
        S3AFileStatus fileStatus = (S3AFileStatus)((Object)IOStatisticsBinding.trackDuration((DurationTrackerFactory)inputStreamStats, (String)Statistic.ACTION_FILE_OPENED.getSymbol(), () -> this.extractOrFetchSimpleFileStatus(path, fileInformation)));
        S3AReadOpContext readContext = this.createReadContext(fileStatus, auditSpan);
        fileInformation.applyOptions(readContext);
        LOG.debug("Opening '{}'", (Object)readContext);
        StreamFactoryRequirements requirements = this.getStore().factoryRequirements();
        int permitCount = requirements.streamThreads() + requirements.vectoredIOContext().getVectoredActiveRangeReads();
        SemaphoredDelegatingExecutor pool = new SemaphoredDelegatingExecutor(this.boundedThreadPool, permitCount, true, (DurationTrackerFactory)inputStreamStats);
        ObjectReadParameters parameters = new ObjectReadParameters().withBoundedThreadPool((ExecutorService)pool).withCallbacks(this.createInputStreamCallbacks(auditSpan)).withContext(readContext.build()).withObjectAttributes(this.createObjectAttributes(path, fileStatus)).withStreamStatistics(inputStreamStats).withEncryptionSecrets(this.getEncryptionSecrets()).withAuditSpan(auditSpan);
        return new FSDataInputStream((InputStream)((Object)this.getStore().readObject(parameters)));
    }

    private ObjectInputStreamCallbacks createInputStreamCallbacks(AuditSpan auditSpan) {
        return new InputStreamCallbacksImpl(auditSpan, this.getStore(), this.fsHandler, this.unboundedThreadPool);
    }

    @VisibleForTesting
    protected S3AReadOpContext createReadContext(FileStatus fileStatus, AuditSpan auditSpan) {
        S3AReadOpContext roc = new S3AReadOpContext(fileStatus.getPath(), this.invoker, this.statistics, this.statisticsContext, fileStatus, this.vectoredIOContext, IOStatisticsContext.getCurrentIOStatisticsContext().getAggregator(), this.futurePool).withAuditSpan(auditSpan);
        this.openFileHelper.applyDefaultOptions(roc);
        return roc.build();
    }

    private S3ObjectAttributes createObjectAttributes(Path f, String eTag, String versionId, long len) {
        return new S3ObjectAttributes(this.bucket, f, this.pathToKey(f), this.getS3EncryptionAlgorithm(), this.encryptionSecrets.getEncryptionKey(), eTag, versionId, len);
    }

    private S3ObjectAttributes createObjectAttributes(Path path, S3AFileStatus fileStatus) {
        return this.createObjectAttributes(path, fileStatus.getEtag(), fileStatus.getVersionId(), fileStatus.getLen());
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path path = this.qualify(f);
        CreateFileBuilder.CreateFileOptions options = this.getPerformanceFlags().enabled((Enum)PerformanceFlagEnum.Create) ? CreateFileBuilder.OPTIONS_CREATE_FILE_PERFORMANCE : (overwrite ? CreateFileBuilder.OPTIONS_CREATE_FILE_OVERWRITE : CreateFileBuilder.OPTIONS_CREATE_FILE_NO_OVERWRITE);
        return (FSDataOutputStream)this.trackDurationAndSpan(Statistic.INVOCATION_CREATE, path, () -> this.innerCreateFile(path, progress, this.getActiveAuditSpan(), options));
    }

    private FSDataOutputStream innerCreateFile(Path path, Progressable progress, AuditSpan auditSpan, CreateFileBuilder.CreateFileOptions options) throws IOException {
        boolean skipList;
        boolean skipHead;
        auditSpan.activate();
        String key = this.pathToKey(path);
        if (key.isEmpty()) {
            throw new PathIOException("/", "Can't create root path");
        }
        EnumSet<CreateFlag> flags = options.getFlags();
        boolean cCreate = options.isConditionalOverwrite();
        boolean cEtag = options.isConditionalOverwriteEtag();
        boolean createPerf = options.isPerformance();
        boolean overwrite = flags.contains(CreateFlag.OVERWRITE);
        boolean magic = this.isUnderMagicCommitPath(path);
        boolean ccAvailable = this.conditionalCreateEnabled;
        if (!ccAvailable && (cCreate || cEtag)) {
            throw new PathIOException(path.toString(), "Conditional Writes Unavailable");
        }
        EnumSet<StatusProbeEnum> probes = EnumSet.of(StatusProbeEnum.List, StatusProbeEnum.Head);
        boolean conditionalPut = cCreate || !overwrite && !cEtag && ccAvailable && createPerf;
        boolean bl = skipHead = createPerf || magic || overwrite || cCreate || cEtag;
        if (skipHead) {
            probes.remove((Object)StatusProbeEnum.Head);
        }
        boolean bl2 = skipList = createPerf || magic || cCreate || cEtag;
        if (skipList) {
            probes.remove((Object)StatusProbeEnum.List);
        }
        if (!probes.isEmpty()) {
            try {
                S3AFileStatus status = this.innerGetFileStatus(path, false, probes);
                if (status.isDirectory()) {
                    throw new FileAlreadyExistsException(path + " is a directory");
                }
                if (!overwrite) {
                    throw new FileAlreadyExistsException(path + " already exists");
                }
                LOG.debug("Overwriting file {}", (Object)path);
            }
            catch (FileNotFoundException status) {}
        } else {
            LOG.debug("Skipping all probes with flags: createPerf={}, magic={}, ccAvailable={}, cCreate={}, cEtag={}", new Object[]{createPerf, magic, ccAvailable, cCreate, cEtag});
        }
        this.instrumentation.fileCreated();
        BlockOutputStreamStatistics outputStreamStatistics = this.statisticsContext.newOutputStreamStatistics();
        PutTracker putTracker = this.committerIntegration.createTracker(path, key, outputStreamStatistics);
        String destKey = putTracker.getDestKey();
        EnumSet<WriteObjectFlags> putFlags = options.writeObjectFlags();
        if (conditionalPut) {
            putFlags.add(WriteObjectFlags.ConditionalOverwrite);
        }
        PutObjectOptions putOptions = new PutObjectOptions(null, options.getHeaders(), putFlags, options.etag());
        S3AUtils.validateOutputStreamConfiguration(path, this.getConf());
        S3ABlockOutputStream.BlockOutputStreamBuilder builder = S3ABlockOutputStream.builder().withKey(destKey).withBlockFactory(this.blockFactory).withBlockSize(this.partSize).withStatistics(outputStreamStatistics).withProgress(progress).withPutTracker(putTracker).withWriteOperations(this.createWriteOperationHelper(auditSpan)).withExecutorService((ExecutorService)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true, (DurationTrackerFactory)outputStreamStatistics)).withDowngradeSyncableExceptions(this.getConf().getBoolean("fs.s3a.downgrade.syncable.exceptions", true)).withCSEEnabled(this.isCSEEnabled).withPutOptions(putOptions).withIOStatisticsAggregator(IOStatisticsContext.getCurrentIOStatisticsContext().getAggregator()).withMultipartEnabled(this.isMultipartUploadEnabled);
        return new FSDataOutputStream((OutputStream)new S3ABlockOutputStream(builder), null);
    }

    @InterfaceAudience.Private
    public WriteOperationHelper getWriteOperationHelper() {
        return this.createWriteOperationHelper(this.getActiveAuditSpan());
    }

    @InterfaceAudience.Private
    public WriteOperationHelper createWriteOperationHelper(AuditSpan auditSpan) {
        return new WriteOperationHelper(this, this.getConf(), this.statisticsContext, this.getAuditSpanSource(), auditSpan, new WriteOperationHelperCallbacksImpl());
    }

    public FSDataOutputStreamBuilder createFile(Path path) {
        try {
            Path qualified = this.qualify(path);
            AuditSpan span = this.entryPoint(Statistic.INVOCATION_CREATE_FILE, this.pathToKey(qualified), null);
            CreateFileBuilder builder = new CreateFileBuilder(this, qualified, new CreateFileBuilderCallbacksImpl(Statistic.INVOCATION_CREATE_FILE, span));
            ((CreateFileBuilder)((CreateFileBuilder)builder.create()).overwrite(true)).must("fs.s3a.create.performance", this.getPerformanceFlags().enabled((Enum)PerformanceFlagEnum.Create));
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FSDataOutputStream createNonRecursive(Path p, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path path = this.makeQualified(p);
        AuditSpan span = this.entryPoint(Statistic.INVOCATION_CREATE_NON_RECURSIVE, this.pathToKey(path), null);
        CreateFileBuilder builder = (CreateFileBuilder)((CreateFileBuilder)((CreateFileBuilder)((CreateFileBuilder)new CreateFileBuilder(this, path, new CreateFileBuilderCallbacksImpl(Statistic.INVOCATION_CREATE_NON_RECURSIVE, span)).create()).withFlags(flags).blockSize(blockSize)).bufferSize(bufferSize)).must("fs.s3a.create.performance", this.getPerformanceFlags().enabled((Enum)PerformanceFlagEnum.Create));
        if (progress != null) {
            builder.progress(progress);
        }
        return builder.build();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported by S3AFileSystem");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        try {
            long bytesCopied = (Long)this.trackDurationAndSpan(Statistic.INVOCATION_RENAME, src.toString(), dst.toString(), () -> this.innerRename(src, dst));
            LOG.debug("Copied {} bytes", (Object)bytesCopied);
            return true;
        }
        catch (SdkException e) {
            throw S3AUtils.translateException("rename(" + src + ", " + dst + ")", src, e);
        }
        catch (RenameFailedException e) {
            LOG.info("{}", (Object)e.getMessage());
            LOG.debug("rename failure", (Throwable)((Object)e));
            return e.getExitCode();
        }
    }

    private Pair<S3AFileStatus, S3AFileStatus> initiateRename(Path src, Path dst) throws IOException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        block13: {
            String srcKey = this.pathToKey(src);
            String dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "source is root directory");
            }
            if (dstKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "dest is root directory");
            }
            srcStatus = this.innerGetFileStatus(src, true, StatusProbeEnum.ALL);
            if (srcKey.equals(dstKey)) {
                LOG.debug("rename: src and dest refer to the same file or directory: {}", (Object)dst);
                throw new RenameFailedException(src, dst, "source and dest refer to the same file or directory").withExitCode(srcStatus.isFile());
            }
            dstStatus = null;
            try {
                dstStatus = this.innerGetFileStatus(dst, true, StatusProbeEnum.ALL);
                if (srcStatus.isDirectory()) {
                    if (dstStatus.isFile()) {
                        throw new FileAlreadyExistsException("Failed to rename " + src + " to " + dst + "; source is a directory and dest is a file");
                    }
                    if (dstStatus.isEmptyDirectory() != Tristate.TRUE) {
                        throw new RenameFailedException(src, dst, "Destination is a non-empty directory").withExitCode(false);
                    }
                } else if (dstStatus.isFile()) {
                    throw new FileAlreadyExistsException("Failed to rename " + src + " to " + dst + "; destination file exists");
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("rename: destination path {} not found", (Object)dst);
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty() || parent.equals((Object)src.getParent())) break block13;
                try {
                    S3AFileStatus dstParentStatus = this.innerGetFileStatus(parent, false, StatusProbeEnum.FILE);
                    if (!dstParentStatus.isDirectory()) {
                        throw new RenameFailedException(src, dst, "destination parent is not a directory");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return Pair.of((Object)((Object)srcStatus), (Object)((Object)dstStatus));
    }

    private long innerRename(Path source, Path dest) throws RenameFailedException, FileNotFoundException, IOException, SdkException {
        Path src = this.qualify(source);
        Path dst = this.qualify(dest);
        LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
        String srcKey = this.pathToKey(src);
        String dstKey = this.pathToKey(dst);
        Pair<S3AFileStatus, S3AFileStatus> p = this.initiateRename(src, dst);
        StoreContext storeContext = this.createStoreContext();
        RenameOperation renameOperation = new RenameOperation(storeContext, src, srcKey, (S3AFileStatus)((Object)p.getLeft()), dst, dstKey, (S3AFileStatus)((Object)p.getRight()), new OperationCallbacksImpl(storeContext), this.pageSize, this.dirOperationsPurgeUploads);
        return renameOperation.execute();
    }

    @Override
    public Token<? extends TokenIdentifier> getFsDelegationToken() throws IOException {
        return this.getDelegationToken(null);
    }

    private long abortMultipartUploadsUnderPrefix(StoreContext storeContext, AuditSpan span, String prefix) throws IOException {
        span.activate();
        RemoteIterator<MultipartUpload> uploads = this.listUploadsUnderPrefix(storeContext, prefix);
        span.activate();
        return RemoteIterators.foreach(uploads, upload -> this.invoker.retry("Aborting multipart commit", upload.key(), true, () -> this.abortMultipartUpload((MultipartUpload)upload)));
    }

    @InterfaceAudience.LimitedPrivate(value={"utilities"})
    @Deprecated
    public HeadObjectResponse getObjectMetadata(Path path) throws IOException {
        return this.getS3AInternals().getObjectMetadata(path);
    }

    private HeadObjectResponse getObjectMetadata(Path path, ChangeTracker changeTracker, Invoker changeInvoker, String operation) throws IOException {
        String key = this.pathToKey(path);
        return (HeadObjectResponse)Invoker.once(operation, path.toString(), () -> this.getObjectMetadata(key, changeTracker, changeInvoker, operation));
    }

    protected AuditSpan entryPoint(Statistic operation, Path path) throws IOException {
        return this.entryPoint(operation, path != null ? this.pathToKey(path) : null, null);
    }

    protected AuditSpan entryPoint(Statistic operation, @Nullable String path1, @Nullable String path2) throws IOException {
        this.checkNotClosed();
        this.incrementStatistic(operation);
        return this.createSpan(operation.getSymbol(), path1, path2);
    }

    private <B> B trackDurationAndSpan(Statistic statistic, String path, String path2, CallableRaisingIOE<B> input) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(statistic.getSymbol(), path, path2);){
            Object object = IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)statistic.getSymbol(), input);
            return (B)object;
        }
    }

    private <B> B trackDurationAndSpan(Statistic statistic, @Nullable Path path, CallableRaisingIOE<B> input) throws IOException {
        return this.trackDurationAndSpan(statistic, path != null ? this.pathToKey(path) : null, null, input);
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.statisticsContext.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.statisticsContext.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.statisticsContext.incrementGauge(statistic, count);
    }

    public void operationRetried(Exception ex) {
        if (S3AUtils.isThrottleException(ex)) {
            LOG.debug("Request throttled");
            this.incrementStatistic(Statistic.STORE_IO_THROTTLED);
            this.statisticsContext.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, 1L);
        } else {
            this.incrementStatistic(Statistic.STORE_IO_RETRY);
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    public S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    public IOStatistics getIOStatistics() {
        return this.instrumentation != null ? this.instrumentation.getIOStatistics() : null;
    }

    protected DurationTrackerFactory getDurationTrackerFactory() {
        return this.instrumentation != null ? this.instrumentation.getDurationTrackerFactory() : null;
    }

    protected DurationTrackerFactory nonNullDurationTrackerFactory(DurationTrackerFactory factory) {
        return this.getStore().nonNullDurationTrackerFactory(factory);
    }

    @InterfaceAudience.LimitedPrivate(value={"external utilities"})
    @VisibleForTesting
    HeadObjectResponse getObjectMetadata(String key) throws IOException {
        return this.getObjectMetadata(key, null, this.invoker, "getObjectMetadata");
    }

    protected HeadObjectResponse getObjectMetadata(String key, ChangeTracker changeTracker, Invoker changeInvoker, String operation) throws IOException {
        return this.getStore().headObject(key, changeTracker, changeInvoker, this.fsHandler, operation);
    }

    protected HeadBucketResponse getBucketMetadata() throws IOException {
        HeadBucketResponse response = (HeadBucketResponse)this.trackDurationAndSpan(Statistic.STORE_EXISTS_PROBE, this.bucket, null, () -> (HeadBucketResponse)this.invoker.retry("getBucketMetadata()", this.bucket, true, () -> {
            try {
                return this.getS3Client().headBucket((HeadBucketRequest)this.getRequestFactory().newHeadBucketRequestBuilder(this.bucket).build());
            }
            catch (NoSuchBucketException e) {
                throw new UnknownStoreException("s3a://" + this.bucket + "/", " Bucket does not exist");
            }
        }));
        return response;
    }

    protected S3ListResult listObjects(S3ListRequest request, @Nullable DurationTrackerFactory trackerFactory) throws IOException {
        this.incrementReadOperations();
        LOG.debug("LIST {}", (Object)request);
        this.validateListArguments(request);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "LIST", new Object[0]);){
            S3ListResult s3ListResult = (S3ListResult)this.invoker.retryUntranslated(request.toString(), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)trackerFactory, (String)"object_list_request", () -> {
                if (this.useListV1) {
                    return S3ListResult.v1(this.getS3Client().listObjects(request.getV1()));
                }
                return S3ListResult.v2(this.getS3Client().listObjectsV2(request.getV2()));
            }));
            return s3ListResult;
        }
    }

    private void validateListArguments(S3ListRequest request) {
        if (this.useListV1) {
            Preconditions.checkArgument((boolean)request.isV1());
        } else {
            Preconditions.checkArgument((!request.isV1() ? 1 : 0) != 0);
        }
    }

    protected S3ListResult continueListObjects(S3ListRequest request, S3ListResult prevResult, DurationTrackerFactory trackerFactory) throws IOException {
        this.incrementReadOperations();
        this.validateListArguments(request);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "LIST (continued)", new Object[0]);){
            S3ListResult s3ListResult = (S3ListResult)this.invoker.retryUntranslated(request.toString(), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)trackerFactory, (String)"object_continue_list_request", () -> {
                if (this.useListV1) {
                    List prevListResult = prevResult.getV1().contents();
                    String nextMarker = prevResult.getV1().nextMarker() != null ? prevResult.getV1().nextMarker() : ((S3Object)prevListResult.get(prevListResult.size() - 1)).key();
                    return S3ListResult.v1(this.getS3Client().listObjects((ListObjectsRequest)request.getV1().toBuilder().marker(nextMarker).build()));
                }
                return S3ListResult.v2(this.getS3Client().listObjectsV2((ListObjectsV2Request)request.getV2().toBuilder().continuationToken(prevResult.getV2().nextContinuationToken()).build()));
            }));
            return s3ListResult;
        }
    }

    public void incrementReadOperations() {
        this.statistics.incrementReadOps(1);
    }

    public void incrementWriteOperations() {
        this.statistics.incrementWriteOps(1);
    }

    @VisibleForTesting
    protected void deleteObject(String key) throws SdkException, IOException {
        this.incrementWriteOperations();
        this.getStore().deleteObject((DeleteObjectRequest)this.getRequestFactory().newDeleteObjectRequestBuilder(key).build());
    }

    void deleteObjectAtPath(Path f, String key, boolean isFile) throws SdkException, IOException {
        if (isFile) {
            this.instrumentation.fileDeleted(1);
        } else {
            this.instrumentation.directoryDeleted();
        }
        this.deleteObject(key);
    }

    private DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteRequest) throws MultiObjectDeleteException, SdkException, IOException {
        this.incrementWriteOperations();
        DeleteObjectsResponse response = this.getStore().deleteObjects(deleteRequest).getValue();
        if (!response.errors().isEmpty()) {
            throw new MultiObjectDeleteException(response.errors());
        }
        return response;
    }

    public PutObjectRequest.Builder newPutObjectRequestBuilder(String key, long length, boolean isDirectoryMarker) {
        return this.requestFactory.newPutObjectRequestBuilder(key, PutObjectOptions.defaultOptions(), length, isDirectoryMarker);
    }

    public UploadInfo putObject(PutObjectRequest putObjectRequest, File file, ProgressableProgressListener listener) throws IOException {
        return this.getStore().putObject(putObjectRequest, file, listener);
    }

    @VisibleForTesting
    PutObjectResponse putObjectDirect(PutObjectRequest putObjectRequest, PutObjectOptions putOptions, S3ADataBlocks.BlockUploadData uploadData, DurationTrackerFactory durationTrackerFactory) throws SdkException {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {}", (Object)len, (Object)putObjectRequest.key());
        this.incrementPutStartStatistics(len);
        UploadContentProviders.BaseContentProvider<?> provider = uploadData.getContentProvider();
        try {
            PutObjectResponse response = (PutObjectResponse)IOStatisticsBinding.trackDurationOfSupplier((DurationTrackerFactory)this.nonNullDurationTrackerFactory(durationTrackerFactory), (String)Statistic.OBJECT_PUT_REQUESTS.getSymbol(), () -> this.getS3Client().putObject(putObjectRequest, RequestBody.fromContentProvider((ContentStreamProvider)provider, (long)provider.getSize(), (String)"application/octet-stream")));
            this.incrementPutCompletedStatistics(true, len);
            return response;
        }
        catch (SdkException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    private long getPutRequestLength(PutObjectRequest putObjectRequest) {
        long len = putObjectRequest.contentLength();
        Preconditions.checkState((len >= 0L ? 1 : 0) != 0, (Object)"Cannot PUT object of unknown length");
        return len;
    }

    UploadPartResponse uploadPart(UploadPartRequest request, RequestBody body, DurationTrackerFactory durationTrackerFactory) throws AwsServiceException {
        long len = request.contentLength();
        this.incrementPutStartStatistics(len);
        try {
            UploadPartResponse uploadPartResponse = (UploadPartResponse)IOStatisticsBinding.trackDurationOfSupplier((DurationTrackerFactory)this.nonNullDurationTrackerFactory(durationTrackerFactory), (String)Statistic.MULTIPART_UPLOAD_PART_PUT.getSymbol(), () -> this.getS3Client().uploadPart(request, body));
            this.incrementPutCompletedStatistics(true, len);
            return uploadPartResponse;
        }
        catch (AwsServiceException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    protected void incrementPutStartStatistics(long bytes) {
        this.getStore().incrementPutStartStatistics(bytes);
    }

    protected void incrementPutCompletedStatistics(boolean success, long bytes) {
        this.getStore().incrementPutCompletedStatistics(success, bytes);
    }

    protected void incrementPutProgressStatistics(String key, long bytes) {
        this.getStore().incrementPutProgressStatistics(key, bytes);
    }

    private void removeKeysS3(List<ObjectIdentifier> keysToDelete, boolean deleteFakeDir) throws MultiObjectDeleteException, AwsServiceException, IOException {
        if (keysToDelete.isEmpty()) {
            return;
        }
        if (keysToDelete.size() == 1) {
            this.deleteObject(keysToDelete.get(0).key());
            this.noteDeleted(1, deleteFakeDir);
            return;
        }
        try {
            if (this.enableMultiObjectsDelete) {
                if (keysToDelete.size() <= this.pageSize) {
                    this.deleteObjects((DeleteObjectsRequest)this.getRequestFactory().newBulkDeleteRequestBuilder(keysToDelete).build());
                } else {
                    LOG.debug("Partitioning the keys to delete as it is more than page size. Number of keys: {}, Page size: {}", (Object)keysToDelete.size(), (Object)this.pageSize);
                    for (List batchOfKeysToDelete : Lists.partition(keysToDelete, (int)this.pageSize)) {
                        this.deleteObjects((DeleteObjectsRequest)this.getRequestFactory().newBulkDeleteRequestBuilder(batchOfKeysToDelete).build());
                    }
                }
            } else {
                for (ObjectIdentifier objectIdentifier : keysToDelete) {
                    this.deleteObject(objectIdentifier.key());
                }
            }
        }
        catch (MultiObjectDeleteException ex) {
            int rejected = ex.errors().size();
            this.noteDeleted(keysToDelete.size() - rejected, deleteFakeDir);
            this.incrementStatistic(Statistic.FILES_DELETE_REJECTED, rejected);
            throw ex;
        }
        this.noteDeleted(keysToDelete.size(), deleteFakeDir);
    }

    private void noteDeleted(int count, boolean deleteFakeDir) {
        if (!deleteFakeDir) {
            this.instrumentation.fileDeleted(count);
        } else {
            this.instrumentation.fakeDirsDeleted(count);
        }
    }

    @VisibleForTesting
    public void removeKeys(List<ObjectIdentifier> keysToDelete, boolean deleteFakeDir) throws MultiObjectDeleteException, AwsServiceException, IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Deleting %d keys", new Object[]{keysToDelete.size()});){
            this.removeKeysS3(keysToDelete, deleteFakeDir);
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.checkNotClosed();
        return this.deleteWithoutCloseCheck(f, recursive);
    }

    @VisibleForTesting
    protected boolean deleteWithoutCloseCheck(Path f, boolean recursive) throws IOException {
        boolean bl;
        block12: {
            Path path = this.qualify(f);
            AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_DELETE.getSymbol(), path.toString(), null);
            try {
                StoreContext storeContext = this.createStoreContext();
                boolean outcome = (Boolean)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.INVOCATION_DELETE.getSymbol(), (CallableRaisingIOE)new DeleteOperation(storeContext, this.innerGetFileStatus(path, true, StatusProbeEnum.ALL), recursive, new OperationCallbacksImpl(storeContext), this.pageSize, this.dirOperationsPurgeUploads));
                if (outcome) {
                    try {
                        this.maybeCreateFakeParentDirectory(path);
                    }
                    catch (AccessDeniedException e) {
                        LOG.warn("Cannot create directory marker at {}: {}", (Object)f.getParent(), (Object)e.toString());
                        LOG.debug("Failed to create fake dir above {}", (Object)path, (Object)e);
                    }
                }
                bl = outcome;
                if (span == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (span != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    LOG.debug("Couldn't delete {} - does not exist: {}", (Object)path, (Object)e.toString());
                    this.instrumentation.errorIgnored();
                    return false;
                }
                catch (SdkException e) {
                    throw S3AUtils.translateException("delete", path, e);
                }
            }
            span.close();
        }
        return bl;
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException, SdkException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.s3Exists(f, StatusProbeEnum.DIRECTORIES)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.createFakeDirectory(key, PutObjectOptions.defaultOptions());
        }
    }

    @VisibleForTesting
    protected void maybeCreateFakeParentDirectory(Path path) throws IOException, SdkException {
        Path parent = path.getParent();
        if (parent != null && !parent.isRoot() && !this.isUnderMagicCommitPath(parent)) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws FileNotFoundException, IOException {
        Path path = this.qualify(p);
        return RemoteIterators.typeCastingRemoteIterator((RemoteIterator)((RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_STATUS, path, () -> (RemoteIterator)Invoker.once("listStatus", path.toString(), () -> this.innerListStatus(p)))));
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        Path path = this.qualify(f);
        return (FileStatus[])this.trackDurationAndSpan(Statistic.INVOCATION_LIST_STATUS, path, () -> (S3AFileStatus[])Invoker.once("listStatus", path.toString(), () -> S3AUtils.iteratorToStatuses(this.innerListStatus(path))));
    }

    private RemoteIterator<S3AFileStatus> innerListStatus(Path f) throws FileNotFoundException, IOException, SdkException {
        S3AFileStatus fileStatus;
        Path path = this.qualify(f);
        LOG.debug("List status for path: {}", (Object)path);
        RemoteIterator<S3AFileStatus> statusIt = this.listing.getFileStatusesAssumingNonEmptyDir(path, this.getActiveAuditSpan());
        if (!statusIt.hasNext() && (fileStatus = this.innerGetFileStatus(path, false, StatusProbeEnum.ALL)).isFile()) {
            LOG.debug("Adding: rd (not a dir): {}", (Object)path);
            S3AFileStatus[] stats = new S3AFileStatus[]{fileStatus};
            return this.listing.createProvidedFileStatusIterator(stats, S3AUtils.ACCEPT_ALL, Listing.ACCEPT_ALL_BUT_S3N);
        }
        return statusIt;
    }

    @VisibleForTesting
    public S3ListRequest createListObjectsRequest(String key, String delimiter) {
        return this.createListObjectsRequest(key, delimiter, this.maxKeys);
    }

    private S3ListRequest createListObjectsRequest(String key, String delimiter, int limit) {
        if (!this.useListV1) {
            ListObjectsV2Request.Builder requestBuilder = this.getRequestFactory().newListObjectsV2RequestBuilder(key, delimiter, limit);
            return S3ListRequest.v2((ListObjectsV2Request)requestBuilder.build());
        }
        ListObjectsRequest.Builder requestBuilder = this.getRequestFactory().newListObjectsV1RequestBuilder(key, delimiter, limit);
        return S3ListRequest.v1((ListObjectsRequest)requestBuilder.build());
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeQualified(newDir);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getUsername() {
        return this.username;
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public boolean mkdirs(Path p, FsPermission permission) throws IOException, FileAlreadyExistsException {
        Path path = this.qualify(p);
        return this.trackDurationAndSpan(Statistic.INVOCATION_MKDIRS, path, new MkdirOperation(this.createStoreContext(), path, this.createMkdirOperationCallbacks(), this.isMagicCommitPath(path), this.performanceFlags.enabled((Enum)PerformanceFlagEnum.Mkdir)));
    }

    @VisibleForTesting
    public MkdirOperation.MkdirCallbacks createMkdirOperationCallbacks() {
        return new MkdirOperationCallbacksImpl();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        Path path = this.qualify(f);
        return this.trackDurationAndSpan(Statistic.INVOCATION_GET_CONTENT_SUMMARY, path, new GetContentSummaryOperation(this.createStoreContext(), path, this.createGetContentSummaryCallbacks()));
    }

    protected GetContentSummaryOperation.GetContentSummaryCallbacks createGetContentSummaryCallbacks() {
        return new GetContentSummaryCallbacksImpl();
    }

    public void access(Path f, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        Path path = this.qualify(f);
        LOG.debug("check access mode {} for {}", (Object)path, (Object)mode);
        this.trackDurationAndSpan(Statistic.INVOCATION_ACCESS, path, () -> {
            S3AFileStatus stat = this.innerGetFileStatus(path, false, StatusProbeEnum.ALL);
            if (!this.getAuditManager().checkAccess(path, stat, mode)) {
                this.incrementStatistic(Statistic.AUDIT_ACCESS_CHECK_FAILURE);
                throw new AccessControlException(String.format("Permission denied: user=%s, path=\"%s\":%s:%s:%s%s", this.getOwner().getUserName(), stat.getPath(), stat.getOwner(), stat.getGroup(), stat.isDirectory() ? "d" : "-", mode));
            }
            return true;
        });
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        Path path = this.qualify(f);
        if (MagicCommitTrackerUtils.isTrackMagicCommitsInMemoryEnabled(this.getConf()) && this.isMagicCommitPath(path) && InMemoryMagicCommitTracker.getPathToBytesWritten().containsKey(path)) {
            long len = InMemoryMagicCommitTracker.getPathToBytesWritten().get(path);
            return new S3AFileStatus(len, 0L, path, this.getDefaultBlockSize(path), this.username, "pending", null);
        }
        return (FileStatus)this.trackDurationAndSpan(Statistic.INVOCATION_GET_FILE_STATUS, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.ALL));
    }

    @VisibleForTesting
    S3AFileStatus innerGetFileStatus(Path f, boolean needEmptyDirectoryFlag, Set<StatusProbeEnum> probes) throws IOException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("Getting path status for {}  ({}); needEmptyDirectory={}", new Object[]{path, key, needEmptyDirectoryFlag});
        return this.s3GetFileStatus(path, key, probes, needEmptyDirectoryFlag);
    }

    @VisibleForTesting
    S3AFileStatus s3GetFileStatus(Path path, String key, Set<StatusProbeEnum> probes, boolean needEmptyDirectoryFlag) throws IOException {
        LOG.debug("S3GetFileStatus {}", (Object)path);
        Preconditions.checkArgument((!needEmptyDirectoryFlag || probes.contains((Object)StatusProbeEnum.List) ? 1 : 0) != 0, (String)"s3GetFileStatus(%s) wants to know if a directory is empty but does not request a list probe", (Object[])new Object[]{path});
        if (key.isEmpty() && !needEmptyDirectoryFlag) {
            return new S3AFileStatus(Tristate.UNKNOWN, path, this.username);
        }
        if (!key.isEmpty() && !key.endsWith("/") && probes.contains((Object)StatusProbeEnum.Head)) {
            try {
                HeadObjectResponse meta = this.getObjectMetadata(key);
                LOG.debug("Found exact file: normal file {}", (Object)key);
                return new S3AFileStatus(meta.contentLength(), meta.lastModified().toEpochMilli(), path, this.getDefaultBlockSize(path), this.username, meta.eTag(), meta.versionId());
            }
            catch (AwsServiceException e) {
                if (e.statusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                    throw S3AUtils.translateException("getFileStatus", path, (SdkException)((Object)e));
                }
            }
            catch (SdkException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
        }
        if (probes.contains((Object)StatusProbeEnum.List)) {
            try {
                String dirKey = this.maybeAddTrailingSlash(key);
                int listSize = 2;
                S3ListRequest request = this.createListObjectsRequest(dirKey, "/", 2);
                S3ListResult listResult = this.listObjects(request, this.getDurationTrackerFactory());
                if (listResult.hasPrefixesOrObjects()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found path as directory (with /)");
                        listResult.logAtDebug(LOG);
                    }
                    if (needEmptyDirectoryFlag && listResult.representsEmptyDirectory(dirKey)) {
                        return new S3AFileStatus(Tristate.TRUE, path, this.username);
                    }
                    return new S3AFileStatus(Tristate.FALSE, path, this.username);
                }
                if (key.isEmpty()) {
                    LOG.debug("Found root directory");
                    return new S3AFileStatus(Tristate.TRUE, path, this.username);
                }
            }
            catch (AwsServiceException e) {
                if (e.statusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                    throw S3AUtils.translateException("getFileStatus", path, (SdkException)((Object)e));
                }
            }
            catch (SdkException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
        }
        LOG.debug("Not Found: {}", (Object)path);
        throw new FileNotFoundException("No such file or directory: " + path);
    }

    private boolean s3Exists(Path path, Set<StatusProbeEnum> probes) throws IOException {
        String key = this.pathToKey(path);
        try {
            this.s3GetFileStatus(path, key, probes, false);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.checkNotClosed();
        LOG.debug("Copying local file from {} to {} (delSrc={} overwrite={}", new Object[]{src, dst, delSrc, overwrite});
        if (this.optimizedCopyFromLocal) {
            this.trackDurationAndSpan(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE, dst, () -> new CopyFromLocalOperation(this.createStoreContext(), src, dst, delSrc, overwrite, this.createCopyFromLocalCallbacks(this.getActiveAuditSpan())).execute());
        } else {
            LOG.debug("Using base copyFromLocalFile implementation");
            this.trackDurationAndSpan(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE, dst, () -> {
                super.copyFromLocalFile(delSrc, overwrite, src, dst);
                return null;
            });
        }
    }

    protected CopyFromLocalOperation.CopyFromLocalOperationCallbacks createCopyFromLocalCallbacks(AuditSpanS3A span) throws IOException {
        LocalFileSystem local = S3AFileSystem.getLocal((Configuration)this.getConf());
        return new CopyFromLocalCallbacksImpl(span, local);
    }

    PutObjectResponse executePut(PutObjectRequest putObjectRequest, Progressable progress, PutObjectOptions putOptions, File file) throws IOException {
        String key = putObjectRequest.key();
        ProgressableProgressListener listener = new ProgressableProgressListener(this.store, key, progress);
        UploadInfo info = this.putObject(putObjectRequest, file, listener);
        PutObjectResponse result = this.getStore().waitForUploadCompletion(key, info).response();
        listener.uploadCompleted((ObjectTransfer)info.getFileUpload());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(Path f) throws IOException {
        Path qualifedPath = this.makeQualified(f);
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            this.deleteOnExit.add(qualifedPath);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDeleteOnExit(Path f) {
        Path qualifedPath = this.makeQualified(f);
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            return this.deleteOnExit.remove(qualifedPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            Iterator<Path> iter = this.deleteOnExit.iterator();
            while (iter.hasNext()) {
                Path path = iter.next();
                try {
                    this.deleteWithoutCloseCheck(path, true);
                }
                catch (IOException e) {
                    LOG.info("Ignoring failure to deleteOnExit for path {}", (Object)path);
                    LOG.debug("The exception for deleteOnExit is {}", (Throwable)e);
                }
                iter.remove();
            }
        }
    }

    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Filesystem {} is closed", (Object)this.uri);
        try {
            super.close();
        }
        finally {
            this.stopAllServices();
            if (this.getConf() != null) {
                String iostatisticsLoggingLevel = this.getConf().getTrimmed("fs.iostatistics.logging.level", "debug");
                IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)iostatisticsLoggingLevel, (Object)this.getIOStatistics());
            }
        }
    }

    protected synchronized void stopAllServices() {
        try {
            IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.FILESYSTEM_CLOSE.getSymbol(), () -> {
                S3AUtils.closeAutocloseables(LOG, new AutoCloseable[]{this.getStore()});
                this.store = null;
                this.s3Client = null;
                if (this.futurePool != null) {
                    this.futurePool.shutdown(LOG, 30L, TimeUnit.SECONDS);
                    this.futurePool = null;
                }
                HadoopExecutors.shutdown((ExecutorService)this.boundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
                this.boundedThreadPool = null;
                HadoopExecutors.shutdown((ExecutorService)this.unboundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
                this.unboundedThreadPool = null;
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.delegationTokens.orElse(null), this.signerManager, this.auditManager});
                S3AUtils.closeAutocloseables(LOG, this.credentials);
                this.delegationTokens = Optional.empty();
                this.signerManager = null;
                this.credentials = null;
                return null;
            });
        }
        catch (IOException e) {
            LOG.warn("Failure during service shutdown", (Throwable)e);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.instrumentation});
    }

    private void checkNotClosed() throws PathIOException {
        if (this.isClosed) {
            throw new PathIOException(this.uri.toString(), "FileSystem is closed!");
        }
    }

    @VisibleForTesting
    public Optional<S3ADelegationTokens> getDelegationTokens() {
        return this.delegationTokens;
    }

    public String getCanonicalServiceName() {
        if (!this.delegationTokens.isPresent()) {
            return null;
        }
        S3ADelegationTokens dt = this.delegationTokens.get();
        return dt.getTokenIssuingPolicy() != S3ADelegationTokens.TokenIssuingPolicy.NoTokensAvailable ? dt.getCanonicalServiceName() : null;
    }

    public Token<AbstractS3ATokenIdentifier> getDelegationToken(String renewer) throws IOException {
        this.checkNotClosed();
        LOG.debug("Delegation token requested");
        if (this.delegationTokens.isPresent()) {
            return (Token)this.trackDurationAndSpan(Statistic.INVOCATION_GET_DELEGATION_TOKEN, null, () -> this.delegationTokens.get().getBoundOrNewDT(this.encryptionSecrets, renewer != null ? new Text(renewer) : new Text()));
        }
        LOG.debug("Token support is not enabled");
        return null;
    }

    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        this.checkNotClosed();
        if (this.delegationTokens.isPresent()) {
            return this.delegationTokens.get().getAdditionalTokenIssuers();
        }
        LOG.debug("Token support is not enabled");
        return null;
    }

    @Override
    @InterfaceAudience.Private
    public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
        if (access.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RoleModel.Statement> statements = new ArrayList<RoleModel.Statement>(RolePolicies.allowS3Operations(this.bucket, access.contains((Object)AWSPolicyProvider.AccessLevel.WRITE) || access.contains((Object)AWSPolicyProvider.AccessLevel.ADMIN)));
        statements.add(RolePolicies.STATEMENT_ALLOW_KMS_RW);
        if (this.s3ExpressStore) {
            LOG.warn("S3Express store polices not yet implemented");
        }
        return statements;
    }

    private CopyObjectResponse copyFile(String srcKey, String dstKey, long size, S3ObjectAttributes srcAttributes, S3AReadOpContext readContext) throws IOException {
        HeadObjectResponse srcom;
        LOG.debug("copyFile {} -> {} ", (Object)srcKey, (Object)dstKey);
        ChangeTracker changeTracker = new ChangeTracker(this.keyToQualifiedPath(srcKey).toString(), this.changeDetectionPolicy, readContext.getS3AStatisticsContext().newInputStreamStatistics().getChangeTrackerStatistics(), srcAttributes);
        String action = "copyFile(" + srcKey + ", " + dstKey + ")";
        Invoker readInvoker = readContext.getReadInvoker();
        try {
            srcom = (HeadObjectResponse)Invoker.once(action, srcKey, () -> this.getObjectMetadata(srcKey, changeTracker, readInvoker, "copy"));
        }
        catch (FileNotFoundException e) {
            LOG.debug("getObjectMetadata({}) failed to find an expected file", (Object)srcKey, (Object)e);
            throw new RemoteFileChangedException(this.keyToQualifiedPath(srcKey).toString(), action, "File to rename disappeared during the rename operation.", e);
        }
        CopyObjectRequest.Builder copyObjectRequestBuilder = this.getRequestFactory().newCopyObjectRequestBuilder(srcKey, dstKey, srcom);
        changeTracker.maybeApplyConstraint(copyObjectRequestBuilder);
        CopyObjectRequest copyRequest = (CopyObjectRequest)copyObjectRequestBuilder.build();
        LOG.debug("Copy Request: {}", (Object)copyRequest);
        boolean useTransferManager = this.isMultipartCopyEnabled && size >= this.multiPartThreshold;
        CopyObjectResponse response = useTransferManager ? (CopyObjectResponse)readInvoker.retry(action, srcKey, true, () -> {
            this.incrementStatistic(Statistic.OBJECT_COPY_REQUESTS);
            Copy copy = this.getStore().getOrCreateTransferManager().copy(CopyRequest.builder().copyObjectRequest(copyRequest).build());
            try {
                CompletedCopy completedCopy = (CompletedCopy)copy.completionFuture().join();
                return completedCopy.response();
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SdkException) {
                    SdkException awsException = (SdkException)cause;
                    changeTracker.processException(awsException, "copy");
                    throw awsException;
                }
                throw S3AUtils.extractException(action, srcKey, e);
            }
        }) : (CopyObjectResponse)readInvoker.retry(action, srcKey, true, () -> {
            LOG.debug("copyFile: single part copy {} -> {} of size {}", new Object[]{srcKey, dstKey, size});
            this.incrementStatistic(Statistic.OBJECT_COPY_REQUESTS);
            try {
                return this.getS3Client().copyObject(copyRequest);
            }
            catch (SdkException awsException) {
                changeTracker.processException(awsException, "copy");
                throw awsException;
            }
        });
        changeTracker.processResponse(response);
        this.incrementWriteOperations();
        this.instrumentation.filesCopied(1, size);
        return response;
    }

    CreateMultipartUploadResponse initiateMultipartUpload(CreateMultipartUploadRequest request) throws IOException {
        LOG.debug("Initiate multipart upload to {}", (Object)request.key());
        return (CreateMultipartUploadResponse)IOStatisticsBinding.trackDurationOfSupplier((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_MULTIPART_UPLOAD_INITIATED.getSymbol(), () -> this.getS3Client().createMultipartUpload(request));
    }

    @InterfaceAudience.Private
    void finishedWrite(String key, long length, PutObjectOptions putOptions) {
        LOG.debug("Finished write to {}, len {}.", (Object)key, (Object)length);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"content length is negative");
    }

    private void createFakeDirectory(String objectName, PutObjectOptions putOptions) throws IOException {
        this.createEmptyObject(objectName, putOptions);
    }

    private void createEmptyObject(String objectName, PutObjectOptions putOptions) throws IOException {
        S3ADataBlocks.BlockUploadData uploadData = new S3ADataBlocks.BlockUploadData(new byte[0], 0, 0, null);
        this.invoker.retry("PUT 0-byte object ", objectName, true, () -> this.putObjectDirect((PutObjectRequest)this.getRequestFactory().newDirectoryMarkerRequest(objectName).build(), putOptions, uploadData, this.getDurationTrackerFactory()));
        this.incrementPutProgressStatistics(objectName, 0L);
        this.instrumentation.directoryCreated();
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("fs.s3a.block.size", 0x2000000L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectsDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        sb.append(", performanceFlags=").append(this.performanceFlags);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL);
        }
        if (this.openFileHelper != null) {
            sb.append(", ").append(this.openFileHelper);
        }
        if (this.getConf() != null) {
            sb.append(", blockSize=").append(this.getDefaultBlockSize());
        }
        sb.append(", multiPartThreshold=").append(this.multiPartThreshold);
        if (this.getS3EncryptionAlgorithm() != null) {
            sb.append(", s3EncryptionAlgorithm='").append((Object)this.getS3EncryptionAlgorithm()).append('\'');
        }
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", auditManager=").append(this.auditManager);
        sb.append(", useListV1=").append(this.useListV1);
        if (this.committerIntegration != null) {
            sb.append(", magicCommitter=").append(this.isMagicCommitEnabled());
        }
        sb.append(", boundedExecutor=").append(this.boundedThreadPool);
        sb.append(", unboundedExecutor=").append(this.unboundedThreadPool);
        sb.append(", credentials=").append(this.credentials);
        sb.append(", delegation tokens=").append(this.delegationTokens.map(Objects::toString).orElse("disabled"));
        if (this.getInstrumentation() != null) {
            sb.append(", instrumentation {").append(this.getInstrumentation().toString()).append("}");
        }
        sb.append(", ClientSideEncryption=").append(this.isCSEEnabled);
        if (this.accessPoint != null) {
            sb.append(", arnForBucket=").append(this.accessPoint.getFullArn());
        }
        sb.append('}');
        return sb.toString();
    }

    public long getPartitionSize() {
        return this.partSize;
    }

    public long getMultiPartThreshold() {
        return this.multiPartThreshold;
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public boolean isMagicCommitEnabled() {
        return this.committerIntegration.isMagicCommitEnabled();
    }

    public boolean isMagicCommitPath(Path path) {
        return this.committerIntegration.isMagicCommitPath(path);
    }

    private boolean isUnderMagicCommitPath(Path path) {
        return this.committerIntegration.isUnderMagicPath(path);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, S3AUtils.ACCEPT_ALL);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return (FileStatus[])this.trackDurationAndSpan(Statistic.INVOCATION_GLOB_STATUS, pathPattern, () -> Globber.createGlobber((FileSystem)this).withPathPattern(pathPattern).withPathFiltern(filter).withResolveSymlinks(false).build().glob());
    }

    public boolean exists(Path f) throws IOException {
        Path path = this.qualify(f);
        try {
            this.trackDurationAndSpan(Statistic.INVOCATION_EXISTS, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.ALL));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDirectory(Path f) throws IOException {
        Path path = this.qualify(f);
        try {
            return (Boolean)this.trackDurationAndSpan(Statistic.INVOCATION_IS_DIRECTORY, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.DIRECTORIES).isDirectory());
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        Path path = this.qualify(f);
        try {
            return (Boolean)this.trackDurationAndSpan(Statistic.INVOCATION_IS_FILE, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.HEAD_ONLY).isFile());
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public EtagChecksum getFileChecksum(Path f, long length) throws IOException {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        Path path = this.qualify(f);
        if (this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false)) {
            return (EtagChecksum)this.trackDurationAndSpan(Statistic.INVOCATION_GET_FILE_CHECKSUM, path, () -> {
                LOG.debug("getFileChecksum({})", (Object)path);
                HeadObjectResponse headers = this.getObjectMetadata(path, null, this.invoker, "getFileChecksum are");
                String eTag = headers.eTag();
                return eTag != null ? new EtagChecksum(eTag) : null;
            });
        }
        return null;
    }

    private HeaderProcessing getHeaderProcessing() {
        return new HeaderProcessing(this.createStoreContext(), this.createHeaderProcessingCallbacks());
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_XATTR_GET_NAMED.getSymbol(), path.toString(), null);){
            byte[] byArray = this.getHeaderProcessing().getXAttr(path, name);
            return byArray;
        }
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_XATTR_GET_MAP.getSymbol(), path.toString(), null);){
            Map<String, byte[]> map = this.getHeaderProcessing().getXAttrs(path);
            return map;
        }
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_XATTR_GET_NAMED_MAP.getSymbol(), path.toString(), null);){
            Map<String, byte[]> map = this.getHeaderProcessing().getXAttrs(path, names);
            return map;
        }
    }

    public List<String> listXAttrs(Path path) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_OP_XATTR_LIST.getSymbol(), path.toString(), null);){
            List<String> list = this.getHeaderProcessing().listXAttrs(path);
            return list;
        }
    }

    protected HeaderProcessing.HeaderProcessingCallbacks createHeaderProcessingCallbacks() {
        return new HeaderProcessingCallbacksImpl();
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        Path path = this.qualify(f);
        return Listing.toLocatedFileStatusIterator((RemoteIterator<? extends LocatedFileStatus>)((RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_FILES, path, () -> this.innerListFiles(path, recursive, new Listing.AcceptFilesOnly(path), null))));
    }

    @InterfaceAudience.Private
    public RemoteIterator<S3ALocatedFileStatus> listFilesAndEmptyDirectories(Path f, boolean recursive) throws IOException {
        Path path = this.qualify(f);
        return (RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_FILES, path, () -> this.innerListFiles(path, recursive, Listing.ACCEPT_ALL_BUT_S3N, null));
    }

    private RemoteIterator<S3ALocatedFileStatus> innerListFiles(Path f, boolean recursive, Listing.FileStatusAcceptor acceptor, S3AFileStatus status) throws IOException {
        Path path = this.qualify(f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            if (status != null && status.isFile()) {
                LOG.debug("Path is a file: {}", (Object)path);
                return this.listing.createSingleStatusIterator(this.toLocatedFileStatus(status));
            }
            RemoteIterator<S3ALocatedFileStatus> listFilesAssumingDir = this.listing.getListFilesAssumingDir(path, recursive, acceptor, this.getActiveAuditSpan());
            if (!listFilesAssumingDir.hasNext()) {
                S3AFileStatus fileStatus;
                S3AFileStatus s3AFileStatus = fileStatus = status != null ? status : this.innerGetFileStatus(path, false, StatusProbeEnum.ALL);
                if (fileStatus.isFile()) {
                    return this.listing.createSingleStatusIterator(this.toLocatedFileStatus(fileStatus));
                }
            }
            return listFilesAssumingDir;
        }
        catch (SdkException e) {
            throw S3AUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, S3AUtils.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        Path path = this.qualify(f);
        AuditSpan span = this.entryPoint(Statistic.INVOCATION_LIST_LOCATED_STATUS, path);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        RemoteIterator iterator = (RemoteIterator)Invoker.once("listLocatedStatus", path.toString(), () -> {
            S3AFileStatus fileStatus;
            RemoteIterator<S3ALocatedFileStatus> locatedFileStatusIteratorForDir = this.listing.getLocatedFileStatusIteratorForDir(path, filter, span);
            if (!locatedFileStatusIteratorForDir.hasNext() && (fileStatus = this.innerGetFileStatus(path, false, StatusProbeEnum.ALL)).isFile()) {
                LOG.debug("Path is a file");
                return this.listing.createSingleStatusIterator(filter.accept(path) ? this.toLocatedFileStatus(fileStatus) : null);
            }
            return locatedFileStatusIteratorForDir;
        });
        return Listing.toLocatedFileStatusIterator((RemoteIterator<? extends LocatedFileStatus>)iterator);
    }

    S3ALocatedFileStatus toLocatedFileStatus(S3AFileStatus status) throws IOException {
        return new S3ALocatedFileStatus(status, status.isFile() ? this.getFileBlockLocations(status, 0L, status.getLen()) : null);
    }

    @InterfaceAudience.Private
    public RemoteIterator<MultipartUpload> listUploads(@Nullable String prefix) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.MULTIPART_UPLOAD_LIST.getSymbol(), prefix, null);){
            RemoteIterator<MultipartUpload> remoteIterator = this.listUploadsUnderPrefix(this.createStoreContext(), prefix);
            return remoteIterator;
        }
    }

    @InterfaceAudience.Private
    public RemoteIterator<MultipartUpload> listUploadsUnderPrefix(StoreContext storeContext, @Nullable String prefix) throws IOException {
        Object p = prefix;
        if (prefix != null && !prefix.isEmpty() && !prefix.endsWith("/")) {
            p = prefix + "/";
        }
        return MultipartUtils.listMultipartUploads(storeContext, this.getS3Client(), (String)p, this.maxKeys);
    }

    @InterfaceAudience.Private
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        if (prefix != null && !((String)prefix).isEmpty() && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        String p = prefix;
        return (List)this.invoker.retry("listMultipartUploads", p, true, () -> {
            ListMultipartUploadsRequest request = (ListMultipartUploadsRequest)this.getRequestFactory().newListMultipartUploadsRequestBuilder(p).build();
            return (List)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getInstrumentation(), (String)Statistic.MULTIPART_UPLOAD_LIST.getSymbol(), () -> this.getS3Client().listMultipartUploads(request).uploads());
        });
    }

    public void abortMultipartUpload(String destKey, String uploadId) throws IOException {
        LOG.debug("Aborting multipart upload {} to {}", (Object)uploadId, (Object)destKey);
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getInstrumentation(), (String)Statistic.OBJECT_MULTIPART_UPLOAD_ABORTED.getSymbol(), () -> this.getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)this.getRequestFactory().newAbortMultipartUploadRequestBuilder(destKey, uploadId).build()));
    }

    public void abortMultipartUpload(MultipartUpload upload) throws IOException {
        String destKey = upload.key();
        String uploadId = upload.uploadId();
        if (LOG.isDebugEnabled()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LOG.debug("Aborting multipart upload {} to {} initiated by {} on {}", new Object[]{uploadId, destKey, upload.initiator(), df.format(Date.from(upload.initiated()))});
        }
        this.abortMultipartUpload(destKey, uploadId);
    }

    public CommitterStatistics newCommitterStatistics() {
        return this.statisticsContext.newCommitterStatistics();
    }

    public boolean hasPathCapability(Path path, String capability) throws IOException {
        String cap;
        Path p = this.makeQualified(path);
        S3AStore store = this.getStore();
        switch (cap = PathCapabilitiesSupport.validatePathCapabilityArgs((Path)p, (String)capability)) {
            case "fs.s3a.capability.magic.committer": 
            case "s3a:magic.committer": {
                return this.isMagicCommitEnabled();
            }
            case "fs.capability.paths.checksums": {
                return this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false);
            }
            case "fs.capability.outputstream.abortable": {
                return true;
            }
            case "fs.capability.multipart.uploader": {
                return !this.isCSEEnabled;
            }
            case "fs.s3a.capability.directory.marker.aware": {
                return true;
            }
            case "fs.s3a.multiobjectdelete.enable": {
                return this.enableMultiObjectsDelete;
            }
            case "fs.s3a.directory.operations.purge.uploads": {
                return this.dirOperationsPurgeUploads;
            }
            case "fs.s3a.capability.aws.v2": {
                return true;
            }
            case "fs.s3a.capability.s3express.storage": 
            case "fs.capability.directory.listing.inconsistent": {
                return this.s3ExpressStore;
            }
            case "fs.capability.etags.available": 
            case "fs.capability.virtual.block.locations": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.policy.keep": 
            case "fs.s3a.capability.directory.marker.action.keep": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.policy.authoritative": 
            case "fs.s3a.capability.directory.marker.action.delete": {
                return false;
            }
            case "fs.s3a.capability.multipart.uploads.enabled": {
                return this.isMultipartUploadEnabled();
            }
            case "fs.option.create.in.close": 
            case "fs.option.create.content.type": 
            case "fs.s3a.create.performance": 
            case "fs.s3a.create.header": {
                return true;
            }
            case "fs.s3a.create.conditional.enabled": 
            case "fs.option.create.conditional.overwrite": 
            case "fs.option.create.conditional.overwrite.etag": {
                return this.conditionalCreateEnabled;
            }
            case "fs.s3a.create.performance.enabled": {
                return this.performanceFlags.enabled((Enum)PerformanceFlagEnum.Create);
            }
            case "fs.s3a.optimized.copy.from.local.enabled": {
                return this.optimizedCopyFromLocal;
            }
            case "fs.s3a.endpoint.fips": {
                return this.fipsEnabled;
            }
            case "fs.s3a.access.grants.enabled": {
                return this.s3AccessGrantsEnabled;
            }
        }
        if (this.performanceFlags.hasCapability(capability)) {
            return true;
        }
        if (store.hasPathCapability(path, capability)) {
            return true;
        }
        return super.hasPathCapability(p, cap);
    }

    @Deprecated
    public boolean hasCapability(String capability) {
        try {
            return this.hasPathCapability(new Path("/"), capability);
        }
        catch (IOException ex) {
            LOG.debug("Ignoring exception on hasCapability({}})", (Object)capability, (Object)ex);
            return false;
        }
    }

    public AWSCredentialProviderList shareCredentials(String purpose) {
        LOG.debug("Sharing credentials for: {}", (Object)purpose);
        return this.credentials.share();
    }

    private S3AFileStatus extractOrFetchSimpleFileStatus(Path path, OpenFileSupport.OpenFileInformation fileInformation) throws IOException {
        S3AFileStatus fileStatus = fileInformation.getStatus();
        if (fileStatus == null) {
            fileStatus = this.innerGetFileStatus(path, false, StatusProbeEnum.HEAD_ONLY);
        }
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException(path.toString() + " is a directory");
        }
        return fileStatus;
    }

    public CompletableFuture<FSDataInputStream> openFileWithOptions(Path rawPath, OpenFileParameters parameters) throws IOException {
        Path path = this.qualify(rawPath);
        OpenFileSupport.OpenFileInformation fileInformation = this.openFileHelper.prepareToOpenFile(path, parameters, this.getDefaultBlockSize());
        CompletableFuture<FSDataInputStream> result = new CompletableFuture<FSDataInputStream>();
        this.unboundedThreadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> this.executeOpen(path, fileInformation)));
        return result;
    }

    public S3AMultipartUploaderBuilder createMultipartUploader(Path basePath) throws IOException {
        if (this.isCSEEnabled) {
            throw new UnsupportedOperationException("Multi-part uploader not supported for Client side encryption.");
        }
        Path path = this.makeQualified(basePath);
        try (AuditSpan span = this.entryPoint(Statistic.MULTIPART_UPLOAD_INSTANTIATED, path);){
            StoreContext ctx = this.createStoreContext();
            S3AMultipartUploaderBuilder s3AMultipartUploaderBuilder = new S3AMultipartUploaderBuilder(this, this.createWriteOperationHelper(span), ctx, path, this.statisticsContext.createMultipartUploaderStatistics());
            return s3AMultipartUploaderBuilder;
        }
    }

    @Override
    @InterfaceAudience.Private
    public StoreContext createStoreContext() {
        return new StoreContextBuilder().setFsURI(this.getUri()).setAuditor(this.getAuditor()).setBucket(this.getBucket()).setChangeDetectionPolicy(this.changeDetectionPolicy).setConfiguration(this.getConf()).setContextAccessors(new ContextAccessorsImpl()).setEnableCSE(this.isCSEEnabled).setExecutor(this.boundedThreadPool).setExecutorCapacity(this.executorCapacity).setInputPolicy(this.getInputPolicy()).setInstrumentation(this.statisticsContext).setInvoker(this.invoker).setMultiObjectDeleteEnabled(this.enableMultiObjectsDelete).setOwner(this.owner).setPerformanceFlags(this.performanceFlags).setStorageStatistics(this.getStorageStatistics()).setUseListV1(this.useListV1).setUsername(this.getUsername()).build();
    }

    @InterfaceAudience.Private
    public MarkerToolOperations createMarkerToolOperations(String target) throws IOException {
        this.createSpan("marker-tool-scan", target, null);
        return new MarkerToolOperationsImpl(new OperationCallbacksImpl(this.createStoreContext()));
    }

    @InterfaceAudience.Private
    public static void initializeClass() {
        LOG.debug("Initialize S3A class");
    }

    public boolean isCSEEnabled() {
        return this.isCSEEnabled;
    }

    public boolean isMultipartUploadEnabled() {
        return this.isMultipartUploadEnabled;
    }

    public BulkDelete createBulkDelete(Path path) throws IllegalArgumentException, IOException {
        Path p = this.makeQualified(path);
        AuditSpanS3A span = this.createSpan("bulkdelete", p.toString(), null);
        int size = this.enableMultiObjectsDelete ? this.pageSize : 1;
        return new BulkDeleteOperation(this.createStoreContext(), this.createBulkDeleteCallbacks(p, size, span), p, size, span);
    }

    protected BulkDeleteOperation.BulkDeleteOperationCallbacks createBulkDeleteCallbacks(Path path, int pageSize, AuditSpanS3A span) {
        return new BulkDeleteOperationCallbacksImpl(this.getStore(), this.pathToKey(path), pageSize, span);
    }

    static {
        S3AFileSystem.addDeprecatedKeys();
    }

    protected class ListingOperationCallbacksImpl
    implements ListingOperationCallbacks {
        protected ListingOperationCallbacksImpl() {
        }

        @Override
        public CompletableFuture<S3ListResult> listObjectsAsync(S3ListRequest request, DurationTrackerFactory trackerFactory, AuditSpan span) {
            return CallableSupplier.submit(S3AFileSystem.this.unboundedThreadPool, span, () -> S3AFileSystem.this.listObjects(request, IOStatisticsBinding.pairedTrackerFactory((DurationTrackerFactory)trackerFactory, (DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory())));
        }

        @Override
        public CompletableFuture<S3ListResult> continueListObjectsAsync(S3ListRequest request, S3ListResult prevResult, DurationTrackerFactory trackerFactory, AuditSpan span) {
            return CallableSupplier.submit(S3AFileSystem.this.unboundedThreadPool, span, () -> S3AFileSystem.this.continueListObjects(request, prevResult, IOStatisticsBinding.pairedTrackerFactory((DurationTrackerFactory)trackerFactory, (DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory())));
        }

        @Override
        public S3ALocatedFileStatus toLocatedFileStatus(S3AFileStatus status) throws IOException {
            return S3AFileSystem.this.toLocatedFileStatus(status);
        }

        @Override
        public S3ListRequest createListObjectsRequest(String key, String delimiter, AuditSpan span) {
            span.activate();
            return S3AFileSystem.this.createListObjectsRequest(key, delimiter);
        }

        @Override
        public long getDefaultBlockSize(Path path) {
            return S3AFileSystem.this.getDefaultBlockSize(path);
        }

        @Override
        public long getObjectSize(S3Object s3Object) throws IOException {
            return S3AFileSystem.this.fsHandler.getS3ObjectSize(s3Object.key(), s3Object.size(), S3AFileSystem.this.getStore(), null);
        }

        @Override
        public int getMaxKeys() {
            return S3AFileSystem.this.getMaxKeys();
        }
    }

    private class ContextAccessorsImpl
    implements ContextAccessors {
        private ContextAccessorsImpl() {
        }

        @Override
        public Path keyToPath(String key) {
            return S3AFileSystem.this.keyToQualifiedPath(key);
        }

        @Override
        public String pathToKey(Path path) {
            return S3AFileSystem.this.pathToKey(path);
        }

        @Override
        public File createTempFile(String prefix, long size) throws IOException {
            return S3AFileSystem.this.createTmpFileForWrite(prefix, size, S3AFileSystem.this.getConf());
        }

        @Override
        public String getBucketLocation() throws IOException {
            return S3AFileSystem.this.getBucketLocation();
        }

        @Override
        public Path makeQualified(Path path) {
            return S3AFileSystem.this.makeQualified(path);
        }

        @Override
        public AuditSpan getActiveAuditSpan() {
            return S3AFileSystem.this.getActiveAuditSpan();
        }

        @Override
        public RequestFactory getRequestFactory() {
            return S3AFileSystem.this.getRequestFactory();
        }
    }

    private class DelegationOperationsImpl
    implements DelegationOperations {
        private DelegationOperationsImpl() {
        }

        @Override
        public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
            return S3AFileSystem.this.listAWSPolicyRules(access);
        }
    }

    private final class S3AInternalsImpl
    implements S3AInternals {
        private S3AInternalsImpl() {
        }

        @Override
        public S3Client getAmazonS3Client(String reason) {
            LOG.debug("Access to S3 client requested, reason {}", (Object)reason);
            return S3AFileSystem.this.getS3Client();
        }

        @Override
        public S3AStore getStore() {
            return S3AFileSystem.this.getStore();
        }

        @Override
        public String getBucketLocation() throws IOException {
            return S3AFileSystem.this.s3aInternals.getBucketLocation(S3AFileSystem.this.bucket);
        }

        @Override
        public String getBucketLocation(String bucketName) throws IOException {
            String region = (String)S3AFileSystem.this.trackDurationAndSpan(Statistic.STORE_EXISTS_PROBE, bucketName, null, () -> (String)S3AFileSystem.this.invoker.retry("getBucketLocation()", bucketName, true, () -> S3AFileSystem.this.accessPoint != null ? S3AFileSystem.this.accessPoint.getRegion() : S3AFileSystem.this.getS3Client().getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(bucketName).build()).locationConstraintAsString()));
            return NetworkBinding.fixBucketRegion(region);
        }

        @Override
        public HeadObjectResponse getObjectMetadata(Path path) throws IOException {
            return (HeadObjectResponse)S3AFileSystem.this.trackDurationAndSpan(Statistic.INVOCATION_GET_FILE_STATUS, path, () -> S3AFileSystem.this.getObjectMetadata(S3AFileSystem.this.makeQualified(path), null, S3AFileSystem.this.invoker, "getObjectMetadata"));
        }

        @Override
        public HeadBucketResponse getBucketMetadata() throws IOException {
            return S3AFileSystem.this.getBucketMetadata();
        }

        @Override
        public AWSCredentialProviderList shareCredentials(String purpose) {
            LOG.debug("Sharing credentials for: {}", (Object)purpose);
            return S3AFileSystem.this.credentials.share();
        }

        @Override
        public boolean isMultipartCopyEnabled() {
            return S3AFileSystem.this.isMultipartUploadEnabled;
        }

        @Override
        public long abortMultipartUploads(Path path) throws IOException {
            String prefix = S3AFileSystem.this.pathToKey(path);
            try (AuditSpanS3A span = S3AFileSystem.this.createSpan("object_multipart_bulk_abort", prefix, null);){
                long l = S3AFileSystem.this.abortMultipartUploadsUnderPrefix(S3AFileSystem.this.createStoreContext(), span, prefix);
                return l;
            }
        }
    }

    private final class WriteOperationHelperCallbacksImpl
    implements WriteOperationHelper.WriteOperationHelperCallbacks {
        private WriteOperationHelperCallbacksImpl() {
        }

        @Override
        public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest request) {
            return S3AFileSystem.this.getStore().completeMultipartUpload(request);
        }

        @Override
        public UploadPartResponse uploadPart(UploadPartRequest request, RequestBody body, DurationTrackerFactory durationTrackerFactory) throws AwsServiceException, UncheckedIOException {
            return S3AFileSystem.this.getStore().uploadPart(request, body, durationTrackerFactory);
        }
    }

    private final class CreateFileBuilderCallbacksImpl
    implements CreateFileBuilder.CreateFileBuilderCallbacks {
        private final Statistic statistic;
        private final AuditSpan span;

        private CreateFileBuilderCallbacksImpl(Statistic statistic, AuditSpan span) {
            this.statistic = statistic;
            this.span = span;
        }

        @Override
        public FSDataOutputStream createFileFromBuilder(Path path, Progressable progress, CreateFileBuilder.CreateFileOptions options) throws IOException {
            return (FSDataOutputStream)IOStatisticsBinding.trackDuration((DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory(), (String)this.statistic.getSymbol(), () -> S3AFileSystem.this.innerCreateFile(path, progress, this.span, options));
        }
    }

    private final class OperationCallbacksImpl
    implements OperationCallbacks {
        private final AuditSpan auditSpan;
        private final StoreContext storeContext;

        private OperationCallbacksImpl(StoreContext storeContext) {
            this.storeContext = Objects.requireNonNull(storeContext);
            this.auditSpan = storeContext.getActiveAuditSpan();
        }

        private AuditSpan getAuditSpan() {
            return this.auditSpan;
        }

        @Override
        public S3ObjectAttributes createObjectAttributes(Path path, String eTag, String versionId, long len) {
            return S3AFileSystem.this.createObjectAttributes(path, eTag, versionId, len);
        }

        @Override
        public S3ObjectAttributes createObjectAttributes(S3AFileStatus fileStatus) {
            return S3AFileSystem.this.createObjectAttributes(fileStatus.getPath(), fileStatus);
        }

        @Override
        public S3AReadOpContext createReadContext(FileStatus fileStatus) {
            return S3AFileSystem.this.createReadContext(fileStatus, this.auditSpan);
        }

        @Override
        public void deleteObjectAtPath(Path path, String key, boolean isFile) throws IOException {
            this.auditSpan.activate();
            Invoker.once("delete", path.toString(), () -> S3AFileSystem.this.deleteObjectAtPath(path, key, isFile));
        }

        @Override
        public RemoteIterator<S3ALocatedFileStatus> listFilesAndDirectoryMarkers(Path path, S3AFileStatus status, boolean includeSelf) throws IOException {
            this.auditSpan.activate();
            return S3AFileSystem.this.innerListFiles(path, true, includeSelf ? Listing.ACCEPT_ALL_OBJECTS : new Listing.AcceptAllButSelf(path), status);
        }

        @Override
        public CopyObjectResponse copyFile(String srcKey, String destKey, S3ObjectAttributes srcAttributes, S3AReadOpContext readContext) throws IOException {
            this.auditSpan.activate();
            return S3AFileSystem.this.copyFile(srcKey, destKey, srcAttributes.getLen(), srcAttributes, readContext);
        }

        @Override
        public void removeKeys(List<ObjectIdentifier> keysToDelete, boolean deleteFakeDir) throws MultiObjectDeleteException, SdkException, IOException {
            this.auditSpan.activate();
            S3AFileSystem.this.removeKeys(keysToDelete, deleteFakeDir);
        }

        @Override
        public void finishRename(Path sourceRenamed, Path destCreated) throws IOException {
            this.auditSpan.activate();
            Path destParent = destCreated.getParent();
            if (!sourceRenamed.getParent().equals((Object)destParent)) {
                LOG.debug("source & dest parents are different; fix up dir markers");
                S3AFileSystem.this.maybeCreateFakeParentDirectory(sourceRenamed);
            }
        }

        @Override
        public RemoteIterator<S3AFileStatus> listObjects(Path path, String key) throws IOException {
            return (RemoteIterator)Invoker.once("listObjects", key, () -> S3AFileSystem.this.listing.createFileStatusListingIterator(path, S3AFileSystem.this.createListObjectsRequest(key, null), S3AUtils.ACCEPT_ALL, Listing.ACCEPT_ALL_BUT_S3N, this.auditSpan));
        }

        @Override
        public long abortMultipartUploadsUnderPrefix(String prefix) throws IOException {
            return S3AFileSystem.this.abortMultipartUploadsUnderPrefix(this.storeContext, this.auditSpan, prefix);
        }
    }

    protected class MkdirOperationCallbacksImpl
    implements MkdirOperation.MkdirCallbacks {
        protected MkdirOperationCallbacksImpl() {
        }

        @Override
        public S3AFileStatus probePathStatus(Path path, Set<StatusProbeEnum> probes) throws IOException {
            return S3AFileSystem.this.innerGetFileStatus(path, false, probes);
        }

        @Override
        public void createFakeDirectory(Path dir) throws IOException {
            S3AFileSystem.this.createFakeDirectory(S3AFileSystem.this.pathToKey(dir), PutObjectOptions.defaultOptions());
        }
    }

    protected class GetContentSummaryCallbacksImpl
    implements GetContentSummaryOperation.GetContentSummaryCallbacks {
        protected GetContentSummaryCallbacksImpl() {
        }

        @Override
        public S3AFileStatus probePathStatus(Path path, Set<StatusProbeEnum> probes) throws IOException {
            return S3AFileSystem.this.innerGetFileStatus(path, false, probes);
        }

        @Override
        public RemoteIterator<S3ALocatedFileStatus> listFilesIterator(Path path, boolean recursive) throws IOException {
            return S3AFileSystem.this.innerListFiles(path, recursive, Listing.ACCEPT_ALL_BUT_S3N, null);
        }
    }

    protected final class CopyFromLocalCallbacksImpl
    implements CopyFromLocalOperation.CopyFromLocalOperationCallbacks {
        private final AuditSpanS3A span;
        private final LocalFileSystem local;

        private CopyFromLocalCallbacksImpl(AuditSpanS3A span, LocalFileSystem local) {
            this.span = span;
            this.local = local;
        }

        @Override
        public RemoteIterator<LocatedFileStatus> listLocalStatusIterator(Path path) throws IOException {
            return this.local.listLocatedStatus(path);
        }

        @Override
        public File pathToLocalFile(Path path) {
            return this.local.pathToFile(path);
        }

        @Override
        public boolean deleteLocal(Path path, boolean recursive) throws IOException {
            return this.local.delete(path, recursive);
        }

        @Override
        public void copyLocalFileFromTo(File file, Path from, Path to) throws IOException {
            this.span.activate();
            IOStatisticsBinding.trackDuration((DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory(), (String)Statistic.OBJECT_PUT_REQUESTS.getSymbol(), () -> {
                String key = S3AFileSystem.this.pathToKey(to);
                PutObjectRequest.Builder putObjectRequestBuilder = S3AFileSystem.this.newPutObjectRequestBuilder(key, file.length(), false);
                String dest = to.toString();
                S3AFileSystem.this.invoker.retry("putObject(" + dest + ")", dest, true, () -> S3AFileSystem.this.executePut((PutObjectRequest)putObjectRequestBuilder.build(), null, PutObjectOptions.defaultOptions(), file));
                return null;
            });
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            return S3AFileSystem.this.getFileStatus(f);
        }

        @Override
        public boolean createEmptyDir(Path path, StoreContext storeContext) throws IOException {
            return (Boolean)IOStatisticsBinding.trackDuration((DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory(), (String)Statistic.INVOCATION_MKDIRS.getSymbol(), (CallableRaisingIOE)new MkdirOperation(storeContext, path, S3AFileSystem.this.createMkdirOperationCallbacks(), false, S3AFileSystem.this.performanceFlags.enabled((Enum)PerformanceFlagEnum.Mkdir)));
        }
    }

    protected final class HeaderProcessingCallbacksImpl
    implements HeaderProcessing.HeaderProcessingCallbacks {
        protected HeaderProcessingCallbacksImpl() {
        }

        @Override
        public HeadObjectResponse getObjectMetadata(String key) throws IOException {
            return (HeadObjectResponse)Invoker.once("getObjectMetadata", key, () -> S3AFileSystem.this.getObjectMetadata(key));
        }

        @Override
        public HeadBucketResponse getBucketMetadata() throws IOException {
            return (HeadBucketResponse)Invoker.once("getBucketMetadata", S3AFileSystem.this.bucket, () -> S3AFileSystem.this.getBucketMetadata());
        }
    }
}

