/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.s3a.impl.write.WriteObjectFlags;
import org.apache.hadoop.util.Preconditions;

public final class PutObjectOptions {
    private final boolean keepMarkers;
    private final String storageClass;
    private final Map<String, String> headers;
    private final EnumSet<WriteObjectFlags> writeObjectFlags;
    private final String etagOverwrite;
    private static final PutObjectOptions EMPTY_OPTIONS;
    private static final PutObjectOptions KEEP_DIRS;
    private static final PutObjectOptions DELETE_DIRS;

    public PutObjectOptions(boolean keepMarkers, @Nullable String storageClass, @Nullable Map<String, String> headers, EnumSet<WriteObjectFlags> writeObjectFlags, @Nullable String etagOverwrite) {
        this.keepMarkers = keepMarkers;
        this.storageClass = storageClass;
        this.headers = headers;
        this.writeObjectFlags = writeObjectFlags;
        this.etagOverwrite = etagOverwrite;
        if (this.isEtagOverwrite()) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)etagOverwrite) ? 1 : 0) != 0, (Object)"etag overwrite is enabled but the etag string is null/empty");
        }
    }

    public boolean isNoObjectOverwrite() {
        return this.hasFlag(WriteObjectFlags.ConditionalOverwrite);
    }

    public boolean isEtagOverwrite() {
        return this.hasFlag(WriteObjectFlags.ConditionalOverwriteEtag);
    }

    public boolean hasFlag(WriteObjectFlags flag) {
        return this.writeObjectFlags.contains((Object)flag);
    }

    public String getEtagOverwrite() {
        return this.etagOverwrite;
    }

    public boolean isKeepMarkers() {
        return this.keepMarkers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public EnumSet<WriteObjectFlags> getWriteObjectFlags() {
        return this.writeObjectFlags;
    }

    public String toString() {
        return "PutObjectOptions{keepMarkers=" + this.keepMarkers + ", storageClass='" + this.storageClass + "', headers=" + this.headers + ", writeObjectFlags=" + this.writeObjectFlags + ", etagOverwrite='" + this.etagOverwrite + "'}";
    }

    public static PutObjectOptions keepingDirs() {
        return KEEP_DIRS;
    }

    public static PutObjectOptions deletingDirs() {
        return DELETE_DIRS;
    }

    public static PutObjectOptions defaultOptions() {
        return PutObjectOptions.keepingDirs();
    }

    static {
        KEEP_DIRS = EMPTY_OPTIONS = new PutObjectOptions(true, null, null, EnumSet.noneOf(WriteObjectFlags.class), null);
        DELETE_DIRS = new PutObjectOptions(false, null, null, EnumSet.noneOf(WriteObjectFlags.class), null);
    }
}

