/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import org.apache.hadoop.fs.impl.FSBuilderSupport;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.impl.InternalConstants;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFileSupport {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFileSupport.class);
    public static final LogExactlyOnce LOG_NO_SQL_SELECT = new LogExactlyOnce(LOG);
    private static final int LENGTH_UNKNOWN = -1;
    private final ChangeDetectionPolicy changePolicy;
    private final long defaultReadAhead;
    private final String username;
    private final int defaultBufferSize;
    private final long defaultAsyncDrainThreshold;
    private final S3AInputPolicy defaultInputPolicy;

    public OpenFileSupport(ChangeDetectionPolicy changePolicy, long defaultReadAhead, String username, int defaultBufferSize, long defaultAsyncDrainThreshold, S3AInputPolicy defaultInputPolicy) {
        this.changePolicy = changePolicy;
        this.defaultReadAhead = defaultReadAhead;
        this.username = username;
        this.defaultBufferSize = defaultBufferSize;
        this.defaultAsyncDrainThreshold = defaultAsyncDrainThreshold;
        this.defaultInputPolicy = defaultInputPolicy;
    }

    public ChangeDetectionPolicy getChangePolicy() {
        return this.changePolicy;
    }

    public long getDefaultReadAhead() {
        return this.defaultReadAhead;
    }

    public int getDefaultBufferSize() {
        return this.defaultBufferSize;
    }

    public long getDefaultAsyncDrainThreshold() {
        return this.defaultAsyncDrainThreshold;
    }

    public S3AReadOpContext applyDefaultOptions(S3AReadOpContext roc) {
        return roc.withInputPolicy(this.defaultInputPolicy).withChangeDetectionPolicy(this.changePolicy).withAsyncDrainThreshold(this.defaultAsyncDrainThreshold).withReadahead(this.defaultReadAhead);
    }

    public OpenFileInformation prepareToOpenFile(Path path, OpenFileParameters parameters, long blockSize) throws IOException {
        Collection policies;
        Configuration options = parameters.getOptions();
        Set mandatoryKeys = parameters.getMandatoryKeys();
        if (options.get("fs.s3a.select.sql", null) != null) {
            if (mandatoryKeys.contains("fs.s3a.select.sql")) {
                throw new UnsupportedOperationException("S3 Select is no longer supported");
            }
            LOG_NO_SQL_SELECT.warn("S3 Select is no longer supported", new Object[0]);
        }
        AbstractFSBuilderImpl.rejectUnknownMandatoryKeys((Set)mandatoryKeys, InternalConstants.S3A_OPENFILE_KEYS, (String)("for " + path + " in file I/O"));
        long fileLength = -1L;
        FileStatus providedStatus = parameters.getStatus();
        S3AFileStatus fileStatus = null;
        if (providedStatus != null) {
            String eTag;
            String versionId;
            Path providedStatusPath = providedStatus.getPath();
            Preconditions.checkArgument((boolean)path.getName().equals(providedStatusPath.getName()), (String)"Filename mismatch between file being opened %s and supplied filestatus %s", (Object[])new Object[]{path, providedStatusPath});
            if (providedStatus.isDirectory()) {
                throw new FileNotFoundException("Supplied status references a directory " + providedStatus);
            }
            long len = providedStatus.getLen();
            long modTime = providedStatus.getModificationTime();
            LOG.debug("File was opened with a supplied FileStatus; skipping getFileStatus call in open() operation: {}", (Object)providedStatus);
            if (providedStatus instanceof S3AFileStatus) {
                S3AFileStatus st = (S3AFileStatus)providedStatus;
                versionId = st.getVersionId();
                eTag = st.getEtag();
            } else if (providedStatus instanceof S3ALocatedFileStatus) {
                S3ALocatedFileStatus st = (S3ALocatedFileStatus)providedStatus;
                versionId = st.getVersionId();
                eTag = st.getEtag();
            } else {
                LOG.debug("Converting file status {}", (Object)providedStatus);
                versionId = null;
                eTag = null;
            }
            fileStatus = new S3AFileStatus(len, modTime, path, blockSize, this.username, eTag, versionId);
            fileLength = fileStatus.getLen();
        }
        FSBuilderSupport builderSupport = new FSBuilderSupport(options);
        long splitStart = builderSupport.getPositiveLong("fs.option.openfile.split.start", 0L);
        long splitEnd = builderSupport.getLong("fs.option.openfile.split.end", -1L);
        if (splitStart > 0L && splitStart > splitEnd) {
            LOG.warn("Split start {} is greater than split end {}, resetting", (Object)splitStart, (Object)splitEnd);
            splitStart = 0L;
        }
        if ((fileLength = builderSupport.getPositiveLong("fs.option.openfile.length", fileLength)) >= 0L && fileStatus == null) {
            fileStatus = this.createStatus(path, fileLength, blockSize);
        }
        if ((policies = options.getStringCollection("fs.option.openfile.read.policy")).isEmpty()) {
            policies = options.getStringCollection("fs.s3a.experimental.input.fadvise");
        }
        return new OpenFileInformation().withAsyncDrainThreshold(builderSupport.getPositiveLong("fs.s3a.input.async.drain.threshold", this.defaultReadAhead)).withBufferSize((int)builderSupport.getPositiveLong("fs.option.openfile.buffer.size", (long)this.defaultBufferSize)).withChangePolicy(this.changePolicy).withFileLength(fileLength).withInputPolicy(S3AInputPolicy.getFirstSupportedPolicy(policies, this.defaultInputPolicy)).withReadAheadRange(builderSupport.getPositiveLong("fs.s3a.readahead.range", this.defaultReadAhead)).withSplitStart(splitStart).withSplitEnd(splitEnd).withStatus(fileStatus).build();
    }

    private S3AFileStatus createStatus(Path path, long length, long blockSize) {
        return new S3AFileStatus(length, 0L, path, blockSize, this.username, null, null);
    }

    public OpenFileInformation openSimpleFile(int bufferSize) {
        return new OpenFileInformation().withAsyncDrainThreshold(this.defaultAsyncDrainThreshold).withBufferSize(bufferSize).withChangePolicy(this.changePolicy).withFileLength(-1L).withInputPolicy(this.defaultInputPolicy).withReadAheadRange(this.defaultReadAhead).withSplitStart(0L).withSplitEnd(-1L).build();
    }

    public String toString() {
        return "OpenFileSupport{changePolicy=" + this.changePolicy + ", defaultReadAhead=" + this.defaultReadAhead + ", defaultBufferSize=" + this.defaultBufferSize + ", defaultAsyncDrainThreshold=" + this.defaultAsyncDrainThreshold + ", defaultInputPolicy=" + this.defaultInputPolicy + "}";
    }

    public static final class OpenFileInformation {
        private S3AFileStatus status;
        private S3AInputPolicy inputPolicy;
        private ChangeDetectionPolicy changePolicy;
        private long readAheadRange;
        private int bufferSize;
        private long splitStart;
        private long splitEnd = -1L;
        private long fileLength = -1L;
        private long asyncDrainThreshold;

        public OpenFileInformation build() {
            return this;
        }

        public S3AFileStatus getStatus() {
            return this.status;
        }

        public S3AInputPolicy getInputPolicy() {
            return this.inputPolicy;
        }

        public ChangeDetectionPolicy getChangePolicy() {
            return this.changePolicy;
        }

        public long getReadAheadRange() {
            return this.readAheadRange;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public long getSplitStart() {
            return this.splitStart;
        }

        public long getSplitEnd() {
            return this.splitEnd;
        }

        public String toString() {
            return "OpenFileInformation{status=" + this.status + ", inputPolicy=" + this.inputPolicy + ", changePolicy=" + this.changePolicy + ", readAheadRange=" + this.readAheadRange + ", splitStart=" + this.splitStart + ", splitEnd=" + this.splitEnd + ", bufferSize=" + this.bufferSize + ", drainThreshold=" + this.asyncDrainThreshold + "}";
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public OpenFileInformation withStatus(S3AFileStatus value) {
            this.status = value;
            return this;
        }

        public OpenFileInformation withInputPolicy(S3AInputPolicy value) {
            this.inputPolicy = value;
            return this;
        }

        public OpenFileInformation withChangePolicy(ChangeDetectionPolicy value) {
            this.changePolicy = value;
            return this;
        }

        public OpenFileInformation withReadAheadRange(long value) {
            this.readAheadRange = value;
            return this;
        }

        public OpenFileInformation withBufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        public OpenFileInformation withSplitStart(long value) {
            this.splitStart = value;
            return this;
        }

        public OpenFileInformation withSplitEnd(long value) {
            this.splitEnd = value;
            return this;
        }

        public OpenFileInformation withFileLength(long value) {
            this.fileLength = value;
            return this;
        }

        public OpenFileInformation withAsyncDrainThreshold(long value) {
            this.asyncDrainThreshold = value;
            return this;
        }

        public S3AReadOpContext applyOptions(S3AReadOpContext roc) {
            return roc.withInputPolicy(this.inputPolicy).withChangeDetectionPolicy(this.changePolicy).withAsyncDrainThreshold(this.asyncDrainThreshold).withReadahead(this.readAheadRange);
        }
    }
}

