/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.auth.CredentialProviderListFactory;
import org.apache.hadoop.fs.s3a.auth.STSClientFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class AssumedRoleCredentialProvider
implements AwsCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AssumedRoleCredentialProvider.class);
    public static final String NAME = "org.apache.hadoop.fs.s3a.auth.AssumedRoleCredentialProvider";
    public static final String E_NO_ROLE = "Unset property fs.s3a.assumed.role.arn";
    private final StsAssumeRoleCredentialsProvider stsProvider;
    private final String sessionName;
    private final long duration;
    private final String arn;
    private final AWSCredentialProviderList credentialsToSTS;
    private final Invoker invoker;
    private final StsClient stsClient;

    public AssumedRoleCredentialProvider(@Nullable URI fsUri, Configuration conf) throws IOException {
        this.arn = conf.getTrimmed("fs.s3a.assumed.role.arn", "");
        if (StringUtils.isEmpty((CharSequence)this.arn)) {
            throw new PathIOException(String.valueOf(fsUri), E_NO_ROLE);
        }
        this.credentialsToSTS = CredentialProviderListFactory.buildAWSProviderList(fsUri, conf, "fs.s3a.assumed.role.credentials.provider", Arrays.asList(SimpleAWSCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class), Sets.newHashSet((Object[])new Class[]{this.getClass()}));
        LOG.debug("Credentials used to obtain role credentials: {}", (Object)this.credentialsToSTS);
        this.sessionName = conf.getTrimmed("fs.s3a.assumed.role.session.name", AssumedRoleCredentialProvider.buildSessionName());
        this.duration = conf.getTimeDuration("fs.s3a.assumed.role.session.duration", "1h", TimeUnit.SECONDS);
        String policy = conf.getTrimmed("fs.s3a.assumed.role.policy", "");
        String externalId = conf.getTrimmed("fs.s3a.assumed.role.external.id", "");
        LOG.debug("{}", (Object)this);
        AssumeRoleRequest.Builder requestBuilder = AssumeRoleRequest.builder().roleArn(this.arn).roleSessionName(this.sessionName).durationSeconds(Integer.valueOf((int)this.duration));
        if (StringUtils.isNotEmpty((CharSequence)externalId)) {
            requestBuilder.externalId(externalId);
        }
        if (StringUtils.isNotEmpty((CharSequence)policy)) {
            LOG.debug("Scope down policy {}", (Object)policy);
            requestBuilder.policy(policy);
        }
        String endpoint = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint", "");
        String region = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint.region", "");
        this.stsClient = (StsClient)STSClientFactory.builder(conf, fsUri != null ? fsUri.getHost() : "", this.credentialsToSTS, endpoint, region).build();
        this.stsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest((AssumeRoleRequest)requestBuilder.build()).stsClient(this.stsClient)).build();
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
        this.resolveCredentials();
    }

    public AwsCredentials resolveCredentials() {
        try {
            return (AwsCredentials)this.invoker.retryUntranslated("resolveCredentials", true, () -> ((StsAssumeRoleCredentialsProvider)this.stsProvider).resolveCredentials());
        }
        catch (IOException e) {
            throw new CredentialInitializationException("getCredentials failed: " + e, e);
        }
        catch (SdkClientException e) {
            LOG.error("Failed to resolve credentials for role {}", (Object)this.arn, (Object)e);
            throw e;
        }
    }

    @Override
    public void close() {
        S3AUtils.closeAutocloseables(LOG, new AutoCloseable[]{this.stsProvider, this.credentialsToSTS, this.stsClient});
    }

    public String toString() {
        String sb = "AssumedRoleCredentialProvider{role='" + this.arn + "', session'" + this.sessionName + "', duration=" + this.duration + "}";
        return sb;
    }

    static String buildSessionName() throws IOException {
        return AssumedRoleCredentialProvider.sanitize(UserGroupInformation.getCurrentUser().getShortUserName());
    }

    @VisibleForTesting
    static String sanitize(String session) {
        StringBuilder r = new StringBuilder(session.length());
        for (char c : session.toCharArray()) {
            if ("abcdefghijklmnopqrstuvwxyz0123456789,.@-".contains(Character.toString(c).toLowerCase(Locale.ENGLISH))) {
                r.append(c);
                continue;
            }
            r.append('-');
        }
        return r.toString();
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        if (retries == 0) {
            LOG.info("Retried {}", (Object)text);
        }
    }
}

