/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class S3LogParser {
    private static final String SIMPLE = "[^ ]*";
    private static final String DATETIME = "\\[(.*?)\\]";
    private static final String NUMBER = "(-|[0-9]*)";
    private static final String QUOTED = "(-|\"[^\"]*\")";
    public static final String OWNER_GROUP = "owner";
    public static final String BUCKET_GROUP = "bucket";
    public static final String TIMESTAMP_GROUP = "timestamp";
    public static final String REMOTEIP_GROUP = "remoteip";
    public static final String REQUESTER_GROUP = "requester";
    public static final String REQUESTID_GROUP = "requestid";
    public static final String VERB_GROUP = "verb";
    public static final String KEY_GROUP = "key";
    public static final String REQUESTURI_GROUP = "requesturi";
    public static final String HTTP_GROUP = "http";
    public static final String AWSERRORCODE_GROUP = "awserrorcode";
    public static final String BYTESSENT_GROUP = "bytessent";
    public static final String OBJECTSIZE_GROUP = "objectsize";
    public static final String TOTALTIME_GROUP = "totaltime";
    public static final String TURNAROUNDTIME_GROUP = "turnaroundtime";
    public static final String REFERRER_GROUP = "referrer";
    public static final String USERAGENT_GROUP = "useragent";
    public static final String VERSION_GROUP = "version";
    public static final String HOSTID_GROUP = "hostid";
    public static final String SIGV_GROUP = "sigv";
    public static final String CYPHER_GROUP = "cypher";
    public static final String AUTH_GROUP = "auth";
    public static final String ENDPOINT_GROUP = "endpoint";
    public static final String TLS_GROUP = "tls";
    public static final String TAIL_GROUP = "tail";
    public static final String LOG_ENTRY_REGEXP = S3LogParser.e("owner") + S3LogParser.e("bucket") + S3LogParser.e("timestamp", "\\[(.*?)\\]") + S3LogParser.e("remoteip") + S3LogParser.e("requester") + S3LogParser.e("requestid") + S3LogParser.e("verb") + S3LogParser.e("key") + S3LogParser.q("requesturi") + S3LogParser.e("http", "(-|[0-9]*)") + S3LogParser.e("awserrorcode") + S3LogParser.e("bytessent") + S3LogParser.e("objectsize") + S3LogParser.e("totaltime") + S3LogParser.e("turnaroundtime") + S3LogParser.q("referrer") + S3LogParser.q("useragent") + S3LogParser.e("version") + S3LogParser.e("hostid") + S3LogParser.e("sigv") + S3LogParser.e("cypher") + S3LogParser.e("auth") + S3LogParser.e("endpoint") + S3LogParser.eNoTrailing("tls", "[^ ]*") + S3LogParser.eNoTrailing("tail", ".*") + "$";
    private static final String[] GROUPS = new String[]{"owner", "bucket", "timestamp", "remoteip", "requester", "requestid", "verb", "key", "requesturi", "http", "awserrorcode", "bytessent", "objectsize", "totaltime", "turnaroundtime", "referrer", "useragent", "version", "hostid", "sigv", "cypher", "auth", "endpoint", "tls", "tail"};
    public static final List<String> AWS_LOG_REGEXP_GROUPS = Collections.unmodifiableList(Arrays.asList(GROUPS));
    public static final Pattern LOG_ENTRY_PATTERN = Pattern.compile(LOG_ENTRY_REGEXP);

    private S3LogParser() {
    }

    private static String e(String name, String pattern) {
        return String.format("(?<%s>%s) ", name, pattern);
    }

    private static String eNoTrailing(String name, String pattern) {
        return String.format("(?<%s>%s)", name, pattern);
    }

    private static String e(String name) {
        return S3LogParser.e(name, SIMPLE);
    }

    private static String q(String name) {
        return S3LogParser.e(name, QUOTED);
    }
}

