/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.s3a.S3ListResult;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.ListingOperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.S3Object;

@InterfaceAudience.Private
public class Listing
extends AbstractStoreOperation {
    private static final Logger LOG = S3AFileSystem.LOG;
    static final FileStatusAcceptor ACCEPT_ALL_BUT_S3N = new AcceptAllButS3nDirs();
    private final ListingOperationCallbacks listingOperationCallbacks;

    public Listing(ListingOperationCallbacks listingOperationCallbacks, StoreContext storeContext) {
        super(storeContext);
        this.listingOperationCallbacks = listingOperationCallbacks;
    }

    RemoteIterator<S3AFileStatus> createProvidedFileStatusIterator(S3AFileStatus[] fileStatuses, PathFilter filter, FileStatusAcceptor acceptor) {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)RemoteIterators.remoteIteratorFromArray((Object[])fileStatuses), status -> filter.accept(status.getPath()) && acceptor.accept((FileStatus)status));
    }

    @VisibleForTesting
    public static RemoteIterator<S3AFileStatus> toProvidedFileStatusIterator(S3AFileStatus[] fileStatuses) {
        return RemoteIterators.filteringRemoteIterator((RemoteIterator)RemoteIterators.remoteIteratorFromArray((Object[])fileStatuses), ACCEPT_ALL_BUT_S3N::accept);
    }

    public FileStatusListingIterator createFileStatusListingIterator(Path listPath, S3ListRequest request, PathFilter filter, FileStatusAcceptor acceptor, AuditSpan span) throws IOException {
        return new FileStatusListingIterator(this.createObjectListingIterator(listPath, request, span), filter, acceptor);
    }

    private ObjectListingIterator createObjectListingIterator(Path listPath, S3ListRequest request, AuditSpan span) throws IOException {
        return new ObjectListingIterator(listPath, request, span);
    }

    @VisibleForTesting
    public RemoteIterator<S3ALocatedFileStatus> createLocatedFileStatusIterator(RemoteIterator<S3AFileStatus> statusIterator) {
        return RemoteIterators.mappingRemoteIterator(statusIterator, this.listingOperationCallbacks::toLocatedFileStatus);
    }

    public RemoteIterator<S3ALocatedFileStatus> createSingleStatusIterator(S3ALocatedFileStatus status) {
        return RemoteIterators.remoteIteratorFromSingleton((Object)((Object)status));
    }

    public RemoteIterator<S3ALocatedFileStatus> getListFilesAssumingDir(Path path, boolean recursive, FileStatusAcceptor acceptor, AuditSpan span) throws IOException {
        String delimiter;
        String key = S3AUtils.maybeAddTrailingSlash(RoleModel.pathToKey(path));
        String string = delimiter = recursive ? null : "/";
        if (recursive) {
            LOG.debug("Recursive list of all entries under {}", (Object)key);
        } else {
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
        }
        return this.createLocatedFileStatusIterator(this.createFileStatusListingIterator(path, this.listingOperationCallbacks.createListObjectsRequest(key, delimiter, span), S3AUtils.ACCEPT_ALL, acceptor, span));
    }

    public RemoteIterator<S3ALocatedFileStatus> getLocatedFileStatusIteratorForDir(Path dir, PathFilter filter, AuditSpan span) throws IOException {
        span.activate();
        String key = S3AUtils.maybeAddTrailingSlash(RoleModel.pathToKey(dir));
        return this.createLocatedFileStatusIterator(this.createFileStatusListingIterator(dir, this.listingOperationCallbacks.createListObjectsRequest(key, "/", span), filter, new AcceptAllButSelfAndS3nDirs(dir), span));
    }

    public RemoteIterator<S3AFileStatus> getFileStatusesAssumingNonEmptyDir(Path path, AuditSpan span) throws IOException {
        Object key = RoleModel.pathToKey(path);
        if (!((String)key).isEmpty()) {
            key = (String)key + "/";
        }
        S3ListRequest request = this.createListObjectsRequest((String)key, "/", span);
        LOG.debug("listStatus: doing listObjects for directory \"{}\"", key);
        return this.createFileStatusListingIterator(path, request, S3AUtils.ACCEPT_ALL, new AcceptAllButSelfAndS3nDirs(path), span);
    }

    public S3ListRequest createListObjectsRequest(String key, String delimiter, AuditSpan span) {
        return this.listingOperationCallbacks.createListObjectsRequest(key, delimiter, span);
    }

    public static RemoteIterator<LocatedFileStatus> toLocatedFileStatusIterator(RemoteIterator<? extends LocatedFileStatus> iterator) {
        return iterator;
    }

    static interface FileStatusAcceptor {
        public boolean accept(Path var1, S3Object var2);

        public boolean accept(Path var1, String var2);

        public boolean accept(FileStatus var1);
    }

    class FileStatusListingIterator
    implements RemoteIterator<S3AFileStatus>,
    IOStatisticsSource,
    Closeable {
        private final ObjectListingIterator source;
        private final PathFilter filter;
        private final FileStatusAcceptor acceptor;
        private int batchSize;
        private ListIterator<S3AFileStatus> statusBatchIterator;

        FileStatusListingIterator(ObjectListingIterator source, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
            this.source = source;
            this.filter = filter;
            this.acceptor = acceptor;
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.sourceHasNext();
        }

        private boolean sourceHasNext() throws IOException {
            return this.statusBatchIterator.hasNext() || this.requestNextBatch();
        }

        public S3AFileStatus next() throws IOException {
            if (!this.sourceHasNext()) {
                throw new NoSuchElementException();
            }
            S3AFileStatus status = this.statusBatchIterator.next();
            return status;
        }

        @Override
        public void close() {
            this.source.close();
        }

        private boolean requestNextBatch() throws IOException {
            while (this.source.hasNext()) {
                if (this.buildNextStatusBatch(this.source.next())) {
                    return true;
                }
                LOG.debug("All entries in batch were filtered...continuing");
            }
            return false;
        }

        private boolean buildNextStatusBatch(S3ListResult objects) throws IOException {
            int added = 0;
            int ignored = 0;
            ArrayList<S3AFileStatus> stats = new ArrayList<S3AFileStatus>(objects.getS3Objects().size() + objects.getCommonPrefixes().size());
            String userName = Listing.this.getStoreContext().getUsername();
            long blockSize = Listing.this.listingOperationCallbacks.getDefaultBlockSize(null);
            for (S3Object s3Object : objects.getS3Objects()) {
                String key = s3Object.key();
                Path keyPath = Listing.this.getStoreContext().getContextAccessors().keyToPath(key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: {}", (Object)keyPath, (Object)S3AUtils.stringify(s3Object));
                }
                if (this.acceptor.accept(keyPath, s3Object) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = S3AUtils.createFileStatus(keyPath, s3Object, blockSize, userName, s3Object.eTag(), null, Listing.this.listingOperationCallbacks.getObjectSize(s3Object));
                    LOG.debug("Adding: {}", (Object)status);
                    stats.add(status);
                    ++added;
                    continue;
                }
                LOG.debug("Ignoring: {}", (Object)keyPath);
                ++ignored;
            }
            for (CommonPrefix prefix : objects.getCommonPrefixes()) {
                Path keyPath = Listing.this.getStoreContext().getContextAccessors().keyToPath(prefix.prefix());
                if (this.acceptor.accept(keyPath, prefix.prefix()) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = new S3AFileStatus(Tristate.FALSE, keyPath, Listing.this.getStoreContext().getUsername());
                    LOG.debug("Adding directory: {}", (Object)status);
                    ++added;
                    stats.add(status);
                    continue;
                }
                LOG.debug("Ignoring directory: {}", (Object)keyPath);
                ++ignored;
            }
            this.batchSize = stats.size();
            this.statusBatchIterator = stats.listIterator();
            boolean hasNext = this.statusBatchIterator.hasNext();
            LOG.debug("Added {} entries; ignored {}; hasNext={}; hasMoreObjects={}", new Object[]{added, ignored, hasNext, objects.isTruncated()});
            return hasNext;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public IOStatistics getIOStatistics() {
            return this.source.getIOStatistics();
        }

        public String toString() {
            return new StringJoiner(", ", FileStatusListingIterator.class.getSimpleName() + "[", "]").add(this.source.toString()).toString();
        }
    }

    class ObjectListingIterator
    implements RemoteIterator<S3ListResult>,
    IOStatisticsSource,
    Closeable {
        private final Path listPath;
        private final AuditSpan span;
        private final IOStatisticsAggregator aggregator;
        private S3ListResult objects;
        private S3ListRequest request;
        private boolean firstListing = true;
        private int listingCount = 1;
        private int maxKeys;
        private final IOStatisticsStore iostats;
        private CompletableFuture<S3ListResult> s3ListResultFuture;
        private S3ListResult objectsPrev;

        ObjectListingIterator(Path listPath, S3ListRequest request, AuditSpan span) throws IOException {
            this.listPath = listPath;
            this.maxKeys = Listing.this.listingOperationCallbacks.getMaxKeys();
            this.request = request;
            this.objectsPrev = null;
            this.iostats = IOStatisticsBinding.iostatisticsStore().withDurationTracking(new String[]{"object_list_request"}).withDurationTracking(new String[]{"object_continue_list_request"}).build();
            this.span = span;
            this.s3ListResultFuture = Listing.this.listingOperationCallbacks.listObjectsAsync(request, (DurationTrackerFactory)this.iostats, span);
            this.aggregator = IOStatisticsContext.getCurrentIOStatisticsContext().getAggregator();
        }

        public boolean hasNext() throws IOException {
            return this.firstListing || this.objectsPrev != null && this.objectsPrev.isTruncated();
        }

        public S3ListResult next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
                this.objects = Invoker.onceInTheFuture("listObjects()", this.listPath.toString(), this.s3ListResultFuture);
                this.fetchNextBatchAsyncIfPresent();
            } else {
                if (this.objectsPrev != null && !this.objectsPrev.isTruncated()) {
                    throw new NoSuchElementException("No more results in listing of " + this.listPath);
                }
                this.objects = Invoker.onceInTheFuture("listObjects()", this.listPath.toString(), this.s3ListResultFuture);
                this.fetchNextBatchAsyncIfPresent();
                ++this.listingCount;
                LOG.debug("New listing status: {}", (Object)this);
            }
            this.objectsPrev = this.objects;
            return this.objectsPrev;
        }

        private void fetchNextBatchAsyncIfPresent() {
            if (this.objects.isTruncated()) {
                LOG.debug("[{}], Requesting next {} objects under {}", new Object[]{this.listingCount, this.maxKeys, this.listPath});
                this.s3ListResultFuture = Listing.this.listingOperationCallbacks.continueListObjectsAsync(this.request, this.objects, (DurationTrackerFactory)this.iostats, this.span);
            }
        }

        public String toString() {
            return "Object listing iterator against " + this.listPath + "; listing count " + this.listingCount + "; isTruncated=" + this.objects.isTruncated() + "; " + this.iostats;
        }

        public IOStatistics getIOStatistics() {
            return this.iostats;
        }

        public Path getListPath() {
            return this.listPath;
        }

        public int getListingCount() {
            return this.listingCount;
        }

        @Override
        public void close() {
            this.aggregator.aggregate(this.getIOStatistics());
        }
    }

    public static class AcceptAllButSelfAndS3nDirs
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptAllButSelfAndS3nDirs(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3Object s3Object) {
            return !keyPath.equals((Object)this.qualifiedPath) && !s3Object.key().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals((Object)this.qualifiedPath);
        }

        @Override
        public boolean accept(FileStatus status) {
            return status != null && !status.getPath().equals((Object)this.qualifiedPath);
        }
    }

    static class AcceptAllButS3nDirs
    implements FileStatusAcceptor {
        AcceptAllButS3nDirs() {
        }

        @Override
        public boolean accept(Path keyPath, S3Object s3Object) {
            return !s3Object.key().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.toString().endsWith("_$folder$");
        }

        @Override
        public boolean accept(FileStatus status) {
            return !status.getPath().toString().endsWith("_$folder$");
        }
    }

    static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptFilesOnly(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3Object s3Object) {
            return !keyPath.equals((Object)this.qualifiedPath) && !s3Object.key().endsWith("_$folder$") && !S3AUtils.objectRepresentsDirectory(s3Object.key());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }

        @Override
        public boolean accept(FileStatus status) {
            return status != null && status.isFile();
        }
    }
}

