/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.s3a.AnonymousAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;

@InterfaceAudience.LimitedPrivate(value={"extensions"})
@InterfaceStability.Evolving
public final class AWSCredentialProviderList
implements AwsCredentialsProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AWSCredentialProviderList.class);
    public static final String NO_AWS_CREDENTIAL_PROVIDERS = "No AWS Credential Providers";
    static final String CREDENTIALS_REQUESTED_WHEN_CLOSED = "Credentials requested after provider list was closed";
    private final List<AwsCredentialsProvider> providers = new ArrayList<AwsCredentialsProvider>(1);
    private boolean reuseLastProvider = true;
    private AwsCredentialsProvider lastProvider;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String name = "";

    public AWSCredentialProviderList() {
    }

    public AWSCredentialProviderList(Collection<AwsCredentialsProvider> providers) {
        this.providers.addAll(providers);
    }

    public AWSCredentialProviderList(String name, AwsCredentialsProvider ... providerArgs) {
        this.setName(name);
        Collections.addAll(this.providers, providerArgs);
    }

    public void setName(String name) {
        this.name = !name.isEmpty() && !name.endsWith(": ") ? name + ": " : name;
    }

    public void add(AwsCredentialsProvider provider) {
        this.providers.add(provider);
    }

    public void addAll(AWSCredentialProviderList other) {
        this.providers.addAll(other.providers);
    }

    @Deprecated
    public void refresh() {
    }

    public AwsCredentials resolveCredentials() {
        if (this.isClosed()) {
            LOG.warn(CREDENTIALS_REQUESTED_WHEN_CLOSED);
            throw new NoAuthWithAWSException(this.name + CREDENTIALS_REQUESTED_WHEN_CLOSED);
        }
        this.checkNotEmpty();
        if (this.reuseLastProvider && this.lastProvider != null) {
            return this.lastProvider.resolveCredentials();
        }
        Object lastException = null;
        for (AwsCredentialsProvider provider : this.providers) {
            try {
                AwsCredentials credentials = provider.resolveCredentials();
                Preconditions.checkNotNull((Object)credentials, (String)"Null credentials returned by %s", (Object[])new Object[]{provider});
                if ((credentials.accessKeyId() == null || credentials.secretAccessKey() == null) && !(provider instanceof AnonymousCredentialsProvider) && !(provider instanceof AnonymousAWSCredentialsProvider)) continue;
                this.lastProvider = provider;
                LOG.debug("Using credentials from {}", (Object)provider);
                return credentials;
            }
            catch (NoAwsCredentialsException e) {
                if (lastException == null) {
                    lastException = e;
                }
                LOG.debug("No credentials from {}: {}", (Object)provider, (Object)e.toString());
            }
            catch (SdkException e) {
                lastException = e;
                LOG.debug("No credentials provided by {}: {}", new Object[]{provider, e.toString(), e});
            }
        }
        String message = this.name + "No AWS Credentials provided by " + this.listProviderNames();
        if (lastException != null) {
            message = message + ": " + lastException;
        }
        if (lastException instanceof CredentialInitializationException) {
            throw lastException;
        }
        throw new NoAuthWithAWSException(message, (Throwable)lastException);
    }

    public List<AwsCredentialsProvider> getProviders() {
        return this.providers;
    }

    public void checkNotEmpty() {
        if (this.providers.isEmpty()) {
            throw new NoAuthWithAWSException(this.name + NO_AWS_CREDENTIAL_PROVIDERS);
        }
    }

    public String listProviderNames() {
        return this.providers.stream().map(provider -> provider.getClass().getSimpleName() + " ").collect(Collectors.joining());
    }

    public String toString() {
        return "AWSCredentialProviderList name=" + this.name + "; refcount= " + this.refCount.get() + "; size=" + this.providers.size() + ": [" + StringUtils.join(this.providers, (String)", ") + "]" + (String)(this.lastProvider != null ? " last provider: " + this.lastProvider : "");
    }

    public synchronized AWSCredentialProviderList share() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Provider list is closed");
        this.refCount.incrementAndGet();
        return this;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.refCount.get();
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AWSCredentialProviderList aWSCredentialProviderList = this;
        synchronized (aWSCredentialProviderList) {
            if (this.closed.get()) {
                return;
            }
            int remainder = this.refCount.decrementAndGet();
            if (remainder != 0) {
                LOG.debug("Not closing {}", (Object)this);
                return;
            }
            LOG.debug("Closing {}", (Object)this);
            this.closed.set(true);
        }
        for (AwsCredentialsProvider p : this.providers) {
            if (p instanceof Closeable) {
                IOUtils.closeStream((Closeable)((Closeable)p));
                continue;
            }
            if (!(p instanceof AutoCloseable)) continue;
            S3AUtils.closeAutocloseables(LOG, (AutoCloseable)p);
        }
    }

    public int size() {
        return this.providers.size();
    }

    public static IOException maybeTranslateCredentialException(String path, Throwable throwable) {
        if (throwable instanceof CredentialInitializationException) {
            return (AccessDeniedException)new AccessDeniedException(path, null, throwable.toString()).initCause(throwable);
        }
        if (throwable.getCause() instanceof CredentialInitializationException) {
            return AWSCredentialProviderList.maybeTranslateCredentialException(path, throwable.getCause());
        }
        return null;
    }
}

