/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.impl.ContextAccessors;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.security.UserGroupInformation;

public class StoreContextBuilder {
    private URI fsURI;
    private String bucket;
    private Configuration configuration;
    private String username;
    private UserGroupInformation owner;
    private ListeningExecutorService executor;
    private int executorCapacity;
    private Invoker invoker;
    private S3AStatisticsContext instrumentation;
    private S3AStorageStatistics storageStatistics;
    private S3AInputPolicy inputPolicy = S3AInputPolicy.Normal;
    private ChangeDetectionPolicy changeDetectionPolicy;
    private boolean multiObjectDeleteEnabled = true;
    private boolean useListV1 = false;
    private ContextAccessors contextAccessors;
    private AuditSpanSource<AuditSpanS3A> auditor;
    private boolean isCSEEnabled;

    public StoreContextBuilder setFsURI(URI fsURI) {
        this.fsURI = fsURI;
        return this;
    }

    public StoreContextBuilder setBucket(String b) {
        this.bucket = b;
        return this;
    }

    public StoreContextBuilder setConfiguration(Configuration conf) {
        this.configuration = conf;
        return this;
    }

    public StoreContextBuilder setUsername(String user) {
        this.username = user;
        return this;
    }

    public StoreContextBuilder setOwner(UserGroupInformation ugi) {
        this.owner = ugi;
        return this;
    }

    public StoreContextBuilder setExecutor(ListeningExecutorService ex) {
        this.executor = ex;
        return this;
    }

    public StoreContextBuilder setExecutorCapacity(int capacity) {
        this.executorCapacity = capacity;
        return this;
    }

    public StoreContextBuilder setInvoker(Invoker invoke) {
        this.invoker = invoke;
        return this;
    }

    public StoreContextBuilder setInstrumentation(S3AStatisticsContext instr) {
        this.instrumentation = instr;
        return this;
    }

    public StoreContextBuilder setStorageStatistics(S3AStorageStatistics sstats) {
        this.storageStatistics = sstats;
        return this;
    }

    public StoreContextBuilder setInputPolicy(S3AInputPolicy policy) {
        this.inputPolicy = policy;
        return this;
    }

    public StoreContextBuilder setChangeDetectionPolicy(ChangeDetectionPolicy policy) {
        this.changeDetectionPolicy = policy;
        return this;
    }

    public StoreContextBuilder setMultiObjectDeleteEnabled(boolean enabled) {
        this.multiObjectDeleteEnabled = enabled;
        return this;
    }

    public StoreContextBuilder setUseListV1(boolean useV1) {
        this.useListV1 = useV1;
        return this;
    }

    public StoreContextBuilder setContextAccessors(ContextAccessors accessors) {
        this.contextAccessors = accessors;
        return this;
    }

    public StoreContextBuilder setAuditor(AuditSpanSource<AuditSpanS3A> value) {
        this.auditor = value;
        return this;
    }

    public StoreContextBuilder setEnableCSE(boolean value) {
        this.isCSEEnabled = value;
        return this;
    }

    public StoreContext build() {
        return new StoreContext(this.fsURI, this.bucket, this.configuration, this.username, this.owner, this.executor, this.executorCapacity, this.invoker, this.instrumentation, this.storageStatistics, this.inputPolicy, this.changeDetectionPolicy, this.multiObjectDeleteEnabled, this.useListV1, this.contextAccessors, this.auditor, this.isCSEEnabled);
    }
}

