/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteRetryHandler;
import org.apache.hadoop.fs.s3a.impl.ClientManager;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.impl.StoreContextFactory;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.RateLimiting;
import org.apache.hadoop.util.functional.Tuples;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class S3AStoreImpl
implements S3AStore {
    private static final Logger LOG = LoggerFactory.getLogger(S3AStoreImpl.class);
    private final StoreContextFactory storeContextFactory;
    private final ClientManager clientManager;
    private final String bucket;
    private final RequestFactory requestFactory;
    private final DurationTrackerFactory durationTrackerFactory;
    private final S3AInstrumentation instrumentation;
    private final S3AStatisticsContext statisticsContext;
    private final S3AStorageStatistics storageStatistics;
    private final RateLimiting readRateLimiter;
    private final RateLimiting writeRateLimiter;
    private final StoreContext storeContext;
    private final Invoker invoker;
    private final AuditSpanSource<AuditSpanS3A> auditSpanSource;

    S3AStoreImpl(StoreContextFactory storeContextFactory, ClientManager clientManager, DurationTrackerFactory durationTrackerFactory, S3AInstrumentation instrumentation, S3AStatisticsContext statisticsContext, S3AStorageStatistics storageStatistics, RateLimiting readRateLimiter, RateLimiting writeRateLimiter, AuditSpanSource<AuditSpanS3A> auditSpanSource) {
        this.storeContextFactory = Objects.requireNonNull(storeContextFactory);
        this.clientManager = Objects.requireNonNull(clientManager);
        this.durationTrackerFactory = Objects.requireNonNull(durationTrackerFactory);
        this.instrumentation = Objects.requireNonNull(instrumentation);
        this.statisticsContext = Objects.requireNonNull(statisticsContext);
        this.storageStatistics = Objects.requireNonNull(storageStatistics);
        this.readRateLimiter = Objects.requireNonNull(readRateLimiter);
        this.writeRateLimiter = Objects.requireNonNull(writeRateLimiter);
        this.auditSpanSource = Objects.requireNonNull(auditSpanSource);
        this.storeContext = Objects.requireNonNull(storeContextFactory.createStoreContext());
        this.invoker = this.storeContext.getInvoker();
        this.bucket = this.storeContext.getBucket();
        this.requestFactory = this.storeContext.getRequestFactory();
    }

    @Override
    public void close() {
        this.clientManager.close();
    }

    @Override
    public Duration acquireWriteCapacity(int capacity) {
        return this.writeRateLimiter.acquire(capacity);
    }

    @Override
    public Duration acquireReadCapacity(int capacity) {
        return this.readRateLimiter.acquire(capacity);
    }

    private StoreContext createStoreContext() {
        return this.storeContextFactory.createStoreContext();
    }

    @Override
    public StoreContext getStoreContext() {
        return this.storeContext;
    }

    private S3Client getS3Client() throws IOException {
        return this.clientManager.getOrCreateS3Client();
    }

    @Override
    public S3TransferManager getOrCreateTransferManager() throws IOException {
        return this.clientManager.getOrCreateTransferManager();
    }

    @Override
    public S3Client getOrCreateS3Client() throws IOException {
        return this.clientManager.getOrCreateS3Client();
    }

    @Override
    public S3AsyncClient getOrCreateAsyncClient() throws IOException {
        return this.clientManager.getOrCreateAsyncClient();
    }

    @Override
    public DurationTrackerFactory getDurationTrackerFactory() {
        return this.durationTrackerFactory;
    }

    private S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public S3AStatisticsContext getStatisticsContext() {
        return this.statisticsContext;
    }

    private S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    @Override
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public ClientManager clientManager() {
        return this.clientManager;
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.statisticsContext.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.statisticsContext.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.statisticsContext.incrementGauge(statistic, count);
    }

    public void operationRetried(Exception ex) {
        if (S3AUtils.isThrottleException(ex)) {
            LOG.debug("Request throttled");
            this.incrementStatistic(Statistic.STORE_IO_THROTTLED);
            this.statisticsContext.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, 1L);
        } else {
            this.incrementStatistic(Statistic.STORE_IO_RETRY);
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    public IOStatistics getIOStatistics() {
        return this.instrumentation.getIOStatistics();
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return (AuditSpanS3A)this.auditSpanSource.createSpan(operation, path1, path2);
    }

    private void blockRootDelete(String key) throws IllegalArgumentException {
        Preconditions.checkArgument((!key.isEmpty() && !"/".equals(key) ? 1 : 0) != 0, (String)"Bucket %s cannot be deleted", (Object[])new Object[]{this.bucket});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<Duration, DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest deleteRequest) throws SdkException {
        BulkDeleteRetryHandler retryHandler = new BulkDeleteRetryHandler(this.createStoreContext());
        List keysToDelete = deleteRequest.delete().objects();
        int keyCount = keysToDelete.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating delete operation for {} objects", (Object)keysToDelete.size());
            keysToDelete.stream().forEach(objectIdentifier -> LOG.debug(" \"{}\" {}", (Object)objectIdentifier.key(), (Object)(objectIdentifier.versionId() != null ? objectIdentifier.versionId() : "")));
        }
        keysToDelete.stream().map(ObjectIdentifier::key).forEach(this::blockRootDelete);
        try (DurationInfo d = new DurationInfo(LOG, false, "DELETE %d keys", new Object[]{keyCount});){
            DeleteObjectsResponse response = (DeleteObjectsResponse)this.invoker.retryUntranslated("delete", true, (text, e, r, i) -> retryHandler.bulkDeleteRetried(deleteRequest, e), IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_BULK_DELETE_REQUEST.getSymbol(), () -> {
                Duration durationToAcquireWriteCapacity = this.acquireWriteCapacity(keyCount);
                this.instrumentation.recordDuration(Statistic.STORE_IO_RATE_LIMITED, true, durationToAcquireWriteCapacity);
                this.incrementStatistic(Statistic.OBJECT_DELETE_OBJECTS, keyCount);
                return this.getS3Client().deleteObjects(deleteRequest);
            }));
            if (!response.errors().isEmpty()) {
                List errors = response.errors();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Partial failure of delete, {} errors", (Object)errors.size());
                    for (S3Error error : errors) {
                        LOG.debug("{}: \"{}\" - {}", new Object[]{error.key(), error.code(), error.message()});
                    }
                }
            }
            d.close();
            Map.Entry entry = Tuples.pair((Object)d.asDuration(), (Object)response);
            return entry;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @Override
    public Map.Entry<Duration, Optional<DeleteObjectResponse>> deleteObject(DeleteObjectRequest request) throws SdkException {
        String key = request.key();
        this.blockRootDelete(key);
        DurationInfo d = new DurationInfo(LOG, false, "deleting %s", new Object[]{key});
        try {
            DeleteObjectResponse response = (DeleteObjectResponse)this.invoker.retryUntranslated(String.format("Delete %s:/%s", this.bucket, key), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_DELETE_REQUEST.getSymbol(), () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_OBJECTS);
                Duration durationToAcquireWriteCapacity = this.acquireWriteCapacity(1);
                this.instrumentation.recordDuration(Statistic.STORE_IO_RATE_LIMITED, true, durationToAcquireWriteCapacity);
                return this.getS3Client().deleteObject(request);
            }));
            d.close();
            return Tuples.pair((Object)d.asDuration(), Optional.of(response));
        }
        catch (AwsServiceException ase) {
            if (!ErrorTranslation.isObjectNotFound(ase)) {
                throw ase;
            }
            d.close();
            return Tuples.pair((Object)d.asDuration(), Optional.empty());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

