/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.impl.ClientManager;
import org.apache.hadoop.fs.s3a.impl.S3AStoreImpl;
import org.apache.hadoop.fs.s3a.impl.StoreContextFactory;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.util.RateLimiting;

public class S3AStoreBuilder {
    private StoreContextFactory storeContextFactory;
    private ClientManager clientManager;
    private DurationTrackerFactory durationTrackerFactory;
    private S3AInstrumentation instrumentation;
    private S3AStatisticsContext statisticsContext;
    private S3AStorageStatistics storageStatistics;
    private RateLimiting readRateLimiter;
    private RateLimiting writeRateLimiter;
    private AuditSpanSource<AuditSpanS3A> auditSpanSource;

    public S3AStoreBuilder withStoreContextFactory(StoreContextFactory storeContextFactoryValue) {
        this.storeContextFactory = storeContextFactoryValue;
        return this;
    }

    public S3AStoreBuilder withClientManager(ClientManager manager) {
        this.clientManager = manager;
        return this;
    }

    public S3AStoreBuilder withDurationTrackerFactory(DurationTrackerFactory durationTrackerFactoryValue) {
        this.durationTrackerFactory = durationTrackerFactoryValue;
        return this;
    }

    public S3AStoreBuilder withInstrumentation(S3AInstrumentation instrumentationValue) {
        this.instrumentation = instrumentationValue;
        return this;
    }

    public S3AStoreBuilder withStatisticsContext(S3AStatisticsContext statisticsContextValue) {
        this.statisticsContext = statisticsContextValue;
        return this;
    }

    public S3AStoreBuilder withStorageStatistics(S3AStorageStatistics storageStatisticsValue) {
        this.storageStatistics = storageStatisticsValue;
        return this;
    }

    public S3AStoreBuilder withReadRateLimiter(RateLimiting readRateLimiterValue) {
        this.readRateLimiter = readRateLimiterValue;
        return this;
    }

    public S3AStoreBuilder withWriteRateLimiter(RateLimiting writeRateLimiterValue) {
        this.writeRateLimiter = writeRateLimiterValue;
        return this;
    }

    public S3AStoreBuilder withAuditSpanSource(AuditSpanSource<AuditSpanS3A> auditSpanSourceValue) {
        this.auditSpanSource = auditSpanSourceValue;
        return this;
    }

    public S3AStore build() {
        return new S3AStoreImpl(this.storeContextFactory, this.clientManager, this.durationTrackerFactory, this.instrumentation, this.statisticsContext, this.storageStatistics, this.readRateLimiter, this.writeRateLimiter, this.auditSpanSource);
    }
}

